/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.EmptyQueueException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class Queue
implements List {
    private LinkedList items = new LinkedList();
    private int _maxSize = -1;

    public Queue(int maxSize) {
        this();
        this._maxSize = maxSize;
    }

    public Queue() {
    }

    public Object enqueue(Object element) {
        if (this.items.size() > 0 && this.items.size() >= this._maxSize && this._maxSize != -1) {
            this.dequeue();
        }
        this.items.add(element);
        return element;
    }

    public Object enqueueUnique(Object element) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!element.equals(this.items.get(i))) continue;
            return element;
        }
        return this.enqueue(element);
    }

    public Object dequeue() {
        if (this.items.size() == 0) {
            throw new EmptyQueueException();
        }
        return this.items.removeFirst();
    }

    public Object front() {
        if (this.items.size() == 0) {
            throw new EmptyQueueException();
        }
        return this.items.getFirst();
    }

    public int size() {
        return this.items.size();
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public void clear() {
        this.items.clear();
    }

    public Object[] toArray() {
        return this.items.toArray();
    }

    public List getItems() {
        return (List)this.items.clone();
    }

    public Object[] toInverseArray() {
        return this.toInverseArray(this.items.toArray());
    }

    public Object[] toInverseArray(Object[] toInverse) {
        Object[] result = new Object[toInverse.length];
        int i = toInverse.length - 1;
        int r = 0;
        while (i >= 0) {
            result[r] = toInverse[i];
            --i;
            ++r;
        }
        return result;
    }

    public void initFromCSV(String csv, String separator) {
        if (csv != null) {
            if (separator == null) {
                separator = ";";
            }
            StringTokenizer tokenizer = new StringTokenizer(csv, separator);
            while (tokenizer.hasMoreElements()) {
                this.enqueue(tokenizer.nextElement());
            }
        }
    }

    public String exportToCSV(String separator) {
        if (separator == null) {
            separator = ";";
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.items.size(); ++i) {
            buff.append(this.items.get(i).toString());
            buff.append(separator);
        }
        return buff.toString();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Object get(int index) {
        return this.items.get(index);
    }

    public Object remove(int index) {
        return this.items.remove(index);
    }

    public void add(int index, Object element) {
        this.items.add(index, element);
    }

    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.items.lastIndexOf(o);
    }

    public boolean add(Object o) {
        return this.enqueue(o) != null;
    }

    public boolean contains(Object o) {
        return this.contains(o);
    }

    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    public boolean addAll(int index, Collection c) {
        return this.items.addAll(index, c);
    }

    public boolean addAll(Collection c) {
        return this.items.add(c);
    }

    public boolean containsAll(Collection c) {
        return this.items.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.items.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.items.retainAll(c);
    }

    public Iterator iterator() {
        return this.items.iterator();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    public ListIterator listIterator() {
        return this.items.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.items.listIterator(index);
    }

    public Object set(int index, Object element) {
        return this.items.set(index, element);
    }

    public Object[] toArray(Object[] a) {
        return this.items.toArray(a);
    }
}

