/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.URLUTF8Encoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class UTF8URL
extends Frame
implements TextListener,
WindowListener {
    private TextField label;
    private TextArea textarea;
    private TextArea echo;

    public UTF8URL() {
        super("UTF-8/URL encoding demo");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        this.addWindowListener(this);
        this.textarea = new TextArea("", 4, 55, 1);
        this.label = new TextField();
        this.label.setEditable(false);
        this.echo = new TextArea("", 4, 55, 1);
        this.echo.setEditable(false);
        this.textarea.addTextListener(this);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        this.add((Component)new Label("Type here:", 0), constraints);
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)this.textarea, constraints);
        constraints.gridy = 2;
        constraints.weighty = 0.0;
        this.add((Component)new Label("Encoded:", 0), constraints);
        constraints.gridy = 3;
        constraints.weighty = 0.0;
        this.add((Component)this.label, constraints);
        constraints.gridy = 4;
        constraints.weighty = 0.0;
        this.add((Component)new Label("Decoded (should be same):", 0), constraints);
        constraints.gridy = 5;
        constraints.weighty = 1.0;
        this.add((Component)this.echo, constraints);
        this.pack();
        this.show();
        this.textarea.requestFocus();
    }

    private void recompute() {
        String input_text = this.textarea.getText();
        String encoded_text = URLUTF8Encoder.encode(input_text);
        this.label.setText(encoded_text);
        this.echo.setText(UTF8URL.unescape(encoded_text));
    }

    private static String unescape(String s) {
        StringBuffer sbuf = new StringBuffer();
        int l = s.length();
        int ch = -1;
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            int b;
            char c = s.charAt(i);
            ch = c;
            switch (c) {
                case '%': {
                    ch = s.charAt(++i);
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    break;
                }
                case '+': {
                    b = 32;
                    break;
                }
                default: {
                    b = ch;
                }
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more != 0) continue;
                sbuf.append((char)sumb);
                continue;
            }
            if ((b & 0x80) == 0) {
                sbuf.append((char)b);
                continue;
            }
            if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
                continue;
            }
            if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
                continue;
            }
            if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
                continue;
            }
            if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
                continue;
            }
            sumb = b & 1;
            more = 5;
        }
        return sbuf.toString();
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void textValueChanged(TextEvent te) {
        this.recompute();
    }

    public static void main(String[] args) {
        UTF8URL udemo = new UTF8URL();
    }
}

