/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.IntroSpectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class VectorHelper {
    public static Vector union(Vector vectA, Vector vectB) {
        Object item;
        Enumeration<Object> aTempEnum;
        int threshold = 0;
        if (vectA != null) {
            threshold = vectA.size();
        }
        if (vectB != null) {
            threshold += vectB.size();
        }
        if (threshold < 10) {
            Object obj;
            int i;
            Vector result = new Vector(threshold);
            if (vectA != null) {
                for (i = 0; i < vectA.size(); ++i) {
                    obj = vectA.elementAt(i);
                    if (result.contains(obj)) continue;
                    result.addElement(obj);
                }
            }
            if (vectB != null) {
                for (i = 0; i < vectB.size(); ++i) {
                    obj = vectB.elementAt(i);
                    if (result.contains(obj)) continue;
                    result.addElement(obj);
                }
            }
            return result;
        }
        Hashtable<Object, Object> workSet = new Hashtable<Object, Object>();
        Vector<Object> result = new Vector<Object>(threshold);
        if (vectA != null) {
            aTempEnum = vectA.elements();
            while (aTempEnum.hasMoreElements()) {
                item = aTempEnum.nextElement();
                workSet.put(item, item);
            }
        }
        if (vectB != null) {
            aTempEnum = vectB.elements();
            while (aTempEnum.hasMoreElements()) {
                item = aTempEnum.nextElement();
                workSet.put(item, item);
            }
        }
        aTempEnum = workSet.elements();
        while (aTempEnum.hasMoreElements()) {
            result.addElement(aTempEnum.nextElement());
        }
        result.trimToSize();
        return result;
    }

    public static synchronized String[] toStringArray(List vals) {
        String[] result = new String[vals.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = vals.get(i).toString();
        }
        return result;
    }

    public static void unionAdd(Vector vect, Object obj) {
        if (obj == null) {
            return;
        }
        if (vect.contains(obj)) {
            return;
        }
        vect.addElement(obj);
    }

    public static boolean overlaps(Vector vectA, Vector vectB) {
        if (vectA == null || vectB == null || vectA.size() == 0 || vectB.size() == 0) {
            return false;
        }
        if (vectA.size() + vectB.size() > 20) {
            int i;
            Hashtable workSet = new Hashtable(vectA.size());
            for (i = 0; i < vectA.size(); ++i) {
                workSet.put(vectA.elementAt(i), vectA.elementAt(i));
            }
            for (i = 0; i < vectB.size(); ++i) {
                if (!workSet.containsKey(vectB.elementAt(i))) continue;
                return true;
            }
        } else if (vectA.size() > vectB.size()) {
            for (int i = 0; i < vectA.size(); ++i) {
                if (!vectB.contains(vectA.elementAt(i))) continue;
                return true;
            }
        } else {
            for (int i = 0; i < vectB.size(); ++i) {
                if (!vectA.contains(vectB.elementAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static Vector intersection(Vector vectA, Vector vectB) {
        Object item;
        Enumeration<Object> aTempEnum;
        Hashtable<Object, Object> workSetA = new Hashtable<Object, Object>();
        Hashtable<Object, Object> workSetB = new Hashtable<Object, Object>();
        Hashtable<Object, Object> resultSet = new Hashtable<Object, Object>();
        Vector<Object> result = new Vector<Object>();
        if (vectA != null) {
            aTempEnum = vectA.elements();
            while (aTempEnum.hasMoreElements()) {
                item = aTempEnum.nextElement();
                workSetA.put(item, item);
            }
        }
        if (vectB != null) {
            aTempEnum = vectB.elements();
            while (aTempEnum.hasMoreElements()) {
                item = aTempEnum.nextElement();
                workSetB.put(item, item);
            }
        }
        aTempEnum = workSetA.elements();
        while (aTempEnum.hasMoreElements()) {
            item = aTempEnum.nextElement();
            if (!workSetB.containsKey(item)) continue;
            resultSet.put(item, item);
        }
        aTempEnum = workSetB.elements();
        while (aTempEnum.hasMoreElements()) {
            item = aTempEnum.nextElement();
            if (!workSetA.containsKey(item)) continue;
            resultSet.put(item, item);
        }
        aTempEnum = resultSet.elements();
        while (aTempEnum.hasMoreElements()) {
            result.addElement(aTempEnum.nextElement());
        }
        return result;
    }

    public static Object getFirstCommonObject(Vector vectA, Vector vectB) {
        if (vectA != null && vectB != null && vectB.size() > 0) {
            for (int i = 0; i < vectA.size(); ++i) {
                Object o = vectA.get(i);
                if (!vectB.contains(o)) continue;
                return o;
            }
        }
        return null;
    }

    public static Vector difference(Vector vectA, Vector vectB) {
        Vector result = new Vector();
        if (vectA == null) {
            return result;
        }
        if (vectB == null) {
            return (Vector)vectA.clone();
        }
        if (vectA.size() + vectB.size() > 10) {
            Object item;
            Hashtable workSetB = new Hashtable();
            Enumeration aTempEnum = vectB.elements();
            while (aTempEnum.hasMoreElements()) {
                item = aTempEnum.nextElement();
                workSetB.put(item, item);
            }
            aTempEnum = vectA.elements();
            while (aTempEnum.hasMoreElements()) {
                item = aTempEnum.nextElement();
                if (workSetB.containsKey(item)) continue;
                result.addElement(item);
            }
        } else {
            for (int i = 0; i < vectA.size(); ++i) {
                Object item = vectA.elementAt(i);
                if (vectB.contains(item)) continue;
                result.addElement(item);
            }
        }
        return result;
    }

    public static List compareDifference(Collection vectA, Collection vectB) {
        Collection tempA = vectA;
        Collection tempB = vectB;
        if (vectA != null && vectB != null && vectB.size() > vectA.size()) {
            tempA = vectB;
            tempB = vectA;
        }
        return VectorHelper.difference(tempA, tempB);
    }

    public static List compareSequence(List vectA, List vectB) {
        List tempA = vectA;
        List tempB = vectB;
        if (vectA != null && vectB != null && vectB.size() > vectA.size()) {
            tempA = vectB;
            tempB = vectA;
        }
        return VectorHelper.sameSequence(tempA, tempB);
    }

    public static List difference(Collection vectA, Collection vectB) {
        Vector result = new Vector();
        Collection temp = null;
        if (vectA != null && vectB != null && vectB.size() > vectA.size()) {
            temp = vectA;
            vectA = vectB;
            vectB = temp;
        }
        if (vectA == null) {
            return result;
        }
        if (vectB == null) {
            return ArrayUtil.toList(vectA.toArray());
        }
        if (vectA.size() + vectB.size() > 10) {
            Object item;
            HashMap workSetB = new HashMap();
            Iterator aTempEnum = vectB.iterator();
            while (aTempEnum.hasNext()) {
                item = aTempEnum.next();
                workSetB.put(item, item);
            }
            aTempEnum = vectA.iterator();
            while (aTempEnum.hasNext()) {
                item = aTempEnum.next();
                if (workSetB.containsKey(item)) continue;
                result.addElement(item);
            }
        } else {
            Iterator aTempEnum = vectA.iterator();
            while (aTempEnum.hasNext()) {
                Object item = aTempEnum.next();
                if (vectB.contains(item)) continue;
                result.addElement(item);
            }
        }
        return result;
    }

    public static Vector duplicates(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector result = null;
        Hashtable found = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            Object item = vector.elementAt(i);
            if (found.containsKey(item)) {
                if (result == null) {
                    result = new Vector();
                }
                VectorHelper.unionAdd(result, item);
            }
            found.put(item, item);
        }
        return result;
    }

    public static List removeDuplicates(List vector) {
        if (vector == null) {
            return null;
        }
        if (vector.size() == 0) {
            return vector;
        }
        boolean nullAdded = false;
        Vector<Object> result = null;
        Hashtable found = new Hashtable(vector.size());
        int vs = vector.size();
        for (int i = 0; i < vs; ++i) {
            Object item = vector.get(i);
            if (item == null) {
                if (nullAdded) continue;
                if (result == null) {
                    result = new Vector<Object>(vector.size());
                }
                result.add(null);
                nullAdded = true;
                continue;
            }
            if (found.containsKey(item)) continue;
            if (result == null) {
                result = new Vector(vector.size());
            }
            if (item == null) continue;
            result.add(item);
            found.put(item, item);
        }
        return result;
    }

    public static List keepEvery(List array, int every) {
        if (array == null || array.size() == 0 || every == 1) {
            return array;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            if ((i + 1) % every == 0) continue;
            array.remove(i);
        }
        return array;
    }

    public static List removeEvery(List array, int every) {
        if (array == null || array.size() == 0) {
            return array;
        }
        if (every == 1) {
            array.clear();
            return array;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            if ((i + 1) % every != 0) continue;
            array.remove(i);
        }
        return array;
    }

    public static List removeDuplicatesLastWins(List aList) {
        if (aList == null) {
            return null;
        }
        HashMap found = new HashMap(aList.size());
        for (int i = aList.size() - 1; i >= 0; --i) {
            Object item = aList.get(i);
            if (found.containsKey(item)) continue;
            found.put(item, item);
        }
        aList.clear();
        aList.addAll(found.values());
        return aList;
    }

    public static List removeLast(List aList, int count) {
        if (aList == null) {
            return null;
        }
        int from = aList.size() - 1;
        int to = from - count;
        to = to < 0 ? 0 : to;
        for (int i = from; i > to; --i) {
            aList.remove(i);
        }
        return aList;
    }

    public static Vector sameSequence(Vector a, Vector b) {
        int i;
        if (a == null || b == null) {
            return null;
        }
        Vector<Object> result = null;
        int bSize = b.size();
        int aSize = a.size();
        for (i = 0; i < aSize; ++i) {
            Object itemA = a.elementAt(i);
            Object itemB = null;
            if (i < bSize && (b.elementAt(i) == itemA || itemB != null && itemB.equals(itemA))) continue;
            if (result == null) {
                result = new Vector<Object>();
            }
            result.add(itemB);
        }
        if (bSize > aSize) {
            for (i = aSize; i < bSize; ++i) {
                Object itemB = b.elementAt(i);
                if (result == null) {
                    result = new Vector();
                }
                result.add(itemB);
            }
        }
        return result;
    }

    public static Vector sameSequence(List a, List b) {
        int i;
        if (a == null || b == null) {
            return null;
        }
        Vector<Object> result = null;
        int bSize = b.size();
        int aSize = a.size();
        for (i = 0; i < aSize; ++i) {
            Object itemA = a.get(i);
            Object itemB = null;
            if (i < bSize && (b.get(i) == itemA || itemB != null && itemB.equals(itemA))) continue;
            if (result == null) {
                result = new Vector();
            }
            result.add(itemB);
        }
        if (bSize > aSize) {
            for (i = aSize; i < bSize; ++i) {
                Object itemB = b.get(i);
                if (result == null) {
                    result = new Vector();
                }
                result.add(itemB);
            }
        }
        if (result == null) {
            result = new Vector<Object>();
        }
        return result;
    }

    public static Vector minus(Vector vectA, Vector vectB) {
        Vector result = new Vector();
        if (vectA == null) {
            return result;
        }
        result = (Vector)vectA.clone();
        if (vectB != null) {
            Enumeration aTempEnum = vectB.elements();
            while (aTempEnum.hasMoreElements()) {
                Object item = aTempEnum.nextElement();
                if (!result.contains(item)) continue;
                result.removeElement(item);
            }
        }
        return result;
    }

    public static String vectorString(Vector vec) {
        if (vec == null) {
            return "";
        }
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < vec.size(); ++i) {
            if (i > 0) {
                temp.append(",");
            }
            temp.append(vec.elementAt(i));
        }
        return temp.toString();
    }

    public static String vectorString(Vector vec, String method) {
        if (vec == null) {
            return "";
        }
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < vec.size(); ++i) {
            if (i > 0) {
                temp.append(",");
            }
            Object result = IntroSpectionHelper.callFunktion(vec.elementAt(i), method);
            temp.append(result);
        }
        return temp.toString();
    }

    public static List copy(List toClone) {
        int size = toClone.size();
        Vector result = new Vector(size);
        for (int t = 0; t < size; ++t) {
            result.add(toClone.get(t));
        }
        return result;
    }

    public static boolean isSame(List listA, List listB) {
        if (listA.size() != listB.size()) {
            return false;
        }
        for (int a = 0; a < listA.size(); ++a) {
            if (listA.get(a) == listB.get(a)) continue;
            return false;
        }
        return true;
    }

    public static Vector stringVector(String input, String sepChars) {
        Vector<String> results = new Vector<String>();
        int index = 0;
        int oldindex = 0;
        char[] inputAry = input.toCharArray();
        while (index != -1) {
            String temp;
            while (oldindex < input.length() && sepChars.indexOf(inputAry[oldindex]) != -1) {
                ++oldindex;
            }
            if (oldindex == input.length()) break;
            index = VectorHelper.findNextSep(input, oldindex, sepChars);
            if (index == -1) {
                temp = input.substring(oldindex);
                results.addElement(temp);
                continue;
            }
            temp = input.substring(oldindex, index);
            results.addElement(temp);
            oldindex = index + 1;
        }
        return results;
    }

    private static int findNextSep(String input, int startDex, String sepChars) {
        int currentIndex = input.length();
        char[] sepAry = sepChars.toCharArray();
        boolean foundSep = false;
        for (int i = 0; i < sepAry.length; ++i) {
            int tempdex = input.indexOf(sepAry[i], startDex);
            if (tempdex <= -1 || tempdex > currentIndex) continue;
            currentIndex = tempdex;
            foundSep = true;
        }
        if (foundSep) {
            return currentIndex;
        }
        return -1;
    }

    public static void main(String[] args) {
        Vector<String> a = new Vector<String>();
        a.add("1");
        a.add("2");
        a.add("3");
        a.add("4");
        a.add("5");
        a.add("6");
        a.add("7");
        a.add("8");
        a.add("9");
        a.add("10");
        a.add("11");
        VectorHelper.removeLast(a, 3);
        VectorHelper.keepEvery(a, 4);
        VectorHelper.removeDuplicatesLastWins(a);
        Vector<String> b = new Vector<String>();
        b.add("a");
        b.add("b");
        b.add("c");
        b.add("d");
        VectorHelper.sameSequence(a, b);
        Vector<String> as = new Vector<String>();
        as.add("a");
        as.add("b");
        as.add("c");
        b = new Vector();
        b.add("a");
        b.add("b");
        b.add("c");
        b.add("d");
        VectorHelper.sameSequence(as, b);
        a = new Vector();
        a.add("a");
        a.add("b");
        a.add("c");
        a.add("d");
        Vector<String> bs = new Vector<String>();
        bs.add("a");
        bs.add("b");
        bs.add("c");
        bs.add(null);
        System.out.println(ArrayUtil.toString(VectorHelper.sameSequence(a, bs)));
        Vector<String> an = new Vector<String>();
        an.add("a");
        an.add(null);
        an.add("c");
        an.add("d");
        Vector<String> bn = new Vector<String>();
        bn.add("a");
        bn.add("b");
        bn.add("c");
        System.out.println(ArrayUtil.toString(VectorHelper.sameSequence(an, bn)));
    }

    public static List getStartsWith(List array, String sword) {
        ArrayList result = new ArrayList(5);
        for (int a = 0; a < array.size(); ++a) {
            Object aObj = array.get(a);
            if (aObj == null || !aObj.toString().startsWith(sword)) continue;
            result.add(aObj);
        }
        return result;
    }

    public static List getEndsWith(List array, String sword) {
        ArrayList result = new ArrayList(5);
        for (int a = 0; a < array.size(); ++a) {
            Object aObj = array.get(a);
            if (aObj == null || !aObj.toString().endsWith(sword)) continue;
            result.add(aObj);
        }
        return result;
    }

    public static List getContains(List array, String sword) {
        ArrayList result = new ArrayList(5);
        for (int a = 0; a < array.size(); ++a) {
            Object aObj = array.get(a);
            if (aObj == null || aObj.toString().indexOf(sword) < 0) continue;
            result.add(aObj);
        }
        return result;
    }
}

