/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.w3c.dom.ls.LSInput;

public class FileHelper {
    private File _openFile = null;
    public static final String PROTOCOL_FILE = "file";
    public static final String ESCPAE_HTML = "HTML";
    private OutputStream _fileOutStream = null;

    public FileHelper(String resourceURL) throws FileNotFoundException, MalformedURLException {
        this.openFileEntry(new URL(resourceURL));
    }

    public FileHelper(String resourceURL, boolean createDirs) throws FileNotFoundException, MalformedURLException {
        this.openFileEntry(new URL(resourceURL), createDirs);
    }

    public FileHelper(URL resourceURL) throws FileNotFoundException {
        this.openFileEntry(resourceURL);
    }

    public FileHelper(URL resourceURL, boolean createDirs) throws FileNotFoundException {
        this.openFileEntry(resourceURL, createDirs);
    }

    public FileHelper(File file) throws FileNotFoundException, MalformedURLException {
        this.openFileEntry(file.toURL());
    }

    public FileHelper(File file, boolean createDirs) throws FileNotFoundException, MalformedURLException {
        this.openFileEntry(file.toURL(), createDirs);
    }

    public FileHelper() throws FileNotFoundException {
    }

    public static void save(Object myObject, String filename) {
        block2: {
            try {
                FileOutputStream out = new FileOutputStream(filename);
                ObjectOutputStream oos = new ObjectOutputStream(out);
                oos.writeObject(myObject);
                oos.close();
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                if (!LogRegistry.getInstance().logWarnings()) break block2;
                LogRegistry.getInstance().warn(FileHelper.class, "Unble to save object (" + myObject + ") fileName: " + filename);
                LogRegistry.getInstance().warn(FileHelper.class, " ---> Reason: " + e.getMessage());
            }
        }
    }

    public static void closeStream(Closeable s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] readFile(String filename) throws IOException {
        URL fileUrl = new URL(filename);
        return FileHelper.readFile(fileUrl);
    }

    public static byte[] readFile(File file) throws IOException {
        URL fileUrl = file.toURL();
        return FileHelper.readFile(fileUrl);
    }

    public static byte[] readFile(URL fileUrl) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream in = JAXFrontProperties.getInstance().getURLResolver().resolveURL(fileUrl);
        FileHelper.write(in, (OutputStream)bos);
        bos.close();
        in.close();
        return bos.toByteArray();
    }

    public static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileHelper.write(in, (OutputStream)bos);
        bos.close();
        in.close();
        return bos.toByteArray();
    }

    public static byte[] read(Reader in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileHelper.write(in, (OutputStream)bos);
        bos.close();
        in.close();
        return bos.toByteArray();
    }

    public static String readAsString(Reader in) throws IOException {
        StringWriter sw = new StringWriter();
        FileHelper.write(in, (Writer)sw);
        in.close();
        return sw.toString();
    }

    public static String removeFileNameExtension(String fileName) {
        if (fileName != null && fileName.lastIndexOf(".") >= 0) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public static String getFileNameExtension(File file) {
        return FileHelper.getFileNameExtension(file, true);
    }

    public static String getFileNameExtension(File file, boolean includeDot) {
        String fileName = file.getName();
        return FileHelper.getFileNameExtension(fileName, includeDot);
    }

    public static String getFileName(String fileName, boolean includeExt) {
        int lastDotIndex = -1;
        if (fileName != null && (lastDotIndex = fileName.lastIndexOf(".")) >= 0) {
            fileName = fileName.substring(0, lastDotIndex);
            return fileName;
        }
        return null;
    }

    public static String getFileNameExtension(String fileName, boolean includeDot) {
        int lastDotIndex = -1;
        if (fileName != null && (lastDotIndex = fileName.lastIndexOf(".")) >= 0) {
            if (!includeDot) {
                ++lastDotIndex;
            }
            fileName = fileName.substring(lastDotIndex, fileName.length());
            return fileName;
        }
        return null;
    }

    public static String readFileAsString(URL fileUrl) throws IOException {
        return FileHelper.readFileAsString(fileUrl, null);
    }

    public static String readFileAsString(File file) throws IOException {
        return FileHelper.readFileAsString(file.toURL(), null);
    }

    public static String[][] readDelimFile(URL fileUrl, String delim) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(fileUrl.getFile()));
        String line = null;
        Vector<String[]> lines = new Vector<String[]>();
        String[][] result = null;
        while ((line = reader.readLine()) != null) {
            String[] entries = StringUtil.split(line, delim);
            lines.add(entries);
        }
        result = new String[lines.size()][];
        for (int l = 0; l < result.length; ++l) {
            result[l] = (String[])lines.get(l);
        }
        return result;
    }

    public static String readFileAsString(URL fileUrl, String encoding) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream in = JAXFrontProperties.getInstance().getURLResolver().resolveURL(fileUrl);
        FileHelper.write(in, (OutputStream)bos);
        bos.close();
        in.close();
        if (encoding != null) {
            return new String(bos.toByteArray(), encoding);
        }
        return new String(bos.toByteArray());
    }

    public static String readFileAsString(LSInput xsdInput) throws IOException {
        Reader aReader = xsdInput.getCharacterStream();
        StringBuffer content = new StringBuffer();
        if (aReader != null) {
            String inputLine;
            BufferedReader in = new BufferedReader(aReader);
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine + "\n");
            }
            in.close();
        }
        return content.toString();
    }

    public static String readFileAsString(LSInput xsdInput, int bufferLen) throws IOException {
        Reader aReader = xsdInput.getCharacterStream();
        StringBuffer content = new StringBuffer();
        if (aReader != null) {
            int cSize;
            BufferedReader in = new BufferedReader(aReader);
            char[] cbuf = new char[bufferLen];
            while ((cSize = in.read(cbuf)) > 0) {
                content.append(cbuf, 0, cSize);
            }
            in.close();
        }
        return content.toString();
    }

    public static Reader getReader(LSInput xsdInput) throws IOException {
        Reader aReader = xsdInput.getCharacterStream();
        if (aReader == null) {
            aReader = new StringReader("");
        }
        return aReader;
    }

    public static String readAsString(InputStream in, String encoding) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileHelper.write(in, (OutputStream)bos);
        bos.close();
        in.close();
        if (encoding != null) {
            return new String(bos.toByteArray(), encoding);
        }
        return new String(bos.toByteArray());
    }

    public static OutputStream write(InputStream inStream, OutputStream outstream) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(outstream);
        BufferedInputStream bis = new BufferedInputStream(inStream);
        byte[] rgb = new byte[10000];
        int readCounter = 0;
        while ((readCounter = bis.read(rgb)) > -1) {
            bos.write(rgb, 0, readCounter);
        }
        bos.flush();
        return bos;
    }

    public static OutputStream write(InputStream inStream, OutputStream outstream, String srcEncoding) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(outstream);
        BufferedInputStream bis = new BufferedInputStream(inStream);
        byte[] rgb = new byte[10000];
        int readCounter = 0;
        while ((readCounter = bis.read(rgb)) > -1) {
            rgb = new String(rgb, 0, readCounter, srcEncoding).getBytes();
            bos.write(rgb);
        }
        bos.flush();
        return bos;
    }

    public static Writer write(Reader inReader, Writer outwriter) throws IOException {
        BufferedWriter bos = new BufferedWriter(outwriter);
        BufferedReader br = new BufferedReader(inReader);
        char[] rgb = new char[10000];
        int readCounter = 0;
        while ((readCounter = br.read(rgb)) > -1) {
            bos.write(rgb, 0, readCounter);
        }
        bos.flush();
        return bos;
    }

    public static OutputStream write(Reader inReader, OutputStream outwriter) throws IOException {
        StringWriter bos = new StringWriter();
        BufferedReader br = new BufferedReader(inReader);
        char[] rgb = new char[10000];
        int readCounter = 0;
        while ((readCounter = br.read(rgb)) > -1) {
            bos.write(rgb, 0, readCounter);
        }
        bos.flush();
        outwriter.write(bos.toString().getBytes());
        return outwriter;
    }

    public static void save(StringBuffer buffer, File file, String encoding) throws IOException {
        FileHelper.save(buffer.toString(), file, encoding);
    }

    public static void save(String buffer, File file, String encoding) throws IOException {
        try {
            FileHelper.write(buffer, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        }
        catch (IOException e) {
            if (LogRegistry.getInstance().logInfos() && JAXFrontProperties.LOG_ENABLED) {
                LogRegistry.getInstance().info(DOMHelper.class, e.toString());
            }
            throw e;
        }
    }

    public static void write(String buffer, Writer writer) throws IOException {
        writer = new BufferedWriter(writer);
        writer.write(buffer);
        writer.close();
    }

    public static boolean fileExist(File file) {
        return file.exists();
    }

    public static boolean fileExist(String file) {
        if (file == null) {
            return false;
        }
        return FileHelper.fileExist(new File(file));
    }

    public void openFileEntry(URL filename) throws FileNotFoundException {
        this.openFileEntry(filename, false);
    }

    public void openFileEntry(URL filename, boolean createDirs) throws FileNotFoundException {
        this._openFile = new File(filename.getFile());
        if (createDirs) {
            FileHelper.mkdirs(this._openFile, false);
        }
        this._fileOutStream = new FileOutputStream(this._openFile);
    }

    public void closeFileEntry() throws IOException {
        this._fileOutStream.flush();
        this._fileOutStream.close();
    }

    public FileHelper writeIntoFile(InputStream in) throws IOException {
        FileHelper.write(in, this._fileOutStream);
        return this;
    }

    public FileHelper writeIntoFile(Reader in) throws IOException {
        FileHelper.write(in, (Writer)new OutputStreamWriter(this._fileOutStream));
        return this;
    }

    public FileHelper writeIntoFile(char[] in) throws IOException {
        FileHelper.write((Reader)new CharArrayReader(in), (Writer)new OutputStreamWriter(this._fileOutStream));
        return this;
    }

    public FileHelper writeIntoFile(byte[] in) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(this._fileOutStream);
        ByteArrayInputStream bis = new ByteArrayInputStream(in);
        FileHelper.write(bis, (OutputStream)bos);
        return this;
    }

    public FileHelper writeIntoFile(String in) throws IOException {
        this.writeIntoFile(in.toCharArray());
        return this;
    }

    public static void copy(File source, File destination) throws IOException {
        FileHelper.copy(source.toURL(), destination.toURL());
    }

    public static void copy(URL source, File destination) throws IOException {
        FileHelper.copy(source, destination.toURL());
    }

    public static void copy(URL source, URL destination) throws IOException {
        try {
            InputStream sourceIs = null;
            Object destArray = null;
            sourceIs = FileHelper.getResourceFromHTTP(source);
            BufferedInputStream bis = new BufferedInputStream(sourceIs);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(destination.getFile()))));
            byte[] rgb = new byte[10000];
            int readCounter = 0;
            while ((readCounter = bis.read(rgb)) > -1) {
                dos.write(rgb, 0, readCounter);
            }
            dos.flush();
            bis.close();
            sourceIs.close();
            dos.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private static InputStream getResourceFromHTTP(URL url) throws IOException {
        InputStream aResourceInputStream = null;
        URL locationURL = url;
        aResourceInputStream = JAXFrontProperties.getInstance().getURLResolver().resolveURL(locationURL);
        return aResourceInputStream;
    }

    public static void deleteDir(File file, boolean deep) {
        FileHelper.deleteDir(file.listFiles(), deep);
        file.delete();
    }

    public static void deleteDir(File[] file, boolean deep) {
        for (int i = 0; i < file.length; ++i) {
            File f = file[i];
            if (deep && f.isDirectory()) {
                File[] children = f.listFiles();
                FileHelper.deleteDir(children, deep);
                f.delete();
                continue;
            }
            if (!f.isFile()) continue;
            f.delete();
        }
    }

    public static boolean mkdirs(File file, boolean includingLeaf) {
        if (includingLeaf) {
            return file.mkdirs();
        }
        String parent = file.getParent();
        if (parent != null) {
            return new File(parent).mkdirs();
        }
        return true;
    }

    public static File getDirectory(URL fileToOpen) {
        return FileHelper.getDirectory(new File(fileToOpen.getFile()));
    }

    public static File getDirectory(File source) {
        if (source != null) {
            if (source.isDirectory()) {
                return source;
            }
            return source.getParentFile();
        }
        return null;
    }

    public static String tail(String fileName, int lineCount) {
        StringWriter sw = new StringWriter();
        try {
            FileHelper.tail(fileName, lineCount, 2000, sw, null);
        }
        catch (IOException e) {
            LogRegistry.getInstance().error(FileHelper.class, e);
        }
        return sw.toString();
    }

    public static void tail(String fileName, int lineCount, PrintWriter writer, String escapeAs) {
        try {
            if (FileHelper.fileExist(fileName)) {
                FileHelper.tail(fileName, lineCount, 2000, writer, escapeAs);
            }
        }
        catch (IOException e) {
            LogRegistry.getInstance().error(FileHelper.class, e);
        }
    }

    public static void tail(String fileName, int lineCount, int bufferSize, Writer pw, String escapeAs) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        if (lineCount == -1) {
            lineCount = Integer.MAX_VALUE;
        }
        byte[] seekbuffer = new byte[bufferSize];
        long raLength = raf.length();
        long junkSize = raLength / (long)seekbuffer.length;
        int readRows = 0;
        long lastSeekPos = -1L;
        if (raLength < (long)seekbuffer.length) {
            lastSeekPos = raLength;
        }
        for (long js = 1L; js <= junkSize + 1L; ++js) {
            long seekPos = raLength - js * (long)seekbuffer.length;
            if (seekPos < 0L) {
                raf.seek(0L);
                seekbuffer = new byte[(int)lastSeekPos];
                raf.read(seekbuffer);
                break;
            }
            raf.seek(seekPos);
            raf.read(seekbuffer);
            lastSeekPos = seekPos;
            StringBuffer sb = new StringBuffer();
            int[] paresRes = FileHelper.parseLines(seekbuffer, lineCount - readRows, sb);
            int n = readRows;
            readRows = paresRes[0];
            readRows = n + readRows;
            if (ESCPAE_HTML.equalsIgnoreCase(escapeAs)) {
                pw.write(StringUtil.escapeHTML(sb.toString()));
            } else {
                pw.write(sb.toString());
            }
            pw.flush();
            if (readRows >= lineCount || seekPos < 0L) break;
        }
        if (raf != null) {
            raf.close();
        }
    }

    public static int[] parseLines(byte[] seekbuffer, int rows, StringBuffer sb) throws IOException {
        int s;
        int r = 0;
        String seekString = new String(seekbuffer);
        int[] result = new int[2];
        int rowEndPos = seekString.length() - 1;
        for (s = seekString.length() - 1; s >= 0; --s) {
            if (seekString.charAt(s) != '\n') continue;
            String aLine = seekString.substring(s, rowEndPos);
            sb.append(aLine);
            rowEndPos = s;
            if (++r <= rows) continue;
            result[1] = rowEndPos;
            result[0] = r;
            return result;
        }
        if (s != rowEndPos && s < 0) {
            result[1] = rowEndPos;
            sb.append(new String(seekbuffer, 0, rowEndPos));
        }
        result[0] = r;
        return result;
    }

    public static StringBuffer tailLines(int rows, StringBuffer seekString) throws IOException {
        int s;
        int r = 0;
        StringBuffer result = new StringBuffer();
        int rowEndPos = seekString.length() - 1;
        for (s = seekString.length() - 1; s >= 0; --s) {
            if (seekString.charAt(s) != '\n') continue;
            String aLine = seekString.substring(s, rowEndPos);
            result.append(aLine);
            rowEndPos = s;
            if (++r <= rows) continue;
            return result;
        }
        if (s != rowEndPos && s < 0) {
            result.append(new String());
        }
        return result;
    }

    public static String getDirectory(String completeFile) {
        return FileHelper.getDirectory(completeFile, true);
    }

    public static String getDirectory(String completeFile, boolean returnFileIfNone) {
        if (completeFile != null) {
            int sepIDX = completeFile.lastIndexOf("/");
            if (sepIDX != -1) {
                completeFile = completeFile.substring(0, sepIDX);
            } else {
                sepIDX = completeFile.lastIndexOf("\\");
                if (sepIDX != -1) {
                    completeFile = completeFile.substring(0, sepIDX);
                } else if (!returnFileIfNone) {
                    return "";
                }
            }
        }
        return completeFile;
    }

    public static String getFileName(File completeFile) {
        String fileName = completeFile.getName();
        if (fileName != null) {
            int sepIDX = fileName.lastIndexOf("/");
            if (sepIDX != -1) {
                fileName = fileName.substring(sepIDX + 1);
            } else {
                sepIDX = fileName.lastIndexOf("\\");
                if (sepIDX != -1) {
                    fileName = fileName.substring(sepIDX + 1);
                }
            }
        }
        return fileName;
    }

    public static String replaceFileName(String file, String newName) {
        String fName = FileHelper.getFileName(file);
        int lIdx = file.lastIndexOf(fName);
        if (lIdx != -1) {
            String newPath = file.substring(0, lIdx);
            return newPath + newName;
        }
        return file;
    }

    public static String getFileName(String fileName) {
        if (fileName != null) {
            int sepIDX = fileName.lastIndexOf("/");
            if (sepIDX != -1) {
                fileName = fileName.substring(sepIDX + 1);
            } else {
                sepIDX = fileName.lastIndexOf("\\");
                if (sepIDX != -1) {
                    fileName = fileName.substring(sepIDX + 1);
                }
            }
        }
        return fileName;
    }

    public static String replaceFileExtension(String fileName, String extension) {
        String ext = FileHelper.getFileNameExtension(fileName, false);
        if (ext != null) {
            return fileName.substring(0, fileName.length() - ext.length()) + extension;
        }
        return fileName + "." + extension;
    }
}

