/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Stack;
import java.util.zip.CRC32;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZIPCompressor {
    private ZipOutputStream _zos = null;
    private ZipEntry _currentEntry = null;
    private CRC32 _currentCRC32 = null;
    private static int _bufferSize = 1024;
    private static int _staticBufferSize = 1024;
    private int _level = 9;
    private Stack _entryStack = null;

    public ZIPCompressor(OutputStream outStream) {
        this(outStream, 9);
    }

    public ZIPCompressor(OutputStream outStream, int zipLevel) {
        this._zos = new ZipOutputStream(outStream);
        this._zos.setLevel(zipLevel);
        this._entryStack = new Stack();
    }

    public void addZipEntry(String id) throws IOException {
        this._currentEntry = new ZipEntry(this.getIdFromStack() + id);
        this._entryStack.push(this._currentEntry);
        this._zos.putNextEntry(this._currentEntry);
    }

    public void addZipEntryAbsPath(String path) throws IOException {
        this._currentEntry = new ZipEntry(path);
        this._entryStack.push(this._currentEntry);
        this._zos.putNextEntry(this._currentEntry);
    }

    public void closeZipEntry() throws IOException {
        this._currentEntry.setTime(System.currentTimeMillis());
        this._zos.flush();
        this._currentEntry.setCrc(this.getCurrentCRC().getValue());
        this._zos.closeEntry();
        this._currentCRC32 = new CRC32();
        this._currentEntry = (ZipEntry)this._entryStack.pop();
    }

    public void write(InputStream inStream) throws IOException {
        this.write(inStream, this._zos, this.getCurrentCRC());
    }

    public void writeConverted(InputStream inputStream, String sourceEncoding) throws IOException {
        InputStreamReader in = new InputStreamReader(inputStream, sourceEncoding);
        OutputStreamWriter ousw = new OutputStreamWriter(this._zos);
        this.write(ousw, in);
    }

    public void write(byte[] toBeCompressed) throws IOException {
        this.write(new ByteArrayInputStream(toBeCompressed), this._zos, this.getCurrentCRC());
    }

    private OutputStreamWriter write(OutputStreamWriter outstream, InputStreamReader in) throws IOException {
        char[] rgb = new char[_bufferSize];
        int readCounter = 0;
        while ((readCounter = in.read(rgb)) > -1) {
            outstream.write(rgb, 0, readCounter);
        }
        outstream.flush();
        return outstream;
    }

    private OutputStream write(InputStream inStream, OutputStream outstream, CRC32 crc) throws IOException {
        byte[] rgb = new byte[_bufferSize];
        int readCounter = 0;
        while ((readCounter = inStream.read(rgb)) > -1) {
            crc.update(rgb);
            outstream.write(rgb, 0, readCounter);
        }
        outstream.flush();
        return outstream;
    }

    public void setBufferSize(int size) {
        _bufferSize = size;
    }

    private CRC32 getCurrentCRC() {
        if (this._currentCRC32 == null) {
            this._currentCRC32 = new CRC32();
        }
        return this._currentCRC32;
    }

    private void setCurrentCRC(CRC32 crc) {
        this._currentCRC32 = crc;
    }

    public OutputStream getOutStream() {
        return this._zos;
    }

    public void close() throws IOException {
        this._zos.flush();
        this._zos.close();
    }

    public String getIdFromStack() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this._entryStack.size(); ++i) {
            result.append(this._entryStack.get(i));
        }
        return result.toString();
    }

    public static byte[] zip(InputStream is) throws IOException {
        int read = 0;
        byte[] data = new byte[_staticBufferSize];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(bos);
        while ((read = is.read(data, 0, _staticBufferSize)) != -1) {
            out.write(data, 0, read);
        }
        is.close();
        out.close();
        bos.close();
        bos.flush();
        return bos.toByteArray();
    }

    public static byte[] zip(byte[] value) throws IOException {
        return ZIPCompressor.zip(new ByteArrayInputStream(value));
    }
}

