/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.cache;

import com.jaxfront.core.util.io.cache.AbstractLockManager;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CountdownLockManager
extends AbstractLockManager {
    protected static CountdownLockManager _instance = null;

    public static synchronized CountdownLockManager getInstance() {
        if (_instance == null) {
            _instance = new CountdownLockManager();
        }
        return _instance;
    }

    public synchronized boolean lock(String key) {
        if (!this.getLocked().containsKey(key)) {
            this.getLocked().put(key, new CountDownLatch(1));
            return true;
        }
        return false;
    }

    public void release() {
        if (this.getLocked() != null) {
            this.getLocked().clear();
        }
        this._locked = null;
    }

    public void release(String key) {
        CountDownLatch old;
        if (this._locked == null || (old = (CountDownLatch)this._locked.remove(key)) != null) {
            // empty if block
        }
    }

    public synchronized boolean isLocked(String key) {
        return this._locked.containsKey(key);
    }

    public void waitForUnlock(String id) {
        CountDownLatch latch = (CountDownLatch)this._locked.get(id);
        if (latch != null) {
            try {
                if (this._timeOut == -1L) {
                    latch.await();
                } else {
                    latch.await(this._timeOut, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void handleLock(String lockKey) {
        if (this.isLocked(lockKey)) {
            this.waitForUnlock(lockKey);
        } else {
            boolean alreadyLocked = this.lock(lockKey);
            if (!alreadyLocked) {
                this.waitForUnlock(lockKey);
            }
        }
    }

    public synchronized void unlock(String key) {
        if (this._locked.containsKey(key)) {
            CountDownLatch latch = (CountDownLatch)this._locked.get(key);
            latch.countDown();
            this._locked.remove(key);
        }
    }
}

