/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.cache;

import com.jaxfront.core.util.io.cache.AbstractLockManager;
import java.util.concurrent.Semaphore;

public class SemaphoreLockManager
extends AbstractLockManager {
    private static SemaphoreLockManager _instance = null;

    private SemaphoreLockManager() {
    }

    public static synchronized SemaphoreLockManager getInstance() {
        if (_instance == null) {
            _instance = new SemaphoreLockManager();
        }
        return _instance;
    }

    public synchronized Semaphore getSemaphore(String key) {
        Semaphore sema = (Semaphore)this.getLocked().get(key);
        if (sema == null) {
            sema = new Semaphore(1);
            this.getLocked().put(key, sema);
        }
        return sema;
    }

    public void release() {
        if (this._locked != null) {
            this._locked.clear();
        }
        this._locked = null;
    }

    public void release(String key) {
        Semaphore old;
        if (this._locked != null && (old = (Semaphore)this._locked.remove(key)) != null) {
            old.release();
        }
    }
}

