/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.cache;

import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.util.JAXFrontProperties;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class XMLSchemaCache {
    public static final String IS_SCHEMA_INIT_MODE = "isSchemaInitMode";
    private Hashtable _schemaCache;
    private static final XMLSchemaCache _singleton = new XMLSchemaCache();

    public XMLSchema cache(String context, String key, XMLSchema schema) {
        if (JAXFrontProperties.getInstance(context).isUsingXSDCache()) {
            this.getSchemaCache().put(key, schema);
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put(IS_SCHEMA_INIT_MODE, "true");
        }
        return schema;
    }

    public XMLSchema cache(String context, URL schemaURL, XMLSchema schema) {
        if (JAXFrontProperties.getInstance(context).isUsingXSDCache()) {
            this.cache(context, this.createKey(schemaURL), schema);
        }
        return schema;
    }

    private String createKey(URL xsdURL) {
        if (xsdURL == null) {
            return "XUI";
        }
        return xsdURL.toExternalForm();
    }

    public XMLSchema getCached(String key) {
        return (XMLSchema)this.getSchemaCache().get(key);
    }

    public XMLSchema getCached(URL schemaURL) {
        return this.getCached(this.createKey(schemaURL));
    }

    public static synchronized XMLSchemaCache getInstance() {
        return _singleton;
    }

    public Hashtable getSchemaCache() {
        if (this._schemaCache == null) {
            this._schemaCache = new Hashtable();
        }
        return this._schemaCache;
    }

    public void releaseCache() {
        Enumeration schemas = this._schemaCache.elements();
        while (schemas.hasMoreElements()) {
            XMLSchema schema = (XMLSchema)schemas.nextElement();
            if (schema.isXUISchema()) continue;
            schema.release();
        }
        this._schemaCache.clear();
    }

    public void releaseCache(String startsWith) {
        Object[] entries = this._schemaCache.keySet().toArray();
        for (int i = 0; i < entries.length; ++i) {
            Object aKey = entries[i];
            if (!aKey.toString().startsWith(startsWith)) continue;
            XMLSchema schema = (XMLSchema)this._schemaCache.get(aKey);
            if (schema != null) {
                schema.release();
            }
            this._schemaCache.remove(aKey);
        }
    }

    public void flushSyncedState(String startsWith) {
        Object[] entries = this._schemaCache.keySet().toArray();
        for (int i = 0; i < entries.length; ++i) {
            XMLSchema schema;
            Object aKey = entries[i];
            if (!aKey.toString().startsWith(startsWith) || (schema = (XMLSchema)this._schemaCache.get(aKey)) == null) continue;
            schema.setSynced(false);
        }
    }

    public void flushSyncedState() {
        Object[] entries = this._schemaCache.keySet().toArray();
        for (int i = 0; i < entries.length; ++i) {
            Object aKey = entries[i];
            XMLSchema schema = (XMLSchema)this._schemaCache.get(aKey);
            if (schema == null) continue;
            schema.setSynced(false);
        }
    }

    public void releaseCached(XMLSchema schema) {
        if (schema.getURL() != null && !schema.isXUISchema()) {
            this.getSchemaCache().remove(this.createKey(schema.getURL()));
            schema.release();
        }
    }
}

