/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.classloader;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;

public abstract class ClassScope {
    private static final Field CLASSES_VECTOR_FIELD;
    private static final CallerResolver CALLER_RESOLVER;
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static final Throwable CVF_FAILURE;
    private static final Throwable CR_FAILURE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class[] getLoadedClasses(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("null input: loader");
        }
        if (CLASSES_VECTOR_FIELD == null) {
            throw new RuntimeException("ClassScope::getLoadedClasses() cannot be used in this JRE", CVF_FAILURE);
        }
        try {
            Class[] result;
            Vector classes = (Vector)CLASSES_VECTOR_FIELD.get(loader);
            if (classes == null) {
                return EMPTY_CLASS_ARRAY;
            }
            Vector vector = classes;
            synchronized (vector) {
                result = new Class[classes.size()];
                classes.toArray(result);
            }
            return result;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(System.out);
            return EMPTY_CLASS_ARRAY;
        }
    }

    public static Class[] getLoadedClasses(ClassLoader[] loaders) {
        if (loaders == null) {
            throw new IllegalArgumentException("null input: loaders");
        }
        LinkedList<Class> resultList = new LinkedList<Class>();
        for (int l = 0; l < loaders.length; ++l) {
            ClassLoader loader = loaders[l];
            if (loader == null) continue;
            Class[] classes = ClassScope.getLoadedClasses(loaders[l]);
            resultList.addAll(Arrays.asList(classes));
        }
        Class[] result = new Class[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public static ClassLoader[] getCallerClassLoaderTree() {
        if (CALLER_RESOLVER == null) {
            throw new RuntimeException("ClassScope::getCallerClassLoaderTree() cannot be used in this JRE", CR_FAILURE);
        }
        Class[] callContext = CALLER_RESOLVER.getClassContext();
        HashSet resultSet = new HashSet();
        for (int c = 2; c < callContext.length; ++c) {
            ClassScope.getClassLoaderTree(callContext[c], resultSet);
        }
        ClassLoader[] result = new ClassLoader[resultSet.size()];
        resultSet.toArray(result);
        return result;
    }

    public static URL getClassLocation(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        URL result = null;
        String clsAsResource = cls.getName().replace('.', '/').concat(".class");
        ProtectionDomain pd = cls.getProtectionDomain();
        if (pd != null) {
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                result = cs.getLocation();
            }
            if (result != null && "file".equals(result.getProtocol())) {
                try {
                    if (result.toExternalForm().endsWith(".jar") || result.toExternalForm().endsWith(".zip")) {
                        result = new URL("jar:".concat(result.toExternalForm()).concat("!/").concat(clsAsResource));
                    } else if (new File(result.getFile()).isDirectory()) {
                        result = new URL(result, clsAsResource);
                    }
                }
                catch (MalformedURLException ignore) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            ClassLoader clsLoader = cls.getClassLoader();
            result = clsLoader != null ? clsLoader.getResource(clsAsResource) : ClassLoader.getSystemResource(clsAsResource);
        }
        return result;
    }

    private ClassScope() {
    }

    private static void getClassLoaderTree(Class cls, Set resultSet) {
        if (cls != null && resultSet != null) {
            for (ClassLoader loader = cls.getClassLoader(); loader != null; loader = loader.getParent()) {
                resultSet.add(loader);
            }
        }
    }

    public static String dump() {
        ClassLoader[] loaders = ClassScope.getCallerClassLoaderTree();
        return ClassScope.dump(loaders);
    }

    public static String dump(ClassLoader[] loaders) {
        Class[] classes = ClassScope.getLoadedClasses(loaders);
        StringBuffer dump = new StringBuffer();
        for (int c = 0; c < classes.length; ++c) {
            Class cls = classes[c];
            dump.append("[" + cls.getName() + "]:");
            dump.append("<br/>");
            dump.append("  loaded by [" + cls.getClassLoader().getClass().getName() + "]");
            dump.append("<br/>");
            dump.append("  from [" + ClassScope.getClassLocation(cls) + "]");
            dump.append("<br/>");
        }
        return dump.toString();
    }

    static {
        EMPTY_CLASS_ARRAY = new Class[0];
        Throwable failure = null;
        Field tempf = null;
        try {
            tempf = ClassLoader.class.getDeclaredField("classes");
            if (tempf.getType() != Vector.class) {
                throw new RuntimeException("not of type java.util.Vector: " + tempf.getType().getName());
            }
            tempf.setAccessible(true);
        }
        catch (Throwable t) {
            failure = t;
        }
        CLASSES_VECTOR_FIELD = tempf;
        CVF_FAILURE = failure;
        failure = null;
        CallerResolver tempcr = null;
        try {
            tempcr = new CallerResolver();
        }
        catch (Throwable t) {
            failure = t;
        }
        CALLER_RESOLVER = tempcr;
        CR_FAILURE = failure;
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

