/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.classloader;

import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.classloader.IJREVersion;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpClassVersions
implements IJREVersion {
    public static final String USAGE = "usage: DumpClassVersions <list of dirs, class files, or .zip/.jar archives>";
    private static int s_classCount;
    private static int s_minMajor;
    private static int s_minMinor;
    private static int s_maxMajor;
    private static int s_maxMinor;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            throw new IllegalArgumentException(USAGE);
        }
        PrintWriter stdout = new PrintWriter(System.out, true);
        s_minMajor = Short.MAX_VALUE;
        for (int a = 0; a < args.length; ++a) {
            DumpClassVersions.dumpClassVersion(new File(args[a]), stdout);
        }
        if (s_classCount > 0) {
            stdout.println("-----------------------------------");
            stdout.println(new StringBuffer().append(s_classCount).append(" class(es) examined:").toString());
            stdout.println(new StringBuffer().append("min version: ").append(s_minMajor).append(".").append(s_minMinor).append("\t").append(DumpClassVersions.classVersionToTarget(s_minMajor, s_minMinor)).toString());
            stdout.println(new StringBuffer().append("max version: ").append(s_maxMajor).append(".").append(s_maxMinor).append("\t").append(DumpClassVersions.classVersionToTarget(s_maxMajor, s_maxMinor)).toString());
        } else {
            stdout.println("no classes found");
        }
    }

    public static String dump(String className, byte[] classBytes) {
        StringBuffer out = new StringBuffer();
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(classBytes));
            int magic = in.readInt();
            if (magic != -889275714) {
                out.append(new StringBuffer().append(className).append(" is not a valid class!").toString());
            }
            int minor = in.readUnsignedShort();
            int major = in.readUnsignedShort();
            String java = "";
            switch (major) {
                case 45: {
                    java = "1.0,1.1";
                    break;
                }
                case 46: {
                    java = "1.2";
                    break;
                }
                case 47: {
                    java = "1.3";
                    break;
                }
                case 48: {
                    java = "1.4";
                    break;
                }
                case 49: {
                    java = "1.5";
                    break;
                }
                case 50: {
                    java = "1.6";
                }
            }
            out.append(new StringBuffer().append(className).append(" ").append(java).append(": ").append(major).append(" . ").append(minor).toString());
            in.close();
        }
        catch (IOException e) {
            out.append(new StringBuffer().append("Exception: ").append(e.getMessage()).toString());
        }
        return out.toString();
    }

    public static void dumpClassVersion(File file, PrintWriter out) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (out == null) {
            throw new IllegalArgumentException("null input: out");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(new StringBuffer().append("does not exist: [").append(file).append("]").toString());
        }
        String lcName = file.getName().toLowerCase();
        if (file.isDirectory()) {
            DumpClassVersions.dumpDirectory(file, out);
        } else if (lcName.endsWith(".zip") || lcName.endsWith(".jar")) {
            DumpClassVersions.dumpArchive(file, out);
        } else if (lcName.endsWith(".class")) {
            DumpClassVersions.dumpClassFile(file, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpClassFile(File file, PrintWriter out) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file), 8);
            DumpClassVersions.dumpClassFile(file.getName(), JRE_1_2_PLUS ? file.getParentFile().toURL().toExternalForm() : file.getParent(), in, out);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void dumpClassFile(String className, String location, byte[] in, PrintWriter out) throws IOException {
        DumpClassVersions.dumpClassFile(className, location, new ByteArrayInputStream(in), out);
    }

    public static void dumpClassFile(String className, String location, InputStream in, PrintWriter out) throws IOException {
        in.skip(4L);
        int minor = (0xFF & in.read()) << 8 | 0xFF & in.read();
        int major = (0xFF & in.read()) << 8 | 0xFF & in.read();
        DumpClassVersions.updateStats(major, minor);
        out.println(new StringBuffer().append(major).append(".").append(minor).append("\t").append(DumpClassVersions.classVersionToTarget(major, minor)).append("\t").append(className).append("\t").append(location).toString());
    }

    public static void dumpDirectory(File dir, PrintWriter out) throws IOException {
        if (JRE_1_2_PLUS) {
            File[] files = dir.listFiles();
            for (int f = 0; f < files.length; ++f) {
                DumpClassVersions.dumpClassVersion(files[f], out);
            }
        } else {
            String[] files = dir.list();
            for (int f = 0; f < files.length; ++f) {
                DumpClassVersions.dumpClassVersion(new File(dir, files[f]), out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpArchive(File zip, PrintWriter out) throws IOException {
        ZipInputStream in = null;
        try {
            ZipEntry entry;
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip), 32768));
            while ((entry = in.getNextEntry()) != null) {
                String lcName = entry.getName().toLowerCase();
                if (entry.isDirectory() || !lcName.endsWith(".class")) continue;
                DumpClassVersions.dumpClassFile(entry.getName(), zip.toString(), in, out);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String classVersionToTarget(int major, int minor) {
        long version = major << 16 | minor;
        if (version >= 0x320000L) {
            return "1.6";
        }
        if (version >= 0x310000L) {
            return "1.5";
        }
        if (version >= 0x300000L) {
            return "1.4";
        }
        if (version >= 0x2F0000L) {
            return "1.3";
        }
        if (version >= 0x2E0000L) {
            return "1.2";
        }
        if (version >= 2949123L) {
            return "1.1";
        }
        if (version >= 0x2D0000L) {
            return "1.0";
        }
        return "unknown";
    }

    private static void updateStats(int major, int minor) {
        long version = major << 16 | minor;
        long maxVersion = s_maxMajor << 16 | s_maxMinor;
        long minVersion = s_minMajor << 16 | s_minMinor;
        if (version > maxVersion) {
            s_maxMajor = major;
            s_maxMinor = minor;
        }
        if (version < minVersion) {
            s_minMajor = major;
            s_minMinor = minor;
        }
        ++s_classCount;
    }

    public static String findManifestInfoInJAR(Class<?> c, String jarName, String name) throws IOException {
        String firstURLLoc;
        String info = "";
        URL firstURL = c.getResource("/META-INF/MANIFEST.MF");
        if (firstURL != null && ((firstURLLoc = firstURL.toExternalForm()).startsWith("jar:") || firstURLLoc.startsWith("zip:"))) {
            String filename = firstURLLoc.substring(4, firstURLLoc.indexOf(33));
            filename = filename.substring(0, filename.lastIndexOf("/"));
            URL testURL = URLHelper.getUserURL(filename = new StringBuffer().append(filename).append("/").append(jarName).toString());
            if (testURL != null) {
                try {
                    JarFile jar = new JarFile(URLHelper.getFile(testURL));
                    Manifest manifest = jar.getManifest();
                    info = manifest.getMainAttributes().getValue(name);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return info;
    }
}

