/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.search;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.search.AbstractSearcher;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class DefaultTreeSearcher
extends AbstractSearcher {
    DefaultMutableTreeNode _node;

    public DefaultTreeSearcher(DefaultMutableTreeNode node) {
        this._node = node;
    }

    public DefaultTreeSearcher(JTree tree) {
        TreeModel model = tree.getModel();
        this._node = (DefaultMutableTreeNode)tree.getModel().getRoot();
    }

    public boolean search(String value) {
        this.initComparator();
        this._result = new Vector();
        if (this._node != null) {
            this.searchTreeNode(this._node, -1, value);
        }
        this.setSearchValue(value);
        return this._result.size() > 0;
    }

    public void searchTreeNode(DefaultMutableTreeNode node, int depth, String searchText) {
        String nodeValue = "";
        int pos = -1;
        nodeValue = node.toString();
        if (nodeValue != null && this.getComparator().compare(node, searchText) > 0) {
            this._result.add(node);
        }
        if (depth != 0) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.searchTreeNode(childNode, depth - 1, searchText);
            }
        }
    }

    public void searchTypeTreeNode(DefaultMutableTreeNode node, int depth, String searchText) {
        String nodeValue = "";
        int pos = -1;
        if (node.getUserObject() instanceof Type) {
            Type aType = (Type)node.getUserObject();
            nodeValue = aType.getName();
            if (aType.isSimple()) {
                nodeValue = nodeValue + " " + ((SimpleType)aType).getValue();
            }
        } else {
            nodeValue = node.toString();
        }
        if (nodeValue != null && (pos = this._matchCase ? nodeValue.indexOf(searchText) : StringUtil.indexOfIgnoreCase(nodeValue, searchText, 0)) >= 0) {
            this._result.add(node);
        }
        if (depth != 0) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.searchTypeTreeNode(childNode, depth - 1, searchText);
            }
        }
    }
}

