/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.search;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.search.DefaultComparator;
import com.jaxfront.core.util.search.SearchFilter;
import com.jaxfront.core.util.stringSearch.ShiftOrWildcards;
import com.jaxfront.core.util.stringSearch.StringSearch;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class TypeComparator
extends DefaultComparator {
    private boolean _nameEquality;
    private boolean _valueEquality;
    private boolean _compareLabel;
    private StringSearch _search = new ShiftOrWildcards();

    public TypeComparator() {
    }

    public TypeComparator(SearchFilter searchFilter) {
        this._searchFilter = searchFilter;
    }

    public TypeComparator(boolean nameEquality, boolean valueEquality) {
        this._nameEquality = nameEquality;
        this._valueEquality = valueEquality;
    }

    public TypeComparator(boolean nameEquality, boolean valueEquality, boolean isRegEx) {
        this._nameEquality = nameEquality;
        this._valueEquality = valueEquality;
        this._isRegEx = isRegEx;
    }

    public int compare(Object o1, Object o2) {
        Type aType = null;
        String value = null;
        if (o1 instanceof Type && o2 instanceof String) {
            aType = (Type)o1;
            value = o2.toString();
        } else if (o1 instanceof String && o2 instanceof DefaultMutableTreeNode) {
            aType = (Type)o2;
            value = o1.toString();
        } else {
            return -1;
        }
        String nodeValue = aType.isSimple() ? ((SimpleType)aType).getValue() : null;
        String nodeName = null;
        nodeName = this._compareLabel ? aType.getStyle().getLabelText() : aType.getName();
        if (!this.isMatchCase()) {
            nodeName = nodeName != null ? nodeName.toLowerCase() : null;
            nodeValue = nodeValue != null ? nodeValue.toLowerCase() : null;
            value = value != null ? value.toLowerCase() : null;
        }
        int valuePos = -1;
        int namePos = -1;
        boolean found = false;
        if (this._nameEquality && this._valueEquality) {
            if (nodeValue != null) {
                valuePos = this.doSearch(value, nodeValue);
            }
            if ((namePos = this.doSearch(value, nodeName)) >= 0 || valuePos >= 0) {
                found = true;
            }
        } else if (this._nameEquality) {
            namePos = this.doSearch(value, nodeName);
            if (namePos >= 0) {
                found = true;
            }
        } else if (nodeValue != null && (valuePos = this.doSearch(value, nodeValue)) >= 0) {
            found = true;
        }
        if (found && !this.getFilter().filter(aType)) {
            return 1;
        }
        return -1;
    }

    private int doSearch(String search, String in) {
        int pos = -1;
        if (search != null && search.length() > 0) {
            if (this._isRegEx) {
                ArrayList occs = StringSearch.getAllOccurences(in, search, this._matchCase, this._isRegEx);
                if (occs != null && occs.size() > 0) {
                    pos = (Integer)occs.get(0);
                }
            } else {
                pos = this._matchCase ? this._search.searchString(in, search) : this._search.searchString(in.toLowerCase(), search.toLowerCase());
            }
        }
        return pos;
    }

    public boolean isNameEquality() {
        return this._nameEquality;
    }

    public boolean isValueEquality() {
        return this._valueEquality;
    }

    public void setCompareLabel(boolean comp) {
        this._compareLabel = comp;
    }

    public boolean isCompareLabel() {
        return this._compareLabel;
    }
}

