/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.search;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.search.DefaultComparator;
import com.jaxfront.core.util.search.EqualityField;
import com.jaxfront.core.util.search.SearchFilter;
import com.jaxfront.core.util.stringSearch.ShiftOrWildcards;
import com.jaxfront.core.util.stringSearch.StringSearch;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class TypeTreeNodeComparator
extends DefaultComparator {
    private static final String EQUALS_VALUE = "Equals Value";
    private static final String EQUALS_NAME = "Equals Name";
    boolean _nameEquality = true;
    boolean _valueEquality = false;
    private StringSearch _search = new ShiftOrWildcards();

    public TypeTreeNodeComparator() {
    }

    public TypeTreeNodeComparator(SearchFilter searchFilter) {
        this._searchFilter = searchFilter;
    }

    public TypeTreeNodeComparator(boolean nameEquality, boolean valueEquality) {
        this._nameEquality = nameEquality;
        this._valueEquality = valueEquality;
    }

    public List getEqualityFields() {
        Vector<EqualityField> equalFields = new Vector<EqualityField>();
        equalFields.add(new EqualityField(EQUALS_NAME, "Eq Name", this._nameEquality));
        equalFields.add(new EqualityField(EQUALS_VALUE, "Eq Value", this._valueEquality));
        return equalFields;
    }

    public void setEqualityFields(List fields) {
        for (int i = 0; i < fields.size(); ++i) {
            EqualityField field = (EqualityField)fields.get(i);
            if (field == null) continue;
            if (EQUALS_NAME.equals(field._id)) {
                this._nameEquality = field._selected;
                continue;
            }
            if (!EQUALS_VALUE.equals(field._id)) continue;
            this._valueEquality = field._selected;
        }
    }

    public int compare(Object o1, Object o2) {
        Type aType = null;
        DefaultMutableTreeNode node = null;
        String value = null;
        if (o1 instanceof DefaultMutableTreeNode && o2 instanceof String) {
            node = (DefaultMutableTreeNode)o1;
            value = o2.toString();
        } else if (o1 instanceof String && o2 instanceof DefaultMutableTreeNode) {
            node = (DefaultMutableTreeNode)o2;
            value = o1.toString();
        } else {
            return -1;
        }
        if (node.getUserObject() instanceof Type) {
            aType = (Type)node.getUserObject();
            String nodeValue = aType.isSimple() ? ((SimpleType)aType).getValue() : null;
            String nodeName = aType.getName();
            if (!this.isMatchCase()) {
                nodeName = nodeName != null ? nodeName.toLowerCase() : null;
                nodeValue = nodeValue != null ? nodeValue.toLowerCase() : null;
                value = value != null ? value.toLowerCase() : null;
            }
            int valuePos = -1;
            int namePos = -1;
            boolean found = false;
            if (this._nameEquality && this._valueEquality) {
                if (nodeValue != null) {
                    valuePos = this._search.searchString(nodeValue, value);
                }
                if ((namePos = this._search.searchString(nodeName, value)) >= 0 || valuePos >= 0) {
                    found = true;
                }
            } else if (this._nameEquality) {
                namePos = this._search.searchString(nodeName, value);
                if (namePos >= 0) {
                    found = true;
                }
            } else if (nodeValue != null && (valuePos = this._search.searchString(nodeValue, value)) >= 0) {
                found = true;
            }
            if (found && !this.getFilter().filter(aType)) {
                return 1;
            }
        }
        return -1;
    }
}

