/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.sort;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.TypeComparator;
import com.jaxfront.core.util.StringUtil;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class FastQSort {
    private static FastQSort _instance = null;
    public static final int ASC = 0;
    public static final int DES = 1;
    public static final int NATURAL = 2;
    Comparator _comparator = String.CASE_INSENSITIVE_ORDER;
    int[] _index;

    private void QuickSort(List a, int l, int r) throws Exception {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (this._comparator.compare(a.get(l), a.get(i)) > 0) {
                this.swap(a, l, i);
            }
            if (this._comparator.compare(a.get(l), a.get(r)) > 0) {
                this.swap(a, l, r);
            }
            if (this._comparator.compare(a.get(i), a.get(r)) > 0) {
                this.swap(a, i, r);
            }
            int j = r - 1;
            this.swap(a, i, j);
            i = l;
            Object v = a.get(j);
            while (true) {
                if (this._comparator.compare(a.get(++i), v) < 0) {
                    continue;
                }
                while (this._comparator.compare(a.get(--j), v) > 0) {
                }
                if (j < i) break;
                this.swap(a, i, j);
            }
            this.swap(a, i, r - 1);
            this.QuickSort(a, l, j);
            this.QuickSort(a, i + 1, r);
        }
    }

    private void QuickSort(Object[] a, int l, int r) throws Exception {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (this._comparator.compare(a[l], a[i]) > 0) {
                this.swap(a, l, i);
            }
            if (this._comparator.compare(a[l], a[r]) > 0) {
                this.swap(a, l, r);
            }
            if (this._comparator.compare(a[i], a[r]) > 0) {
                this.swap(a, i, r);
            }
            int j = r - 1;
            this.swap(a, i, j);
            i = l;
            Object v = a[j];
            while (true) {
                if (this._comparator.compare(a[++i], v) < 0) {
                    continue;
                }
                while (this._comparator.compare(a[--j], v) > 0) {
                }
                if (j < i) break;
                this.swap(a, i, j);
            }
            this.swap(a, i, r - 1);
            this.QuickSort(a, l, j);
            this.QuickSort(a, i + 1, r);
        }
    }

    private void swap(List a, int i, int j) {
        Object T = a.get(i);
        a.set(i, a.get(j));
        a.set(j, T);
        int iT = this._index[i];
        this._index[i] = this._index[j];
        this._index[j] = iT;
    }

    private void swap(Object[] a, int i, int j) {
        Object T = a[i];
        a[i] = a[j];
        a[j] = T;
        int iT = this._index[i];
        this._index[i] = this._index[j];
        this._index[j] = iT;
    }

    private void InsertionSort(List a, int lo0, int hi0) throws Exception {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            int j;
            Object v = a.get(i);
            int vi = this._index[i];
            for (j = i; j > lo0 && this._comparator.compare(a.get(j - 1), v) > 0; --j) {
                a.set(j, a.get(j - 1));
                this._index[j] = this._index[j - 1];
            }
            a.set(j, v);
            this._index[j] = vi;
        }
    }

    private void InsertionSort(Object[] a, int lo0, int hi0) throws Exception {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            Object v = a[i];
            int vi = this._index[i];
            for (int j = i; j > lo0 && this._comparator.compare(a[j - 1], v) > 0; --j) {
                a[j] = a[j - 1];
                this._index[j] = this._index[j - 1];
            }
            a[j] = v;
            this._index[j] = vi;
        }
    }

    public int[] sort(List a, Comparator comparator) {
        try {
            this.initIndex(a.size());
            this._comparator = comparator;
            this.QuickSort(a, 0, a.size() - 1);
            this.InsertionSort(a, 0, a.size() - 1);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        return this._index;
    }

    public static void sortList(List toSort, Comparator comparator) {
        if (toSort != null) {
            FastQSort sort = new FastQSort();
            if (comparator != null) {
                sort.sort(toSort, comparator);
            }
        }
    }

    public static void sortArray(Object[] toSort, Comparator comparator) {
        if (toSort != null) {
            FastQSort sort = new FastQSort();
            if (comparator != null) {
                sort.sort(toSort, comparator);
            }
        }
    }

    public static void shellsort(Comparable[] a) {
        int gap = a.length / 2;
        while (gap > 0) {
            for (int i = gap; i < a.length; ++i) {
                Comparable tmp = a[i];
                for (int j = i; j >= gap && tmp.compareTo(a[j - gap]) < 0; j -= gap) {
                    a[j] = a[j - gap];
                }
                a[j] = tmp;
            }
            gap = gap == 2 ? 1 : (int)((double)gap / 2.2);
        }
    }

    public int[] sort(List a, Comparator comparator, int direction) throws Exception {
        this.initIndex(a.size());
        this._comparator = comparator;
        this.QuickSort(a, 0, a.size() - 1);
        this.InsertionSort(a, 0, a.size() - 1);
        if (direction == 1) {
            Vector aClone = new Vector(a);
            a.clear();
            for (int i = aClone.size() - 1; i >= 0; --i) {
                a.add(aClone.get(i));
            }
        }
        return this._index;
    }

    public int[] sort(Object[] a, Comparator comparator) {
        try {
            this.initIndex(a.length);
            this._comparator = comparator;
            this.QuickSort(a, 0, a.length - 1);
            this.InsertionSort(a, 0, a.length - 1);
        }
        catch (Exception e) {
            return null;
        }
        return this._index;
    }

    public int[] sort(List a, int[] indexList, Comparator comparator) throws Exception {
        this._index = indexList;
        this._comparator = comparator;
        this.QuickSort(a, 0, a.size() - 1);
        this.InsertionSort(a, 0, a.size() - 1);
        return this._index;
    }

    public int[] sort(Object[] a, int[] indexList, Comparator comparator) throws Exception {
        this._index = indexList;
        this._comparator = comparator;
        this.QuickSort(a, 0, a.length - 1);
        this.InsertionSort(a, 0, a.length - 1);
        return this._index;
    }

    private void initIndex(int size) {
        this._index = new int[size];
        for (int i = 0; i < size; ++i) {
            this._index[i] = i;
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        Object[] sTest = new String[10];
        String[] sSeq = new String[]{"b", "c", "a", "z"};
        int s = 0;
        sTest[s++] = "a";
        sTest[s++] = "b";
        sTest[s++] = "c";
        sTest[s++] = "c";
        sTest[s++] = "z";
        sTest[s++] = "c";
        sTest[s++] = "b";
        sTest[s++] = "a";
        sTest[s++] = "z";
        sTest[s++] = "null";
        FastQSort sort = new FastQSort();
        sort.sort(sTest, FastQSort.getStringSequenceCompare(sSeq));
        String[][] test = new String[3][2];
        test[0] = new String[]{"1", "a"};
        test[1] = new String[]{"3", "c"};
        test[2] = new String[]{"2", "b"};
        sort.sort((Object[])test, FastQSort.getStringArrCompare(0, false, true, 0));
        Vector<String> v = new Vector<String>();
        int[] indexlist = new int[4];
        indexlist[0] = 0;
        indexlist[1] = 1;
        indexlist[2] = 2;
        v.add("a");
        v.add("b");
        v.add("c");
        sort.sort(v, indexlist, FastQSort.getStringComparator());
        for (i = 0; i < v.size(); ++i) {
            System.out.print(v.get(i));
            System.out.println(sort._index[i]);
        }
        sort.sort(v, indexlist, FastQSort.getStringComparator());
        for (i = 0; i < v.size(); ++i) {
            System.out.print(v.get(i));
            System.out.println(sort._index[i]);
        }
    }

    public static Comparator getStringComparator() {
        return Collator.getInstance();
    }

    public static Comparator getStringCaseInsensitiveComparator() {
        return String.CASE_INSENSITIVE_ORDER;
    }

    public static Comparator getTypeComparator() {
        return new TypeComparator();
    }

    public static Comparator getNumberCompare() {
        return new Comparator(){

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                return false;
            }

            public int compare(Object o1, Object o2) {
                Number n1 = (Number)o1;
                Number n2 = (Number)o2;
                if (n1.doubleValue() > n2.doubleValue()) {
                    return 1;
                }
                if (n1.doubleValue() < n2.doubleValue()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static Comparator getStringArrCompare(int col, boolean natural, boolean asNumber, int order) {
        FastQSort fastQSort = FastQSort.getInstance();
        fastQSort.getClass();
        return fastQSort.new StringArrComparator(col, natural, asNumber, order == 0);
    }

    public static Comparator getStringSequenceCompare(String[] seq) {
        FastQSort fastQSort = FastQSort.getInstance();
        fastQSort.getClass();
        return fastQSort.new StringSequenceCompare(seq);
    }

    private static synchronized FastQSort getInstance() {
        if (_instance == null) {
            _instance = new FastQSort();
        }
        return _instance;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StringSequenceCompare
    implements Comparator<String> {
        List<String> sequence;

        StringSequenceCompare(String[] seq) {
            this.sequence = Arrays.asList(seq);
        }

        @Override
        public int compare(String t1, String t2) {
            if (t1 == null && t2 == null) {
                return 0;
            }
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            if (t1.equals(t2)) {
                return 0;
            }
            return this.sequence.indexOf(t1) - this.sequence.indexOf(t2);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((String)x0, (String)x1);
        }
    }

    public class StringArrComparator
    implements Comparator {
        private int _col = -1;
        Comparator _stringComp = String.CASE_INSENSITIVE_ORDER;
        boolean _asc = true;
        boolean _asNumber = false;

        public StringArrComparator(int col, boolean natural, boolean asNumber, boolean asc) {
            this._col = col;
            if (natural) {
                this._stringComp = StringUtil.getNaturalComparator();
            }
            this._asNumber = asNumber;
            this._asc = asc;
        }

        public int compare(Object arg0, Object arg1) throws ClassCastException {
            if (this._col < ((String[])arg0).length && this._col < ((String[])arg1).length) {
                if (this._asNumber) {
                    int aInt = Integer.valueOf(((String[])arg0)[this._col]);
                    int bInt = Integer.valueOf(((String[])arg1)[this._col]);
                    if (this._asc) {
                        return aInt - bInt;
                    }
                    return bInt - aInt;
                }
                int result = this._stringComp.compare(((String[])arg0)[this._col], ((String[])arg1)[this._col]);
                if (!this._asc) {
                    return result * -1;
                }
                return result;
            }
            return -1;
        }
    }
}

