/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.sql;

import [Ljava.lang.Byte;;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontDateTools;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.VectorHelper;
import com.jaxfront.core.util.io.IResult;
import com.jaxfront.core.util.sql.SQLCLOB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.nfunk.jep.type.NULL;

public class SQLHelper {
    private static Hashtable intTypeMapping = null;
    public static final String BIND_VAR_SKIP_MARKER = "skipMarker";

    public static void addValueToSQLStatement(int dataType, PreparedStatement statement, int position, Object value) throws SQLException {
        if (dataType == 0) {
            dataType = 12;
        }
        if (SQLHelper.isNull(value)) {
            statement.setNull(position, dataType);
            return;
        }
        String sVal = value.toString();
        switch (dataType) {
            case -5: {
                statement.setDouble(position, SQLHelper.parseAsDouble(value));
                break;
            }
            case -2: {
                SQLHelper.setBinaryStream(statement, position, value);
                break;
            }
            case -7: {
                statement.setByte(position, SQLHelper.parseAsByte(value));
                break;
            }
            case 16: {
                statement.setBoolean(position, SQLHelper.parseAsBoolean(value));
                break;
            }
            case 2004: {
                SQLHelper.setBinaryStream(statement, position, value);
                break;
            }
            case 1: {
                statement.setString(position, value.toString());
                break;
            }
            case 2005: {
                SQLHelper.setCharacterStream(statement, position, SQLHelper.parseAsInputStream(value));
                break;
            }
            case 91: {
                SQLHelper.setDate(statement, position, value, sVal);
                break;
            }
            case 3: {
                statement.setDouble(position, SQLHelper.parseAsDouble(value));
                break;
            }
            case 8: {
                statement.setDouble(position, SQLHelper.parseAsDouble(value));
                break;
            }
            case 6: {
                statement.setFloat(position, SQLHelper.parseAsFloat(value));
                break;
            }
            case 4: {
                statement.setInt(position, SQLHelper.parseAsInt(value));
                break;
            }
            case 2000: {
                statement.setObject(position, value);
                break;
            }
            case -4: {
                statement.setBytes(position, SQLHelper.parseAsByteArray(value));
                break;
            }
            case -1: {
                statement.setString(position, value.toString());
                break;
            }
            case 0: {
                statement.setNull(position, SQLHelper.parseAsInt(value));
                break;
            }
            case 2: {
                statement.setDouble(position, SQLHelper.parseAsDouble(value));
                break;
            }
            case 1111: {
                statement.setObject(position, value);
                break;
            }
            case 7: {
                statement.setDouble(position, SQLHelper.parseAsDouble(value));
                break;
            }
            case 5: {
                statement.setInt(position, SQLHelper.parseAsInt(value));
                break;
            }
            case 93: {
                SQLHelper.setTimestamp(statement, position, value, sVal);
                break;
            }
            case 92: {
                SQLHelper.setTime(statement, position, value, sVal);
                break;
            }
            case -6: {
                statement.setInt(position, SQLHelper.parseAsInt(value));
                break;
            }
            case -3: {
                statement.setInt(position, SQLHelper.parseAsInt(value));
                break;
            }
            case 12: {
                statement.setString(position, value.toString());
                break;
            }
            default: {
                statement.setString(position, value.toString());
                break;
            }
        }
    }

    public static boolean isNull(Object value) {
        return value == null || value.toString() == null || value.toString().length() == 0;
    }

    public static void setDate(PreparedStatement statement, int position, Object value, String sVal) throws SQLException {
        if (sVal.startsWith("{d ")) {
            statement.setDate(position, Date.valueOf(sVal.substring(3, sVal.length() - 1)));
        } else if (value instanceof Date) {
            statement.setDate(position, (Date)value);
        } else if (value instanceof java.util.Date) {
            statement.setDate(position, new Date(((java.util.Date)value).getTime()));
        } else {
            statement.setDate(position, Date.valueOf(sVal));
        }
    }

    public static void setTime(PreparedStatement statement, int position, Object value, String sVal) throws SQLException {
        if (sVal.startsWith("{t ")) {
            statement.setTime(position, Time.valueOf(sVal.substring(3, sVal.length() - 1)));
        } else if (value instanceof Time) {
            statement.setTime(position, (Time)value);
        } else {
            statement.setTime(position, Time.valueOf(sVal));
        }
    }

    public static void setTimestamp(PreparedStatement statement, int position, Object value, String sVal) throws SQLException {
        if (sVal.startsWith("{ts ")) {
            statement.setTimestamp(position, Timestamp.valueOf(sVal.substring(4, sVal.length() - 1)));
        } else if (value instanceof Timestamp) {
            statement.setTimestamp(position, (Timestamp)value);
        } else if (value instanceof Date) {
            statement.setTimestamp(position, new Timestamp(((Date)value).getTime()));
        } else if (value instanceof java.util.Date) {
            statement.setTimestamp(position, new Timestamp(((java.util.Date)value).getTime()));
        } else {
            statement.setTimestamp(position, Timestamp.valueOf(sVal));
        }
    }

    public static void setBinaryStream(PreparedStatement statement, int position, Object value) throws SQLException {
        InputStream is = null;
        int isSize = Integer.MAX_VALUE;
        if (value instanceof byte[]) {
            isSize = ((byte[])value).length;
            is = new ByteArrayInputStream((byte[])value);
        } else if (value instanceof ByteArrayInputStream) {
            is = (ByteArrayInputStream)value;
            isSize = ((ByteArrayInputStream)value).available();
        } else if (value instanceof InputStream) {
            is = (InputStream)value;
        } else if (value instanceof String) {
            byte[] isBytes = ((String)value).getBytes();
            isSize = isBytes.length;
            is = new ByteArrayInputStream(isBytes);
        } else if (value != null) {
            byte[] isBytes = String.valueOf(value).getBytes();
            isSize = isBytes.length;
            is = new ByteArrayInputStream(isBytes);
        }
        statement.setBinaryStream(position, is, isSize);
    }

    public static void setCharacterStream(PreparedStatement statement, int position, Object value) throws SQLException {
        Reader reader = null;
        int size = Integer.MAX_VALUE;
        if (value instanceof byte[]) {
            String sVal = new String((byte[])value);
            size = sVal.length();
            reader = new StringReader(sVal);
        } else if (value instanceof String) {
            size = ((String)value).length();
            reader = new StringReader((String)value);
        } else if (value instanceof Reader) {
            reader = (Reader)value;
        } else if (value instanceof ByteArrayInputStream) {
            reader = new InputStreamReader((ByteArrayInputStream)value);
            size = ((ByteArrayInputStream)value).available();
        } else if (value instanceof InputStream) {
            reader = new InputStreamReader((InputStream)value);
        } else {
            String sVal = value.toString();
            size = sVal.length();
            reader = new StringReader(sVal);
        }
        statement.setCharacterStream(position, reader, size);
    }

    public static Reader parseAsStringReader(Object value) {
        if (value instanceof byte[]) {
            return new StringReader(new String((byte[])value));
        }
        if (value instanceof String) {
            return new StringReader((String)value);
        }
        if (value instanceof Reader) {
            return (Reader)value;
        }
        if (value instanceof InputStream) {
            return new InputStreamReader((InputStream)value);
        }
        return new StringReader(value.toString());
    }

    public static double parseAsDouble(Object value) {
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        return 0.0;
    }

    public static InputStream parseAsInputStream(Object value) {
        if (value instanceof byte[]) {
            return new ByteArrayInputStream((byte[])value);
        }
        if (value instanceof InputStream) {
            return (InputStream)value;
        }
        if (value instanceof String) {
            return new ByteArrayInputStream(((String)value).getBytes());
        }
        if (value instanceof SQLCLOB) {
            return new ByteArrayInputStream(((SQLCLOB)value).getBytes());
        }
        if (value != null) {
            return new ByteArrayInputStream(String.valueOf(value).getBytes());
        }
        return null;
    }

    public static int parseAsInt(Object value) {
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Float) {
            return ((Float)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return 0;
    }

    public static float parseAsFloat(Object value) {
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).floatValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Long) {
            return ((Long)value).floatValue();
        }
        return 0.0f;
    }

    public static byte[] parseAsByteArray(Object value) {
        if (value == null) {
            return (byte[])value;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return value.toString().getBytes();
        }
        return value.toString().getBytes();
    }

    public static long parseAsLong(Object value) {
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    public static byte parseAsByte(Object value) {
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        return 0;
    }

    public static boolean parseAsBoolean(Object value) {
        boolean isTrue = false;
        if (value instanceof String) {
            if ("true".equalsIgnoreCase(value.toString())) {
                isTrue = true;
            }
            isTrue = "1".equals(value) ? true : Boolean.valueOf((String)value);
        } else if (value instanceof Byte) {
            isTrue = (Boolean)value;
        } else if (value instanceof Boolean) {
            isTrue = (Boolean)value;
        } else if (value instanceof Number) {
            isTrue = ((Number)value).intValue() >= 0;
        }
        return isTrue;
    }

    public static java.util.Date parseAsDate(Object value) throws ParseException {
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof String) {
            return JAXFrontDateTools.isoDateFormat.parse((String)value);
        }
        return new java.util.Date();
    }

    public static java.util.Date parseAsTime(Object value) throws ParseException {
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof String) {
            return JAXFrontDateTools.isoDateFormat.parse((String)value);
        }
        return new java.util.Date();
    }

    public static java.util.Date parseAsTimeStamp(Object value) throws ParseException {
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof String) {
            if (value == null || ((String)value).length() == 0) {
                return new java.util.Date();
            }
            return JAXFrontDateTools.isoDateTimeFormat.parse((String)value);
        }
        return new java.util.Date();
    }

    public static String toSQLDdate(java.util.Date d) {
        Date sqlDate = d instanceof Date ? (Date)d : new Date(d.getTime());
        return "{d '" + sqlDate + "'}";
    }

    public static String toSQLTime(java.util.Date d) {
        Time sqlTime = d instanceof Time ? (Time)d : new Time(d.getTime());
        return "{t '" + sqlTime + "'}";
    }

    public static String toSQLTimestamp(java.util.Date d) {
        Timestamp sqlTimestamp = d instanceof Timestamp ? (Timestamp)d : new Timestamp(d.getTime());
        return "{ts '" + sqlTimestamp + "'}";
    }

    public static boolean isNumeric(int dataType) {
        switch (dataType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinary(int sqlType) {
        switch (sqlType) {
            case -4: 
            case -3: 
            case -2: 
            case 2000: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    public static boolean isText(int dataType) {
        switch (dataType) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateTime(int dataType) {
        switch (dataType) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTime(int dataType) {
        return dataType == 92;
    }

    public static boolean isDate(int dataType) {
        return dataType == 91;
    }

    public static String getColumnNamesSQLFormatted(String[] columnNames) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < columnNames.length; ++i) {
            sql.append(columnNames[i]);
            if (i == columnNames.length - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    public static String getAdditionalParams(String[] columnNames) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < columnNames.length; ++i) {
            sql.append("?");
            if (i == columnNames.length - 1) continue;
            sql.append(", ");
        }
        return sql.toString();
    }

    public static String getSQLFieldBlocks(Object[] fields, String cond, String sep) {
        StringBuffer updateSQL = new StringBuffer();
        for (int i = 0; i < fields.length; i += 2) {
            updateSQL.append(" ");
            updateSQL.append(fields[i]);
            updateSQL.append(" ");
            updateSQL.append(cond);
            updateSQL.append(" ");
            SQLHelper.addSQLFieldValue(updateSQL, i, fields[i + 1]);
            if (i + 2 >= fields.length) continue;
            updateSQL.append(sep);
        }
        return updateSQL.toString();
    }

    public static void addSQLFieldValue(StringBuffer updateSQL, int i, Object aFieldVal) {
        if (aFieldVal == null) {
            updateSQL.append("NULL");
        } else if (aFieldVal instanceof String) {
            updateSQL.append("'");
            updateSQL.append(aFieldVal);
            updateSQL.append("'");
        } else if (aFieldVal instanceof Number) {
            updateSQL.append(aFieldVal);
        }
    }

    public static void addSQLFieldValueSQLTyped(StringBuffer updateSQL, int colType, Object aFieldVal) {
        if (aFieldVal == null) {
            updateSQL.append("NULL");
        } else if (SQLHelper.isNumeric(colType)) {
            updateSQL.append(aFieldVal);
        } else {
            updateSQL.append("'");
            updateSQL.append(aFieldVal);
            updateSQL.append("'");
        }
    }

    public static String getSQLPreparedInsert(String tableName, Object[] fields) {
        int i;
        StringBuffer updateSQL = new StringBuffer("INSERT INTO " + tableName + " (");
        for (i = 0; i < fields.length; i += 2) {
            updateSQL.append(" ");
            updateSQL.append(fields[i]);
            if (i + 2 >= fields.length) continue;
            updateSQL.append(",");
        }
        updateSQL.append(") values ( ");
        for (i = 1; i < fields.length; i += 2) {
            updateSQL.append("?");
            if (i + 2 >= fields.length) continue;
            updateSQL.append(",");
        }
        updateSQL.append(") ");
        return updateSQL.toString();
    }

    public static String createSQLPreparedInsert(String tableName, Object[] fields) {
        int i;
        StringBuffer updateSQL = new StringBuffer("INSERT INTO " + tableName + " (");
        for (i = 0; i < fields.length; ++i) {
            updateSQL.append(" ");
            updateSQL.append(fields[i]);
            if (i + 1 >= fields.length) continue;
            updateSQL.append(",");
        }
        updateSQL.append(") values ( ");
        for (i = 0; i < fields.length; ++i) {
            updateSQL.append("?");
            if (i + 1 >= fields.length) continue;
            updateSQL.append(",");
        }
        updateSQL.append(") ");
        return updateSQL.toString();
    }

    public static void addToSQLPreparedStatement(PreparedStatement stmnt, Object[] values) throws SQLException {
        for (int v = 0; v < values.length; ++v) {
            SQLHelper.addValueToSQLStatement(12, stmnt, v + 1, values[v]);
        }
    }

    public static void addGenericToSQLPreparedStatement(PreparedStatement stmnt, Object[] values) throws SQLException {
        for (int v = 0; v < values.length; ++v) {
            if (BIND_VAR_SKIP_MARKER.equals(values[v])) continue;
            SQLHelper.addValueToSQLStatement(SQLHelper.getSQLIntDataType(values[v] != null ? values[v].getClass() : null), stmnt, v + 1, values[v]);
        }
    }

    public static String getSQLPreparedUpdateKeyValArray(String tableName, Object[] idFieldsWithValue, Object[] fieldsWithValue) {
        Object aFieldVal;
        int i;
        StringBuffer updateSQL = new StringBuffer("UPDATE " + tableName + " SET ");
        for (i = 0; i < fieldsWithValue.length; i += 2) {
            updateSQL.append(" ");
            updateSQL.append(fieldsWithValue[i]);
            updateSQL.append(" = ");
            aFieldVal = fieldsWithValue[i + 1];
            SQLHelper.addSQLFieldValue(updateSQL, i, aFieldVal);
            if (i + 2 >= fieldsWithValue.length) continue;
            updateSQL.append(",");
        }
        if (idFieldsWithValue != null && idFieldsWithValue.length > 0) {
            updateSQL.append(" WHERE ");
            for (i = 0; i < idFieldsWithValue.length; i += 2) {
                updateSQL.append(" ");
                updateSQL.append(idFieldsWithValue[i]);
                updateSQL.append(" = ");
                aFieldVal = idFieldsWithValue[i + 1];
                SQLHelper.addSQLFieldValue(updateSQL, i, aFieldVal);
                if (i + 2 >= idFieldsWithValue.length) continue;
                updateSQL.append(" and ");
            }
        }
        return updateSQL.toString();
    }

    public static String getSQLPreparedUpdate(String tableName, Object[] idFields, Object[] fields) {
        int i;
        StringBuffer updateSQL = new StringBuffer("UPDATE " + tableName + " SET ");
        for (i = 0; i < fields.length; ++i) {
            updateSQL.append(" ");
            updateSQL.append(fields[i]);
            updateSQL.append(" = ?");
            if (i + 1 >= fields.length) continue;
            updateSQL.append(",");
        }
        if (idFields != null && idFields.length > 0) {
            updateSQL.append(" WHERE ");
            for (i = 0; i < idFields.length; ++i) {
                updateSQL.append(" ");
                updateSQL.append(idFields[i]);
                updateSQL.append(" = ?");
                if (i + 1 >= idFields.length) continue;
                updateSQL.append(" and ");
            }
        }
        return updateSQL.toString();
    }

    public static String getSQLPreparedUpdate(String tableName, Object[] idFields, Object[] idValues, Object[] fields) {
        int i;
        StringBuffer updateSQL = new StringBuffer("UPDATE " + tableName + " SET ");
        for (i = 0; i < fields.length; ++i) {
            updateSQL.append(" ");
            updateSQL.append(fields[i]);
            updateSQL.append(" = ?");
            if (i + 1 >= fields.length) continue;
            updateSQL.append(",");
        }
        if (idFields != null && idFields.length > 0) {
            updateSQL.append(" WHERE ");
            for (i = 0; i < idFields.length; ++i) {
                updateSQL.append(" ");
                updateSQL.append(idFields[i]);
                if (idValues[i] == null) {
                    updateSQL.append(" IS NULL ");
                } else if (idValues[i] instanceof String && ((String)idValues[i]).length() == 0) {
                    updateSQL.append(" IS NULL ");
                } else {
                    updateSQL.append(" = ?");
                }
                if (i + 1 >= idFields.length) continue;
                updateSQL.append(" and ");
            }
        }
        return updateSQL.toString();
    }

    public static String getSQLPreparedDelete(String tableName, Object[] idFields, Object[] idValues) {
        StringBuffer updateSQL = new StringBuffer("DELETE FROM " + tableName);
        if (idFields != null && idFields.length > 0) {
            updateSQL.append(" WHERE ");
            for (int i = 0; i < idFields.length; ++i) {
                updateSQL.append(" ");
                updateSQL.append(idFields[i]);
                if (idValues[i] == null) {
                    updateSQL.append(" IS NULL ");
                } else if (idValues[i] instanceof String && ((String)idValues[i]).length() == 0) {
                    updateSQL.append(" IS NULL ");
                } else {
                    updateSQL.append(" = ?");
                }
                if (i + 1 >= idFields.length) continue;
                updateSQL.append(" and ");
            }
        }
        return updateSQL.toString();
    }

    public static void getCatalogs(DatabaseMetaData meta) throws Exception {
        ResultSet catalogs = null;
        catalogs = meta.getCatalogs();
        while (catalogs.next()) {
            String catalog = catalogs.getString(1);
            System.out.println("catalog: " + catalog);
        }
    }

    public static void getSchemas(DatabaseMetaData meta) throws Exception {
        ResultSet schemas = meta.getSchemas();
        while (schemas.next()) {
            System.out.println(schemas.getString(1));
        }
    }

    public static String[] queryPrimaryKeys(String schema, String tableName, DatabaseMetaData meta) throws SQLException {
        ResultSet rs = meta.getPrimaryKeys(null, schema, tableName);
        String[] pKeys = new String[]{};
        int cols = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            String columnName = SQLHelper.getColumnName(rs);
            if (columnName == null || columnName.length() <= 0 || ArrayUtil.containsIgnoreCase(pKeys, columnName) >= 0) continue;
            pKeys = ArrayUtil.addToArray(pKeys, columnName);
        }
        rs.close();
        return pKeys;
    }

    public static List queryFunctions(Connection con, String schema, String tableName) throws SQLException {
        return null;
    }

    public static List getDBSchemas(Connection con) throws SQLException {
        System.out.println("The following Schemas are available in the database:");
        DatabaseMetaData dmd = con.getMetaData();
        ResultSet rs = dmd.getSchemas();
        ResultSet rs1 = null;
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            System.out.println(rs.getString(1));
            System.out.println("The following tables are available in the " + rs.getString(1) + " schema:");
            rs1 = dmd.getTables(null, rs.getString(1), "%", null);
            while (rs1.next()) {
                System.out.println("   " + rs1.getString(3) + " : " + rs1.getString(4));
                result.add(rs1.getString(3) + " : " + rs1.getString(4));
            }
        }
        return result;
    }

    public static List queryForeignKeys(Connection con, String schema, String tableName) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = con.getMetaData().getExportedKeys(con.getCatalog(), schema, tableName);
        while (rs.next()) {
            String fkTableName = rs.getString("FKTABLE_NAME");
            String fkColumnName = rs.getString("FKCOLUMN_NAME");
            int fkSequence = rs.getInt("KEY_SEQ");
            list.add(fkColumnName);
        }
        rs.close();
        return list;
    }

    public static List queryImportedKeys(Connection con, String schema, String tableName) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = con.getMetaData().getImportedKeys(con.getCatalog(), schema, tableName);
        while (rs.next()) {
            String fkTableName = rs.getString("FKTABLE_NAME");
            String fkColumnName = rs.getString("FKCOLUMN_NAME");
            int fkSequence = rs.getInt("KEY_SEQ");
            list.add(fkColumnName);
        }
        rs.close();
        return VectorHelper.removeDuplicates(list);
    }

    public static List queryIndex(Connection con, String schema, String tableName, boolean unique) throws SQLException {
        String[] pk = SQLHelper.queryPrimaryKeys(schema, tableName, con.getMetaData());
        ArrayList<String> list = new ArrayList<String>();
        ResultSet indexInformation = con.getMetaData().getIndexInfo(con.getCatalog(), schema, tableName, true, true);
        while (indexInformation.next()) {
            String dbCatalog = SQLHelper.getCatalogName(indexInformation);
            String dbSchema = SQLHelper.getSchemaName(indexInformation);
            String dbTableName = SQLHelper.getTableName(indexInformation);
            boolean dbNoneUnique = indexInformation.getBoolean("NON_UNIQUE");
            String dbIndexQualifier = indexInformation.getString("INDEX_QUALIFIER");
            String dbIndexName = SQLHelper.getIndexName(indexInformation);
            short dbType = indexInformation.getShort("TYPE");
            short dbOrdinalPosition = indexInformation.getShort("ORDINAL_POSITION");
            String dbColumnName = SQLHelper.getColumnName(indexInformation);
            String dbAscOrDesc = indexInformation.getString("ASC_OR_DESC");
            int dbCardinality = indexInformation.getInt("CARDINALITY");
            int dbPages = indexInformation.getInt("PAGES");
            String dbFilterCondition = indexInformation.getString("FILTER_CONDITION");
            if (dbColumnName == null || ArrayUtil.containsIgnoreCase(pk, dbColumnName) >= 0 || dbNoneUnique != !unique) continue;
            list.add(dbColumnName);
        }
        indexInformation.close();
        if (list != null && list.size() > 1) {
            return VectorHelper.removeDuplicates(list);
        }
        return list;
    }

    public static String getIndexName(ResultSet indexInformation) throws SQLException {
        String dbIndexName = indexInformation.getString("INDEX_NAME");
        return dbIndexName;
    }

    public static void printAllCols(ResultSet indexInformation) throws SQLException {
        int cols = indexInformation.getMetaData().getColumnCount();
        int[] colTypes = SQLHelper.getColDataTypes(indexInformation.getMetaData());
        try {
            for (int c = 1; c <= cols; ++c) {
                System.out.println(indexInformation.getObject(c));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getColumnName(ResultSet indexInformation) throws SQLException {
        String dbColumnName = indexInformation.getString("COLUMN_NAME");
        return dbColumnName;
    }

    public static String[] getTableNames(ResultSetMetaData meta) throws SQLException {
        String[] tables = new String[meta.getColumnCount()];
        for (int i = 0; i < tables.length; ++i) {
            tables[i] = meta.getTableName(i + 1);
        }
        return tables;
    }

    public static int[] getColDataTypes(ResultSetMetaData meta) throws SQLException {
        int[] cols = new int[meta.getColumnCount()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = meta.getColumnType(i + 1);
        }
        return cols;
    }

    public static String[] getColNames(ResultSetMetaData meta) throws SQLException {
        String[] cols = new String[meta.getColumnCount()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = meta.getColumnName(i + 1);
        }
        return cols;
    }

    public static String getCatalogName(ResultSet indexInformation) throws SQLException {
        String dbCatalog = indexInformation.getString("TABLE_CAT");
        return dbCatalog;
    }

    public static String getTableName(ResultSet indexInformation) throws SQLException {
        String dbTableName = indexInformation.getString("TABLE_NAME");
        return dbTableName;
    }

    public static String getSchemaName(ResultSet indexInformation) throws SQLException {
        String dbSchema = indexInformation.getString("TABLE_SCHEM");
        return dbSchema;
    }

    public static Vector parseSQLCommands(InputStream initStream) throws IOException {
        return SQLHelper.parseSQLCommands(new InputStreamReader(initStream));
    }

    public static Vector parseSQLCommands(Reader input) throws IOException {
        Vector<String> resultBlocks = new Vector<String>();
        LineNumberReader lis = new LineNumberReader(input);
        String line = null;
        StringBuffer blockContent = new StringBuffer();
        while ((line = lis.readLine()) != null) {
            if (line.length() <= 0) continue;
            if (line.trim().startsWith("--") || line.trim().startsWith("#")) {
                if (blockContent.length() > 0) {
                    resultBlocks.add(StringUtil.removeIfLast(blockContent.toString(), ";", true));
                }
                blockContent = new StringBuffer();
                continue;
            }
            if (line.trim().endsWith(";")) {
                blockContent.append(line);
                resultBlocks.add(StringUtil.removeIfLast(blockContent.toString(), ";", true));
                blockContent = new StringBuffer();
                continue;
            }
            blockContent.append(line);
        }
        if (blockContent.length() > 0) {
            resultBlocks.add(StringUtil.removeIfLast(blockContent.toString(), ";", true));
        }
        return resultBlocks;
    }

    public static String getRangeSQL(String qualifiedColName, String[] fromToDef) {
        String aDef;
        int ft;
        if (fromToDef == null || fromToDef.length == 0) {
            return "";
        }
        StringBuffer muniRestriction = new StringBuffer("");
        ArrayList<String> muniList = new ArrayList<String>();
        for (ft = 0; ft < fromToDef.length; ++ft) {
            aDef = fromToDef[ft];
            if (aDef == null || aDef.length() <= 0 || !StringUtil.isInteger(aDef.trim())) continue;
            muniList.add(aDef);
        }
        if (muniList.size() > 0) {
            muniRestriction.append("(" + qualifiedColName + " in (" + ArrayUtil.toString(muniList, ",", null, null, null, null) + "))");
        }
        for (ft = 0; ft < fromToDef.length; ++ft) {
            aDef = fromToDef[ft];
            if (aDef == null || aDef.length() <= 0 || StringUtil.isInteger(aDef.trim())) continue;
            String[] ftString = SQLHelper.extractFromToRangeString(aDef);
            muniRestriction.append(" or ( " + qualifiedColName + " >=" + ftString[0] + " and " + qualifiedColName + " <=" + ftString[1] + ")");
        }
        if (muniRestriction.length() > 0) {
            return " and (" + muniRestriction.toString() + ")";
        }
        return muniRestriction.toString();
    }

    public static String[] extractFromToRangeString(String fromTo) {
        if (fromTo == null || fromTo.length() == 0) {
            return null;
        }
        String[] fromToSplitRange = fromTo.split("-");
        if (fromToSplitRange.length == 1) {
            String r0 = fromToSplitRange[0] != null ? fromToSplitRange[0].trim() : null;
            return new String[]{r0};
        }
        if (fromToSplitRange.length >= 2) {
            String r0 = fromToSplitRange[0] != null ? fromToSplitRange[0].trim() : null;
            String r1 = fromToSplitRange[1] != null ? fromToSplitRange[1].trim() : null;
            return new String[]{r0, r1};
        }
        return null;
    }

    public static String[] extractFromToListString(String fromTo) {
        if (fromTo == null || fromTo.length() == 0) {
            return null;
        }
        String[] fromToSplitList = fromTo.split(",");
        if (fromToSplitList.length == 1) {
            return new String[]{fromToSplitList[0]};
        }
        if (fromToSplitList.length >= 2) {
            return new String[]{fromToSplitList[0], fromToSplitList[1]};
        }
        return null;
    }

    public static int getSQLIntDataType(Class javaClass) {
        Integer result;
        int dt = 0;
        if (javaClass != null && (result = (Integer)SQLHelper.getIntDataTypes().get(javaClass)) != null) {
            dt = result;
        }
        return dt;
    }

    public static Map getIntDataTypes() {
        if (intTypeMapping == null) {
            intTypeMapping = new Hashtable();
            intTypeMapping.put(Boolean.class, new Integer(16));
            intTypeMapping.put(String.class, new Integer(12));
            intTypeMapping.put(java.util.Date.class, new Integer(93));
            intTypeMapping.put(Date.class, new Integer(93));
            intTypeMapping.put(Timestamp.class, new Integer(93));
            intTypeMapping.put(Integer.class, new Integer(4));
            intTypeMapping.put(Float.class, new Integer(6));
            intTypeMapping.put(Double.class, new Integer(6));
            intTypeMapping.put(BigDecimal.class, new Integer(-5));
            intTypeMapping.put(Long.class, new Integer(-5));
            intTypeMapping.put(Short.class, new Integer(5));
            intTypeMapping.put(Byte.class, new Integer(-6));
            intTypeMapping.put(Byte;.class, new Integer(2004));
            intTypeMapping.put(Clob.class, new Integer(2005));
            intTypeMapping.put(SQLCLOB.class, new Integer(2005));
            intTypeMapping.put(Blob.class, new Integer(2004));
            intTypeMapping.put(Object.class, new Integer(2000));
            intTypeMapping.put(Number.class, new Integer(8));
        }
        return intTypeMapping;
    }

    public static Connection getConnection(String url, String dbName, String driver, String userName, String password) {
        Connection conn = null;
        try {
            Class.forName(driver).newInstance();
            conn = DriverManager.getConnection(url + dbName, userName, password);
            System.out.println("Connected to the database");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    public static String translateVar(String query, IResult result, int row) {
        String resultQ = query;
        List vars = StringUtil.getAllBetween(query, "${", "}", null);
        for (int v = 0; v < vars.size(); ++v) {
            String varValue;
            int colPos;
            String aValue = (String)vars.get(v);
            if (aValue == null) continue;
            aValue = aValue.trim();
            if (result == null || (colPos = result.getColumnForName(aValue)) < 0 || (varValue = result.getValue(row, colPos)) == null || varValue.equals(NULL._null)) continue;
            resultQ = StringUtil.replace(resultQ, "${" + aValue + "}", varValue);
        }
        return resultQ;
    }

    public static int translateJDBCTypeToXSD(int dataType) {
        Object javaDate = null;
        switch (dataType) {
            case 12: {
                return 2;
            }
            case 16: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 4;
            }
            case 8: {
                return 6;
            }
            case 6: {
                return 5;
            }
            case 4: {
                return 30;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return 8;
            }
            case 92: {
                return 9;
            }
            case -4: {
                return 17;
            }
            case 2005: {
                return -1;
            }
            case 2004: {
                return -1;
            }
        }
        return 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createIdentityByHighValue(Connection con, String tableName, String uuidFName, String id) {
        PreparedStatement idQuery = null;
        ResultSet idRs = null;
        try {
            idQuery = con.prepareStatement("SELECT max(" + uuidFName + ") FROM " + tableName);
            idQuery.execute();
            idRs = idQuery.getResultSet();
            idRs.next();
            id = idRs.getLong(1) + 1L + "";
        }
        catch (SQLException e) {
            try {
                LogRegistry.getInstance().error(SQLHelper.class, e);
                id = "1";
            }
            catch (Throwable throwable) {
                SQLHelper.closeResultSet(idRs);
                SQLHelper.closeStatement(idQuery);
                throw throwable;
            }
            SQLHelper.closeResultSet(idRs);
            SQLHelper.closeStatement(idQuery);
        }
        SQLHelper.closeResultSet(idRs);
        SQLHelper.closeStatement(idQuery);
        return id;
    }

    public static String createIdentityByAutoIncrement(Connection con, String tableName, String uuidFName, String id) {
        int newKey = -1;
        try {
            ResultSet rs;
            PreparedStatement ps = con.prepareStatement("INSERT INTO users (\ufffd) VALUES (\ufffd)");
            int insertStatus = ps.executeUpdate();
            if (insertStatus == 1 && (rs = ps.getGeneratedKeys()).next()) {
                newKey = rs.getInt(1);
                if (rs.next()) {
                    // empty if block
                }
            }
            System.out.println("The key value for the newly created record is: " + newKey);
        }
        catch (Exception e) {
            // empty catch block
        }
        return newKey + "";
    }

    public static void closeStatement(Statement aStatement) {
        if (aStatement != null) {
            try {
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(SQLHelper.class, "close statement:" + aStatement.hashCode());
                }
                aStatement.close();
            }
            catch (SQLException e) {
                LogRegistry.getInstance().warn(SQLHelper.class, e.getLocalizedMessage());
            }
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(SQLHelper.class, "close resultSet:" + resultSet.hashCode());
                }
                resultSet.close();
            }
            catch (SQLException e) {
                LogRegistry.getInstance().warn(SQLHelper.class, e.getLocalizedMessage());
            }
        }
    }

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(SQLHelper.class, "close connection:" + con.hashCode());
                }
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (SQLException e) {
                LogRegistry.getInstance().warn(SQLHelper.class, e.getLocalizedMessage());
            }
        }
    }

    public static void main(String[] args) {
        String[] cols = new String[]{"LASTUPDATE", "POS"};
        String sql = "insert into \"JAX_FORM_ACTION_MAP\" (\"UUID\",\"MANDANT_ID\",\"CREATED\",\"LASTUPDATE\",\"UUID_GROUP\",\"FORM_ID\",\"FORM_STATE\",\"ACTION_UUID\",\"POS\",\"ROLE\",\"HTML_SOURCE\",\"FAIL_STATE\",\"SUCCESS_STATE\",\"ID\",\"VISUAL_REPRESENTATION\",\"EXIT_WORKFLOW\",\"XML\",\"PARENT_ID\",\"SCOPE\",\"ACTIVE\",\"PRE_CONDITION\",\"OK_CONDITION\",\"COMMON_ID\",\"IS_ESURVEY\",\"ESURVEY_ID\") values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        System.out.println(SQLHelper.removeFromPreparedInsertSQL(sql, cols));
    }

    public static String removeFromPreparedInsertSQL(String sql, String[] missingCols) {
        if (missingCols != null && missingCols.length > 0) {
            String res = sql;
            for (int m = 0; m < missingCols.length; ++m) {
                res = res.replaceAll("\"?" + missingCols[m] + "\"?,", "");
                res = res.replaceFirst("\\?,", "");
            }
            return res;
        }
        return sql;
    }
}

