/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.undo.ChangeSerializationUndoableEditWrapper;
import com.jaxfront.core.util.undo.ChoiceChangeUndoableEditWrapper;
import com.jaxfront.core.util.undo.CompoundEditWrapper;
import com.jaxfront.core.util.undo.JAXFrontUndoableEdit;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import com.jaxfront.core.util.undo.ListMoveUndoableEditWrapper;
import com.jaxfront.core.util.undo.ListSortUndoableEditWrapper;
import com.jaxfront.core.util.undo.ListUndoableEditWrapper;
import com.jaxfront.core.util.undo.PasteUndoableEditWrapper;
import com.jaxfront.core.util.undo.PropertyChangeUndoableEditWrapper;
import com.jaxfront.core.util.undo.RecursionEventUndoableEditWrapper;
import com.jaxfront.core.util.undo.UndoManagerWrapper;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.w3c.dom.Element;

public class JAXFrontUndoManager
extends UndoManagerWrapper {
    private static final long serialVersionUID = -496173452759318550L;
    protected EventListenerList listenerList = new EventListenerList();
    protected Document _dom = null;
    int _next = 0;
    private CompoundEditWrapper _compoundEdit = null;
    private boolean _blockInput = false;
    private boolean _isUndoing = false;
    private boolean _isRedoing = false;

    public void undoableEditHappened(UndoableEditEvent e) {
        UndoableEdit ue = e.getEdit();
        this.addEdit(ue);
    }

    public JAXFrontUndoManager(Document dom) {
        this._dom = dom;
        this.setLimit(50);
    }

    public synchronized void addPropertyChangeEditEvent(Object eventSource, SimpleType target, String newValue, String oldValue) {
        if (!this.isBlocked()) {
            PropertyChangeUndoableEditWrapper wrapper = new PropertyChangeUndoableEditWrapper(this, eventSource, target, newValue, oldValue);
            this.addEdit(eventSource, target, wrapper);
        }
    }

    public synchronized void addListChangeEditEvent(Object eventSource, ListType target, Type listItem, int index, short action) {
        if (!this.isBlocked()) {
            ListUndoableEditWrapper wrapper = new ListUndoableEditWrapper(this, eventSource, target, listItem, index, action);
            this.addEdit(eventSource, target, wrapper);
        }
    }

    public synchronized void addListItemMovedEvent(Object eventSource, ListType target, int from, int to) {
        if (!this.isBlocked()) {
            ListMoveUndoableEditWrapper wrapper = new ListMoveUndoableEditWrapper(this, eventSource, target, from, to);
            this.addEdit(eventSource, target, wrapper);
        }
    }

    public synchronized void addListSortEvent(Object eventSource, ListType target, int direction, int inverseDirection, String actionName) {
        if (!this.isBlocked()) {
            ListSortUndoableEditWrapper wrapper = new ListSortUndoableEditWrapper(this, eventSource, target, direction, inverseDirection, actionName);
            this.addEdit(eventSource, target, wrapper);
        }
    }

    public synchronized void addChoiceChangeUndoableEditEvent(Object eventSource, Type target, Type newValue, Type oldValue, boolean isTemporary) {
        if (!this.isBlocked()) {
            ChoiceChangeUndoableEditWrapper wrapper = new ChoiceChangeUndoableEditWrapper(this, eventSource, target, newValue, oldValue, isTemporary);
            this.addEdit(eventSource, target, wrapper);
        }
    }

    public synchronized void addChangeSerializationUndoableEditEvent(Object eventSource, Type target, boolean newValue, boolean oldValue) {
        if (!this.isBlocked()) {
            ChangeSerializationUndoableEditWrapper wrapper = new ChangeSerializationUndoableEditWrapper(this, eventSource, target, newValue, oldValue);
            this.addEdit(eventSource, target, wrapper);
        }
    }

    public synchronized void addRecursionEventUndoableEditWrapper(Object eventSource, Type recursionType, short action) {
        if (!this.isBlocked()) {
            RecursionEventUndoableEditWrapper wrapper = new RecursionEventUndoableEditWrapper(this, eventSource, recursionType, action);
            this.addEdit(eventSource, recursionType, wrapper);
        }
    }

    public synchronized void addPasteUndoableEditEvent(Object eventSource, Type target, String newValue, String oldValue, boolean isTemporary) {
        if (!this.isBlocked()) {
            PasteUndoableEditWrapper wrapper = new PasteUndoableEditWrapper(this, eventSource, target, oldValue, newValue);
            this.addEdit(eventSource, target, wrapper);
        }
    }

    private void addEdit(Object eventSource, Type target, JAXFrontUndoableEditWrapper edit) {
        if (!this.isBlocked()) {
            if (this._compoundEdit == null) {
                super.undoableEditHappened(new UndoableEditEvent(eventSource == null ? target : eventSource, edit));
                this.fireUndoableEditUpdate(new UndoableEditEvent(eventSource == null ? target : eventSource, edit));
            } else {
                edit.setIsInCompoundEdit(true);
                this._compoundEdit.addEdit(edit);
            }
        }
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.add(UndoableEditListener.class, listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.remove(UndoableEditListener.class, listener);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return (UndoableEditListener[])this.listenerList.getListeners(UndoableEditListener.class);
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$UndoableEditListener == null ? JAXFrontUndoManager.class$("javax.swing.event.UndoableEditListener") : class$javax$swing$event$UndoableEditListener)) continue;
            ((UndoableEditListener)listeners[i + 1]).undoableEditHappened(e);
        }
    }

    public void startCompoundEdit() {
        if (!this.isBlocked() && this._compoundEdit == null) {
            this._compoundEdit = new CompoundEditWrapper(this);
        }
    }

    public boolean isInCompoundEditState() {
        return this._compoundEdit != null;
    }

    public synchronized void undo(boolean onlyLastSignificant) throws CannotUndoException {
        if (onlyLastSignificant && this.getLastEditStep().isSignificant()) {
            this.undo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undo() throws CannotUndoException {
        this._isUndoing = true;
        boolean wasBlocked = this.isBlocked();
        this.blockInput(true);
        try {
            super.undo();
        }
        finally {
            if (!wasBlocked) {
                this.blockInput(false);
            }
            this._isUndoing = false;
        }
    }

    public synchronized void undoAll() throws CannotUndoException {
        for (int e = this.edits.size() - 1; e >= 0; --e) {
            UndoableEdit edit = (UndoableEdit)this.edits.get(e);
            if (edit instanceof CompoundEditWrapper) {
                ((CompoundEditWrapper)edit).macroUndo();
                continue;
            }
            if (!(edit instanceof JAXFrontUndoableEditWrapper)) continue;
            ((JAXFrontUndoableEditWrapper)edit).macroUndo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void redo() throws CannotRedoException {
        this._isRedoing = true;
        boolean wasBlocked = this.isBlocked();
        this.blockInput(true);
        try {
            super.redo();
        }
        finally {
            if (!wasBlocked) {
                this.blockInput(false);
            }
            this._isRedoing = false;
        }
    }

    public void stopCompoundEdit() {
        if (!this.isBlocked() && this._compoundEdit != null) {
            this._compoundEdit.end();
            if (!this.isBlocked()) {
                super.addEdit(this._compoundEdit);
            }
            this.fireUndoableEditUpdate(new UndoableEditEvent(this._compoundEdit._targetDOM, this._compoundEdit));
            this._compoundEdit = null;
        }
    }

    public void abortCompoundEdit() {
        if (!this.isBlocked() && this._compoundEdit != null) {
            this._compoundEdit.end();
            this._compoundEdit = null;
        }
    }

    public void blockInput(boolean blocked) {
        this._blockInput = blocked;
    }

    public boolean isBlocked() {
        return this._blockInput && !this._dom.isBinding();
    }

    public void release() {
        this.discardAllEdits();
        this._dom = null;
    }

    public String serializeUndoManager() {
        StringWriter sw = new StringWriter();
        this.serializeUndoManager(new PrintWriter(sw));
        return sw.toString();
    }

    public void serializeUndoManager(PrintWriter writer) {
        this.serializeUndoManager(writer, (List)this.edits);
    }

    public void serializeUndoManager(PrintWriter writer, List editList) {
        writer.print("<UndoList>");
        for (int i = 0; i < editList.size(); ++i) {
            Object aEdit = editList.get(i);
            writer.print("<Event eventClass=\"" + aEdit.getClass().getName() + "\">");
            if (aEdit instanceof JAXFrontUndoableEdit) {
                ((JAXFrontUndoableEdit)aEdit).serialize(writer);
            }
            writer.print("</Event>");
        }
        writer.print("</UndoList>");
    }

    public void serializeUndoManager(File location) throws IOException {
        FileWriter fw = new FileWriter(location);
        this.serializeUndoManager(new PrintWriter(fw));
        fw.close();
    }

    public void serializeUndoManager(File location, List editList) throws IOException {
        FileWriter fw = new FileWriter(location);
        this.serializeUndoManager(new PrintWriter(fw), editList);
        fw.close();
    }

    public void createFromSerialize(org.w3c.dom.Document serialDom) {
        Vector sEdits = new Vector();
        List eventList = DOMHelper.getChildren(null, serialDom.getDocumentElement(), "Event");
        for (int e = 0; e < eventList.size(); ++e) {
            Element event = (Element)eventList.get(e);
            this.edits.add(JAXFrontUndoManager.parseEventObject(this, null, this._dom, event, sEdits));
        }
    }

    public void write(String url) {
        try {
            this.createFromSerialize(DOMHelper.createDocument(new FileReader(url)));
            StringWriter sw = new StringWriter();
            this.serializeUndoManager(new PrintWriter(sw));
            System.out.println(sw.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void discardAllEdits() {
        this._next = -1;
        super.discardAllEdits();
    }

    public static JAXFrontUndoableEdit parseEventObject(JAXFrontUndoManager manager, UndoableEdit edit, Document dom, Element event, List edits) {
        String eventClass = event.getAttribute("eventClass");
        String targetTypeXPath = DOMHelper.getChildText(null, event, "targetType");
        JAXFrontUndoableEdit editToAdd = null;
        if (eventClass.equals("com.jaxfront.core.util.undo.PropertyChangeUndoableEditWrapper")) {
            String oldValue = DOMHelper.getChildText(null, event, "oldValue");
            String newValue = DOMHelper.getChildText(null, event, "newValue");
            editToAdd = new PropertyChangeUndoableEditWrapper(manager, (Object)manager, targetTypeXPath, newValue, oldValue);
        } else if (eventClass.equals("com.jaxfront.core.util.undo.ChoiceChangeUndoableEditWrapper")) {
            String oldValue = DOMHelper.getChildText(null, event, "oldValue");
            String newValue = DOMHelper.getChildText(null, event, "newValue");
            editToAdd = new ChoiceChangeUndoableEditWrapper(manager, manager, targetTypeXPath, newValue, oldValue);
        } else if (eventClass.equals("com.jaxfront.core.util.undo.CompoundEditWrapper")) {
            editToAdd = new CompoundEditWrapper(manager, event);
        } else if (eventClass.equals("com.jaxfront.core.util.undo.ListMoveUndoableEditWrapper")) {
            String listFromIndex = DOMHelper.getChildText(null, event, "listFromIndex");
            String listToIndex = DOMHelper.getChildText(null, event, "listToIndex");
            editToAdd = new ListMoveUndoableEditWrapper(manager, (Object)manager, targetTypeXPath, Integer.parseInt(listFromIndex), Integer.parseInt(listToIndex));
        } else if (eventClass.equals("com.jaxfront.core.util.undo.ListSortUndoableEditWrapper")) {
            String direction = DOMHelper.getChildText(null, event, "direction");
            String inverseDirection = DOMHelper.getChildText(null, event, "inverseDirection");
            String action = DOMHelper.getChildText(null, event, "action");
            editToAdd = new ListSortUndoableEditWrapper(manager, (Object)manager, targetTypeXPath, Integer.parseInt(direction), Integer.parseInt(inverseDirection), action);
        } else if (eventClass.equals("com.jaxfront.core.util.undo.ListUndoableEditWrapper")) {
            String newValueType = DOMHelper.getChildText(null, event, "newValueType");
            String listItemIndex = DOMHelper.getChildText(null, event, "listItemIndex");
            String listAction = DOMHelper.getChildText(null, event, "listAction");
            editToAdd = new ListUndoableEditWrapper(manager, (Object)manager, targetTypeXPath, newValueType, Integer.parseInt(listItemIndex), Short.parseShort(listAction));
        } else if (eventClass.equals("com.jaxfront.core.util.undo.RecursionEventUndoableEditWrapper")) {
            String newValueType = DOMHelper.getChildText(null, event, "newValueType");
            String listAction = DOMHelper.getChildText(null, event, "action");
            editToAdd = new RecursionEventUndoableEditWrapper(manager, manager, targetTypeXPath, newValueType, Short.parseShort(listAction));
        } else if (eventClass.equals("com.jaxfront.core.util.undo.PasteUndoableEditWrapper")) {
            String oldValue = DOMHelper.getChildText(null, event, "oldValue");
            String newValue = DOMHelper.getChildText(null, event, "newValue");
            editToAdd = new PasteUndoableEditWrapper(manager, (Object)manager, targetTypeXPath, oldValue, newValue);
        } else if (eventClass.equals("com.jaxfront.core.util.undo.ChangeSerializationUndoableEditWrapper")) {
            String oldValue = DOMHelper.getChildText(null, event, "oldValue");
            String newValue = DOMHelper.getChildText(null, event, "newValue");
            editToAdd = new ChangeSerializationUndoableEditWrapper(manager, (Object)manager, targetTypeXPath, Boolean.getBoolean(newValue), Boolean.getBoolean(oldValue));
        }
        return editToAdd;
    }

    public boolean canMacroUndo() throws CannotUndoException {
        return this.canMacroUndo(this._next);
    }

    public boolean canMacroRedo() {
        return this.canMacroRedo(this._next);
    }

    public void macroUndo() throws CannotUndoException {
        this.macroUndo(this._next);
    }

    public void macroRedo() {
        this.macroRedo(this._next);
    }

    public boolean canMacroUndo(int from) throws CannotUndoException {
        return from - 1 >= 0;
    }

    public boolean canMacroRedo(int from) {
        return from >= 0 && from < this.edits.size();
    }

    public void macroUndo(int from) throws CannotUndoException {
        if (from - 1 >= 0) {
            UndoableEdit edit;
            if ((edit = (UndoableEdit)this.edits.get(--from)) instanceof CompoundEditWrapper) {
                ((CompoundEditWrapper)edit).macroUndo();
            } else if (edit instanceof JAXFrontUndoableEditWrapper) {
                ((JAXFrontUndoableEditWrapper)edit).macroUndo();
            }
            this._next = from;
        }
    }

    public void macroRedo(int from) {
        if (from >= 0 && from < this.edits.size()) {
            UndoableEdit edit;
            if ((edit = (UndoableEdit)this.edits.get(from++)) instanceof CompoundEditWrapper) {
                ((CompoundEditWrapper)edit).macroRedo();
            } else if (edit instanceof JAXFrontUndoableEditWrapper) {
                ((JAXFrontUndoableEditWrapper)edit).macroRedo();
            }
            this._next = from;
        }
    }

    public int getNextEditIndex() {
        return this._next;
    }

    public int getMaxEditIndex() {
        return this.edits.size();
    }

    public List getEditSteps() {
        return (List)this.edits.clone();
    }

    public void addMacroEdit(UndoableEdit edit) {
        this.edits.add(edit);
    }

    public boolean isUndoing() {
        return this._isUndoing;
    }

    public boolean isRedoing() {
        return this._isRedoing;
    }
}

