/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.type.AbstractListType;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.commons.lang.StringEscapeUtils;

public class ListUndoableEditWrapper
extends JAXFrontUndoableEditWrapper {
    public static final short DELETE = 1;
    public static final short ADD = 2;
    private String _newV = null;
    private int _listItemIndex = -1;
    private short _listAction = (short)-1;

    public ListUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, ListType target, Type listItem, int index, short action) {
        super(manager, target);
        this._sourceType = eventSource;
        this._listItemIndex = index;
        this._newV = ((Type)target.get(index)).serialize().toString();
        this._listAction = action;
    }

    public ListUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, String target, String listItemValue, int index, short action) {
        super(manager, target);
        this._sourceType = eventSource;
        this._listItemIndex = index;
        this._newV = StringEscapeUtils.unescapeXml((String)listItemValue);
        this._listAction = action;
    }

    public void die() {
        super.die();
        this._newV = null;
    }

    public String getPresentationName() {
        return "Shit";
    }

    public String getRedoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public String getUndoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            AbstractListType listType = (AbstractListType)tt;
            switch (this._listAction) {
                case 1: {
                    if (listType.violateCardinality(-1)) break;
                    try {
                        if (this._listItemIndex == -1) break;
                        listType.delete(JAXFrontUndoManager.class, this._listItemIndex, false, false);
                    }
                    catch (ListModificationException e) {}
                    break;
                }
                case 2: {
                    if (listType.violateCardinality(1)) break;
                    if (this._listItemIndex >= 0 && this._listItemIndex < tt.getDirectChildren().size()) {
                        Type newType = listType.addNewChild(JAXFrontUndoManager.class, null, this._listItemIndex);
                        listType.getDOM().getClipBoard().doPaste(newType, this._newV, null, newType.getStyle().isRepresentedAsTreeNode(), false);
                        break;
                    }
                    Type newType = listType.addNewChild();
                    listType.getDOM().getClipBoard().doPaste(newType, this._newV, null, newType.getStyle().isRepresentedAsTreeNode(), false);
                }
            }
            TypeVisualizerFactory.getInstance().populateAllVisualizerForType(tt);
            this.stopBlocking();
            this.visualizeRedo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            AbstractListType listType = (AbstractListType)tt;
            switch (this._listAction) {
                case 1: {
                    Type newType;
                    if (listType.violateCardinality(1)) break;
                    if (this._listItemIndex >= 0 && this._listItemIndex < tt.getDirectChildren().size()) {
                        newType = listType.addNewChild(JAXFrontUndoManager.class, null, this._listItemIndex);
                        newType.getDOM().getClipBoard().doPaste(newType, this._newV, null, newType.getStyle().isRepresentedAsTreeNode(), false);
                    } else {
                        newType = listType.addNewChild();
                        newType.getDOM().getClipBoard().doPaste(newType, this._newV, null, newType.getStyle().isRepresentedAsTreeNode(), false);
                    }
                    Vector allVis = TypeVisualizerFactory.getInstance().getAllVisualizers(tt);
                    for (int i = 0; i < allVis.size(); ++i) {
                        ((ListVisualizer)allVis.get(i)).populateView();
                    }
                    break;
                }
                case 2: {
                    if (this._listItemIndex < 0) break;
                    try {
                        int index = this._listItemIndex;
                        if (listType.violateCardinality(-1) || index == -1 || index >= listType.size()) break;
                        Type toDeleteType = (Type)listType.get(index);
                        TypeVisualizerFactory.getInstance().removeVisualizerStructure(toDeleteType, true);
                        listType.delete(JAXFrontUndoManager.class, index, false, false);
                        --index;
                        if (listType.getList().size() > 0) {
                            if (index > 0 && index >= listType.getList().size()) {
                                index = listType.getList().size() - 1;
                            }
                            if (index < 0 || index >= listType.size()) break;
                            Type lastType = (Type)listType.getList().get(index);
                            ((ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer(tt)).selectType(lastType, false);
                            break;
                        }
                        ((ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer(tt)).selectType(null, false);
                        ((ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer(tt)).showModel(null);
                        break;
                    }
                    catch (ListModificationException listModificationException) {
                        // empty catch block
                    }
                }
            }
            this.stopBlocking();
            this.visualizeUndo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public boolean canRedo() {
        Type tt = this.evalTargetType();
        boolean canUndo = true;
        if (tt != null) {
            AbstractListType listType = (AbstractListType)tt;
            switch (this._listAction) {
                case 1: {
                    if (!listType.violateCardinality(-1)) break;
                    canUndo = false;
                    break;
                }
                case 2: {
                    listType = (AbstractListType)tt;
                    if (!listType.violateCardinality(1)) break;
                    canUndo = false;
                }
            }
        }
        return !this.dead && canUndo;
    }

    public boolean canUndo() {
        Type tt = this.evalTargetType();
        boolean canUndo = true;
        if (tt != null) {
            AbstractListType listType = (AbstractListType)tt;
            switch (this._listAction) {
                case 1: {
                    if (!listType.violateCardinality(1)) break;
                    canUndo = false;
                    break;
                }
                case 2: {
                    if (!listType.violateCardinality(-1)) break;
                    canUndo = false;
                }
            }
        }
        return !this.dead && canUndo;
    }

    public void serialize(PrintWriter writer) {
        super.serialize(writer);
        if (this._newV != null) {
            writer.print("<newValueType>");
            writer.print(StringEscapeUtils.escapeXml((String)this._newV));
            writer.print("</newValueType>");
        }
        writer.print("<listItemIndex>");
        writer.print(this._listItemIndex);
        writer.print("</listItemIndex>");
        writer.print("<listAction>");
        writer.print(this._listAction);
        writer.print("</listAction>");
    }
}

