/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.xpath.NodeList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.xerces.xni.parser.XMLParseException;
import org.jaxen.JaxenException;
import org.jaxen.XPathSyntaxException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class W3CXPathExecuterImpl {
    private static W3CXPathExecuterImpl _singleton = null;

    public List processXPath(Node rootElement, String xpath) throws TransformerException {
        return this.processXPath(rootElement, xpath, false);
    }

    public List processXPath(Node rootElement, String xpath, boolean ignoreNS) throws TransformerException {
        List results = null;
        try {
            DOMXPath typeXpath = new DOMXPath(xpath);
            Hashtable namespaces = DOMHelper.getNameSpaces(rootElement.getOwnerDocument());
            Enumeration namespacesEnum = namespaces.keys();
            String nsKey = null;
            String nsURI = null;
            if (ignoreNS) {
                typeXpath.setNamespaceContext(null);
            } else {
                while (namespacesEnum.hasMoreElements()) {
                    nsKey = (String)namespacesEnum.nextElement();
                    nsURI = (String)namespaces.get(nsKey);
                    typeXpath.addNamespace(nsKey, nsURI);
                }
            }
            results = typeXpath.selectNodes(rootElement);
        }
        catch (XPathSyntaxException e) {
            LogRegistry.getInstance().error(this.getClass(), "XPath-Syntax Error for (" + xpath + ") Reason:" + e.getMultilineMessage());
        }
        catch (JaxenException e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        return results;
    }

    public NodeList processNodeListXPath(Node rootElement, String xpath) throws TransformerException {
        return new NodeList(this.processXPath(rootElement, xpath, false));
    }

    public String getElementValue(Element element, String xpath) {
        return this.getElementValue(element, xpath, false);
    }

    public String getElementValue(Element element, String xpath, boolean ignoreNS) {
        if (xpath != null && xpath.length() > 0) {
            try {
                List childs = W3CXPathExecuterImpl.getInstance().processXPath(element, xpath, false);
                if (childs.size() > 0) {
                    return DOMHelper.getText((Element)childs.get(0));
                }
                if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(this.getClass(), "can't find value for:" + xpath);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public void setElementValue(Element element, String xpath, String value) {
        try {
            List childs = W3CXPathExecuterImpl.getInstance().processXPath(element, xpath, false);
            if (childs.size() > 0) {
                Node node = (Node)childs.get(0);
                if (node.getNodeType() == 2) {
                    node.setNodeValue(value);
                } else {
                    DOMHelper.setText((Element)node, value);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private W3CXPathExecuterImpl() {
    }

    public static void main(String[] args) throws XMLParseException, MalformedURLException, SAXException, IOException, TransformerException {
        Document doc = DOMHelper.createDocument(new URL("file:c:/po/po.xml"));
        W3CXPathExecuterImpl.getInstance().processXPath(doc, "//*", false);
    }

    public static W3CXPathExecuterImpl getInstance() {
        if (_singleton == null) {
            _singleton = new W3CXPathExecuterImpl();
            return _singleton;
        }
        return _singleton;
    }
}

