/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.DocumentCreationException;
import com.jaxfront.core.schema.SchemaCreationException;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.EmptyUnmodifiableList;
import com.jaxfront.core.xpath.XPNode;
import com.jaxfront.core.xpath.XPathError;
import com.jaxfront.core.xpath.XPathNodeExtractor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XPNodeWalker {
    Map _nsMappings = null;
    private static final EmptyUnmodifiableList EMPTY_LIST = new EmptyUnmodifiableList();

    public XPNodeWalker() {
    }

    public XPNodeWalker(Map nsMappings) {
        this._nsMappings = nsMappings;
    }

    public List walkTypeXpath(String xpath, Type start, boolean traverseOnlyEditingType, boolean edTypeIncluded, boolean listTypeIncluded, boolean onlySerializable, boolean checkExp, boolean choosenOnly) throws XPathError {
        if (start == null) {
            return EMPTY_LIST;
        }
        XPNode xnode = null;
        if (xpath.startsWith("/")) {
            start = start.getDOM().getRootType();
            if (xpath.equals("/*")) {
                ArrayList<Type> result = new ArrayList<Type>(1);
                result.add(start);
                return result;
            }
            if (xpath.startsWith("/*")) {
                xnode = XPathNodeExtractor.tokenizeNext(xpath, xnode, checkExp, this._nsMappings, true);
            } else if (!xpath.startsWith("//") && !this.compareNode((xnode = XPathNodeExtractor.tokenizeNext(xpath, xnode, checkExp, this._nsMappings, true)).getNodeName(), xnode.getNodeNSpace(), false, start)) {
                return EMPTY_LIST;
            }
        }
        ArrayList toProcess = new ArrayList();
        XPNodeWalker.addToResult(toProcess, start, onlySerializable);
        ArrayList processResult = new ArrayList();
        boolean hadResult = true;
        while ((xnode = XPathNodeExtractor.tokenizeNext(xpath, xnode, checkExp, this._nsMappings, true)) != null) {
            hadResult = false;
            boolean consumeNextToken = false;
            block9: for (int tp = 0; tp < toProcess.size(); ++tp) {
                if (toProcess.size() == 0) {
                    if (!hadResult) {
                        toProcess.clear();
                    }
                    return processResult;
                }
                start = (Type)toProcess.get(tp);
                switch (xnode.getNodeType()) {
                    case 5: {
                        if (!start.isComposite()) continue block9;
                        XPNodeWalker.addToResult(processResult, ((CompositeType)start).getContentType(), onlySerializable);
                        continue block9;
                    }
                    case 8: {
                        XPNode allXnode = XPathNodeExtractor.tokenizeNext(xpath, xnode, checkExp, false);
                        this.handleGetAllNode(start, allXnode, traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, processResult, onlySerializable, true, choosenOnly);
                        consumeNextToken = true;
                        continue block9;
                    }
                    case 6: {
                        start = this.handleParentNode(start, traverseOnlyEditingType, listTypeIncluded);
                        XPNodeWalker.addToResult(processResult, start, onlySerializable);
                        continue block9;
                    }
                    case 4: {
                        continue block9;
                    }
                    case 9: {
                        this.getAsterixChilds(start, traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, processResult, onlySerializable, false, choosenOnly);
                        continue block9;
                    }
                    case 10: {
                        this.getAsterixChilds(start, traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, processResult, onlySerializable, true, choosenOnly);
                        continue block9;
                    }
                    default: {
                        if (xnode.getNodeExpression() != null) {
                            this.handleExpressionNode(start, xnode, traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, processResult, onlySerializable, choosenOnly);
                            continue block9;
                        }
                        this.handleNamedNode(start, xnode, traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, processResult, onlySerializable, choosenOnly);
                    }
                }
            }
            if (consumeNextToken) {
                XPathNodeExtractor.tokenizeNext(xpath, xnode, checkExp, true);
            }
            if (processResult.size() <= 0) continue;
            ArrayList tlist = toProcess;
            toProcess = processResult;
            processResult = tlist;
            processResult.clear();
            hadResult = true;
        }
        if (!hadResult) {
            toProcess.clear();
        }
        return toProcess;
    }

    private void getAsterixChilds(Type start, boolean traverseOnlyEditingType, boolean includeEditingType, boolean listTypeIncluded, ArrayList processResult, boolean onlySerializable, boolean attrMode, boolean choosenOnly) {
        if (choosenOnly && start.isChoice()) {
            processResult.add(start.getChoosenType());
        } else if (start.getDirectChildrenSize() > 0) {
            List childs = start.getDirectChildren();
            for (int c = 0; c < childs.size(); ++c) {
                Type child = (Type)childs.get(c);
                if (attrMode) {
                    if (!child.isAttribute()) continue;
                    processResult.add(child);
                    continue;
                }
                if (child.isAttribute()) continue;
                if (child.isList()) {
                    processResult.addAll((ListType)child);
                    if (listTypeIncluded) {
                        processResult.add(child);
                    }
                    if (!includeEditingType) continue;
                    processResult.add(((ListType)child).getEditingType());
                    continue;
                }
                processResult.add(child);
            }
        }
    }

    public ArrayList createXPathNodes(String xpath, Type start) throws XPathError {
        ArrayList<XPNode> result = new ArrayList<XPNode>();
        XPNode xnode = null;
        if (xpath.startsWith("/")) {
            start = start.getDOM().getRootType();
            if (!xpath.startsWith("//") && !this.compareNode((xnode = XPathNodeExtractor.tokenizeNext(xpath, xnode, false, this._nsMappings, true)).getNodeName(), xnode.getNodeNSpace(), false, start)) {
                return null;
            }
        }
        result.add(xnode);
        while ((xnode = XPathNodeExtractor.tokenizeNext(xpath, xnode, false, this._nsMappings, true)) != null) {
            result.add(xnode);
        }
        return result;
    }

    public static void main(String[] args) throws SchemaCreationException, MalformedURLException, DocumentCreationException, XPathError {
        Document aDom = DOMBuilder.getInstance().build(null, new URL("file:/c:/temp/po.xsd"), new URL("file:/c:/temp/po.xml"), null, null);
        XPNodeWalker xpw = new XPNodeWalker();
        List result = xpw.walkTypeXpath("/purchaseOrder/item", aDom.getRootType(), false, true, true, false, true, true);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            result = xpw.walkTypeXpath("/purchaseOrder/item[2]/product/billTo2", aDom.getRootType(), false, true, true, false, true, true);
        }
        long stop = System.currentTimeMillis();
        System.out.println(stop - start + " " + ArrayUtil.toString(result.toArray()));
        for (int i = 0; i < 100000; ++i) {
            aDom.getType("/purchaseOrder/item[2]/product/billTo2");
        }
        long stop2 = System.currentTimeMillis();
        System.out.println(stop2 - stop + "");
    }

    public Type handleParentNode(Type start, boolean traverseOnlyEditingType, boolean ltIncluded) {
        Type parent = start.getParent();
        if (traverseOnlyEditingType && parent != null && parent.isList()) {
            parent = parent.getParent();
        }
        if (!ltIncluded) {
            while (parent != null && parent.isList()) {
                parent = parent.getParent();
            }
        }
        return parent;
    }

    public static Type handleSameNode(Type start) {
        return start;
    }

    public boolean handleNamedNode(Type start, XPNode xNode, boolean traverseOnlyEditingType, boolean edTypeIncluded, boolean listTypeIncluded, ArrayList result, boolean onlySerializable, boolean choosenOnly) {
        Type child = null;
        boolean added = false;
        if (xNode.isAttr()) {
            if (xNode.isAsterix()) {
                List allChilds = start.getDirectChildren();
                for (int c = allChilds.size() - 1; c >= 0; --c) {
                    Type aAttrChild = (Type)allChilds.get(c);
                    added |= this.handleAttrNamedNodeChild(traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, result, aAttrChild, onlySerializable, choosenOnly);
                }
            } else {
                child = start.getDirectChild(xNode.getNodeName(), xNode.getNodeNSpace());
                added = this.handleAttrNamedNodeChild(traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, result, child, onlySerializable, choosenOnly);
            }
        } else if (xNode.isAsterix()) {
            List allChilds = null;
            allChilds = start.isList() ? (List)((Object)start) : start.getDirectChildren();
            for (int c = 0; c < allChilds.size(); ++c) {
                added |= this.handleElementNamedNodeChild(traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, result, (Type)allChilds.get(c), onlySerializable, choosenOnly);
            }
        } else if (start.isList()) {
            if (edTypeIncluded) {
                this.getAllChilds(((ListType)start).getEditingType(), xNode, result, traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, onlySerializable, false, choosenOnly);
            } else {
                List allChilds = start.getDirectChildren();
                for (int c = allChilds.size() - 1; c >= 0; --c) {
                    Type aLChild = (Type)allChilds.get(c);
                    added |= this.handleElementNamedNodeChild(traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, result, aLChild, onlySerializable, choosenOnly);
                }
            }
        } else {
            child = start.getDirectChild(xNode.getNodeName(), xNode.getNodeNSpace());
            added = this.handleElementNamedNodeChild(traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, result, child, onlySerializable, choosenOnly);
        }
        return added;
    }

    private boolean handleElementNamedNodeChild(boolean traverseOnlyEditingType, boolean edTypeIncluded, boolean listTypeIncluded, ArrayList result, Type child, boolean onlySerializable, boolean choosenOnly) {
        boolean added = false;
        if (child != null && !child.isAttribute()) {
            if (child.isList()) {
                if (!traverseOnlyEditingType) {
                    added = result.addAll((List)((Object)child));
                    if (listTypeIncluded) {
                        added |= XPNodeWalker.addToResult(result, child, onlySerializable);
                    }
                }
                if (edTypeIncluded) {
                    child = ((ListType)child).getEditingType();
                    added |= XPNodeWalker.addToResult(result, child, onlySerializable);
                }
            } else {
                added = XPNodeWalker.addToResult(result, child, onlySerializable);
            }
        }
        return added;
    }

    private boolean handleAttrNamedNodeChild(boolean traverseOnlyEditingType, boolean edTypeIncluded, boolean listTypeIncluded, ArrayList result, Type child, boolean onlySerializable, boolean choosenOnly) {
        boolean added = false;
        if (child != null && child.isAttribute()) {
            if (child.isList()) {
                if (!traverseOnlyEditingType) {
                    added = result.addAll((List)((Object)child));
                    if (listTypeIncluded) {
                        added |= XPNodeWalker.addToResult(result, child, onlySerializable);
                    }
                }
                if (edTypeIncluded) {
                    child = ((ListType)child).getEditingType();
                    added |= XPNodeWalker.addToResult(result, child, onlySerializable);
                }
            } else {
                added = XPNodeWalker.addToResult(result, child, onlySerializable);
            }
        }
        return added;
    }

    private static boolean addToResult(ArrayList result, Type child, boolean onlySerializable) {
        if (child != null) {
            if (onlySerializable) {
                if (child.isSerializable()) {
                    return result.add(child);
                }
                return false;
            }
            return result.add(child);
        }
        return false;
    }

    public void handleGetAllNode(Type start, XPNode xNode, boolean traverseOnlyEditingType, boolean edTypeIncluded, boolean listTypeIncluded, ArrayList result, boolean onlySerializable, boolean isStart, boolean choosenOnly) {
        this.getAllChilds(start, xNode, result, traverseOnlyEditingType, edTypeIncluded, listTypeIncluded, onlySerializable, isStart, choosenOnly);
    }

    public void handleExpressionNode(Type start, XPNode xNode, boolean traverseOnlyEditingType, boolean edTypeIncluded, boolean listTypeIncluded, ArrayList result, boolean onlySerializable, boolean choosenOnly) {
        boolean returnList = false;
        boolean returnIndexed = false;
        switch (xNode.getNodeType()) {
            case 1: {
                returnList = true;
                break;
            }
            case 7: {
                returnIndexed = true;
            }
        }
        Type list = start.getDirectChild(xNode.getNodeName(), xNode.getNodeNSpace());
        Type child = null;
        if (list != null && list.isList()) {
            int pos;
            if (returnList) {
                child = list;
            } else if (returnIndexed && (pos = xNode.getNodeIDX() - 1) >= 0 && pos < ((List)((Object)list)).size()) {
                child = (Type)((List)((Object)list)).get(pos);
            }
        }
        XPNodeWalker.addToResult(result, child, onlySerializable);
    }

    public void getAllChilds(Type aStartType, XPNode xNode, List result, boolean traverseOnlyEditingType, boolean includeEditingType, boolean listTypeIncluded, boolean onlySerializable, boolean isStart, boolean choosenOnly) {
        Type choosenType;
        List childs = null;
        String name = xNode.getNodeName();
        String ns = xNode.getNodeNSpace();
        boolean addAll = xNode.isAsterix();
        boolean isAttribute = xNode.isAttr();
        if (aStartType.isList()) {
            childs = (ArrayList)((Object)aStartType);
        }
        childs = choosenOnly && aStartType.isChoice() ? ((choosenType = aStartType.getChoosenType()) != null ? ArrayUtil.createListContaining(choosenType) : EMPTY_LIST) : (aStartType.getDirectChildrenSize() > 0 ? aStartType.getDirectChildren() : new ArrayList());
        for (int c = 0; c < childs.size(); ++c) {
            Type aType = (Type)childs.get(c);
            this.getAllChilds(aType, xNode, result, traverseOnlyEditingType, includeEditingType, listTypeIncluded, onlySerializable, false, choosenOnly);
        }
        if (aStartType.isList()) {
            if (listTypeIncluded && this.compareNode(name, ns, addAll, aStartType)) {
                XPNodeWalker.addToResult(result, aStartType, onlySerializable, isAttribute);
            }
            if (includeEditingType) {
                this.getAllChilds(((ListType)aStartType).getEditingType(), xNode, result, traverseOnlyEditingType, includeEditingType, listTypeIncluded, onlySerializable, false, choosenOnly);
            }
        } else if (this.compareNode(name, ns, addAll, aStartType)) {
            if (xNode.isIndexdNode()) {
                if (aStartType.getParent() != null && aStartType.getParent().isList() && aStartType.getParentList().indexOf(aStartType) == xNode.getNodeIDX() - 1) {
                    XPNodeWalker.addToResult(result, aStartType, onlySerializable, isAttribute);
                }
            } else {
                XPNodeWalker.addToResult(result, aStartType, onlySerializable, isAttribute);
            }
        }
    }

    private boolean compareNode(String nodeName, String nameSpace, boolean matchesAnyName, Type aType) {
        boolean nameMatch = false;
        String aTypeName = aType.getName();
        if (aType.isDerived()) {
            aTypeName = aType.getParent().getName();
        }
        boolean bl = nameMatch = matchesAnyName || nodeName.equals(aTypeName);
        if (!nameMatch) {
            return false;
        }
        String nodeUri = this.getElementNamespaceUri(aType, nameSpace != null);
        if (this.hasNamespace(nameSpace) != this.hasNamespace(nodeUri)) {
            return false;
        }
        if (nameMatch) {
            return this.matchesNamespaceURIs(nameSpace, nodeUri);
        }
        return false;
    }

    public String getElementNamespaceUri(Type aNodeType, boolean defaultStepIsPrefixed) {
        if (aNodeType.isGlobal()) {
            return null;
        }
        if (!defaultStepIsPrefixed && (aNodeType.getSchemaElement().isGlobalReference() || aNodeType.getSchemaElement().isGlobal() || aNodeType.getNamespace() == aNodeType.getDOM().getSchema().getTargetNamespace())) {
            return null;
        }
        return aNodeType.getNamespace();
    }

    protected boolean matchesNamespaceURIs(String uri1, String uri2) {
        if (uri1 == uri2) {
            return true;
        }
        if (uri1 == null) {
            return uri2.length() == 0;
        }
        if (uri2 == null) {
            return uri1.length() == 0;
        }
        return uri1.equals(uri2);
    }

    private boolean hasNamespace(String uri) {
        return uri != null && uri.length() > 0;
    }

    private static boolean addToResult(List result, Type aType, boolean onlySerializable, boolean xpIsAttriute) {
        if (onlySerializable) {
            if (aType.isSerializable() && xpIsAttriute == aType.isAttribute()) {
                return result.add(aType);
            }
            return false;
        }
        if (xpIsAttriute == aType.isAttribute()) {
            return result.add(aType);
        }
        return false;
    }

    public Map getNSMappings() {
        return this._nsMappings;
    }
}

