/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.xpath.XPNode;
import com.jaxfront.core.xpath.XPathError;
import com.jaxfront.core.xpath.XPathNodeExtractor;
import java.util.List;
import java.util.Vector;

public class XPathTree {
    XPNode _rootNode = null;

    public void addNode(List nodePath) throws XPathError {
        XPNode baseNode = this.getRootNode();
        for (int i = 0; i < nodePath.size(); ++i) {
            XPNode pNode = (XPNode)nodePath.get(i);
            XPNode aChild = baseNode.getChild(pNode.getNodeName());
            if (aChild == null) {
                baseNode.addChild(pNode);
                baseNode = pNode;
                continue;
            }
            if (pNode.getUserObject() != null) {
                if (aChild.getUserObject() != null) {
                    XPNode sameAxisNode = new XPNode(pNode.getNodeName(), false);
                    sameAxisNode.setUserObject(pNode.getUserObject());
                    aChild.addSameAxis(sameAxisNode);
                } else {
                    aChild.setUserObject(pNode.getUserObject());
                }
            }
            baseNode = aChild;
        }
    }

    public static XPathTree createTree(Vector xuiComponents, boolean check) throws XPathError {
        XPathTree tree = new XPathTree();
        for (int i = 0; i < xuiComponents.size(); ++i) {
            Type xuiC = (Type)xuiComponents.get(i);
            new XPathNodeExtractor();
            List nodes = XPathNodeExtractor.tokenize(xuiC.getDirectChildValue("xpath"), check);
            ((XPNode)nodes.get(nodes.size() - 1)).setUserObject(xuiC);
            tree.addNode(nodes);
        }
        return tree;
    }

    public XPNode getRootNode() throws XPathError {
        if (this._rootNode == null) {
            this._rootNode = new XPNode("root", -1, false);
        }
        return this._rootNode;
    }
}

