/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath.schema;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xpath.schema.SchemaDocumentNavigator;
import com.jaxfront.core.xpath.schema.SchemaXPath;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.XPathSyntaxException;

public class SchemaXPathExecuterImpl {
    private static final Vector nullResult = new Vector();
    private static SchemaXPathExecuterImpl _singleton = null;

    public List processXPath(String xpath, Document dom, SchemaNode schemaElement, boolean namespaceAware) throws TransformerException {
        List results = null;
        boolean listTypeOnly = false;
        boolean listTypeInlcuded = false;
        Vector<SchemaNode> result = new Vector<SchemaNode>();
        try {
            if (xpath == null || xpath.equals("")) {
                return nullResult;
            }
            SchemaDocumentNavigator navigator = (SchemaDocumentNavigator)SchemaDocumentNavigator.getInstance();
            navigator.reset();
            if (xpath.indexOf("[list]") > -1 || xpath.indexOf("[List]") > -1) {
                listTypeOnly = true;
                listTypeInlcuded = true;
                xpath = TextTools.replace(xpath, "[list]", "");
                xpath = TextTools.replace(xpath, "[List]", "");
            }
            SchemaXPath xsdXpath = new SchemaXPath(xpath, navigator);
            if (namespaceAware) {
                if (dom != null) {
                    Hashtable nsMapps = dom.getXUINamespaceMappings();
                    if (nsMapps != null && nsMapps.size() > 0) {
                        this.addNamespacesToXpath(xsdXpath, dom.getXUINamespaceMappings());
                    }
                } else {
                    this.addNamespacesToXpath(xsdXpath, schemaElement.getSchema().getNamespaceMapping());
                }
                if (schemaElement.getTargetNS() != null) {
                    xsdXpath.addNamespace("", schemaElement.getTargetNS());
                }
            }
            results = xsdXpath.selectNodes(schemaElement);
            for (int i = 0; i < results.size(); ++i) {
                boolean isListNode;
                SchemaNode aSchemaNode = (SchemaNode)results.get(i);
                boolean bl = isListNode = aSchemaNode.getMaxOccurs() > 1;
                if (listTypeOnly) {
                    if (!isListNode) continue;
                    result.add(aSchemaNode);
                    continue;
                }
                if (isListNode && listTypeInlcuded) {
                    result.add(aSchemaNode);
                    continue;
                }
                result.add(aSchemaNode);
            }
        }
        catch (XPathSyntaxException e) {
            LogRegistry.getInstance().error(this.getClass(), "XPath-Syntax Error for (" + xpath + ") Reason:" + e.getMultilineMessage());
        }
        catch (JaxenException e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        return results;
    }

    private void addNamespacesToXpath(XPath typeXpath, Hashtable mapping) throws JaxenException {
        Enumeration entries = mapping.keys();
        while (entries.hasMoreElements()) {
            Object uri = entries.nextElement();
            Object prefix = mapping.get(uri);
            typeXpath.addNamespace(prefix.toString(), uri.toString());
        }
    }

    private SchemaXPathExecuterImpl() {
    }

    public static SchemaXPathExecuterImpl getInstance() {
        if (_singleton == null) {
            _singleton = new SchemaXPathExecuterImpl();
            return _singleton;
        }
        return _singleton;
    }
}

