/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.dom.LoggingListener;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.AbstractAction;
import com.jaxfront.core.rule.ConditionExpression;
import com.jaxfront.core.rule.Rule;
import com.jaxfront.core.rule.RuleImpl;
import com.jaxfront.core.type.AbstractListType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeController;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.xui.AbstractXUIElement;
import com.jaxfront.core.xui.XUIDefinition;
import com.jaxfront.core.xui.XUITypes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class BehaviourDefinition
extends AbstractXUIElement
implements XUITypes {
    public BehaviourDefinition(XUIDefinition xuiDefinition, Type xuiType) {
        super(xuiDefinition, xuiType);
    }

    public BehaviourDefinition(XUIDefinition xuiDefinition, BehaviourDefinition behaviourDefinition) {
        this._xuiDefinition = xuiDefinition;
        Iterator iterator = behaviourDefinition.getRules().iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            this.addRule((Rule)rule.clone(this.getType()));
        }
        LoggingListener loggingListener = behaviourDefinition.getLoggingListener();
        if (loggingListener != null) {
            this.setLoggingListener(loggingListener.getLogScope(), loggingListener.getLogLevel());
        }
        if (!this.getType().isEditingType() && !this.getType().isDerivedFromEditingType()) {
            this.applyInitializationRules();
        }
    }

    public Rule addRule(Rule rule) {
        this.getRules().add(rule);
        if (!(this.getXUIDefinition().isTemplate() || this.getDOM().isReleased() || this.getDOM().isSCReleased())) {
            this.getDOM().getController().addRule(rule);
        }
        return rule;
    }

    public List getRules() {
        ArrayList rules = (ArrayList)this.getProperty("rule");
        if (rules == null) {
            rules = new ArrayList(2);
            this.setProperty("rule", rules);
        }
        return rules;
    }

    public LoggingListener getLoggingListener() {
        return (LoggingListener)this.getProperty("log");
    }

    protected String getStringProperty(String relativePath) {
        return super.getStringProperty("XUI/component/behaviour", relativePath);
    }

    public boolean hasPropertyChangeRules() {
        Iterator iterator = this.getRules().iterator();
        while (iterator.hasNext()) {
            if (!((Rule)iterator.next()).isPropertyChangeRule()) continue;
            return true;
        }
        return false;
    }

    public void applyInitializationRules() {
        if (!this.getType().getDOM().isRuleEngineBlocked()) {
            Iterator iterator = this.getRules().iterator();
            while (iterator.hasNext()) {
                Rule rule = (Rule)iterator.next();
                if (!rule.isVisualizerInitializationRule() && !rule.isChangeAndInitializationRule() && !rule.isDomInitialized()) continue;
                rule.apply(this.getType(), null);
            }
        }
    }

    protected void initialize() {
        if (this.getDOM().isImmutable()) {
            return;
        }
        List behaviours = this._xuiType.getDirectChildren();
        for (int i = 0; i < behaviours.size(); ++i) {
            Type behaviourEntry = (Type)behaviours.get(i);
            if (!behaviourEntry.getName().equals("rule")) continue;
            this.initializeRules((ListType)behaviourEntry);
        }
        this.checkLogging();
    }

    private void checkLogging() {
        String loggingScope = this._xuiType.getDirectChild("log").getDirectChildValue("scope");
        String logLevel = this._xuiType.getDirectChild("log").getDirectChildValue("level");
        if (logLevel != null) {
            this.setLoggingListener(loggingScope, logLevel);
        }
    }

    public String getLogLevel() {
        if (this.getLoggingListener() != null) {
            return this.getLoggingListener().getLogLevel();
        }
        return null;
    }

    public static boolean definesLogging(Type xuiType) {
        String logLevel = null;
        Type logType = xuiType.getDirectChild("log");
        if (logType != null) {
            logLevel = logType.getDirectChildValue("level");
        }
        return logLevel != null;
    }

    public void update(BehaviourDefinition behaviourDefinition) {
        if (behaviourDefinition.hasProperties()) {
            Enumeration styleProps = behaviourDefinition.getPropertyKeys();
            while (styleProps.hasMoreElements()) {
                String propKey = styleProps.nextElement().toString();
                Object propValue = behaviourDefinition.getProperty(propKey);
                if (propValue == null) continue;
                this.setProperty(propKey, propValue);
            }
        }
    }

    private void setLoggingListener(String loggingScope, String logLevel) {
        LoggingListener loggingListener = this.getType().getDOM().getController().addLogListener(this.getType(), loggingScope, logLevel);
        if (this.getXUIDefinition().isTemplate()) {
            this.getType().getDOM().getController().removeLogListener(loggingListener);
        }
        this.setProperty("log", loggingListener);
    }

    private void initializeRules(ListType rules) {
        Iterator childs = rules.getList().iterator();
        int counter = 0;
        while (childs.hasNext()) {
            Type ruleDefinition = (Type)childs.next();
            this.initializeRule(counter, ruleDefinition);
            ++counter;
        }
    }

    private void initializeRule(int counter, Type ruleDefinition) {
        Rule rule = null;
        String ruleEnabled = ruleDefinition.getDirectChildValue("enabled");
        String ruleSource = ruleDefinition.getDirectChildValue("source");
        boolean ruleSourceResolved = false;
        if ("false".equals(ruleEnabled)) {
            return;
        }
        Type ruleSourceType = this.getType();
        if (ruleSource != null) {
            ruleSourceType = this.getDOM().getVarToTypeMapping().get(ruleSource);
            if (ruleSourceType == null) {
                ruleSourceType = this.getDOM().getType(ruleSource, this.getType());
            }
            ruleSourceResolved = true;
            if (ruleSourceType == null) {
                LogRegistry.getInstance().warn(this.getClass(), "Unable to resolve source type for: " + ruleSource);
                ruleSourceType = this.getType();
                ruleSourceResolved = false;
            }
        }
        SimpleType refType = (SimpleType)ruleDefinition.getDirectChild("ref");
        SimpleType idType = (SimpleType)ruleDefinition.getDirectChild("id");
        String id = idType != null ? idType.getValue() : null;
        String tempPriority = ruleDefinition.getDirectChildValue("priority");
        if (refType != null && refType.getValue() != null) {
            this.initializeRuleRef(counter, refType);
        } else if (ruleDefinition != null) {
            Type eventDefinition = ruleDefinition.getDirectChild("event");
            Type conditionDefinition = ruleDefinition.getDirectChild("condition");
            ListType actionDefinition = (ListType)ruleDefinition.getDirectChild("action");
            if (eventDefinition != null) {
                long eventFilter = 0L;
                String eventType = eventDefinition.getDirectChildValue("type");
                AbstractListType triggerList = (AbstractListType)eventDefinition.getChild("trigger");
                if (triggerList != null && triggerList.size() <= 0) {
                    long eventToAdd = BehaviourDefinition.convertRuleTypeToMask(eventType);
                    if (eventToAdd > 0L) {
                        eventFilter = BehaviourDefinition.addToEventFilter(eventFilter, eventToAdd);
                    }
                } else {
                    eventFilter = this.buildEventFilter(triggerList);
                }
                String executionMode = eventDefinition.getDirectChildValue("executionMode");
                String scope = eventDefinition.getDirectChildValue("scope");
                String doesConcernNoneSerializableSource = eventDefinition.getDirectChildValue("doesConcernNoneSerializableSource");
                String doesConcernOnlyVisible = eventDefinition.getDirectChildValue("doesConcernOnlyVisibleSource");
                String scopeIncludeTarget = eventDefinition.getDirectChildValue("includeActionTarget");
                String scopeXPath = "rule/event/scope";
                if (scope != null) {
                    this.setProperty(scopeXPath, scope);
                } else {
                    scope = this.getStringProperty(scopeXPath);
                }
                if (eventFilter == 0L) {
                    eventFilter = 4L;
                }
                rule = new RuleImpl(id, eventFilter, ruleSourceType, executionMode, scope, StringUtil.isTrue(doesConcernNoneSerializableSource), StringUtil.isTrue(doesConcernOnlyVisible), StringUtil.isTrue(scopeIncludeTarget));
                if (tempPriority != null) {
                    try {
                        rule.setPriority(Integer.parseInt(tempPriority));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (conditionDefinition != null) {
                ConditionExpression condition = new ConditionExpression(counter, this.getDOM(), ruleSourceType, conditionDefinition);
                if (ruleSourceResolved) {
                    condition.getMessage().setID(0);
                }
                rule.setCondition(condition);
            }
            if (actionDefinition != null && actionDefinition.size() > 0) {
                Iterator iterator = actionDefinition.getList().iterator();
                int actionCounter = 1;
                while (iterator.hasNext()) {
                    AbstractAction action = BehaviourDefinition.initAction(actionCounter, this.getDOM(), ruleSourceType, (Type)iterator.next());
                    if (action == null) continue;
                    rule.getActions().add(action);
                    ++actionCounter;
                }
            }
            if (rule != null) {
                this.addRule(rule);
            }
        }
    }

    private long buildEventFilter(List events) {
        long resultFilter = 0L;
        if (events != null) {
            for (int i = 0; i < events.size(); ++i) {
                resultFilter = BehaviourDefinition.addToEventFilter(resultFilter, BehaviourDefinition.convertRuleTypeToMask(((SimpleType)events.get(i)).getValue()));
            }
        }
        if (resultFilter == 0L) {
            resultFilter = BehaviourDefinition.addToEventFilter(resultFilter, 2L);
            resultFilter = BehaviourDefinition.addToEventFilter(resultFilter, 1L);
        }
        return resultFilter;
    }

    public static void main(String[] args) {
        long f = 0x1000000L;
        System.out.println(f);
        f = BehaviourDefinition.addToEventFilter(f, 128L);
        System.out.println(f);
        f = BehaviourDefinition.removeFromEventFilter(f, 128L);
        System.out.println(f);
        System.out.println(0x10000000);
        System.out.println(" 0x10000000;// 268435456");
    }

    public static long addToEventFilter(long event, long eventToAdd) {
        long resultFilter = event;
        return resultFilter |= eventToAdd;
    }

    public static long removeFromEventFilter(long event, long eventToAdd) {
        long resultFilter = event;
        return resultFilter &= eventToAdd ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long convertRuleTypeToMask(String eventType) {
        long result = 0L;
        if (eventType == null) {
            result = 0L;
        } else if (eventType.equals("visualized") || eventType.equals("initialization")) {
            result = 1L;
        } else if (eventType.equals("change")) {
            result = 2L;
        } else if (eventType.equals("commit")) {
            result = 0x8000000L;
        } else if (eventType.equals("changeAndInitialization")) {
            result = 4L;
        } else if (eventType.startsWith("propertyChange")) {
            result = 8L;
        } else if (eventType.equals("structureChange")) {
            result = 64L;
        } else if (eventType.equals("structureChange (add)")) {
            result = 16L;
        } else if (eventType.equals("structureChange (remove)")) {
            result = 32L;
        } else if (eventType.equals("save")) {
            result = 1024L;
        } else if (eventType.equals("aboutToSerialize")) {
            result = Integer.MIN_VALUE;
        } else if (eventType.equals("persistent")) {
            result = 16384L;
        } else if (eventType.equals("aboutToPersist")) {
            result = 32768L;
        } else if (eventType.equals("aboutToValidate")) {
            result = 131072L;
        } else if (eventType.equals("domInitialized")) {
            result = 128L;
        } else if (eventType.equals("listItemSelected")) {
            result = 256L;
        } else if (eventType.equals("listItemDeselected")) {
            result = 512L;
        } else if (eventType.equals("onCreation")) {
            result = 2048L;
        } else if (eventType.equals("copyContent")) {
            result = 4096L;
        } else if (eventType.equals("pasteContent")) {
            result = 8192L;
        } else if (eventType.equals("domDeleted")) {
            result = 65536L;
        } else if (eventType.equals("goNext")) {
            result = 0x800000L;
        } else if (eventType.equals("aboutGoNext")) {
            result = 0x1000000L;
        } else if (eventType.equals("goPrevious")) {
            result = 0x20000000L;
        } else if (eventType.equals("aboutGoPrevious")) {
            result = 0x40000000L;
        }
        return result;
    }

    public static String convertMaskToRuleString(Rule rule) {
        StringBuffer result = new StringBuffer();
        if (rule.isVisualizerInitializationRule()) {
            result.append("visualized");
            result.append(",");
        }
        if (rule.isChangeRule()) {
            result.append("change");
            result.append(",");
        }
        if (rule.isChangeAndInitializationRule()) {
            result.append("changeAndInitialization");
            result.append(",");
        }
        if (rule.isPropertyChangeRule()) {
            result.append("propertyChange");
            result.append(",");
        }
        if (rule.isStructureChangeRule()) {
            result.append("structureChange");
            result.append(",");
        }
        if (rule.isStructureChangeAddRule()) {
            result.append("structureChange (add)");
            result.append(",");
        }
        if (rule.isStructureChangeRemoveRule()) {
            result.append("structureChange (remove)");
            result.append(",");
        }
        if (rule.isSaveDocumentRule()) {
            result.append("save");
            result.append(",");
        }
        if (rule.isAboutToSerialize()) {
            result.append("aboutToSerialize");
            result.append(",");
        }
        if (rule.isPersistentRule()) {
            result.append("persistent");
            result.append(",");
        }
        if (rule.isAboutToPersistRule()) {
            result.append("aboutToPersist");
            result.append(",");
        }
        if (rule.isAboutToValidateRule()) {
            result.append("aboutToValidate");
            result.append(",");
        }
        if (rule.isDomInitialized()) {
            result.append("domInitialized");
            result.append(",");
        }
        if (rule.isListItemSelectedRule()) {
            result.append("listItemSelected");
            result.append(",");
        }
        if (rule.isListItemDeselectedRule()) {
            result.append("listItemDeselected");
            result.append(",");
        }
        if (rule.isOnCreationRule()) {
            result.append("onCreation");
            result.append(",");
        }
        if (rule.isCopyContentRule()) {
            result.append("copyContent");
            result.append(",");
        }
        if (rule.isPasteContentRule()) {
            result.append("pasteContent");
            result.append(",");
        }
        if (rule.isDomDeletedRule()) {
            result.append("domDeleted");
            result.append(",");
        }
        if (rule.isGoNext()) {
            result.append("goNext");
            result.append(",");
        }
        if (rule.isAboutGoNext()) {
            result.append("aboutGoNext");
            result.append(",");
        }
        if (rule.isGoPrevious()) {
            result.append("goPrevious");
            result.append(",");
        }
        if (rule.isAboutGoPrevious()) {
            result.append("aboutGoPrevious");
            result.append(",");
        }
        return result.toString();
    }

    private void initializeRuleRef(int counter, SimpleType keyRefType) {
        Type ruleType = keyRefType.getReferencedKeyType();
        if (ruleType != null) {
            this.initializeRule(counter, ruleType);
        } else if (LogRegistry.getInstance().logWarnings()) {
            LogRegistry.getInstance().warn(this.getClass(), "KeyRef: " + keyRefType.getValue() + " not found.");
        }
    }

    public void release() {
        List rules = this.getRules();
        if (rules != null && this.getDOM().hasController()) {
            TypeController cont = this.getDOM().getController();
            for (int r = rules.size() - 1; r >= 0; --r) {
                Rule aRule = (Rule)rules.get(r);
                cont.removeRule(aRule);
                aRule.release();
            }
            this.removeProperty("rule");
        }
        super.release();
    }
}

