/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import [Ljava.lang.String;;
import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.ActionDefinition;
import com.jaxfront.core.rule.ActionPerformEvent;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.rule.JavaAction;
import com.jaxfront.core.rule.UIAction;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.schema.SchemaType;
import com.jaxfront.core.type.AbstractCompositeType;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.ComplexGroup;
import com.jaxfront.core.type.ComplexGroupList;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.MethodParameter;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.ui.FormlayoutDefaults;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.SimpleListEnumeration;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.TreeSort;
import com.jaxfront.core.util.io.classloader.DBClassLoader;
import com.jaxfront.core.util.sort.FastQSort;
import com.jaxfront.core.xui.AbstractXUIElement;
import com.jaxfront.core.xui.ButtonEnabling;
import com.jaxfront.core.xui.FormLayoutInfo;
import com.jaxfront.core.xui.GlobalDefinition;
import com.jaxfront.core.xui.LayoutInfo;
import com.jaxfront.core.xui.ListInfo;
import com.jaxfront.core.xui.NLS;
import com.jaxfront.core.xui.PluginBean;
import com.jaxfront.core.xui.PluginException;
import com.jaxfront.core.xui.TableCell;
import com.jaxfront.core.xui.TableInfo;
import com.jaxfront.core.xui.XMLResourceCodeSetCreator;
import com.jaxfront.core.xui.XUIDefinition;
import com.jaxfront.core.xui.XUIElementPaths;
import com.jaxfront.core.xui.XUITypes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class StyleDefinition
extends AbstractXUIElement
implements XUITypes,
XUIElementPaths {
    private static Hashtable _wrongPlugins;
    private Type _treeEntryDependsOnThisType;
    private Type _captionOccurrenceDependsOnThisType;
    private boolean _markError;
    private byte _isVisible = (byte)-1;
    private byte _isReadOnly = (byte)-1;
    private byte _isEnumeration = (byte)-1;
    public static final int COMP_SIZE_DEFAULT = -1;
    public static final int COMP_SIZE_GROW = -2;
    public static final int COMP_SIZE_COMBO_DEFAULT = -3;
    public static final int DEFAULT_SIZE_NUMBER = 10;
    public static final int DEFAULT_SIZE_STRING = 30;
    public static final int DEFAULT_SIZE_DATE = 8;
    public static final int DEFAULT_SIZE_DATETIME = 8;
    public static final int DEFAULT_SIZE_TIME = 8;
    public static final int DEFAULT_SIZE_BOOLEAN = 30;
    public static final int DEFAULT_SIZE_BOOLEAN_CHECKBOX = 10;
    public static final int DEFAULT_SIZE_CHOICE_COMBO = 30;
    private int _selectedTabIdx = -1;
    private Type _selectedTabType;
    private byte _isEditableRuntime = (byte)-1;
    private Boolean _isVisibleAtRuntime = null;
    private String _cssStyle;

    public StyleDefinition(XUIDefinition xuiDefinition, Type xuiType) {
        super(xuiDefinition, xuiType);
    }

    private StyleDefinition() {
    }

    public StyleDefinition(XUIDefinition xuiDefinition, StyleDefinition styleDefinition) {
        Vector layoutInfos;
        String[] enumeration;
        this._xuiDefinition = xuiDefinition;
        if (styleDefinition.hasProperties()) {
            this.setProperties(styleDefinition.cloneProperties());
        }
        this._cssStyle = styleDefinition._cssStyle;
        if (styleDefinition.getCodeSetClass() != null && (enumeration = this.getCodeSetValuesFromClass(styleDefinition.getCodeSetClass(), styleDefinition.getCodeSetName())) != null) {
            this.setEnumeration(enumeration);
        }
        if (styleDefinition.getTableInfo() != null) {
            TableInfo tInfo = styleDefinition.getTableInfo();
            if (!xuiDefinition.isGlobal() || xuiDefinition.isTemplate()) {
                this.setProperty("table", tInfo.copy(this.getType()));
            } else {
                try {
                    TableInfo tiClone = (TableInfo)tInfo.clone();
                    tiClone.update(this.getType());
                    this.setProperty("table", tiClone);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if ((layoutInfos = (Vector)styleDefinition.getProperty("layout")) != null) {
            Vector<LayoutInfo> clonedLayoutInfos = new Vector<LayoutInfo>();
            Iterator iter = layoutInfos.iterator();
            while (iter.hasNext()) {
                LayoutInfo tempInfo = (LayoutInfo)iter.next();
                if (tempInfo instanceof FormLayoutInfo) {
                    clonedLayoutInfos.add(((FormLayoutInfo)tempInfo).clone(this.getType()));
                    continue;
                }
                clonedLayoutInfos.add(tempInfo);
            }
            this.setProperty("layout", clonedLayoutInfos);
        }
        if (this.getType() != null && this.getType().isSimple()) {
            if (this.getLeafDefaultValue() != null) {
                this.checkSimpleDefaultValue(this.getLeafDefaultValue());
            }
            if (this.getLeafEnumerationDefaultSelection() != null) {
                this.checkSimpleDefaultValue(this.getLeafEnumerationDefaultSelection());
            }
        }
        this.initActAs(styleDefinition.getStringProperty("/XUI/component/style", "leaf/component/value/dataType"));
    }

    public void update(StyleDefinition styleDefinition) {
        if (styleDefinition.hasProperties()) {
            Enumeration styleProps = styleDefinition.getPropertyKeys();
            while (styleProps.hasMoreElements()) {
                String propKey = styleProps.nextElement().toString();
                Object propValue = styleDefinition.getProperty(propKey);
                if (propValue == null) continue;
                this.setProperty(propKey, propValue);
            }
        }
    }

    public static int getTableHeight(Type model, int defaultRowHeight) {
        int tableRows = 5;
        StyleDefinition style = model.getStyle();
        if (style.isUsingSerialList()) {
            return -1;
        }
        TableInfo tInfo = style.getTableInfo();
        SchemaNode scNode = model.getSchemaElement();
        if (tInfo != null) {
            tableRows = tInfo.getTableSize();
        } else if (scNode.getMaxOccurs() != -1 && tableRows > scNode.getMaxOccurs()) {
            tableRows = scNode.getMaxOccurs();
        }
        int offset = 0;
        if (tInfo != null && !tInfo.isPanelEditMode()) {
            defaultRowHeight += 4;
        } else {
            offset = 2;
        }
        if (tableRows == -1) {
            return tableRows;
        }
        return (tableRows + 1) * defaultRowHeight + offset;
    }

    private Hashtable getWrongPlugins() {
        if (_wrongPlugins == null) {
            _wrongPlugins = new Hashtable();
        }
        return _wrongPlugins;
    }

    public void setCaptionOccurrence(boolean hasCaption, String applyOnDescendants) {
        if (this.getStringProperty("caption/style/occurrence") == null) {
            if (hasCaption) {
                this.setProperty("caption/style/occurrence", "always");
            } else {
                this.setProperty("caption/style/occurrence", "never");
            }
            if (applyOnDescendants != null) {
                this.setCaptionOccurrenceApplyOnDescendants(applyOnDescendants);
            }
        }
    }

    public void update(Type aType) {
        if (this.getTableInfo() != null) {
            TableInfo tInfo = this.getTableInfo();
            tInfo.update(aType);
        }
    }

    public String toString() {
        Vector layoutInfos;
        StringBuffer toString = new StringBuffer();
        toString.append("XUIDef:Type" + this.getXUIDefinition().getType().getXPathLocation());
        if (this.getTableInfo() != null) {
            TableInfo tInfo = this.getTableInfo();
            toString.append(tInfo.toString());
        }
        if ((layoutInfos = (Vector)this.getProperty("layout")) != null) {
            Iterator iter = layoutInfos.iterator();
            while (iter.hasNext()) {
                LayoutInfo tempInfo = (LayoutInfo)iter.next();
                toString.append(tempInfo.toString());
            }
        }
        return toString.toString();
    }

    public boolean isRepresentedAsTreeNode() {
        boolean hasTreeEntry = false;
        Type parent = this.getType().getParent();
        if (this.isTreeEntryAlways()) {
            return true;
        }
        if (this.isTreeEntryNever()) {
            return false;
        }
        if (this.getType().hasUnChoosenChoiceParent()) {
            return false;
        }
        if (this.isTreeEntryDependingOn()) {
            block15: {
                hasTreeEntry = false;
                if (this._treeEntryDependsOnThisType == null && this.getTreeEntryDependsOnXPath() != null && this.getTreeEntryDependsOnXPath().length() > 0) {
                    try {
                        List list = TypePathExecuter.getInstance().processXPath(this.getType(), this.getTreeEntryDependsOnXPath());
                        if (list != null && list.size() > 0) {
                            this._treeEntryDependsOnThisType = (Type)list.get(0);
                        }
                    }
                    catch (Exception ex) {
                        if (!LogRegistry.getInstance().logInfos()) break block15;
                        LogRegistry.getInstance().info(this.getClass(), ex.getMessage());
                    }
                }
            }
            if (this._treeEntryDependsOnThisType != null && this._treeEntryDependsOnThisType != this.getType()) {
                hasTreeEntry = this._treeEntryDependsOnThisType.isRepresentedAsTreeNode();
            } else if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(this.getClass(), this.getXUIDefinition().getXUIXPath() + ": treeEntry dependent -> wrong xpath");
            }
            return hasTreeEntry;
        }
        Type refParent = this.getReferencedTreeOccurrenceParent(parent);
        if (refParent != null) {
            boolean isRepresendAsTreeNode = refParent.getStyle().isRepresentedAsTreeNode();
            if (refParent.getStyle().isTreeEntryApplyOnDirectDescendants() && parent == refParent) {
                this.setTreeEntry(isRepresendAsTreeNode, null);
                return isRepresendAsTreeNode;
            }
            if (refParent.getStyle().isTreeEntryApplyOnAllDescendants()) {
                this.setTreeEntry(isRepresendAsTreeNode, "allDescendants");
                return isRepresendAsTreeNode;
            }
        }
        String capType = this.getCaptionType();
        if (this.getType().isRoot() || this.getDOM().getGlobalDefinition().isDefaultTreeEntryForHeaders() && "header".equals(capType) && parent != null && parent.isRepresentedAsTreeNode() || this.getType() instanceof ComplexGroup && parent != null && parent.isList() && parent.isRepresentedAsTreeNode() || this.getType() instanceof ComplexGroupList && parent != null && parent.isRepresentedAsTreeNode()) {
            return true;
        }
        return hasTreeEntry;
    }

    private void checkPluginComponent(String pluginComponentClass) throws PluginException {
        Class<?> pluginClass = null;
        try {
            pluginClass = this.getDOM().getCustomClassloader().loadClass(pluginComponentClass);
        }
        catch (Throwable e) {
            this.getWrongPlugins().put(pluginComponentClass, pluginComponentClass);
            throw new PluginException(pluginComponentClass + " can not be found");
        }
        if (pluginClass != null && !Visualizer.class.isAssignableFrom(pluginClass)) {
            this.getWrongPlugins().put(pluginComponentClass, pluginComponentClass);
            throw new PluginException(pluginComponentClass + " does not implement Visualizer");
        }
    }

    public String[] getSchemaEnumeration() {
        SchemaNode element = this.getType().getSchemaElement();
        if (element != null && element.isSimple()) {
            return ((SchemaSimpleType)element.getSchemaType()).getChoices();
        }
        return null;
    }

    protected int getIntegerProperty(String relativePath) {
        return this.getIntProperty("/XUI/component/style", relativePath);
    }

    protected Float getFloatProperty(String relativePath) {
        return this.getFloatProperty("/XUI/component/style", relativePath);
    }

    protected boolean getBooleanProperty(String relativePath) {
        Boolean value = null;
        value = super.getBooleanProperty("/XUI/component/style", relativePath);
        if (value != null) {
            return value;
        }
        return false;
    }

    protected Boolean getBooleanPropertyAsObject(String relativePath) {
        return super.getBooleanProperty("/XUI/component/style", relativePath);
    }

    protected String getStringProperty(String relativePath) {
        return super.getStringProperty("/XUI/component/style", relativePath);
    }

    public void setBooleanVisualizerAsCheckBox() {
        this.setProperty("leaf/component/booleanVisualizer", "checkBox");
    }

    public void setBoolean3StateButton() {
        this.setProperty("leaf/component/booleanVisualizer", "threeStateButton");
    }

    public String getBooleanVisualizer() {
        String booleanVisualizerType = this.getStringProperty("leaf/component/booleanVisualizer");
        if (booleanVisualizerType == null || booleanVisualizerType.length() == 0) {
            booleanVisualizerType = this.getDOM().getGlobalDefinition().getBooleanVisualizerType();
        }
        return booleanVisualizerType;
    }

    public boolean isUsingGroupingDelimiters() {
        boolean useGrouping = this.getBooleanProperty("leaf/component/useGroupingDelimiters");
        return useGrouping;
    }

    public void setUsingGroupingDelimiters(boolean useDelims) {
        this.setBooleanProperty("leaf/component/useGroupingDelimiters", useDelims);
    }

    public String getTimeFormat() {
        String tf = this.getProperty("/XUI/component/style", "leaf/component/timeFormat", false);
        if (tf == null) {
            tf = this.getDOM().getGlobalDefinition().getTimeFormatStringPattern(null);
        }
        return tf;
    }

    public String getChildrenView() {
        return this.getStringProperty("mode/childrenView");
    }

    public String getChoiceDefaultSelection() {
        return this.getStringProperty("/XUI/component/stylechoice/defaultSelection", "choice/defaultSelection");
    }

    public Boolean isChoiceAvailable() {
        return this.getBooleanProperty("/XUI/component/style", "choice/choiceAvailable");
    }

    public String getChoiceLabel() {
        String choiceLabel = "";
        if (!this.hasCaption()) {
            choiceLabel = this.getCaptionTitleLabel();
        } else if (((CompositeType)this.getType()).hasAttributes()) {
            choiceLabel = this.getCaptionTitleLabel();
        }
        return choiceLabel;
    }

    public String getChoiceOrientation() {
        String value = null;
        value = this.getStringProperty("choice/orientation");
        if (value != null) {
            return value;
        }
        return this.getDOM().getGlobalDefinition().getGlobalChoiceOrientation();
    }

    public String getLeafMask() {
        return this.getStringProperty("leaf/component/mask/mask");
    }

    public String getLeafMaskValidChars() {
        return this.getStringProperty("leaf/component/mask/validCharacters");
    }

    public String getLeafMaskInvalidChars() {
        return this.getStringProperty("leaf/component/mask/invalidCharacters");
    }

    public String getLeafMaskPlaceHolder() {
        return this.getStringProperty("leaf/component/mask/placeHolder");
    }

    public boolean getLeafMaskAllowInvalid() {
        return this.getBooleanProperty("leaf/component/mask/allowInvalid");
    }

    public boolean getLeafMaskCommitOnValidEnd() {
        return this.getBooleanProperty("leaf/component/mask/commitOnValidEnd");
    }

    public boolean getLeafMaskOverwriteMode() {
        return this.getBooleanProperty("leaf/component/mask/overwriteMode");
    }

    public boolean isChoiceOrientationHorizontal() {
        String orient = this.getChoiceOrientation();
        if (orient != null) {
            return orient.equals("horizontal");
        }
        return false;
    }

    public boolean isEnumerationOrientationHorizontal() {
        if (this.getChoiceOrientation() != null) {
            return this.getLeafEnumerationOrientation().equals("horizontal");
        }
        return false;
    }

    public String getChoiceType() {
        String ct = this.getStringProperty("choice/type");
        if (ct != null) {
            return ct;
        }
        return this.getDOM().getGlobalDefinition().getGlobalChoiceType();
    }

    public String getCodeSetName() {
        return this.getStringProperty("leaf/component/value/enumeration/codeSet/name");
    }

    public boolean isUsingExternalEnumeration() {
        return this.getCodeSetName() != null || this.getType().getClientProperty("selection") != null || this.getType().getClientProperty("implementation") != null;
    }

    public int getCodesetEntryIdx(String value) {
        String codeSetName = this.getCodeSetName();
        Object[] choicesIds = null;
        if (codeSetName != null) {
            choicesIds = this.getDOM().getSchema().getCodeTables().getCodeItemKeys(this.getType(), codeSetName);
        } else if (this.isEnumeration()) {
            choicesIds = this.getEnumeration();
        }
        if (choicesIds != null && this.isEnumerationAsRadioButton()) {
            if (value == null) {
                value = "";
            }
            return ArrayUtil.contains(choicesIds, value);
        }
        return -1;
    }

    public void setCodeSetName(String name) {
        this.setProperty("leaf/component/value/enumeration/codeSet/name", name);
    }

    public void setShowAsLabel(boolean show) {
        this.setBooleanProperty("leaf/component/showAsLabel", show);
    }

    public boolean showAsLabel() {
        return this.getBooleanProperty("leaf/component/showAsLabel");
    }

    public String getCodeSetURL() {
        return this.getStringProperty("leaf/component/value/enumeration/codeSet/url");
    }

    public String getCodeSetXPointer() {
        return this.getStringProperty("keyFieldXPath");
    }

    public void setCodeSetURL(String codesetURL) {
        this.setProperty("leaf/component/value/enumeration/codeSet/url", codesetURL);
    }

    public String[] getCodeSetValuesFromFile(String fileURL, String codeSetName) {
        CodeTables codeTables = this.getCodeTablesFromFile(fileURL, codeSetName);
        if (codeTables != null) {
            return codeTables.getItems(true, this.getType(), codeSetName, this.getDOM().getLanguage());
        }
        return null;
    }

    public String[] getCodeSetIdsFromFile(String fileURL, String codeSetName) {
        CodeTables codeTables = this.getCodeTablesFromFile(fileURL, codeSetName);
        if (codeTables != null) {
            return codeTables.getCodeItemKeys(this.getType(), codeSetName);
        }
        return null;
    }

    public String[][] getCodeSetItemsFromFile(String fileURL, String codeSetName) {
        CodeTables codeTables = this.getCodeTablesFromFile(fileURL, codeSetName);
        if (codeTables != null) {
            return codeTables.getCodeItems(true, this.getType(), codeSetName, this.getDOM().getLanguage());
        }
        return null;
    }

    public CodeTables getCodeTablesFromFile(String fileURL, String codeSetName) {
        CodeTables codeTables = null;
        if (codeSetName != null && this.getDOM() != null && this.getDOM().getSchema() != null) {
            if (fileURL != null) {
                codeTables = this.getDOM().getSchema().getCodeTables(this.getDOM().getSchema(), fileURL, this.getDOM().getFingerPrint().getXUIURL(), this.getDOM().getFingerPrint().getEntityResolver());
                if (codeTables == null) {
                    codeTables = this.getDOM().getSchema().getCodeTables();
                }
            } else {
                codeTables = this.getDOM().getSchema().getCodeTables();
            }
        }
        return codeTables;
    }

    public void setCodeSetValuesFromFile(String fileURL, String codeSetName, String[] codes) {
        this.setCodeSetValuesFromFile(fileURL, codeSetName, codes, false, false);
    }

    public void setCodeSetValuesFromFile(String fileURL, String codeSetName, String[] codes, boolean syncWithCodeEnum, boolean valueBasedSync) {
        String codeSetLabel;
        String[][] codesArr = null;
        if (fileURL != null) {
            this.setCodeSetURL(fileURL);
        }
        if (codeSetName != null) {
            this.setCodeSetName(codeSetName);
        }
        if ((codeSetLabel = this.getDOM().getSchema().getCodeTables().getCodeSetLabel(codeSetName, this.getDOM().getLanguage())) != null) {
            this.setLabelText(codeSetLabel);
        } else {
            this.setLabelText(this.getType().getStyle().getLabelText());
        }
        if (codes != null && codes.length > 0) {
            CodeTables codeTables = this.getCodeTablesFromFile(fileURL, codeSetName);
            codesArr = codeTables.getCodeSetEntry(true, this.getType(), codeSetName, this.getDOM().getLanguage()).getSelectableEntries(codes);
        } else {
            codesArr = this.getCodeSetItemsFromFile(fileURL, codeSetName);
        }
        if (syncWithCodeEnum && this.getCodeEnumeration() != null) {
            Object[][] codeEnum = this.getCodeEnumeration();
            int keyPos = valueBasedSync ? 1 : 0;
            for (int c = 0; c < codesArr.length; ++c) {
                String key = codesArr[c][0];
                int entryIdx = ArrayUtil.contains(codeEnum, keyPos, key, true);
                if (entryIdx < 0) continue;
                codesArr[c][0] = this.getCodeEnumeration()[entryIdx][0];
            }
        }
        boolean visible = codesArr != null && codesArr.length > 0;
        MethodParameter[] params = new MethodParameter[]{new MethodParameter(this.getType(), "boolean", String.valueOf(visible)), new MethodParameter(this.getType(), "boolean", String.valueOf(visible))};
        UIAction visibleAndSerializableAction = new UIAction(this.getDOM(), this.getType(), null, null, "setVisibleAndSerializable", params, null);
        try {
            visibleAndSerializableAction.invoke(this.getDOM(), this.getType(), new Object[]{visible, visible});
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.getType().setVisibleAndSerializable(visible, visible);
        }
        this.setEnumeration(codesArr);
    }

    public void setCodeSetValuesFromFile(String fileURL, String codeSetName, String[][] codesArr) {
        String codeSetLabel;
        if (fileURL != null) {
            this.setCodeSetURL(fileURL);
        }
        if (codeSetName != null) {
            this.setCodeSetName(codeSetName);
        }
        if ((codeSetLabel = this.getDOM().getSchema().getCodeTables().getCodeSetLabel(codeSetName, this.getDOM().getLanguage())) != null) {
            this.setLabelText(codeSetLabel);
        } else {
            this.setLabelText(this.getType().getStyle().getLabelText());
        }
        boolean visible = codesArr != null && codesArr.length > 0;
        MethodParameter[] params = new MethodParameter[]{new MethodParameter(this.getType(), "boolean", String.valueOf(visible)), new MethodParameter(this.getType(), "boolean", String.valueOf(visible))};
        UIAction visibleAndSerializableAction = new UIAction(this.getDOM(), this.getType(), null, null, "setVisibleAndSerializable", params, null);
        try {
            visibleAndSerializableAction.invoke(this.getDOM(), this.getType(), new Object[]{visible, visible});
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.getType().setVisibleAndSerializable(visible, visible);
        }
        this.setEnumeration(codesArr);
    }

    public void setCodeSetValuesFromClass(String classURL, String codeSetName, String[] values) {
        if (classURL != null) {
            this.setCodeSetClass(classURL);
        }
        if (codeSetName != null) {
            this.setCodeSetName(codeSetName);
        }
        if (values != null) {
            this.setEnumeration(values);
        }
    }

    public String[] getCodeSetValuesFromClass(String classURL, String codeSetName) {
        if (classURL != null) {
            CodeTables codeTables = this.getDOM().getSchema().getCodeTables();
            if (!this.getXUIDefinition().isTemplate() && codeTables != null) {
                return codeTables.initialize(this.getType(), classURL, codeSetName);
            }
        }
        return null;
    }

    public String[][] getCodeSetItemsFromClass(String classURL, String codeSetName) {
        if (classURL != null) {
            CodeTables codeTables = this.getDOM().getSchema().getCodeTables();
            if (!this.getXUIDefinition().isTemplate() && codeTables != null) {
                return codeTables.initialize2(this.getType(), classURL, codeSetName);
            }
        }
        return null;
    }

    public String getCodeSetClass() {
        return this.getStringProperty("leaf/component/value/enumeration/codeSet/class");
    }

    public void setCodeSetClass(String className) {
        this.setProperty("leaf/component/value/enumeration/codeSet/class", className);
    }

    public String getLabelText() {
        String name = null;
        name = !this.getType().isSimple() && this.getType().isAnonymous() ? this.getType().getVisualName() : this.getType().getName();
        return this.getNLS(name, "label", null, null);
    }

    public String getPrintingLabel() {
        return this.getNLS(null, "printing", null, null);
    }

    public String getLabelChoiceText() {
        String defaultName = this.getType().getName();
        if (this.getType().getSchemaElement().isGroup()) {
            // empty if block
        }
        return this.getNLS(defaultName, "label", "choice", null);
    }

    public String getLabelToolTip() {
        return this.getNLS("label", null, "tooltip");
    }

    public String getTreeEntryToolTip() {
        return this.getNLS("treeEntry", null, "tooltip");
    }

    public String getCaptionTitleToolTip() {
        return this.getNLS("caption", null, "tooltip");
    }

    public String getPageTitle(Type pageType, int pageIndex) {
        if (this.getDOM() != null && this.getDOM().getNLS() != null) {
            return this.getDOM().getNLS().getTranslation(pageType, null, "paging", String.valueOf(pageIndex), null);
        }
        return "";
    }

    public boolean hasTreeLabelFormulaExpression() {
        return this.getStringProperty("/treeEntry/label") != null;
    }

    public Object getTreeLabelFormulaResult() {
        String formulaLabel = this.getStringProperty("/treeEntry/label");
        Object result = null;
        if (formulaLabel != null) {
            try {
                if (formulaLabel.length() > 0) {
                    formulaLabel = TextTools.replaceGlobalUserProperties(formulaLabel, this.getType().getDOM());
                }
                result = this.getDOM().getController().getMathEvaluator().evaluateObject(this.getType(), formulaLabel, false);
            }
            catch (Exception ex) {
                LogRegistry.getInstance().error(this.getClass(), "Formula wrong:" + formulaLabel + " USE\" to qualify text constants -> " + ex.getMessage());
            }
        }
        return result;
    }

    public String getTreeLabelText() {
        if (this.getType().isEmpty()) {
            return this.getType().getName();
        }
        String formulaLabel = this.getStringProperty("/treeEntry/label");
        if (formulaLabel != null) {
            Object result = this.getTreeLabelFormulaResult();
            if (result != null) {
                formulaLabel = result.toString();
            }
            if (formulaLabel == null || formulaLabel.length() < 1) {
                formulaLabel = this.getType().getName();
            }
            return formulaLabel;
        }
        return this.getNLS(this.getType().getName(), "treeEntry", null, null);
    }

    public String getCaptionTitleLabel() {
        Type aType = this.getType();
        String qname = aType.getName();
        if (this.getType().isEmpty()) {
            return qname;
        }
        if (!aType.isReleased() && aType.isAnonymous() && aType.getSchemaElement().getRefName() != null && (qname = aType.getSchemaElement().getRefName()) != null && qname.indexOf(":") != -1) {
            qname = qname.substring(qname.lastIndexOf(":") + 1, qname.length());
        }
        return this.getNLS(qname, "caption", null, null);
    }

    public String getSerialListAddLabel() {
        String name = this.getType().getName();
        return this.getNLS(name, "serial_add", null, null);
    }

    public String getDialogLabel() {
        String qname = this.getType().getName();
        if (this.getType().isEmpty()) {
            return qname;
        }
        return this.getNLS(qname, "dialog", null, null);
    }

    public String getDeletionConfirmationMessageText() {
        String messageText = null;
        String qname = this.getType().getName();
        if (this.getType().isEmpty()) {
            messageText = qname;
        }
        messageText = this.getNLS(qname, "deletionConfirmationMessage", null, null);
        return messageText;
    }

    public String getKeyContextDialogLabel() {
        String qname = this.getType().getName();
        if (this.getType().isEmpty()) {
            return qname;
        }
        return this.getNLS(qname, "contextdialog", null, null);
    }

    public boolean hasKeyRefSelectionLineInfoFE() {
        return this.getKeyRefSelectionLineInfoFE() != null;
    }

    public boolean hasKeyRefConditionFormulaExpression() {
        return this.getKeyRefConditionFE() != null;
    }

    public String getKeyRefSelectionLineInfoFE() {
        return (String)this.getProperty("/keyRefselectionLineInfo/formulaExpression");
    }

    public String getKeyRefConditionFE() {
        return (String)this.getProperty("/keyRef/condition/formulaExpression");
    }

    public String getKeyContextLocation() {
        return this.getStringProperty("/key/context/location");
    }

    public boolean hasKeyContextLocation() {
        return this.getKeyContextLocation() != null;
    }

    public float getLabelColumnWidth() {
        String path = null;
        path = this.getType().isComposite() ? "choice/labelColumnWidth" : (this.getType().isList() ? "list/labelComponent/label/columnWidth" : "leaf/label/columnWidth");
        Float colWidth = this.getFloatProperty(path);
        if (colWidth != null) {
            return colWidth.floatValue();
        }
        return this.getDOM().getGlobalDefinition().getLabelColumnWidth();
    }

    public boolean isChoiceLabelVisible() {
        return this.getBooleanProperty("choice/labelVisible");
    }

    public void setLabelColumnWidth(float width) {
        String path = this.getStartElement() + "/" + "label" + "/" + "columnWidth";
        this.setProperty(path, new Float(width));
    }

    public float getComponentColumnWidth() {
        String path = null;
        path = this.getType().isComposite() ? "choice/componentColumnWidth" : (this.getType().isList() ? "list/labelComponent/component/columnWidth" : "leaf/component/columnWidth");
        Float value = this.getFloatProperty(path);
        if (value != null) {
            return value.floatValue();
        }
        return this.getDOM().getGlobalDefinition().getComponentColumnWidth();
    }

    public void setComponentColumnWidth(float width) {
        String path = this.getStartElement() + "/" + "component" + "/" + "columnWidth";
        this.setProperty(path, new Float(width));
    }

    public float getLabelIndent() {
        Type refCaptionParent;
        String path = null;
        path = this.getType().isComposite() ? "layout/labelComponent/label/indent" : (this.getType().isList() ? "list/labelComponent/label/indent" : "leaf/label/indent");
        Float fvalue = this.getFloatProperty(path);
        if (fvalue != null) {
            return fvalue.floatValue();
        }
        if (this.getType() != null && this.getType().getParent() != null && (refCaptionParent = this.getReferencedCaptionIndentParent(this.getType().getParent(), true)) != null && refCaptionParent != this.getType()) {
            float captionIndentValue = refCaptionParent.getStyle().getCaptionIndentValue();
            boolean applyIndentOnLabel = refCaptionParent.getStyle().isCaptionIndentApplyOnLabel();
            if (applyIndentOnLabel) {
                Float nestedIndent = this.getNestedIndent(this.getType().getParent(), 1, true, true);
                captionIndentValue = nestedIndent != null ? (captionIndentValue += nestedIndent.floatValue()) : (captionIndentValue += this.getDOM().getGlobalDefinition().getGlobalNestedIndent());
                this.setLabelIndent(captionIndentValue);
                return captionIndentValue;
            }
        }
        if (this.getType() != null && (this.getType().isRoot() || this.isSelfViewHolder())) {
            float captionIndent = 0.0f;
            this.setCaptionIndentValue(captionIndent);
            return captionIndent;
        }
        if (this.getDOM().getGlobalDefinition().isGlobalApplyCaptionIndentOnLabel()) {
            float labelIndent = 0.0f;
            Float nestedIndent = this.getNestedIndent(this.getType().getParent(), 0, true, true);
            labelIndent = nestedIndent != null ? nestedIndent.floatValue() : this.getDOM().getGlobalDefinition().getGlobalNestedIndent();
            this.setLabelIndent(labelIndent);
            return labelIndent;
        }
        return this.getDOM().getGlobalDefinition().getGlobalLabelIndent();
    }

    public void setLabelIndent(float newLabelIndent) {
        String path = this.getStartElement() + "/" + "label" + "/" + "indent";
        if (this.getFloatProperty(path) == null) {
            this.setProperty(path, new Float(newLabelIndent));
        }
    }

    public String getCaptionVisibility() {
        return this.getStringProperty("caption/style/occurrence/visibility");
    }

    public boolean isUserModifiedSerialization() {
        return this.getBooleanProperty("caption/userModifiedSerialization");
    }

    public boolean isUserModifiedSerializationCollapsed() {
        boolean isBorderCollapsed = false;
        Boolean collapsed = this.getBooleanProperty("/XUI/component/style", "caption/userModifiedSerialization/@collapsed");
        isBorderCollapsed = collapsed == null ? this.getDOM().getGlobalDefinition().isUserModfiedSerializationCollapsed() : collapsed.booleanValue();
        return isBorderCollapsed;
    }

    public boolean useUserModifiedSerialization() {
        boolean result = false;
        if (this.isUserModifiedSerialization()) {
            result = true;
        } else if (!this.hasUserModfiedSerialization() && this.getDOM() != null && this.getDOM().getGlobalDefinition().isUserModfiedSerialization()) {
            result = true;
        }
        return result;
    }

    public void setUserModifiedSerializationCollapsed(boolean collapsed) {
        this.setBooleanProperty("caption/userModifiedSerialization/@collapsed", collapsed);
    }

    public boolean hasUserModfiedSerialization() {
        Boolean userSerialization = super.getBooleanProperty("/XUI/component/style", "caption/userModifiedSerialization");
        return userSerialization != null;
    }

    public boolean isCaptionOccurrenceAlways() {
        String capVis = this.getCaptionVisibility();
        return capVis != null && capVis.equals("always");
    }

    public boolean isCaptionOccurrenceNever() {
        String capVis = this.getCaptionVisibility();
        return capVis != null && capVis.equals("never");
    }

    public boolean isCaptionOccurrenceDependsOn() {
        String capVis = this.getCaptionVisibility();
        return capVis != null && capVis.equals("dependsOn");
    }

    public String getCaptionOccurrenceDependsOnXPath() {
        return this.getStringProperty("caption/style/occurrence/visibility/dependsOn/xpath");
    }

    public String getCaptionTitleID() {
        return null;
    }

    public float getCaptionIndentValue() {
        Type refCaptionParent;
        GlobalDefinition globalDef = this.getDOM().getGlobalDefinition();
        Float fval = this.getFloatProperty("caption/indent/value");
        if (fval != null) {
            return fval.floatValue();
        }
        if (this.getType() != null && this.getType().getParent() != null && (refCaptionParent = this.getReferencedCaptionIndentParent(this.getType().getParent(), true)) != null && refCaptionParent != this.getType()) {
            float captionIndentValue = refCaptionParent.getStyle().getCaptionIndentValue();
            Float nestedIndent = this.getNestedIndent(this.getType().getParent(), 1, true, true);
            captionIndentValue = nestedIndent != null ? (captionIndentValue += nestedIndent.floatValue()) : (captionIndentValue += globalDef.getGlobalNestedIndent());
            this.setCaptionIndentValue(captionIndentValue);
            return captionIndentValue;
        }
        if (this.getType() != null && (this.getType().isRoot() || this.isSelfViewHolder())) {
            float captionIndent = 0.0f;
            this.setCaptionIndentValue(captionIndent);
            return captionIndent;
        }
        if (globalDef.getGlobalNestedIndent() != 0.0f) {
            float captionIndent = 0.0f;
            Float nestedIndent = this.getNestedIndent(this.getType().getParent(), 0, true, true);
            captionIndent = nestedIndent != null ? nestedIndent.floatValue() : globalDef.getGlobalNestedIndent();
            this.setCaptionIndentValue(captionIndent);
            return captionIndent;
        }
        return globalDef.getGlobalCaptionIndent();
    }

    private Float getNestedIndent(Type parentType, int iterations, boolean isDirectParent, boolean countIteration) {
        if (parentType != null) {
            boolean applyOnAllDesc = parentType.getStyle().isCaptionIndentApplyOnAllDescendants();
            boolean applyOnDirectDesc = parentType.getStyle().isCaptionIndentApplyOnDirectDescendants();
            if (applyOnAllDesc || isDirectParent && applyOnDirectDesc) {
                Float parentIndent = parentType.getStyle().getNestedCaptionIndent();
                if (parentIndent != null) {
                    float currentIndent = parentIndent.floatValue();
                    if (currentIndent >= 1.0f) {
                        currentIndent = (float)iterations * currentIndent;
                    }
                    this.setNestedCaptionIndent(currentIndent);
                    return new Float(currentIndent);
                }
            } else {
                if (parentType instanceof ComplexGroupList || parentType.getStyle().isSelfViewHolder()) {
                    countIteration = false;
                }
                if (countIteration && parentType.getStyle().hasCaption()) {
                    ++iterations;
                }
                return this.getNestedIndent(parentType.getParent(), iterations, false, countIteration);
            }
        }
        float nestedIndent = (float)iterations * this.getDOM().getGlobalDefinition().getGlobalNestedIndent();
        return new Float(nestedIndent);
    }

    public void setCaptionIndentValue(float newCaptionIndent) {
        if (this.getFloatProperty("caption/indent/value") == null) {
            this.setProperty("caption/indent/value", new Float(newCaptionIndent));
        }
    }

    public void setNestedCaptionIndent(float newCaptionIndent) {
        this.setProperty("caption/indent/applyOnDescendants/nestedIndent", new Float(newCaptionIndent));
    }

    public String getCaptionType() {
        String captionType = null;
        String captProp = this.getStringProperty("caption/style/type");
        if (captProp != null) {
            if (captProp.equals("separator")) {
                String sepStyle = this.getProperty("/XUI/component/stylecaption/style/type/separator/style", "caption/style/type/separator/style");
                if (sepStyle != null) {
                    captionType = captProp + "_" + sepStyle;
                }
            } else {
                captionType = captProp;
            }
        } else {
            if (!this.getType().isSimple() && this.getType().getParent() != null && this.getType().getParent().getStyle().getChildrenView() != null) {
                String childrenView = this.getType().getParent().getStyle().getChildrenView();
                if (childrenView.equals("separator_classic")) {
                    captionType = "separator_classic";
                } else if (childrenView.equals("separator_modern")) {
                    captionType = "separator_modern";
                } else if (childrenView.equals("header")) {
                    captionType = "header";
                }
            }
            if (captionType == null) {
                Type aparentType = this.getType();
                if ((aparentType = this.getReferencedCaptionOccurrenceParent(aparentType.getParent())) != null) {
                    String parCapType = aparentType.getStyle().getStringProperty("caption/style/type");
                    if ("separator".equals(parCapType)) {
                        String parSepStyle = aparentType.getStyle().getStringProperty("caption/style/type/separator/style");
                        if (parSepStyle != null) {
                            captionType = parCapType + "_" + parSepStyle;
                        }
                    } else {
                        captionType = parCapType;
                    }
                }
            }
            if (captionType == null && this.getDOM().getGlobalDefinition().getGlobalCaptionType() != null) {
                captionType = this.getDOM().getGlobalDefinition().getGlobalCaptionType();
            }
        }
        return captionType;
    }

    public boolean isCaptionTypeBorder() {
        String capType = this.getCaptionType();
        return capType != null && capType.equals("border");
    }

    public boolean isInitiallyCollapsed() {
        boolean isBorderCollapsed = false;
        Boolean collapsed = this.getBooleanProperty("/XUI/component/style", "caption/style/type/collapsed");
        isBorderCollapsed = collapsed == null ? this.getDOM().getGlobalDefinition().isOptionalBorderCollapsed() : collapsed.booleanValue();
        if (isBorderCollapsed && this.expandIfContainsData() && this.getType().isComposite()) {
            isBorderCollapsed = ((CompositeType)this.getType()).hasEmptyContent(true, true);
        }
        return isBorderCollapsed;
    }

    public boolean expandIfContainsData() {
        boolean expandIfContainsData = true;
        expandIfContainsData = this.getBooleanProperty("/XUI/component/style", "caption/style/type/expandIfContainsData");
        return expandIfContainsData;
    }

    public void setInitiallyCollapsed(boolean collapsed) {
        this.setBooleanProperty("caption/style/type/collapsed", collapsed);
    }

    public void setExpandIfContainsData(boolean expand) {
        this.setBooleanProperty("caption/style/type/expandIfContainsData", expand);
    }

    public boolean isCaptionOccurrenceApplyOnAllDescendants() {
        String capAplOnDe = this.getCaptionOccurrenceApplyOnDescendants();
        if (capAplOnDe != null) {
            return capAplOnDe.equals("allDescendants");
        }
        return false;
    }

    public boolean isCaptionOccurrenceApplyOnDirectDescendants() {
        String capAplOnDe = this.getCaptionOccurrenceApplyOnDescendants();
        if (capAplOnDe != null) {
            return capAplOnDe.equals("directDescendants");
        }
        return false;
    }

    private void setCaptionOccurrenceApplyOnDescendants(String applyOnDescendants) {
        if (applyOnDescendants != null && this.getProperty("caption/style/occurrence/applyOnDescendants") == null) {
            this.setProperty("caption/style/occurrence/applyOnDescendants", applyOnDescendants);
        }
    }

    public void setComponentSize(float size) {
        this.setFloatProperty(this.getStartElement() + "/" + "component" + "/" + "size", size);
    }

    public float getComponentSize() {
        String path = this.getStartElement() + "/" + "component" + "/" + "size";
        Float compSize = this.getFloatProperty(path);
        if (compSize != null) {
            if (compSize.intValue() == -2) {
                return -1.0f;
            }
            if (compSize.intValue() == -1) {
                return this.getDefaultComponentSize();
            }
            return compSize.floatValue();
        }
        return this.getDefaultComponentSize();
    }

    private float getDefaultComponentSize() {
        int defaultLeafSize = this.getDOM().getGlobalDefinition().getLeafSize();
        switch (defaultLeafSize) {
            case -1: {
                return this.evaluateDefaultComponentSize();
            }
            case -2: {
                return -1.0f;
            }
        }
        return defaultLeafSize;
    }

    private float evaluateDefaultComponentSize() {
        float compSize = -1.0f;
        Type targetType = this.getType();
        if (targetType.isSimple()) {
            SimpleType st = (SimpleType)targetType;
            if (targetType.isKeyRef()) {
                compSize = -1.0f;
            } else if (targetType.isChoice() && (this.isEnumerationAsComboBox() || this.isEnumerationAsListBox())) {
                compSize = -3.0f;
            } else if (st.isNumber()) {
                compSize = 10.0f;
            } else if (st.isString()) {
                compSize = 30.0f;
            } else if (st.isDate()) {
                compSize = 8.0f;
            } else if (st.isTime()) {
                compSize = 8.0f;
            } else if (st.isDateTime()) {
                compSize = 8.0f;
            } else if (st.isBoolean()) {
                compSize = this.isBooleanViewCheckBox() ? 10.0f : 30.0f;
            }
        } else if (targetType.isChoice() && this.isChoiceAsComboBox()) {
            compSize = 30.0f;
        }
        return compSize;
    }

    public void setComponentIndent(float newComponentIndent) {
        String path = this.getStartElement() + "/" + "component" + "/" + "indent";
        if (this.getFloatProperty(path) == null) {
            this.setProperty(path, new Float(newComponentIndent));
        }
    }

    public float getComponentIndent() {
        Type refCaptionParent;
        String path = this.getStartElement() + "/" + "component" + "/" + "indent";
        Float compIndent = this.getFloatProperty(path);
        if (compIndent != null) {
            return compIndent.floatValue();
        }
        if (this.getType() != null && this.getType().getParent() != null && (refCaptionParent = this.getReferencedCaptionIndentParent(this.getType().getParent(), true)) != null && refCaptionParent != this.getType()) {
            float captionIndentValue = refCaptionParent.getStyle().getCaptionIndentValue();
            boolean applyIndentOnComponent = refCaptionParent.getStyle().isCaptionIndentApplyOnComponent();
            if (applyIndentOnComponent) {
                Float nestedIndent = this.getNestedIndent(this.getType().getParent(), 1, true, true);
                captionIndentValue = nestedIndent != null ? (captionIndentValue += nestedIndent.floatValue()) : (captionIndentValue += this.getDOM().getGlobalDefinition().getGlobalNestedIndent());
                this.setComponentIndent(captionIndentValue);
                return captionIndentValue;
            }
        }
        if (this.getType() != null && (this.getType().isRoot() || this.isSelfViewHolder())) {
            float captionIndent = 0.0f;
            this.setCaptionIndentValue(captionIndent);
            return captionIndent;
        }
        if (this.getDOM().getGlobalDefinition().isGlobalApplyCaptionIndentOnComponent()) {
            float componentIndent = 0.0f;
            Float nestedIndent = this.getNestedIndent(this.getType().getParent(), 0, true, true);
            componentIndent = nestedIndent != null ? nestedIndent.floatValue() : this.getDOM().getGlobalDefinition().getGlobalNestedIndent();
            this.setComponentIndent(componentIndent);
            return componentIndent;
        }
        return this.getDOM().getGlobalDefinition().getGlobalComponentIndent();
    }

    public LayoutInfo getLayoutManager() {
        return this.getLayoutManager("main");
    }

    public Vector getLayoutInfos() {
        return (Vector)this.getProperty("layout");
    }

    public void updateLayoutManager(LayoutInfo info) {
        int index = this.getLayoutInfos().indexOf(this.getLayoutManager());
        if (index != -1) {
            this.getLayoutInfos().remove(index);
            this.getLayoutInfos().add(index, info);
        }
    }

    public LayoutInfo getLayoutManager(String id) {
        Vector layoutInfos = (Vector)this.getProperty("layout");
        LayoutInfo info = null;
        if (layoutInfos != null) {
            Iterator iter = layoutInfos.iterator();
            while (iter.hasNext()) {
                LayoutInfo tempInfo = (LayoutInfo)iter.next();
                if (!(tempInfo instanceof FormLayoutInfo) || ((FormLayoutInfo)tempInfo).getId() == null || !((FormLayoutInfo)tempInfo).getId().equals(id)) continue;
                info = tempInfo;
                break;
            }
        }
        return info;
    }

    public String getMandatoryExpression() {
        return this.getStringProperty("mode/mandatoryExpression");
    }

    public int getMultiLineNumberComponent() {
        return this.getIntegerProperty("leaf/component/multiLine");
    }

    public int getMultiLineColSize() {
        return this.getIntegerProperty("leaf/component/multiLineColSize");
    }

    public int getMaxTextLength() {
        Object maxL = this.getObjectProperty("/XUI/component/style", "leaf/component/maxLength", true);
        int max = -1;
        if (maxL == null) {
            Integer maxGL = null;
            SchemaType scType = this.getType().getSchemaElement().getSchemaType();
            if (scType.isSimple()) {
                max = (int)((SchemaSimpleType)scType).getMaxLength();
            }
            if (max < 0) {
                if (this.getType().isSimple() || scType.isMixedContent()) {
                    maxGL = this.isComponentMulti() ? Integer.valueOf(this.getDOM().getGlobalDefinition().getComponentMaxLengthStringMultiLine()) : Integer.valueOf(this.getDOM().getGlobalDefinition().getComponentMaxLengthString());
                }
                if (maxGL != null) {
                    max = maxGL;
                }
            }
        } else {
            max = (Integer)maxL;
        }
        return max;
    }

    public PluginBean getPluginBean() {
        return this.getPluginBean(null);
    }

    public PluginBean getPluginBean(String rendererID) {
        return (PluginBean)this.getProperty("plugIn" + (rendererID == null ? "" : "_" + rendererID));
    }

    public String getTableModelClass() {
        TableInfo info = this.getTableInfo();
        if (info == null) {
            return "com.jaxfront.core.ui.FlipOrientationTableModel";
        }
        return info.getTableModelClass();
    }

    public String getTablePosition() {
        TableInfo info = this.getTableInfo();
        if (info == null) {
            return "north";
        }
        return info.getTablePosition();
    }

    public String getLabelIcon() {
        String path = this.getStartElement() + "/" + "label" + "/" + "icon";
        return this.getStringProperty(path);
    }

    private String getStartElement() {
        String startElement = "leaf";
        if (this.getType().isComposite()) {
            startElement = "layout/labelComponent";
        } else if (this.getType().isList()) {
            startElement = "list/labelComponent";
        }
        return startElement;
    }

    public String getLabelIconPosition() {
        String path = this.getStartElement() + "/" + "label" + "/" + "iconPosition";
        return this.getStringProperty(path);
    }

    public String getLeafLabelHRef() {
        String path = this.getStartElement() + "/" + "label" + "/" + "href";
        return this.getStringProperty(path);
    }

    public String getPagingTitleFormula() {
        return this.getStringProperty("pageTitleFormula");
    }

    public boolean isLabelIconPositionLeft() {
        String position = this.getLabelIconPosition();
        return position != null && position.equalsIgnoreCase("left");
    }

    public boolean isLabelIconPositionRight() {
        String position = this.getLabelIconPosition();
        return position != null && position.equalsIgnoreCase("right");
    }

    public boolean isLabelIconPositionTop() {
        String position = this.getLabelIconPosition();
        return position != null && position.equalsIgnoreCase("top");
    }

    public boolean isLabelIconPositionBottom() {
        String position = this.getLabelIconPosition();
        return position != null && position.equalsIgnoreCase("bottom");
    }

    public String getSplitterLayoutDefinition() {
        return (String)this.getProperty("splitter");
    }

    public boolean hasTreeIconFormula() {
        String value = this.getStringProperty("/treeEntry/icon");
        return value != null && !value.endsWith(".jpg") && !value.endsWith(".gif");
    }

    public boolean hasTreeLinkFormula() {
        String value = this.getStringProperty("/treeEntry/link");
        return value != null;
    }

    public String getTreeIcon() {
        if (this.hasTreeIconFormula()) {
            String value = this.getStringProperty("/treeEntry/icon");
            FormulaExpression formulaExpression = new FormulaExpression(this.getType(), value, false, false);
            if (formulaExpression != null) {
                try {
                    value = formulaExpression.evaluate();
                    if (value != null && value.equals("NULL")) {
                        value = null;
                    }
                }
                catch (FormulaException ex) {
                    LogRegistry.getInstance().error(this.getClass(), ex.getMessage());
                }
            }
            return value;
        }
        return this.getStringProperty("/treeEntry/icon");
    }

    public String getTreeLink() {
        if (this.hasTreeLinkFormula()) {
            String value = this.getStringProperty("/treeEntry/link");
            FormulaExpression formulaExpression = new FormulaExpression(this.getType(), value, false, false);
            if (formulaExpression != null) {
                try {
                    value = formulaExpression.evaluate();
                    if (value != null && value.equals("NULL")) {
                        value = null;
                    }
                }
                catch (FormulaException ex) {
                    LogRegistry.getInstance().error(this.getClass(), ex.getMessage());
                }
            }
            return value;
        }
        return this.getStringProperty("/treeEntry/link");
    }

    public String getTreePopUpClass() {
        return this.getStringProperty("/treeEntry/popUpClass");
    }

    public String getTreeLinkTarget() {
        return this.getStringProperty("/treeEntry/target");
    }

    public String getHeaderImageURL() {
        return this.getStringProperty("caption/style/headerImage");
    }

    public boolean hasHeaderImageURL() {
        return this.getHeaderImageURL() != null;
    }

    public boolean applyViewHolderOnDirectDescendants() {
        return this.getPrimitiveBooleanProperty("/XUI/component/styleviewHolderApplyOnDirectDescendants", "mode/viewHolderApplyOnDirectDescendants");
    }

    public String getViewHolder() {
        String viewHolder = this.getStringProperty("mode/viewHolder");
        if (viewHolder == null) {
            Type aType = this.getType();
            if (!aType.isRoot() && aType.getParent().getXUIDefinition(false) != null && aType.getParent().getXUIDefinition(false).getStyle().applyViewHolderOnDirectDescendants()) {
                viewHolder = aType.getParent().getXUIDefinition(false).getStyle().getViewHolder();
            } else {
                if (aType != null && aType.getTypeClassification() == 194) {
                    String viewHolderType = "self";
                    if (!aType.getDOM().getGlobalDefinition().isShowingTree() || !aType.isRepresentedAsTreeNode()) {
                        viewHolderType = "parent";
                    }
                    return viewHolderType;
                }
                return "parent";
            }
        }
        return viewHolder;
    }

    public boolean hasHeader() {
        return this.getTableInfo() != null;
    }

    protected void initialize() {
        if (this.getDOM().isImmutable()) {
            return;
        }
        Iterator iterator = ((CompositeType)this._xuiType).getComposites().iterator();
        while (iterator.hasNext()) {
            Type styleEntry = (Type)iterator.next();
            String styleEntryName = styleEntry.getName();
            if (styleEntry == null) continue;
            if (styleEntryName.equals("plugIn")) {
                this.initializePlugins(styleEntry);
                continue;
            }
            if (styleEntryName.equals("mode")) {
                this.initializeGroup(styleEntry);
                continue;
            }
            if (styleEntryName.equals("choice")) {
                this.initializeGroup(styleEntry);
                continue;
            }
            if (styleEntryName.equals("caption")) {
                this.initializeCaption(styleEntry);
                continue;
            }
            if (styleEntryName.equals("treeEntry")) {
                this.initializeTreeEntry(styleEntry);
                continue;
            }
            if (styleEntryName.equals("key")) {
                this.initializeKey(styleEntry);
                continue;
            }
            if (styleEntryName.equals("keyRef")) {
                this.initializeKeyRef(styleEntry);
                continue;
            }
            if (styleEntryName.equals("help")) {
                this.initializeHelp(styleEntry);
                continue;
            }
            if (styleEntryName.equals("list")) {
                Type userActionComps;
                if (this.getType() == null || this.getType().isRoot() || this.getType().isList()) {
                    this.initializeList(styleEntry);
                }
                if ((userActionComps = styleEntry.getDirectChild("userActions")) == null) continue;
                List userActionsTypeDef = (List)((Object)userActionComps.getDirectChild("action"));
                ArrayList<ActionDefinition> actionDefs = new ArrayList<ActionDefinition>(userActionsTypeDef.size());
                if (userActionsTypeDef == null || userActionsTypeDef.size() <= 0) continue;
                for (int i = 0; i < userActionsTypeDef.size(); ++i) {
                    Type aAction = (Type)userActionsTypeDef.get(i);
                    actionDefs.add(JavaAction.createActionDefinition(aAction, this.getDOM().getCustomClassloader()));
                }
                this.setProperty("userActions", actionDefs);
                continue;
            }
            if (styleEntryName.equals("leaf")) {
                this.initializeLeaf(styleEntry);
                continue;
            }
            if (styleEntryName.equals("printing")) {
                this.initializeGroup(styleEntry);
                ListType lineInfoType = (ListType)styleEntry.getDirectChild("lineInfo");
                if (lineInfoType.size() <= 0) continue;
                List lineInfos = lineInfoType.getList();
                TableInfo tableInfo = new TableInfo((ListType)this.getType());
                tableInfo.initializeLineInfos(this.getType(), lineInfos);
                this.setProperty("table_pdf", tableInfo);
                continue;
            }
            if (styleEntryName.equals("layout")) {
                Type tableLayoutType = styleEntry.getDirectChild("UNNAMED1").getChoosenType();
                if (tableLayoutType == null) continue;
                if (tableLayoutType.getName().equals("table") || tableLayoutType.getName().equals("paging")) {
                    String hidePageNav;
                    String tableStyle;
                    this.initializeTableLayoutVector(tableLayoutType);
                    String useCebraS = styleEntry.getDirectChildValue("useZebra");
                    if (useCebraS != null) {
                        boolean useZebra = Boolean.parseBoolean(useCebraS);
                        this.setUseTableLayoutZebra(useZebra);
                        if (useZebra) {
                            String evenStyle;
                            String oddStyle = styleEntry.getDirectChildValue("oddCssStyle");
                            if (oddStyle != null) {
                                this.setProperty("oddCssStyle", oddStyle);
                            }
                            if ((evenStyle = styleEntry.getDirectChildValue("evenCssStyle")) != null) {
                                this.setProperty("evenCssStyle", evenStyle);
                            }
                        }
                    }
                    if ((tableStyle = styleEntry.getDirectChildValue("cssStyle")) != null) {
                        this.setProperty("cssStyle", tableStyle);
                    }
                    if (!tableLayoutType.getName().equals("paging")) continue;
                    String restrictivePaging = styleEntry.getDirectChildValue("useRestrictivePaging");
                    if (restrictivePaging != null) {
                        this.setUseRestrictivePaging(Boolean.parseBoolean(restrictivePaging));
                    }
                    if ((hidePageNav = styleEntry.getDirectChildValue("hidePageNavigation")) == null) continue;
                    this.setHidePageNavigation(Boolean.parseBoolean(hidePageNav));
                    continue;
                }
                if (!tableLayoutType.getName().equals("splitter")) continue;
                this.initSplitterLayout(tableLayoutType);
                continue;
            }
            if (!styleEntryName.equals("cssStyle")) continue;
            this._cssStyle = ((SimpleType)styleEntry).getPlainValue();
        }
    }

    public boolean isUseTableLayoutZebra() {
        Boolean use = this.getBooleanProperty("", "useZebra");
        if (use != null) {
            return use;
        }
        return false;
    }

    public void setUseTableLayoutZebra(boolean use) {
        this.setBooleanProperty("useZebra", use);
    }

    public String getTableLayoutOddStyle() {
        return this.getStringProperty("oddCssStyle");
    }

    public String getTableLayoutEvenStyle() {
        return this.getStringProperty("evenCssStyle");
    }

    public String getTableLayoutStyle() {
        return this.getStringProperty("cssStyle");
    }

    public void setTableLayoutOddStyle(String cssParam) {
        this.setProperty("oddCssStyle", cssParam);
    }

    public void setTableLayoutEvenStyle(String cssParam) {
        this.setProperty("evenCssStyle", cssParam);
    }

    public void setTableLayoutStyle(String cssParam) {
        this.setProperty("cssStyle", cssParam);
    }

    public boolean hidePageNavigation() {
        Boolean hide = this.getBooleanProperty("", "hidePageNavigation");
        if (hide != null) {
            return hide;
        }
        return false;
    }

    public void setHidePageNavigation(boolean hide) {
        this.setBooleanProperty("hidePageNavigation", hide);
    }

    public boolean isUsingRestrictivePaging() {
        return this.getBooleanProperty("", "useRestrictivePaging");
    }

    public void setUseRestrictivePaging(boolean use) {
        this.setBooleanProperty("useRestrictivePaging", use);
    }

    private void initSplitterLayout(Type tableLayoutType) {
        Type spType = tableLayoutType.getDirectChild("splitPanel");
        this.setProperty("splitter", spType.serialize().toString());
        Vector targets = new Vector();
        DOMHelper.getAllChilds(spType, "target", null, targets);
        for (int t = 0; t < targets.size(); ++t) {
            Type refType;
            String xpath = ((SimpleType)targets.get(t)).getPlainValue();
            if (xpath == null || (refType = TypePathExecuter.getInstance().getTypeForXPath(this.getType(), xpath, false, true)) == null) continue;
            refType.setViewContextType(this.getType());
        }
    }

    public List getUserListActions() {
        return (List)this.getProperty("userActions");
    }

    private void initializeHelp(Type helpType) {
        String helpText;
        if (helpType != null && (helpText = helpType.getDirectChildValue("id")) != null) {
            this.setProperty("/help", helpText);
        }
    }

    public String getHelpText(String language) {
        return this.getNLS("help", null, null);
    }

    public String getHelpURL() {
        return this.getStringProperty("/help");
    }

    public String getHelpText() {
        String helpText = null;
        if (this.getDOM() != null && this.getDOM().getLanguage() != null) {
            helpText = this.getHelpText(this.getDOM().getLanguage());
        }
        if (helpText == null && this.getDOM().getGlobalDefinition().isUsingAnnotationHelp()) {
            helpText = DOMHelper.getAnnotation(this.getType());
        }
        return helpText;
    }

    private void initializePlugins(Type bean) {
        int pSize = ((ListType)bean).size();
        if (pSize > 0) {
            List plugins = ((ListType)bean).getList();
            for (int i = 0; i < pSize; ++i) {
                this.initializePlugin((Type)plugins.get(i));
            }
        }
    }

    private void initializePlugin(Type bean) {
        String plugInClassName = bean.getDirectChildValue("class");
        String rendererID = bean.getDirectChildValue("renderer");
        if (plugInClassName != null) {
            plugInClassName = plugInClassName.trim();
        }
        if (plugInClassName != null && plugInClassName.length() > 0 && this.getWrongPlugins().get(plugInClassName) == null) {
            block5: {
                try {
                    this.checkPluginComponent(plugInClassName);
                }
                catch (PluginException e) {
                    if (!LogRegistry.getInstance().logWarnings()) break block5;
                    LogRegistry.getInstance().warn(this.getClass(), "Not possible to register plugin=" + plugInClassName);
                    LogRegistry.getInstance().warn(this.getClass(), e.getMessage());
                }
            }
            ListType paramList = (ListType)bean.getDirectChild("param");
            MethodParameter[] methodParamters = new MethodParameter[paramList.size()];
            int paramCounter = 0;
            for (int p = 0; p < paramList.size(); ++p) {
                MethodParameter methodParamter;
                Type param = (Type)paramList.get(p);
                if (param == null) continue;
                String attrType = param.getDirectChildValue("type");
                String value = param.getDirectChildValue("value");
                methodParamters[paramCounter] = methodParamter = new MethodParameter(this.getType(), attrType, value);
                ++paramCounter;
            }
            PluginBean pluginBean = new PluginBean(plugInClassName, methodParamters);
            this.setPluginBean(pluginBean, rendererID);
        }
    }

    public String getLeafDefaultValue() {
        return this.getProperty("/XUI/component/styleleaf/component/value/singleValue/defaultValue", "leaf/component/value/singleValue/defaultValue");
    }

    public boolean isLeafComponentHRef() {
        return this.getBooleanProperty("leaf/component/href");
    }

    public String getLeafEnumerationDefaultSelection() {
        return this.getProperty("/XUI/component/styleleaf/component/value/enumeration", "leaf/component/value/enumeration/defaultSelection");
    }

    public void setLeafEnumerationDefaultSelection(String defaultSelection) {
        this.setProperty("leaf/component/value/enumeration/defaultSelection", defaultSelection);
    }

    public String getLeafEnumerationType() {
        String leafEnum = this.getStringProperty("leaf/component/value/enumeration/type");
        if (leafEnum != null) {
            return leafEnum;
        }
        return this.getDOM().getGlobalDefinition().getGlobalEnumerationType();
    }

    public String getLeafEnumerationOrientation() {
        String leafEnumOrient = this.getStringProperty("leaf/component/value/enumeration/orientation");
        if (leafEnumOrient != null) {
            return leafEnumOrient;
        }
        return this.getDOM().getGlobalDefinition().getGlobalEnumerationOrientation();
    }

    private void initializeLeaf(Type leafType) {
        Type componentType = leafType.getDirectChild("component");
        if (componentType != null) {
            Type choosenValueType;
            Type valueType = componentType.getDirectChild("value");
            if (valueType != null && (choosenValueType = valueType.getChoosenType()) != null) {
                String choosenName = choosenValueType.getName();
                if (choosenName.equals("enumeration")) {
                    String sort = choosenValueType.getDirectChildValue("sort");
                    if (sort != null) {
                        this.setProperty("sort", sort);
                    }
                    this.setBooleanProperty("isEnumerationType", true);
                    Type enumerationType = choosenValueType;
                    if (enumerationType != null) {
                        Type selectionType = enumerationType.getDirectChild("selection");
                        Type codeSetType = enumerationType.getDirectChild("codeSet");
                        Type xmlResourceType = enumerationType.getDirectChild("xmlResource");
                        Type simpleListImplType = enumerationType.getDirectChild("implementation");
                        Type choosenType = enumerationType.getChoosenType();
                        if (selectionType != null && choosenType == selectionType) {
                            List selectionList = ((ListType)selectionType).getList();
                            if (selectionList != null && selectionList.size() > 0) {
                                this.getType().putClientProperty("selection", "selection");
                                String[] enumeration = new String[selectionList.size()];
                                for (int i = 0; i < selectionList.size(); ++i) {
                                    Type currentSelection = (Type)selectionList.get(i);
                                    enumeration[i] = ((SimpleType)currentSelection).getValue();
                                }
                                this.setEnumeration(enumeration);
                            }
                        } else if (codeSetType != null && choosenType == codeSetType) {
                            String[][] enumeration = this.initializeCodeSet(codeSetType);
                            this.setEnumeration(enumeration);
                        } else if (xmlResourceType != null && choosenType == xmlResourceType) {
                            String[][] enumeration = this.initializeXmlResource2(xmlResourceType);
                            this.setEnumeration(enumeration);
                        } else if (simpleListImplType != null && choosenType == simpleListImplType) {
                            String[][] enumeration = this.initializeSimpleListImplementation(simpleListImplType);
                            this.setEnumeration(enumeration);
                        }
                        this.initializeFor("leaf/component/value", (CompositeType)choosenValueType, true);
                    }
                } else {
                    this.initializeFor("leaf/component/value", (CompositeType)choosenValueType, true);
                }
            }
            valueType = leafType.getDirectChild("label");
            this.initializeFor("leaf", (CompositeType)valueType, true);
            this.initializeFor("leaf", (CompositeType)componentType, true);
        }
        if (this.getType().isSimple()) {
            this.initActAs(this.getActAs());
        }
        if (this.getType() != null && this.getType().isSimple()) {
            if (this.getLeafDefaultValue() != null) {
                this.checkSimpleDefaultValue(this.getLeafDefaultValue());
            }
            if (this.getLeafEnumerationDefaultSelection() != null) {
                this.checkSimpleDefaultValue(this.getLeafEnumerationDefaultSelection());
            }
        }
    }

    private String[][] initializeSimpleListImplementation(Type type) {
        String[][] list = null;
        String className = type.getDirectChildValue("class");
        Class listClass = DBClassLoader.getInstance().findClass(className);
        if (listClass != null) {
            try {
                this.getType().putClientProperty("implementation", className);
                IntroSpectionHelper.getInstance();
                SimpleListEnumeration listEnumeration = (SimpleListEnumeration)IntroSpectionHelper.createObject(className, IntroSpectionHelper.getMethodParameters(type));
                list = listEnumeration.getList(this.getType());
                String defaultSelection = listEnumeration.getDefault(this.getType());
                if (defaultSelection != null) {
                    this.setLeafEnumerationDefaultSelection(defaultSelection);
                }
            }
            catch (Throwable t) {
                LogRegistry.getInstance().warn(this.getClass(), "Unable to instantiate class: " + className);
            }
        }
        return list;
    }

    public boolean isUsingTab() {
        return this.isUsingTabList() || this.isTabHolder();
    }

    protected void initActAs(String actAs) {
        if (actAs != null) {
            SimpleType simpModel = (SimpleType)this.getType();
            if (actAs.equals("integer")) {
                simpModel.actAsInteger();
            } else if (actAs.equals("date")) {
                simpModel.actAsDate();
            } else if (actAs.equals("time")) {
                simpModel.actAsTime();
            } else if (actAs.equals("dateTime")) {
                simpModel.actAsDateTime();
            } else if (actAs.equals("color")) {
                simpModel.actAsColor();
            } else if (actAs.equals("double")) {
                simpModel.actAsDouble();
            } else if (actAs.equals("boolean")) {
                simpModel.actAsBoolean();
            } else if (actAs.equals("password")) {
                simpModel.actAsPassword();
            } else if (actAs.equals("html")) {
                simpModel.actAsHTML();
            }
        }
    }

    private void checkSimpleDefaultValue(String xuiValue) {
        SimpleType st = (SimpleType)this.getType();
        String value = st.getValue();
        String schemaDefaultValue = st.getDefaultValue();
        if (value != null && schemaDefaultValue != null && value.equals(schemaDefaultValue)) {
            st.setValue(xuiValue);
        }
    }

    private void initializeTreeEntry(Type list) {
        String labelValue = list.getDirectChildValue("label");
        String showSearch = list.getDirectChildValue("showSearch");
        String treeIconValue = list.getDirectChildValue("icon");
        String treeLinkValue = list.getDirectChildValue("link");
        String treePopUpClassValue = list.getDirectChildValue("popUpClass");
        Type treeEntryOccurrenceType = list.getDirectChild("occurrence");
        if (labelValue != null) {
            this.setProperty("/treeEntry/label", labelValue);
        }
        if (treeIconValue != null) {
            this.setProperty("/treeEntry/icon", treeIconValue);
        }
        if (treeLinkValue != null) {
            this.setProperty("/treeEntry/link", treeLinkValue);
        }
        if (treePopUpClassValue != null) {
            this.setProperty("/treeEntry/popUpClass", treePopUpClassValue);
        }
        if (showSearch != null) {
            boolean value = Boolean.valueOf(showSearch);
            this.setBooleanProperty("/treeEntry/showSearch", value);
        }
        if (treeEntryOccurrenceType != null) {
            Type choosenApplyOnDescType;
            Type applyOnDescType;
            Type choosenVisibilityType;
            Type visibilityType;
            String isShowChildsAsOptional;
            String isShowAsOptional;
            String isFocusable = treeEntryOccurrenceType.getDirectChildValue("isFocusable");
            if (isFocusable != null) {
                boolean value = Boolean.valueOf(isFocusable);
                this.setBooleanProperty("/treeEntry/occurrence/isFocusable", value);
            }
            if ((isShowAsOptional = treeEntryOccurrenceType.getDirectChildValue("showAsOptional")) != null) {
                boolean value = Boolean.valueOf(isShowAsOptional);
                this.setBooleanProperty("/treeEntry/occurrence/showAsOptional", value);
            }
            if ((isShowChildsAsOptional = treeEntryOccurrenceType.getDirectChildValue("showChildrenAsOptional")) != null) {
                boolean value = Boolean.valueOf(isShowChildsAsOptional);
                this.setBooleanProperty("/treeEntry/occurrence/showChildrenAsOptional", value);
            }
            if ((visibilityType = treeEntryOccurrenceType.getDirectChild("visibility")) != null && (choosenVisibilityType = visibilityType.getChoosenType()) != null) {
                String choosenTypeName = choosenVisibilityType.getName();
                if (choosenTypeName.equals("always")) {
                    this.setProperty("/treeEntry/occurrence/visibility", "always");
                } else if (choosenTypeName.equals("never")) {
                    this.setProperty("/treeEntry/occurrence/visibility", "never");
                } else if (choosenTypeName.equals("dependsOn")) {
                    this.setProperty("/treeEntry/occurrence/visibility", "dependsOn");
                    if (choosenVisibilityType.getDirectChildValue("xpath") != null) {
                        this.setProperty("/treeEntry/occurrence/visibility/dependsOn", choosenVisibilityType.getDirectChildValue("xpath"));
                    }
                }
            }
            if ((applyOnDescType = treeEntryOccurrenceType.getDirectChild("applyOnDescendants")) != null && (choosenApplyOnDescType = applyOnDescType.getChoosenType()) != null) {
                String choosenTypeName = choosenApplyOnDescType.getName();
                if (choosenTypeName.equals("directDescendants")) {
                    this.setProperty("/treeEntry/occurrence/applyOnDescendants", "directDescendants");
                } else if (choosenTypeName.equals("allDescendants")) {
                    this.setProperty("/treeEntry/occurrence/applyOnDescendants", "allDescendants");
                }
            }
        }
    }

    private void initializeGroup(Type type) {
        this.initializeFor((CompositeType)type);
    }

    private void initializeKeyRef(Type keyRefType) {
        SimpleType formExType;
        Type keyRefSelectionLIType;
        SimpleType formExType2;
        Type keyRefConditionType = keyRefType.getChild("condition");
        if (keyRefConditionType != null && (formExType2 = (SimpleType)keyRefConditionType.getChild("formulaExpression")) != null && formExType2.getValue() != null) {
            this.setProperty("/keyRef/condition/formulaExpression", formExType2.getValue());
        }
        if ((keyRefSelectionLIType = keyRefType.getChild("selectionLineInfo")) != null && (formExType = (SimpleType)keyRefSelectionLIType.getChild("formulaExpression")) != null && formExType.getValue() != null) {
            this.setProperty("/keyRefselectionLineInfo/formulaExpression", formExType.getValue());
        }
    }

    private void initializeKey(Type keyType) {
        Type contextDialogType;
        Type dialogButtonSequenceType;
        String dialogButtonSequence;
        String value;
        Type contextLocationType = keyType.getChild("location");
        if (contextLocationType != null && contextLocationType.isSimple() && (value = ((SimpleType)contextLocationType).getValue()) != null) {
            this.setProperty("/key/context/location", value);
        }
        if ((dialogButtonSequence = ((SimpleType)(dialogButtonSequenceType = (contextDialogType = keyType.getChild("dialog")).getChild("dialogButtonSequence"))).getValue()) != null && dialogButtonSequence.length() > 0) {
            this.setProperty("/key/context/dialog/dialogButtonSequence", dialogButtonSequence);
        }
    }

    public String getContextDialogBounds() {
        return this.getStringProperty("/key/context/dialog/dialogLocation");
    }

    public Point getContextDialogLocation() {
        StringTokenizer tokenizer;
        String dialogBounds = this.getContextDialogBounds();
        int xDialogPosition = 0;
        int yDialogPosition = 0;
        int dialogWidth = -1;
        int dialogHeight = -1;
        if (dialogBounds != null && dialogBounds.length() > 0 && (tokenizer = new StringTokenizer(dialogBounds, ",")).hasMoreTokens()) {
            xDialogPosition = Integer.parseInt(tokenizer.nextToken());
            if (tokenizer.hasMoreTokens()) {
                yDialogPosition = Integer.parseInt(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    dialogWidth = Integer.parseInt(tokenizer.nextToken());
                    if (tokenizer.hasMoreTokens()) {
                        dialogHeight = Integer.parseInt(tokenizer.nextToken());
                    }
                }
            }
        }
        return new Point(xDialogPosition, yDialogPosition);
    }

    public Dimension getContextDialogSize() {
        StringTokenizer tokenizer;
        String dialogBounds = this.getContextDialogBounds();
        int xDialogPosition = 0;
        int yDialogPosition = 0;
        int dialogWidth = -1;
        int dialogHeight = -1;
        if (dialogBounds != null && dialogBounds.length() > 0 && (tokenizer = new StringTokenizer(dialogBounds, ",")).hasMoreTokens()) {
            xDialogPosition = Integer.parseInt(tokenizer.nextToken());
            if (tokenizer.hasMoreTokens()) {
                yDialogPosition = Integer.parseInt(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    dialogWidth = Integer.parseInt(tokenizer.nextToken());
                    if (tokenizer.hasMoreTokens()) {
                        dialogHeight = Integer.parseInt(tokenizer.nextToken());
                    }
                }
            }
        }
        return new Dimension(dialogWidth, dialogHeight);
    }

    public String getContextDialogButtonSequence() {
        String okButtonPositionPath = "/key/context/dialog/dialogButtonSequence";
        return this.getStringProperty(okButtonPositionPath);
    }

    private void initializeCaption(Type captionType) {
        Type captionIndentType;
        Type captionUserSerType;
        Type captionStyleType = captionType.getDirectChild("style");
        if (captionStyleType != null) {
            Type captionTypeType;
            Type captionOccurrenceType;
            String allowCopyPaste;
            String value = captionStyleType.getDirectChildValue("headerImage");
            if (value != null) {
                this.setProperty("caption/style/headerImage", value);
            }
            if ((allowCopyPaste = captionStyleType.getDirectChildValue("allowCopyPaste")) != null) {
                this.setProperty("caption/style/allowCopyPaste", Boolean.valueOf(allowCopyPaste));
            }
            if ((captionOccurrenceType = captionStyleType.getDirectChild("occurrence")) != null) {
                Type choosenApplyOnDescType;
                Type applyOnDescType;
                Type choosenType;
                Type visibilityType = captionOccurrenceType.getDirectChild("visibility");
                if (visibilityType != null && (choosenType = visibilityType.getChoosenType()) != null) {
                    String choosenTypeName = choosenType.getName();
                    if (choosenTypeName.equals("always")) {
                        this.setProperty("caption/style/occurrence/visibility", "always");
                    } else if (choosenTypeName.equals("never")) {
                        this.setProperty("caption/style/occurrence/visibility", "never");
                    } else if (choosenTypeName.equals("dependsOn")) {
                        this.setProperty("caption/style/occurrence/visibility", "dependsOn");
                        if (choosenType.getDirectChildValue("xpath") != null) {
                            String relPath = "caption/style/occurrence/visibility/dependsOn";
                            this.setProperty(relPath, choosenType.getDirectChildValue("xpath"));
                        }
                    }
                }
                if ((applyOnDescType = captionOccurrenceType.getDirectChild("applyOnDescendants")) != null && (choosenApplyOnDescType = applyOnDescType.getChoosenType()) != null) {
                    String choosenTypeName = choosenApplyOnDescType.getName();
                    if (choosenTypeName.equals("directDescendants")) {
                        this.setProperty("caption/style/occurrence/applyOnDescendants", "directDescendants");
                    } else if (choosenTypeName.equals("allDescendants")) {
                        this.setProperty("caption/style/occurrence/applyOnDescendants", "allDescendants");
                    }
                }
            }
            if ((captionTypeType = captionStyleType.getDirectChild("type")) != null) {
                String choosenCaptionTypeName;
                String expand;
                Type expandType;
                String isCollapsed;
                Type choosenCaptionType = captionTypeType.getChoosenType();
                Type collapsedType = captionTypeType.getDirectChild("collapsed");
                if (collapsedType != null && (isCollapsed = ((SimpleType)collapsedType).getValue()) != null) {
                    this.setInitiallyCollapsed(Boolean.valueOf(isCollapsed));
                }
                if ((expandType = captionTypeType.getDirectChild("expandIfContainsData")) != null && (expand = ((SimpleType)expandType).getValue()) != null) {
                    this.setExpandIfContainsData(Boolean.valueOf(expand));
                }
                if (choosenCaptionType != null && (choosenCaptionTypeName = choosenCaptionType.getName()) != null) {
                    String separatorStyle;
                    this.setProperty("caption/style/type", choosenCaptionTypeName);
                    if (choosenCaptionTypeName.equals("separator") && (separatorStyle = choosenCaptionType.getDirectChildValue("style")) != null) {
                        this.setProperty("caption/style/type/separator/style", separatorStyle);
                    }
                }
            }
        }
        if ((captionUserSerType = captionType.getDirectChild("userModifiedSerialization")) != null) {
            String value = captionUserSerType.getDirectChildValue("text()");
            if (value != null && value.length() > 0) {
                this.setBooleanProperty("caption/userModifiedSerialization", new Boolean(value));
            }
            if ((value = captionUserSerType.getDirectChildValue("collapsed")) != null && value.length() > 0) {
                this.setBooleanProperty("caption/userModifiedSerialization/@collapsed", new Boolean(value));
            }
        }
        if ((captionIndentType = captionType.getDirectChild("indent")) != null) {
            Type choosenDescendantType;
            Type applyOnDescendantsType;
            String indentValue = captionIndentType.getDirectChildValue("value");
            if (indentValue != null) {
                this.setProperty("caption/indent/value", new Float(indentValue));
            }
            if ((applyOnDescendantsType = captionIndentType.getDirectChild("applyOnDescendants")) != null && (choosenDescendantType = applyOnDescendantsType.getChoosenType()) != null) {
                String applyCaptionOn;
                String nestedIndent;
                String choosenName = choosenDescendantType.getName();
                if (choosenName != null) {
                    this.setProperty("caption/indent/applyOnDescendants", choosenName);
                }
                if ((nestedIndent = choosenDescendantType.getDirectChildValue("nestedIndent")) != null) {
                    this.setProperty("caption/indent/applyOnDescendants/nestedIndent", new Float(nestedIndent));
                }
                if ((applyCaptionOn = choosenDescendantType.getDirectChildValue("applyCaptionIndentOn")) != null) {
                    this.setProperty("caption/indent/applyOnDescendants/applyCaptionIndentOn", applyCaptionOn);
                }
            }
        }
    }

    public Float getNestedCaptionIndent() {
        return this.getFloatProperty("caption/indent/applyOnDescendants/nestedIndent");
    }

    private String getCaptionIndentApplyOnDescendants() {
        return this.getStringProperty("caption/indent/applyOnDescendants");
    }

    private String getCaptionOccurrenceApplyOnDescendants() {
        return this.getStringProperty("caption/style/occurrence/applyOnDescendants");
    }

    public boolean isCaptionIndentApplyOnDirectDescendants() {
        String applOnDesc = this.getCaptionIndentApplyOnDescendants();
        return applOnDesc != null && applOnDesc.equals("directDescendants");
    }

    public boolean isCaptionIndentApplyOnAllDescendants() {
        String applOnDesc = this.getCaptionIndentApplyOnDescendants();
        return applOnDesc != null && applOnDesc.equals("allDescendants");
    }

    private String getCaptionIndentApplyOnType() {
        return this.getStringProperty("caption/indent/applyOnDescendants/applyCaptionIndentOn");
    }

    public boolean isCaptionIndentApplyOnLabel() {
        String applOnType = this.getCaptionIndentApplyOnType();
        if (applOnType != null) {
            if (applOnType.equals("label")) {
                return true;
            }
            return this.isCaptionIndentApplyOnBoth();
        }
        return false;
    }

    public boolean isCaptionIndentApplyOnComponent() {
        String applOnType = this.getCaptionIndentApplyOnType();
        if (applOnType != null) {
            if (applOnType.equals("component")) {
                return true;
            }
            return this.isCaptionIndentApplyOnBoth();
        }
        return false;
    }

    public boolean isCaptionIndentApplyOnBoth() {
        String applOnType = this.getCaptionIndentApplyOnType();
        return applOnType != null && applOnType.equals("both");
    }

    private FormLayoutInfo initializeTableLayout(Type layoutType) {
        FormLayoutInfo tableLayout = new FormLayoutInfo();
        String isOptional = layoutType.getDirectChildValue("optional");
        if (isOptional == null) {
            isOptional = layoutType.getDirectChild("optional").getSchemaElement().getDefaultValue();
        }
        tableLayout.setIsOptional(Boolean.valueOf(isOptional));
        String id = layoutType.getDirectChildValue("id");
        if (layoutType.getName().equals("table")) {
            id = "main";
        } else if (layoutType.getName().equals("paging")) {
            id = "page";
        }
        if (id == null) {
            id = layoutType.getDirectChild("id").getSchemaElement().getDefaultValue();
        }
        tableLayout.setId(id);
        ListType rowsType = (ListType)layoutType.getDirectChild("row");
        List rows = rowsType.getList();
        String[] rowCSS = new String[rows.size()];
        for (int r = 0; r < rows.size(); ++r) {
            int pos;
            Type rowGroupType = (Type)rows.get(r);
            String value = rowGroupType.getDirectChildValue("text()");
            rowCSS[r] = rowGroupType.getDirectChildValue("cssStyle");
            FormlayoutDefaults.buildRowDefsRespectingDefaults(value);
            if (value != null && (pos = value.indexOf(44)) != -1) {
                value = value.substring(0, pos);
            }
            if (value == null || value.equals("")) {
                value = FormlayoutDefaults.getInstance().getDefaultRowHeightAsString();
            }
            tableLayout.addRow(new Double(value));
        }
        tableLayout.setRowCSS(rowCSS);
        ListType columnsType = (ListType)layoutType.getDirectChild("column");
        List columns = columnsType.getList();
        String[] colCSS = new String[columns.size()];
        for (int c = 0; c < columns.size(); ++c) {
            int pos;
            Type columnGroupType = (Type)columns.get(c);
            String value = columnGroupType.getDirectChildValue("text()");
            colCSS[c] = columnGroupType.getDirectChildValue("cssStyle");
            FormlayoutDefaults.buildColDefsRespectingDefaults(value);
            if (value != null && (pos = value.indexOf(44)) != -1) {
                value = value.substring(0, pos);
            }
            if (value == null || value.equals("")) {
                value = FormlayoutDefaults.getInstance().getDefaultColWidthAsString();
            }
            tableLayout.addColumn(new Double(value));
        }
        tableLayout.setColCSS(colCSS);
        ListType cellsType = (ListType)layoutType.getDirectChild("cell");
        Iterator cells = cellsType.getList().iterator();
        while (cells.hasNext()) {
            Type cell = (Type)cells.next();
            TableCell tableCell = new TableCell(this.getType(), cell.getDirectChild("type").getChoosenType(), cell.getDirectChildValue("dimension"), this.getXUIDefinition().isGlobal());
            this.registerNestedDialog(tableCell);
            tableLayout.addCell(tableCell);
        }
        return tableLayout;
    }

    public void registerNestedDialog(TableCell cell) {
        if (cell.isLabel() || cell.isXPathLabel()) {
            int startIndex;
            String value = null;
            String labelType = cell.getLabelType();
            if (labelType.equals("label") || labelType.equals("text")) {
                if (cell.hasFormula()) {
                    try {
                        value = cell.getFormula().evaluate();
                    }
                    catch (FormulaException e) {
                        LogRegistry.getInstance().error(StyleDefinition.class, e.getMessage());
                    }
                } else {
                    value = labelType.equals("label") ? cell.getLabel() : cell.getText();
                }
            } else if (labelType.equals("link")) {
                try {
                    String cellURL = cell.getURL();
                    if (cellURL != null) {
                        if (cellURL.startsWith("${HTML}")) {
                            cellURL = cellURL.substring("${HTML}".length());
                        }
                        value = this.getDOM().getController().getMathEvaluator().evaluateExternal(this.getType(), cellURL);
                    }
                }
                catch (Exception e) {
                    LogRegistry.getInstance().error(StyleDefinition.class, e.getMessage());
                }
            }
            if (!StringUtil.isEmpty(value) && (startIndex = value.lastIndexOf("javascript:performDialogAction")) >= 0) {
                String[] jScriptParams = value.substring(value.indexOf("(", startIndex) + 1, value.indexOf(")", startIndex)).split(",");
                HashMap<String, String[]> nestedDialogs = (HashMap<String, String[]>)this.getType().getDOM().getRootType().getClientProperty("nestedDialogs");
                String xPath = "";
                String params = "";
                if (nestedDialogs == null) {
                    nestedDialogs = new HashMap<String, String[]>();
                    this.getType().getDOM().getRootType().putClientProperty("nestedDialogs", nestedDialogs);
                }
                if (jScriptParams.length > 9) {
                    params = jScriptParams[9].replace("'", "");
                }
                StringTokenizer st = new StringTokenizer(params, "=&");
                while (st.hasMoreTokens()) {
                    if (!st.nextElement().toString().equalsIgnoreCase("node")) continue;
                    xPath = st.nextToken().toString();
                }
                if (!StringUtil.isEmpty(xPath)) {
                    nestedDialogs.put(xPath, jScriptParams);
                }
            }
        }
    }

    public boolean isComponentMulti() {
        return this.getMultiLineNumberComponent() > 1 || this.getMultiLineNumberComponent() == -1;
    }

    private void initializeTableLayoutVector(Type layoutType) {
        Vector<FormLayoutInfo> tables = new Vector<FormLayoutInfo>();
        Iterator iter = layoutType.getDirectChildren().iterator();
        while (iter.hasNext()) {
            Type tableType = (Type)iter.next();
            tables.addElement(this.initializeTableLayout(tableType));
        }
        this.setProperty("layout", tables);
    }

    public boolean isBooleanViewRadioButton() {
        String boolVis = this.getBooleanVisualizer();
        if (boolVis != null) {
            return boolVis.equals("radioButton");
        }
        return false;
    }

    public boolean isBooleanViewRadioButtonUnselected() {
        String boolVis = this.getBooleanVisualizer();
        if (boolVis != null) {
            return boolVis.equals("radioButtonUnselected");
        }
        return false;
    }

    public boolean isBoolean3StateButton() {
        String boolVis = this.getBooleanVisualizer();
        if (boolVis != null) {
            return boolVis.equals("threeStateButton");
        }
        return false;
    }

    public boolean isBooleanViewCheckBox() {
        String boolVis = this.getBooleanVisualizer();
        if (boolVis != null) {
            return boolVis.equals("checkBox");
        }
        return false;
    }

    public boolean isAllowingCopyPaste() {
        boolean allowCopyPaste = true;
        Boolean allowCopyPasteBoolean = this.getBooleanProperty("/XUI/component/style", "caption/style/allowCopyPaste");
        allowCopyPaste = allowCopyPasteBoolean == null ? this.getDOM().getGlobalDefinition().isAllowingCopyPaste() : allowCopyPasteBoolean.booleanValue();
        return allowCopyPaste;
    }

    public boolean isEnumeration() {
        if (this._isEnumeration == -1) {
            this._isEnumeration = 0;
            String[] enumElem = this.getEnumeration();
            if (enumElem != null && enumElem.length > 0) {
                this._isEnumeration = 1;
            } else if (this.getPrimitiveBooleanProperty("/XUI/component/style/isEnumerationType", "isEnumerationType")) {
                this._isEnumeration = 1;
            } else if (this.getPrimitiveBooleanProperty("/XUI/component/style/isEnumerationType", "/isEnumerationType")) {
                this._isEnumeration = 1;
            }
        }
        return this._isEnumeration == 1;
    }

    public void setEnumeration(boolean isEnum) {
        this._isEnumeration = isEnum ? (byte)1 : 0;
    }

    public boolean isEnumerationAllowingInvalidCodes() {
        return this.getBooleanProperty("leaf/component/value/enumeration/allowInvalidCodes");
    }

    public boolean isEnumerationShowErrorForInvalidCodes() {
        return this.getBooleanProperty("leaf/component/value/enumeration/showErrorForInvalidCode");
    }

    public boolean isDefaultLayout() {
        return !this.isTableLayout();
    }

    public boolean isDialogMode() {
        TableInfo tabInf = this.getTableInfo();
        if (tabInf == null) {
            return false;
        }
        return tabInf.isDialogEditMode();
    }

    public boolean isKeyRefShowingNewButton() {
        return this.getBooleanProperty("leaf/component/showNewButton");
    }

    public boolean isKeyRefShowingDetailsButton() {
        return this.getBooleanProperty("leaf/component/showDetailsButton");
    }

    public boolean isKeyRefShowingBackLinkButton() {
        return this.getBooleanProperty("leaf/component/showBackLinkButton");
    }

    public boolean isLabelMulti() {
        String path = null;
        path = this.getType().isComposite() ? "layout/labelComponent/label/multiLine" : (this.getType().isList() ? "list/labelComponent/label/multiLine" : "leaf/label/multiLine");
        return this.getBooleanProperty(path);
    }

    public boolean isLabelUnderlined() {
        String path = null;
        path = this.getType().isComposite() ? "layout/labelComponent/label/useUnderline" : (this.getType().isList() ? "list/labelComponent/label/useUnderline" : "leaf/label/useUnderline");
        return this.getBooleanProperty(path);
    }

    public boolean isParentViewHolder() {
        String viewHolder = this.getType().getStyle().getViewHolder();
        return viewHolder != null && viewHolder.equalsIgnoreCase("parent");
    }

    public boolean isEnumerationAsRadioButton() {
        String enumType = this.getLeafEnumerationType();
        return enumType != null && enumType.equals("radioButton");
    }

    public boolean isEnumerationAsListBox() {
        String enumType = this.getLeafEnumerationType();
        return enumType != null && enumType.equals("list") || enumType.equals("listMultiselect");
    }

    public boolean isEnumerationAsListBoxMultipleSelect() {
        String enumType = this.getLeafEnumerationType();
        return enumType != null && enumType.equals("listMultiselect");
    }

    public void setEnumerationAsListBoxMultiSelect() {
        this.setProperty("leaf/component/value/enumeration/type", "listMultiselect");
    }

    public boolean isEnumerationAsComboBox() {
        String enumType = this.getLeafEnumerationType();
        return enumType != null && enumType.equals("comboBox");
    }

    public boolean isChoiceAsRadioButton() {
        String choiceType = this.getChoiceType();
        return choiceType != null && choiceType.equals("radioButton");
    }

    public boolean isChoiceAsComboBox() {
        String choiceType = this.getChoiceType();
        return choiceType != null && choiceType.equals("comboBox");
    }

    public boolean isReadOnly() {
        if (this._isEditableRuntime == -1) {
            boolean isReadOnly;
            String path = "mode/readonly";
            boolean bl = isReadOnly = this.isReadOnlyNoHash() == 1;
            if (!isReadOnly && this.getType().getParent() != null) {
                isReadOnly = this.getType().getParent().getStyle().isReadOnly();
            }
            return isReadOnly;
        }
        return !this.isEditableAtRuntime();
    }

    public boolean isTreeEntryShowChildrenAsOptional() {
        return this.getBooleanProperty("/treeEntry/occurrence/showChildrenAsOptional");
    }

    public boolean isTreeEntryShowAsOptional() {
        Boolean property = this.getBooleanProperty("/XUI/component/style", "/treeEntry/occurrence/showAsOptional");
        boolean showTreeEntryWithCheckBox = false;
        if (property == null) {
            Type defType = this.getXUIDefinition().getType();
            if (defType != null && defType.getParent() != null) {
                showTreeEntryWithCheckBox = defType.getParent().getStyle().isTreeEntryShowChildrenAsOptional();
            }
        } else {
            showTreeEntryWithCheckBox = property;
        }
        return showTreeEntryWithCheckBox;
    }

    public boolean isEditable() {
        if (this._isEditableRuntime == -1) {
            String path = "mode/editable";
            boolean isEditable = this.getBooleanProperty(path);
            if (isEditable && this.getType().getParent() != null) {
                isEditable = this.getType().getParent().getStyle().isEditable();
            }
            return isEditable;
        }
        return this.isEditableAtRuntime();
    }

    public Boolean isChoiceEnabled() {
        return this.getBooleanPropertyAsObject("choice/enabled");
    }

    public boolean isUnlocked() {
        boolean isUnlocked = this.getBooleanProperty("mode/editable/temporary");
        if (isUnlocked) {
            return true;
        }
        if (this.getType().getParent() != null) {
            isUnlocked = this.getType().getParent().getStyle().isUnlocked();
        }
        return isUnlocked;
    }

    public void setEditable(boolean editable) {
        this.setBooleanProperty("mode/editable", editable);
    }

    public void setChoiceEnabled(boolean enabled) {
        this.setBooleanProperty("choice/enabled", enabled);
    }

    public void setAllowEmptyChoice(boolean enabled) {
        this.setBooleanProperty("leaf/component/value/enumeration/allowEmpty", enabled);
    }

    public void markAsUnlockedField() {
        this.setBooleanProperty("mode/editable/temporary", true);
    }

    public boolean isRepresentedAsHeader() {
        Type parent = this.getType().getParent();
        if (parent == null) {
            return false;
        }
        if (parent.isList()) {
            return false;
        }
        return parent.getStyle().isSerialView();
    }

    public boolean getPrimitiveBooleanProperty(String fullPath, String relativePath) {
        Boolean booleanValue = super.getBooleanProperty(fullPath, relativePath);
        return booleanValue != null ? booleanValue : false;
    }

    public boolean isApplicationRequired() {
        return this.getPrimitiveBooleanProperty("/XUI/component/stylemode/isRequired", "mode/isRequired");
    }

    public String getCSSStyle() {
        return this._cssStyle;
    }

    public void setCSSStyle(String className) {
        this._cssStyle = className;
    }

    public void setApplicationRequired(boolean applicationRequired) {
        this.setProperty("/XUI/component/stylemode/isRequired", "mode/isRequired", applicationRequired);
    }

    public boolean isRepresentedAsTab() {
        Type parent = this.getType().getParent();
        if (parent == null) {
            return false;
        }
        if (parent.isList()) {
            return false;
        }
        return parent.getStyle().isTabHolder();
    }

    public boolean isSelfViewHolder() {
        String viewHolder = this.getType().getStyle().getViewHolder();
        return viewHolder != null && viewHolder.equalsIgnoreCase("self");
    }

    public boolean isSerialView() {
        String childView = this.getChildrenView();
        return childView != null && (childView.equals("header") || childView.startsWith("separator"));
    }

    public boolean isSelectionOnly() {
        boolean isSelectionOnly;
        boolean bl = isSelectionOnly = !this.isEditable() || this.isReadOnly();
        if (this.getTableInfo() != null) {
            isSelectionOnly |= this.getTableInfo().isSelectionOnly();
        }
        return isSelectionOnly;
    }

    public boolean isHierarchyEnabled(Type startType) {
        if (startType != null) {
            XUIDefinition xuiDef = startType.getXUIDefinition(true);
            if (xuiDef != null && xuiDef.getStyle().isSelectionOnly()) {
                return false;
            }
            return this.isHierarchyEnabled(startType.getParent());
        }
        return true;
    }

    public boolean isTabHolder() {
        String childView = this.getChildrenView();
        boolean isTabHolder = false;
        if (childView != null) {
            isTabHolder = childView.equals("tab");
        } else if (this.getDOM().getGlobalDefinition().useAutomaticTabbedChildrenView() != -1) {
            isTabHolder = this.getTabTypes().size() > this.getDOM().getGlobalDefinition().useAutomaticTabbedChildrenView();
        }
        return isTabHolder;
    }

    private List getTabTypes() {
        Vector<Type> tabTypes = new Vector<Type>();
        if (this.getType().isComposite()) {
            List possibleTabTypes = ((AbstractCompositeType)this.getType()).getAllRepresentableTypes();
            Type type = null;
            for (int i = 0; i < possibleTabTypes.size(); ++i) {
                type = (Type)possibleTabTypes.get(i);
                if (type.isSimple() || type.getTypeClassification() == 128) continue;
                tabTypes.add(type);
            }
        }
        return tabTypes;
    }

    public boolean isTableLayout() {
        return this.getLayoutManager("main") != null && this.getLayoutManager("main") instanceof FormLayoutInfo;
    }

    public boolean isPagingLayout() {
        return this.getLayoutManager("page") != null || this.isUsingPagingList();
    }

    public boolean isInTableLayoutContext() {
        return this.getType().getViewContextType() != null;
    }

    public boolean hasTableLayoutParent() {
        if (this.getType().getViewContextType() != null) {
            return true;
        }
        if (this.getType().getParent() != null) {
            return this.getType().getParent().getStyle().isInTableLayoutContext();
        }
        return false;
    }

    public boolean isTreeEntryAlways() {
        String treeEnMode = this.getTreeEntryMode();
        return treeEnMode != null && treeEnMode.equals("always");
    }

    public String getTreeEntryMode() {
        String path = "/treeEntry/occurrence/visibility";
        String occVis = (String)this.getProperty(path);
        if (occVis != null) {
            return occVis;
        }
        return null;
    }

    public boolean isTreeEntryDependingOn() {
        String treeEnMode = this.getTreeEntryMode();
        return treeEnMode != null && treeEnMode.equals("dependsOn");
    }

    public String getTreeEntryDependsOnXPath() {
        return this.getStringProperty("/treeEntry/occurrence/visibility/dependsOn");
    }

    public boolean isTreeEntryNever() {
        String treeEnMode = this.getTreeEntryMode();
        return treeEnMode != null && treeEnMode.equals("never");
    }

    public boolean isTreeEntryApplyOnAllDescendants() {
        String applOnDesc = this.getTreeEntryApplyOnDescendants();
        if (applOnDesc != null) {
            return applOnDesc.equals("allDescendants");
        }
        return false;
    }

    public boolean isTreeEntryApplyOnDirectDescendants() {
        String applOnDesc = this.getTreeEntryApplyOnDescendants();
        if (applOnDesc != null) {
            return applOnDesc.equals("directDescendants");
        }
        return false;
    }

    private String getTreeEntryApplyOnDescendants() {
        return this.getStringProperty("/treeEntry/occurrence/applyOnDescendants");
    }

    public boolean isTreeEntryFocusable() {
        return this.getBooleanProperty("/treeEntry/occurrence/isFocusable");
    }

    public boolean isTreeEntryAllowSearch() {
        return this.getBooleanProperty("/treeEntry/showSearch");
    }

    public boolean hasCaption() {
        boolean hasCaption = false;
        Type parent = this.getType().getParent();
        String captionOccurrence = this.getCaptionVisibility();
        if (captionOccurrence != null) {
            if (captionOccurrence.equals("always")) {
                return true;
            }
            if (captionOccurrence.equals("never")) {
                return false;
            }
            if (captionOccurrence.equals("dependsOn")) {
                block23: {
                    hasCaption = false;
                    if (this._captionOccurrenceDependsOnThisType == null && this.getCaptionOccurrenceDependsOnXPath() != null && this.getCaptionOccurrenceDependsOnXPath().length() > 0) {
                        try {
                            List list = TypePathExecuter.getInstance().processXPath(this.getType(), this.getCaptionOccurrenceDependsOnXPath());
                            if (list != null && list.size() > 0) {
                                this._captionOccurrenceDependsOnThisType = (Type)list.get(0);
                            }
                        }
                        catch (Exception ex) {
                            if (!LogRegistry.getInstance().logInfos()) break block23;
                            LogRegistry.getInstance().info(this.getClass(), ex.getMessage());
                        }
                    }
                }
                if (this._captionOccurrenceDependsOnThisType != null && this._captionOccurrenceDependsOnThisType != this.getType()) {
                    hasCaption = this._captionOccurrenceDependsOnThisType.getStyle().hasCaption();
                } else if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), this.getXUIDefinition().getXUIXPath() + ": captionOccurrence dependent -> wrong xpath");
                }
                return hasCaption;
            }
        } else {
            Type refCaptionParent = this.getReferencedCaptionOccurrenceParent(this.getType());
            if (refCaptionParent != null && refCaptionParent != this.getType()) {
                boolean hasParentCaption = refCaptionParent.getStyle().hasCaption();
                String applyOnDescendants = refCaptionParent.getStyle().getCaptionOccurrenceApplyOnDescendants();
                if (applyOnDescendants != null) {
                    if (applyOnDescendants.equals("directDescendants") && parent == refCaptionParent) {
                        this.setCaptionOccurrence(hasParentCaption, null);
                        return hasParentCaption;
                    }
                    if (applyOnDescendants.equals("allDescendants")) {
                        this.setCaptionOccurrence(hasParentCaption, applyOnDescendants);
                        return hasParentCaption;
                    }
                }
            }
        }
        if (this.getDOM().getGlobalDefinition().isGlobalCaptionHideUnnamed() && this.getType().isAnonymous()) {
            return false;
        }
        if (this.getType().isComposite() && this.getType().getDOM().getGlobalDefinition().isGlobalCaptionHideIfOnlyOneVisibleChild() && ((AbstractCompositeType)this.getType()).hasOnlyOneVisibleChild()) {
            return false;
        }
        if (!this.getType().isSimple() && parent != null && parent.getStyle().getChildrenView() != null) {
            String childrenView = parent.getStyle().getChildrenView();
            if (childrenView.equals("separator_classic") || childrenView.equals("separator_modern") || childrenView.equals("header")) {
                return true;
            }
        } else {
            if (parent != null && parent.isChoice()) {
                return false;
            }
            if (!this.getType().isSimple() && !this.getType().isRoot() && parent != null && !parent.getStyle().isDialogMode() && (this.getType().isComposite() && !this.isSelfViewHolder() || this.getType().isList() && !this.isSelfViewHolder() && !((ListType)this.getType()).getEditingType().isSimple())) {
                return true;
            }
        }
        return hasCaption;
    }

    private Type getReferencedCaptionOccurrenceParent(Type parentType) {
        while (parentType != null) {
            String applyOnDesc = parentType.getStyle().getCaptionOccurrenceApplyOnDescendants();
            if (applyOnDesc != null) {
                return parentType;
            }
            parentType = parentType.getParent();
        }
        return null;
    }

    private Type getReferencedTreeOccurrenceParent(Type parentType) {
        while (parentType != null) {
            String applyOnDesc = null;
            if (parentType.hasUIDefinition()) {
                applyOnDesc = parentType.getStyle().getTreeEntryApplyOnDescendants();
            }
            if (applyOnDesc != null) {
                return parentType;
            }
            parentType = parentType.getParent();
        }
        return null;
    }

    private Type getReferencedCaptionIndentParent(Type parentType, boolean isDirectParent) {
        while (parentType != null) {
            boolean applyOnAllDesc = parentType.getStyle().isCaptionIndentApplyOnAllDescendants();
            boolean applyOnDirectDesc = parentType.getStyle().isCaptionIndentApplyOnDirectDescendants();
            if (applyOnAllDesc) {
                return parentType;
            }
            if (isDirectParent && applyOnDirectDesc) {
                return parentType;
            }
            parentType = parentType.getParent();
        }
        return null;
    }

    public int getPDFCaptionIndent() {
        Integer value;
        String path = "PDF_CAPTION_INDENT";
        if (this.getFloatProperty(path) != null && (value = new Integer(this.getFloatProperty(path).intValue())) != null) {
            return value;
        }
        return -1;
    }

    public int getPDFLabelIndent() {
        Integer value;
        String path = "PDF_LABEL_INDENT";
        if (this.getFloatProperty(path) != null && (value = new Integer(this.getFloatProperty(path).intValue())) != null) {
            return value;
        }
        return -1;
    }

    public void setPDFCaptionIndent(int captionIndent) {
        String path = "PDF_CAPTION_INDENT";
        this.setProperty(path, new Float(captionIndent));
    }

    public void setPDFLabelIndent(int labelIndent) {
        String path = "PDF_LABEL_INDENT";
        this.setProperty(path, new Float(labelIndent));
    }

    public float getPDFCaptionFontSize() {
        Float value;
        String path = "PDF_CAPTION_FONT_SIZE";
        if (this.getProperty(path) != null && (value = (Float)this.getProperty(path)) != null) {
            return value.floatValue();
        }
        return -1.0f;
    }

    public void setPDFCaptionFontSize(float fontSize) {
        String path = "PDF_CAPTION_FONT_SIZE";
        this.setProperty(path, new Float(fontSize));
    }

    public float getPDFLabelFontSize() {
        Float value;
        String path = "PDF_LABEL_FONT_SIZE";
        if (this.getProperty(path) != null && (value = (Float)this.getProperty(path)) != null) {
            return value.floatValue();
        }
        return -1.0f;
    }

    public void setPDFLabelFontSize(float fontSize) {
        String path = "PDF_LABEL_FONT_SIZE";
        this.setProperty(path, new Float(fontSize));
    }

    public float getPDFComponentFontSize() {
        Float value;
        String path = "PDF_COMPONENT_FONT_SIZE";
        if (this.getProperty(path) != null && (value = (Float)this.getProperty(path)) != null) {
            return value.floatValue();
        }
        return -1.0f;
    }

    public void setPDFComponentFontSize(float fontSize) {
        String path = "PDF_COMPONENT_FONT_SIZE";
        this.setProperty(path, new Float(fontSize));
    }

    public boolean isUsingPlugIn() {
        if (this.getPluginBean() != null) {
            return true;
        }
        return this.getPluginBean(this.getDOM().getRenderRequestVisualizerFactory().getRendererID()) != null;
    }

    public void setVisible(boolean visible) {
        this._isVisible = visible ? (byte)1 : 0;
        this.setBooleanProperty("mode/visible", visible);
    }

    public void setEditableAtRuntime(boolean editable) {
        this._isEditableRuntime = (byte)(editable ? 1 : 0);
    }

    public boolean isEditableAtRuntime() {
        if (this._isEditableRuntime == -1) {
            return this.isEditable();
        }
        return this._isEditableRuntime == 1;
    }

    public void setVisibleAtRuntime(boolean visible) {
        this._isVisibleAtRuntime = visible;
    }

    public boolean isVisibleAtRuntime() {
        if (this._isVisibleAtRuntime == null) {
            return this.isVisible();
        }
        return this._isVisibleAtRuntime;
    }

    public void setEnabled(boolean enabled) {
        this._isReadOnly = !enabled ? (byte)1 : 0;
        this.setBooleanProperty("mode/readonly", !enabled);
    }

    public boolean isEnabled() {
        boolean readOnly;
        String path = "mode/readonly";
        boolean bl = readOnly = this.isReadOnlyNoHash() == 1;
        if (readOnly) {
            return false;
        }
        if (this.getType().getParent() != null) {
            return this.getType().getParent().getStyle().isEnabled();
        }
        return true;
    }

    public byte isVisibleNoHash() {
        if (this._isVisible == -1) {
            Boolean isVisible = super.getBooleanProperty("/XUI/component/style", "mode/visible");
            this._isVisible = isVisible == null ? (byte)-1 : (isVisible != false ? (byte)1 : 0);
        }
        return this._isVisible;
    }

    public byte isReadOnlyNoHash() {
        if (this._isReadOnly == -1) {
            String path = "mode/readonly";
            boolean isReadOnly = this.getBooleanProperty(path);
            if (!isReadOnly && this.getType().getParent() != null) {
                isReadOnly = this.getType().getParent().getStyle().isReadOnly();
            }
            this._isReadOnly = isReadOnly ? (byte)1 : 0;
        }
        return this._isReadOnly;
    }

    public boolean isVisible() {
        byte isVisible = this.isVisibleNoHash();
        GlobalDefinition globDef = this.getDOM().getGlobalDefinition();
        if (globDef.isShowingOnlyMandatoryElements()) {
            boolean isInMandatoryAxis = ((AbstractType)this.getType()).isMandatoryAxis();
            return isInMandatoryAxis;
        }
        if (globDef.hideEmptyElements()) {
            return ((AbstractType)this.getType()).hasEmptyContent(true, true);
        }
        boolean visible = false;
        if (isVisible == -1) {
            visible = this.getType().isAttribute() ? (((SimpleType)this.getType()).isKeyRef() ? true : globDef.isShowAttributes()) : this.isLabelVisible() || this.isEditorComponentVisible();
        } else if (isVisible == 1) {
            boolean bl = visible = this.isLabelVisible() || this.isEditorComponentVisible();
        }
        if (visible && this.getType().getParent() != null && !this.isInTableLayoutContext()) {
            visible = this.getType().getParent().getStyle().isVisible();
        }
        return visible;
    }

    public void setIsVisibleInOptionalTreeMode(boolean isVisible) {
        this.setBooleanProperty("isVisibleInOptionalTreeMode", isVisible);
    }

    public boolean isVisibleInOptionalTreeMode() {
        if (this.getType().getStyle().isTreeEntryShowAsOptional()) {
            Boolean value = (Boolean)this.getProperty("isVisibleInOptionalTreeMode");
            if (value == null) {
                if (this.isSelfViewHolder()) {
                    return true;
                }
                if (this.getType().getParent() != null && this.getType().getParent().isList()) {
                    return true;
                }
                if (this.getType().isComposite()) {
                    return !((CompositeType)this.getType()).hasEmptyContent(true, true);
                }
                if (this.getType().isList()) {
                    return ((ListType)this.getType()).getList().size() > 0;
                }
                return ((SimpleType)this.getType()).getValue() != null;
            }
            return value;
        }
        return true;
    }

    public boolean isLabelVisible() {
        String path = null;
        path = this.getType().isComposite() ? (this.getType().isChoice() ? "choice/labelVisible" : "layout/labelComponent/label/visible") : (this.getType().isList() ? "list/labelComponent/label/visible" : "leaf/label/visible");
        Boolean isVisible = super.getBooleanProperty("/XUI/component/style", path);
        if (isVisible == null) {
            return true;
        }
        return isVisible;
    }

    public void setListLabelVisible(boolean visible) {
        this.setBooleanProperty("list/labelComponent/label/visible", visible);
    }

    public void setLabelVisible(boolean visible) {
        String path = this.getStartElement() + "/" + "label" + "/" + "visible";
        this.setProperty(path, new Boolean(visible));
    }

    public boolean isEditorComponentVisible() {
        String path = null;
        path = this.getType().isComposite() ? "layout/labelComponent/component/visible" : (this.getType().isList() ? "list/labelComponent/component/visible" : "leaf/component/visible");
        Boolean isVisible = super.getBooleanProperty("/XUI/component/style", path);
        if (isVisible == null) {
            return true;
        }
        return isVisible;
    }

    public boolean isSerializableAsCDATA() {
        String path = "leaf/component/value/serializeContentAsCDATA";
        Boolean serializeAsCDATA = super.getBooleanProperty("/XUI/component/style", path);
        if (serializeAsCDATA == null) {
            return false;
        }
        return serializeAsCDATA;
    }

    public boolean isEditableComboBoxEnabled() {
        String path = "leaf/component/value/enableEditableComboBox";
        Boolean enableEditableComboBox = super.getBooleanProperty("/XUI/component/style", path);
        if (enableEditableComboBox == null) {
            return false;
        }
        return enableEditableComboBox;
    }

    public String getActAs() {
        String actAs = this.getStringProperty("/XUI/component/style", "leaf/component/value/dataType");
        return actAs;
    }

    public boolean isCurrencyControl() {
        return "currency".equals(this.getActAs());
    }

    public void setActAs(String actAs) {
        this.setProperty("leaf/component/value/dataType", actAs);
    }

    public void setSerializableAsCDATA(boolean isCDATA) {
        this.setBooleanProperty("leaf/component/value/serializeContentAsCDATA", isCDATA);
    }

    public boolean allowFreetextChoice() {
        boolean allow = true;
        if (this.getType().isSimple()) {
            allow = this.getBooleanProperty("leaf/component/value/enumeration/allowFreeText");
        }
        return allow;
    }

    public boolean allowEmptyChoice() {
        boolean allow = true;
        if (this.getType().isSimple()) {
            allow = this.getBooleanProperty("leaf/component/value/enumeration/allowEmpty");
        }
        return allow;
    }

    public boolean allowDeselection() {
        boolean allow = this.getDOM().getGlobalDefinition().allowRadioButtonDeselection();
        if (!allow) {
            return allow;
        }
        if (this.getType().isSimple()) {
            allow = this.getBooleanProperty("leaf/component/value/enumeration/allowDeselection");
        }
        return allow;
    }

    public void setEnumeration(String[] selection) {
        if (selection != null) {
            this._isEnumeration = 1;
            String origSortOrder = this.getEnumerationSortOrder();
            String sortOrder = origSortOrder;
            if (sortOrder != null) {
                sortOrder = sortOrder.startsWith("ascending") ? TreeSort.SORT_ASC : TreeSort.SORT_DESC;
                if ((origSortOrder.equals("ascendingByCode") || origSortOrder.equals("descendingByCode")) && this.isUsingCodeSet()) {
                    CodeTables codeTables = this.getDOM().getSchema().getCodeTables();
                    String codeSetName = this.getCodeSetName();
                    if (codeTables != null) {
                        boolean isNumberSort = origSortOrder.endsWith("AsNumber");
                        selection = TreeSort.sort(codeTables.getCodeItems(this.getType(), codeSetName), sortOrder, 0, isNumberSort);
                    }
                } else {
                    selection = TreeSort.sort(selection, sortOrder);
                }
            }
        }
        this.setProperty("leaf/component/value/enumeration", selection);
        try {
            Method method = this.getClass().getMethod("setEnumeration", String;.class);
            Object[] tempSelection = selection;
            if (selection != null && selection.length > 0 && !selection[0].equals("")) {
                tempSelection = TextTools.getChoicesWithNoneEntry(selection);
            }
            this.getDOM().fireActionPerformed(new ActionPerformEvent(this.getType(), method, tempSelection));
            if (this.getDOM() != null && this.getDOM().getRenderRequestVisualizerFactory() != null) {
                this.getDOM().getRenderRequestVisualizerFactory();
                TypeVisualizerFactory.getInstance().populateAllVisualizerForType(this.getType());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void setEnumeration(String[][] selection) {
        if (selection != null) {
            String origSortOrder;
            this._isEnumeration = 1;
            String sortOrder = origSortOrder = this.getEnumerationSortOrder();
            int iSOrder = 0;
            if (sortOrder != null) {
                if (sortOrder.startsWith("ascending")) {
                    sortOrder = TreeSort.SORT_ASC;
                    iSOrder = 0;
                } else {
                    sortOrder = TreeSort.SORT_DESC;
                    iSOrder = 1;
                }
                if ((origSortOrder.equals("ascendingByCode") || origSortOrder.equals("descendingByCode")) && this.isUsingCodeSet()) {
                    CodeTables codeTables = this.getDOM().getSchema().getCodeTables();
                    String codeSetName = this.getCodeSetName();
                    if (codeTables != null) {
                        boolean isNumberSort = origSortOrder.endsWith("AsNumber");
                        new FastQSort().sort((Object[])codeTables.getCodeItems(this.getType(), codeSetName), FastQSort.getStringArrCompare(0, true, isNumberSort, iSOrder));
                    }
                } else {
                    new FastQSort().sort((Object[])selection, FastQSort.getStringArrCompare(1, true, false, iSOrder));
                }
            }
            this.setProperty("leaf/component/value/enumeration", selection);
        }
        try {
            Method method = this.getClass().getMethod("setEnumeration", String;.class);
            this.getDOM().fireActionPerformed(new ActionPerformEvent(this.getType(), method, (Object[])selection));
            if (this.getDOM().getRenderRequestVisualizerFactory() != null) {
                this.getDOM().getRenderRequestVisualizerFactory();
                TypeVisualizerFactory.getInstance().populateAllVisualizerForType(this.getType());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String translateToCodeSetValue(Type type, String key) {
        String codeset = this.getCodeSetName();
        if (codeset != null) {
            if (key == null) return "";
            if (key.equals("")) return "";
            if (!this.isEnumerationAsListBoxMultipleSelect()) return this.getDOM().getSchema().getCodeTables().getText(type, codeset, key, this.getDOM().getLanguage());
            String[] items = TextTools.tokenize(key, "_;_");
            String newValue = "";
            int i = 0;
            while (i < items.length) {
                String newNLSItem = this.getDOM().getSchema().getCodeTables().getText(type, codeset, items[i], this.getDOM().getLanguage());
                newValue = newValue + (newNLSItem != null ? newNLSItem : items[i]);
                if (i != items.length - 1) {
                    newValue = newValue + ", ";
                }
                ++i;
            }
            return newValue;
        }
        if (!this.isEnumeration()) return null;
        return key;
    }

    public String[] getEnumeration() {
        Object oEnum = this.getProperty("leaf/component/value/enumeration");
        Object[] enumeration = null;
        enumeration = oEnum == null ? this.getSchemaEnumeration() : (oEnum instanceof String[] ? (String[])oEnum : ArrayUtil.toStringArray((String[][])oEnum, 1));
        if (enumeration != null && this.allowEmptyChoice() && this.getType().isSimple() && !this.isEnumerationAsListBoxMultipleSelect() && this.getType().getSchemaElement().getDefaultValue() == null && this.getType().getStyle().getLeafDefaultValue() == null && ArrayUtil.contains(enumeration, "") == -1) {
            enumeration = TextTools.getChoicesWithNoneEntry((String[])enumeration);
        }
        return enumeration;
    }

    public String[][] getCodeEnumeration() {
        Object oEnum = this.getProperty("leaf/component/value/enumeration");
        String[][] enumeration = null;
        if (oEnum == null) {
            return enumeration;
        }
        if (oEnum instanceof String[][]) {
            enumeration = (String[][])oEnum;
        }
        return enumeration;
    }

    public void setPluginBean(PluginBean bean, String rendererID) {
        this.setProperty("plugIn" + (rendererID == null ? "" : "_" + rendererID), bean);
    }

    public void setPluginBean(PluginBean bean) {
        this.setPluginBean(bean, null);
    }

    public void setTreeEntry(boolean hasTreeEntry) {
        this.setTreeEntry(hasTreeEntry, null);
    }

    public void setTreeEntry(boolean hasTreeEntry, String applyOnDescendants) {
        String path = "/treeEntry/occurrence/visibility";
        if (hasTreeEntry) {
            this.setProperty(path, "always");
        } else {
            this.setProperty(path, "never");
        }
        if (applyOnDescendants != null) {
            path = "/treeEntry/occurrence/applyOnDescendants";
            if (applyOnDescendants.equals("allDescendants")) {
                this.setProperty(path, "allDescendants");
            } else if (applyOnDescendants.equals("directDescendants")) {
                this.setProperty(path, "directDescendants");
            }
        }
    }

    public void setTreeIcon(String gifName) {
        this.setProperty("/treeEntry/icon", gifName);
        this.getPropertyChangeSupport().firePropertyChange("icon", null, gifName);
    }

    public void setTabIndex(int tabIndex) {
        this.setProperty("tabIndex", new Integer(tabIndex));
    }

    public Integer getTabIndex() {
        return this.getIntProperty("/XUI/component/style", "tabIndex");
    }

    public boolean isSingleChoiceAndSerialize() {
        Boolean value = super.getBooleanProperty("/XUI/component/style", "choice/singleChoiceAndSerialize");
        if (value != null && this.getType() != null && this.getType().isSimple() && ((SimpleType)this.getType()).getDefaultValue() != null && !((SimpleType)this.getType()).getDefaultValue().equals(value)) {
            return value;
        }
        boolean globalValue = this.getDOM().getGlobalDefinition().isSingleChoiceAndSerialize();
        this.setBooleanProperty("choice/singleChoiceAndSerialize", globalValue);
        return globalValue;
    }

    public boolean isUsingCodeSet() {
        return this.getCodeSetName() != null;
    }

    public void setBackgroundColor(Color color) {
        this.setProperty("backgroundColor", color);
    }

    public Color getBackgroundColor() {
        return this.getColorProperty("/XUI/component/style", "backgroundColor");
    }

    public void setForegroundColor(Color color) {
        this.setProperty("foregroundColor", color);
    }

    public Color getForegroundColor() {
        return this.getColorProperty("/XUI/component/style", "foregroundColor");
    }

    public void setLabelColor(Color color) {
        this.setProperty("labelColor", color);
    }

    public void setLabelText(String text) {
        NLS nLS = this.getDOM().getNLS();
        this.getDOM().getNLS();
        String oldText = nLS.get(NLS.nlsKey(this.getType(), "label", null, null));
        this.getDOM().getRenderRequestVisualizerFactory();
        Visualizer visualizer = TypeVisualizerFactory.getInstance().getVisualizer(this.getType(), false);
        if (visualizer != null) {
            visualizer.setLabelText(text);
            if (oldText != null && !oldText.equals(text) || oldText == null && text != null) {
                try {
                    Method method = this.getClass().getMethod("setLabelText", String.class);
                    this.getDOM().fireActionPerformed(new ActionPerformEvent(this.getType(), method, new Object[]{text}));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    public Color getLabelColor() {
        return this.getColorProperty("/XUI/component/style", "labelColor");
    }

    public void setHint(String text, boolean isFormula, Color color, boolean isBold) {
        if (text != null) {
            this.setProperty("hintText", text);
            this.setBooleanProperty("hintIsFormula", isFormula);
            this.setBooleanProperty("hintIsBold", isBold);
        }
        if (color != null) {
            this.setProperty("hintColor", color);
        }
    }

    public void removeHint() {
        this.removeProperty("hintText");
        this.removeProperty("hintColor");
        this.removeProperty("hintIsFormula");
        this.removeProperty("hintIsBold");
    }

    public boolean hasHint() {
        return this.getHintText() != null;
    }

    public String getHintText() {
        return (String)this.getProperty("hintText");
    }

    public boolean isHintTextFormula() {
        return this.getBooleanProperty("hintIsFormula");
    }

    public boolean isHintTextBold() {
        return this.getBooleanProperty("hintIsBold");
    }

    public Color getHintColor() {
        return (Color)this.getProperty("hintColor");
    }

    public String getEnumerationSortOrder() {
        return this.getStringProperty("sort");
    }

    public String getDisplayValue() {
        FormulaExpression shortValueFormulaEx;
        String displayValue = this.getStringProperty("mode/displayValue");
        if (displayValue != null && (shortValueFormulaEx = new FormulaExpression(this.getType(), displayValue)) != null) {
            try {
                displayValue = shortValueFormulaEx.evaluate();
            }
            catch (FormulaException ex) {
                LogRegistry.getInstance().error(this.getClass(), ex.getMessage());
            }
        }
        if (displayValue == null || displayValue.length() < 1) {
            displayValue = this.getType().isSimple() ? ((SimpleType)this.getType()).getValue() : this.getType().getDisplayValue();
        }
        return displayValue;
    }

    public boolean hasDisplayValue() {
        String displayValue = this.getStringProperty("mode/displayValue");
        return displayValue != null;
    }

    private String[][] initializeCodeSet(Type codeSetType) {
        String className;
        String[][] enumeration = null;
        String codeSetName = codeSetType.getDirectChildValue("name");
        Type urlType = codeSetType.getDirectChild("url");
        Type classType = codeSetType.getDirectChild("class");
        String allowInvalidCodes = codeSetType.getDirectChildValue("allowInvalidCodes");
        String showErrorForInvalidCode = codeSetType.getDirectChildValue("showErrorForInvalidCode");
        if (codeSetName != null) {
            this.setCodeSetName(codeSetName);
        }
        Type choosenType = codeSetType.getChoosenType();
        if (urlType != null && choosenType == urlType) {
            URL globalURL;
            String urlValue = ((SimpleType)urlType).getValue();
            if (urlValue != null) {
                this.setCodeSetURL(urlValue);
            } else if (this.getDOM().getSchema() != null && this.getDOM().getGlobalDefinition().getGlobalCodeSetURL() != null && (globalURL = CodeTables.getCodeSetURL(this.getDOM().getSchema(), this.getDOM().getGlobalDefinition().getGlobalCodeSetURL())) != null) {
                urlValue = globalURL.toExternalForm();
            }
            if (codeSetName != null) {
                enumeration = this.getCodeSetItemsFromFile(urlValue, codeSetName);
            }
        } else if (classType != null && choosenType == classType && (className = ((SimpleType)classType).getValue()) != null) {
            this.setCodeSetClass(className);
            enumeration = this.getCodeSetItemsFromClass(className, codeSetName);
        }
        if (allowInvalidCodes != null && allowInvalidCodes.length() > 0) {
            this.setBooleanProperty("leaf/component/value/enumeration/allowInvalidCodes", Boolean.valueOf(allowInvalidCodes));
        }
        if (showErrorForInvalidCode != null && showErrorForInvalidCode.length() > 0) {
            this.setBooleanProperty("leaf/component/value/enumeration/showErrorForInvalidCode", Boolean.valueOf(showErrorForInvalidCode));
        }
        return enumeration;
    }

    private String[] initializeXmlResource(Type xmlResourceType) {
        String[] enumeration = null;
        String codeSetName = xmlResourceType.getDirectChildValue("name");
        String xmlLoc = xmlResourceType.getDirectChildValue("url");
        String keyXPath = xmlResourceType.getDirectChildValue("keyFieldXPath");
        String descXPath = xmlResourceType.getDirectChildValue("keyFieldDescXPath");
        String labelXPath = xmlResourceType.getDirectChildValue("labelXPath");
        String allowInvalidCodes = xmlResourceType.getDirectChildValue("allowInvalidCodes");
        String serializeAsXlink = xmlResourceType.getDirectChildValue("serializeAsXLink");
        String showErrorForInvalidCode = xmlResourceType.getDirectChildValue("showErrorForInvalidCode");
        if (codeSetName != null) {
            this.setCodeSetName(codeSetName);
            this.setCodeSetURL(xmlLoc);
            this.setProperty("keyFieldXPath", keyXPath);
            if (descXPath != null) {
                this.setProperty("keyFieldDescXPath", descXPath);
            }
            if (labelXPath != null) {
                this.setProperty("labelXPath", labelXPath);
            }
            Reader reader = new XMLResourceCodeSetCreator(this.getType().getDOM().getFingerPrint().getXSDURL(), xmlLoc, labelXPath, keyXPath, descXPath).getCodeSet(this.getType(), codeSetName, this.getType().getDOM().getAppVersionNo());
            CodeTables codeTables = this.getDOM().getSchema().getCodeTables();
            enumeration = codeTables.initialize(this.getType(), codeSetName, reader);
            if (allowInvalidCodes != null && allowInvalidCodes.length() > 0) {
                this.setBooleanProperty("leaf/component/value/enumeration/allowInvalidCodes", Boolean.valueOf(allowInvalidCodes));
            }
            if (showErrorForInvalidCode != null && showErrorForInvalidCode.length() > 0) {
                this.setBooleanProperty("leaf/component/value/enumeration/showErrorForInvalidCode", Boolean.valueOf(showErrorForInvalidCode));
            }
            if (serializeAsXlink != null && serializeAsXlink.length() > 0) {
                this.setBooleanProperty("serializeAsXLink", Boolean.valueOf(serializeAsXlink));
            }
        } else if (JAXFrontProperties.LOG_ENABLED) {
            LogRegistry.getInstance().error(this.getClass(), "no codesetname defined for:" + this.getType().getXPathLocation());
        }
        return enumeration;
    }

    private String[][] initializeXmlResource2(Type xmlResourceType) {
        String[][] enumeration = null;
        String codeSetName = xmlResourceType.getDirectChildValue("name");
        String xmlLoc = xmlResourceType.getDirectChildValue("url");
        String keyXPath = xmlResourceType.getDirectChildValue("keyFieldXPath");
        String descXPath = xmlResourceType.getDirectChildValue("keyFieldDescXPath");
        String labelXPath = xmlResourceType.getDirectChildValue("labelXPath");
        String allowInvalidCodes = xmlResourceType.getDirectChildValue("allowInvalidCodes");
        String serializeAsXlink = xmlResourceType.getDirectChildValue("serializeAsXLink");
        String showErrorForInvalidCode = xmlResourceType.getDirectChildValue("showErrorForInvalidCode");
        if (codeSetName != null) {
            this.setCodeSetName(codeSetName);
            this.setCodeSetURL(xmlLoc);
            this.setProperty("keyFieldXPath", keyXPath);
            if (descXPath != null) {
                this.setProperty("keyFieldDescXPath", descXPath);
            }
            if (labelXPath != null) {
                this.setProperty("labelXPath", labelXPath);
            }
            Reader reader = new XMLResourceCodeSetCreator(this.getType().getDOM().getFingerPrint().getXSDURL(), xmlLoc, labelXPath, keyXPath, descXPath).getCodeSet(this.getType(), codeSetName, this.getType().getDOM().getAppVersionNo());
            CodeTables codeTables = this.getDOM().getSchema().getCodeTables();
            enumeration = codeTables.initialize2(this.getType(), codeSetName, reader);
            if (allowInvalidCodes != null && allowInvalidCodes.length() > 0) {
                this.setBooleanProperty("leaf/component/value/enumeration/allowInvalidCodes", Boolean.valueOf(allowInvalidCodes));
            }
            if (showErrorForInvalidCode != null && showErrorForInvalidCode.length() > 0) {
                this.setBooleanProperty("leaf/component/value/enumeration/showErrorForInvalidCode", Boolean.valueOf(showErrorForInvalidCode));
            }
            if (serializeAsXlink != null && serializeAsXlink.length() > 0) {
                this.setBooleanProperty("serializeAsXLink", Boolean.valueOf(serializeAsXlink));
            }
        } else if (JAXFrontProperties.LOG_ENABLED) {
            LogRegistry.getInstance().error(this.getClass(), "no codesetname defined for:" + this.getType().getXPathLocation());
        }
        return enumeration;
    }

    public boolean isXLinkCodeset() {
        return this.getStringProperty("keyFieldXPath") != null;
    }

    public boolean serializeAsXLink() {
        return this.getBooleanProperty("serializeAsXLink");
    }

    public void reinitializeCodeSetValues() {
        String[][] enumeration = null;
        String codeSetName = this.getCodeSetName();
        if (codeSetName != null) {
            if (this.isXLinkCodeset()) {
                String xmlResKeyXPath = this.getStringProperty("keyFieldXPath");
                String xmlDescKeyXPath = this.getStringProperty("keyFieldDescXPath");
                String labelXPath = this.getStringProperty("labelXPath");
                Reader reader = new XMLResourceCodeSetCreator(this.getType().getDOM().getFingerPrint().getXSDURL(), this.getCodeSetURL(), labelXPath, xmlResKeyXPath, xmlDescKeyXPath).getCodeSet(this.getType(), codeSetName, this.getType().getDOM().getAppVersionNo());
                CodeTables codeTables = this.getDOM().getSchema().getCodeTables();
                enumeration = codeTables.initialize2(this.getType(), codeSetName, reader);
            } else {
                enumeration = this.getCodeSetURL() != null ? this.getCodeSetItemsFromFile(this.getCodeSetURL(), codeSetName) : this.getCodeSetItemsFromClass(this.getCodeSetClass(), codeSetName);
            }
            if (enumeration != null) {
                this.setEnumeration(enumeration);
            }
        }
    }

    public boolean isPanelMode() {
        boolean isPanel = false;
        if (this.getType().isList()) {
            Type editingType = ((ListType)this.getType()).getEditingType();
            if (editingType.isAbstract() || editingType.isChoice()) {
                isPanel = this.getTableInfo() == null || !this.getTableInfo().isDialogEditMode();
            } else if (this.getTableInfo() == null) {
                if (this.getType().getTypeClassification() == 194) {
                    isPanel = true;
                } else if (editingType.getTypeClassification() == 65) {
                    SimpleGroup sg = (SimpleGroup)editingType;
                    if (sg.getAllSimpleChildren().size() == 0) {
                        isPanel = true;
                    }
                } else {
                    isPanel = false;
                }
            } else if (this.getTableInfo().isDefaultPanelEditMode()) {
                if (this.getType().getTypeClassification() == 128) {
                    isPanel = false;
                } else if (this.getType().getTypeClassification() != 193) {
                    isPanel = true;
                }
            } else {
                isPanel = this.getTableInfo().isPanelEditMode();
            }
        }
        return isPanel;
    }

    public boolean isMarkedAsError() {
        return this._markError;
    }

    public void markAsError(boolean markAsError) {
        this._markError = markAsError;
    }

    public String getValidationErrorMessage() {
        String validationMessage = this.getNLS("validationMessage", null, null);
        return validationMessage;
    }

    public boolean isValidationErrorNeedingUserAcceptance() {
        return this.getBooleanProperty("mode/message/needsUserAcceptance");
    }

    public String getValidationErrorClassification() {
        return this.getStringProperty("mode/message/classification");
    }

    public String getPrintable() {
        return this.getStringProperty("printing/printable");
    }

    public String getPrintingFormula() {
        return this.getStringProperty("printing/formula");
    }

    public void setPrintable(boolean printable) {
        String path = "printing/printable";
        String printableString = "always";
        if (!printable) {
            printableString = "never";
        }
        this.setProperty(path, printableString);
    }

    public boolean printLabelOnly() {
        return this.getBooleanProperty("printing/printLabelOnly");
    }

    public Boolean printChoiceAsHeader() {
        return super.getBooleanProperty("/XUI/component/style", "printing/printChoiceAsHeader");
    }

    public String getListPrintMode() {
        return this.getStringProperty("printing/listPrintMode");
    }

    public boolean isListPrintModeSerial() {
        return this.getListPrintMode() != null && this.getListPrintMode().equals("serial");
    }

    public boolean isListPrintModeTable() {
        return this.getListPrintMode() != null && this.getListPrintMode().equals("table");
    }

    public boolean isListPrintModeTableAndSerial() {
        return this.getListPrintMode() != null && this.getListPrintMode().equals("tableAndSerial");
    }

    public boolean getSerializable() {
        Boolean serialize = super.getBooleanProperty("/XUI/component/style", "mode/serialize", false);
        if (serialize == null) {
            return true;
        }
        return serialize;
    }

    public Boolean getSerializableDefault() {
        return super.getBooleanProperty("/XUI/component/style", "mode/serialize", false);
    }

    public String getNLS(String context, String subId, String classification) {
        return this.getNLS(null, context, subId, classification);
    }

    public String getNLS(String defaultNLS, String context, String subId, String classification) {
        String nls = null;
        if (this.getDOM() != null && this.getDOM().getNLS() != null) {
            nls = this.getDOM().getNLS().getTranslation(this.getType(), null, context, subId, classification);
            if (nls == null && this.getType().isList() && ((ListType)this.getType()).getEditingType().isSimple()) {
                nls = this.getDOM().getNLS().getTranslation(((ListType)this.getType()).getEditingType(), null, context, subId, classification);
            }
            if (nls == null && classification == null) {
                nls = this.getDOM().getNLS().getTranslation(this.getType(), null, context, subId, "formula");
            }
        }
        if (this.getType().isSimple() && ((SimpleType)this.getType()).isSimpleContent() && nls == null) {
            nls = this.getType().getParent().getStyle().getCaptionTitleLabel();
        }
        if (nls == null) {
            return defaultNLS;
        }
        return nls;
    }

    public void setProperty(Object fullKey, Object relativeKey, Boolean value) {
        this.setProperty(relativeKey, value);
    }

    public ListInfo getListInfo() {
        if (this.isUsingTabList()) {
            return this.getTabListInfo();
        }
        if (this.isUsingSerialList()) {
            return this.getSerialListInfo();
        }
        if (this.isUsingTableList()) {
            return this.getTableInfo();
        }
        if (this.isUsingPagingList()) {
            return this.getPagingListInfo();
        }
        if (this.getTableInfo() != null) {
            return this.getTableInfo();
        }
        return null;
    }

    public static ButtonEnabling checkEnabling(Type forType) {
        boolean isSelectionOnly = false;
        boolean isShowingButtons = true;
        boolean allowAdding = false;
        boolean allowCopying = false;
        boolean allowDeleting = false;
        StyleDefinition style = forType.getStyle();
        isSelectionOnly = !style.isHierarchyEnabled(forType);
        ListInfo tableInfo = style.getListInfo();
        if (forType.getParent() != null && forType.getParent().isList()) {
            tableInfo = forType.getParent().getStyle().getListInfo();
        }
        if (tableInfo != null) {
            if (tableInfo.isSelectionOnly()) {
                isSelectionOnly = true;
            }
            isShowingButtons = tableInfo.isShowingButtons();
            if (!isSelectionOnly && isShowingButtons) {
                allowAdding = tableInfo.isShowingNewButton();
                allowCopying = allowAdding && tableInfo.isShowingCopyButton();
                allowDeleting = tableInfo.isShowingDeleteButton();
            }
        } else {
            allowAdding = !isSelectionOnly;
            allowCopying = !isSelectionOnly;
            boolean bl = allowDeleting = !isSelectionOnly;
        }
        if (forType.isList()) {
            ListType lt = (ListType)forType;
            if (lt.violateCardinality(1)) {
                allowAdding = false;
            }
            if (lt.violateCardinality(-1)) {
                allowDeleting = false;
            }
        }
        return new ButtonEnabling(allowAdding, allowCopying, allowDeleting, isSelectionOnly, tableInfo);
    }

    public void release() {
        _wrongPlugins = null;
        this._treeEntryDependsOnThisType = null;
        this._selectedTabType = null;
        this._captionOccurrenceDependsOnThisType = null;
        Vector lInsof = this.getLayoutInfos();
        if (lInsof != null) {
            for (int l = 0; l < lInsof.size(); ++l) {
                ((LayoutInfo)lInsof.get(l)).release();
            }
        }
        super.release();
    }

    public int getTotalNumberOfPages() {
        Vector layoutInfos = this.getLayoutInfos();
        if (layoutInfos != null) {
            return layoutInfos.size();
        }
        return 0;
    }

    public boolean isTreeEntryAllowExpColapse() {
        return true;
    }

    public boolean contains(Type holder, Type childType) {
        List path = DOMHelper.getAllSelectedVisStructureChilds(holder, true);
        return path.contains(childType);
    }

    public void setSelectedTabIdx(int selectedTabIdx) {
        this._selectedTabIdx = selectedTabIdx;
    }

    public int getSelectedTabIdx() {
        return this._selectedTabIdx;
    }

    public void setSelectedTabType(Type selectedTabType) {
        this._selectedTabType = selectedTabType;
    }

    public Type getSelectedTabType() {
        return this._selectedTabType;
    }

    public boolean forcePDFPageBreak() {
        String path = "printing/forcePageBreak";
        if (this.getProperty(path) != null) {
            return this.getBooleanProperty(path);
        }
        return false;
    }

    public boolean isEnumerationWithDynamicFreeText() {
        String[][] choices;
        boolean dynamicVisibility = false;
        if (this.getType().isSimple() && (choices = ((SimpleType)this.getType()).getChoices()) != null) {
            for (int i = 0; i < choices.length; ++i) {
                if (!"*".equals(choices[i][0])) continue;
                dynamicVisibility = true;
                break;
            }
        }
        return dynamicVisibility;
    }

    public boolean isEnumerationWithDynamicFreeTextAndEmptyOption() {
        String[][] choices;
        boolean hasEmptyOption = false;
        if (this.getType().isSimple() && (choices = ((SimpleType)this.getType()).getChoices()) != null) {
            for (int i = 0; i < choices.length; ++i) {
                if (!"NULL".equals(choices[i][0])) continue;
                hasEmptyOption = true;
                break;
            }
        }
        return hasEmptyOption;
    }

    public String getTimeInputMask() {
        return StringUtil.replaceLetters(this.getTimeFormat(), " ");
    }
}

