/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.xui.ColumnInfo;
import com.jaxfront.core.xui.ListInfo;
import com.jaxfront.core.xui.XUITypes;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInfo
extends ListInfo
implements Serializable,
Cloneable,
XUITypes {
    private boolean _useDefaultPanelMode;
    private List<ColumnInfo> _lineInfos;
    private int _lineDirection;
    private boolean _allowFlippingOnTheFly = true;
    private String _editMode;
    public static final int ASCOLUMN = 0;
    private String _tableModelClass;
    public static final int ASROW = 1;
    private String _tablePosition;
    private String _columnHeaderLabellingStrategy;
    private String _cellRendererClass = null;

    private TableInfo() {
    }

    public TableInfo(ListType listType) {
        this.createDefaultLineInfos(listType);
    }

    public TableInfo(Type xuiType, Type schemaType) {
        super(xuiType, schemaType);
    }

    public TableInfo(Type xuiType, Type schemaType, int lineDirection, boolean showSequenceNumbering) {
        super(xuiType, schemaType);
        this._lineDirection = lineDirection;
        this._showSequenceNumbering = showSequenceNumbering;
        if (schemaType.isList()) {
            this.createDefaultLineInfos((ListType)schemaType);
        }
    }

    private int addDefaultStructureElementToLineInfo(ListType listType, Type aType, int lineInfoIndex) {
        if (aType.getStyle().isVisible() && lineInfoIndex < this.getLineInfos().size()) {
            ColumnInfo aLineInfo = this.getLineInfo(lineInfoIndex);
            aLineInfo.setUsingDefaultRendering(true);
            FormulaExpression aFE = null;
            aFE = this.getFormulaExpression(aLineInfo, listType, aType);
            aLineInfo.addFormulaExpression(aFE);
            ++lineInfoIndex;
        }
        return lineInfoIndex;
    }

    public void addLineInfo(ColumnInfo info) {
        this.getLineInfos().add(info);
    }

    private FormulaExpression getFormulaExpression(ColumnInfo lineInfo, ListType listType, Type type) {
        FormulaExpression fe = type.getDOM().lookupFormula(type, lineInfo.getFormulaExpression());
        if (fe == null) {
            return new FormulaExpression(type, lineInfo.getFormulaExpression(), false, false);
        }
        return fe;
    }

    private int addStructureElementToLineInfo(ListType listType, Type source, int lineInfoIndex) {
        ColumnInfo aLineInfo = this.getLineInfo(lineInfoIndex);
        aLineInfo.setUsingDefaultRendering(false);
        FormulaExpression aFE = this.getFormulaExpression(aLineInfo, listType, source);
        aLineInfo.addFormulaExpression(aFE);
        return lineInfoIndex;
    }

    public boolean allowFlippingOnTheFly() {
        return this._allowFlippingOnTheFly;
    }

    public void createFormula(SimpleType simpleType) {
        if (this.isUsingDefaultRendering()) {
            this.addDefaultStructureElementToLineInfo(simpleType.getParentList(), simpleType, 0);
        } else {
            this.addStructureElementToLineInfo(simpleType.getParentList(), simpleType, 0);
        }
    }

    private void createDefaultFormulasForColumns(CompositeType composite) {
        boolean isAbstractOrChoice;
        List composites = composite.getComposites();
        ListType listType = composite.getParentList();
        boolean isSimpleGroupWithNestedChoice = false;
        if (!listType.getEditingType().isAbstract() && listType.getTypeClassification() == 193 && (composites = ((SimpleGroup)composite).getAllSimpleChildren()).size() == 0) {
            isSimpleGroupWithNestedChoice = true;
        }
        int compositesSize = composites.size();
        boolean bl = isAbstractOrChoice = listType.getEditingType().isAbstract() || listType.getEditingType().isChoice();
        if (isAbstractOrChoice) {
            compositesSize = 1;
        }
        if (isSimpleGroupWithNestedChoice) {
            compositesSize = 1;
            this._editMode = "panel";
        }
        int lineInfoIndex = 0;
        Type aFESourceType = composite;
        for (int i = 0; i < compositesSize; ++i) {
            aFESourceType = isAbstractOrChoice || isSimpleGroupWithNestedChoice ? composite : (Type)composites.get(i);
            lineInfoIndex = this.addDefaultStructureElementToLineInfo(composite.getParentList(), aFESourceType, lineInfoIndex);
        }
    }

    public void createFormulas(CompositeType composite) {
        if (this.isUsingDefaultRendering()) {
            this.createDefaultFormulasForColumns(composite);
        } else {
            this.createFormulasForColumns(composite);
        }
    }

    private void createFormulasForColumns(CompositeType composite) {
        int lineInfoSize = this.getLineInfos().size();
        for (int i = 0; i < lineInfoSize; ++i) {
            this.addStructureElementToLineInfo(composite.getParentList(), composite, i);
        }
    }

    public String getCancelButtonAlignment() {
        return this._cancelButtonAlignment;
    }

    public Point getDialogLocation() {
        return new Point(this._xDialogPos, this._yDialogPos);
    }

    public void setDialogSize(int dialogWidth, int dialogHeight) {
        this._dialogWidth = dialogWidth;
        this._dialogHeight = dialogHeight;
    }

    public void setDialogLocation(int xDialogPos, int yDialogPos) {
        this._xDialogPos = xDialogPos;
        this._yDialogPos = yDialogPos;
    }

    public Dimension getDialogSize() {
        return new Dimension(this._dialogWidth, this._dialogHeight);
    }

    public String getEditMode() {
        return this._editMode;
    }

    public String getColumnHeaderLabellingStrategy() {
        return this._columnHeaderLabellingStrategy;
    }

    public int getLineDirection() {
        return this._lineDirection;
    }

    public ColumnInfo getLineInfo(int index) {
        return this.getLineInfos().get(index);
    }

    public List<ColumnInfo> getLineInfos() {
        if (this._lineInfos == null) {
            this._lineInfos = new Vector<ColumnInfo>();
        }
        return this._lineInfos;
    }

    public List getLineNames() {
        Vector<String> names = new Vector<String>();
        Iterator<ColumnInfo> iterator = this.getLineInfos().iterator();
        while (iterator.hasNext()) {
            names.add(iterator.next().getName());
        }
        return names;
    }

    public String getOkButtonAlignment() {
        return this._okButtonAlignment;
    }

    public int getOkButtonSeqPos() {
        return this._okButtonSequencePosition;
    }

    public String getTableModelClass() {
        if (this._tableModelClass == null) {
            this._tableModelClass = "com.jaxfront.core.ui.FlipOrientationTableModel";
        }
        return this._tableModelClass;
    }

    public String getTablePosition() {
        return this._tablePosition;
    }

    public int getWidthForLine(int lineNumber) {
        return this.getLineInfo(lineNumber).getLineWidth();
    }

    private void initDialogBounds(String dialogBounds) {
        StringTokenizer tokenizer;
        if (dialogBounds != null && dialogBounds.length() > 0 && (tokenizer = new StringTokenizer(dialogBounds, ",")).hasMoreTokens()) {
            this._xDialogPos = Integer.parseInt(tokenizer.nextToken());
            if (tokenizer.hasMoreTokens()) {
                this._yDialogPos = Integer.parseInt(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    this._dialogWidth = Integer.parseInt(tokenizer.nextToken());
                    if (tokenizer.hasMoreTokens()) {
                        this._dialogHeight = Integer.parseInt(tokenizer.nextToken());
                    }
                }
            }
        }
    }

    private void initDialogButtonSequence(String dialogButtonSequence) {
        StringTokenizer tokenizer;
        if (dialogButtonSequence != null && dialogButtonSequence.length() > 0 && (tokenizer = new StringTokenizer(dialogButtonSequence, "[],")).hasMoreTokens()) {
            String tempButtonName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String tempButtonAlignment = tokenizer.nextToken();
                if (tempButtonName.equals("ok")) {
                    this._okButtonAlignment = tempButtonAlignment;
                    this._okButtonSequencePosition = 0;
                } else {
                    this._cancelButtonAlignment = tempButtonAlignment;
                }
                if (tokenizer.hasMoreTokens()) {
                    tempButtonName = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        tempButtonAlignment = tokenizer.nextToken();
                        if (tempButtonName.equals("ok")) {
                            this._okButtonAlignment = tempButtonAlignment;
                            this._okButtonSequencePosition = 1;
                        } else {
                            this._cancelButtonAlignment = tempButtonAlignment;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void initialize(Type list, Type schemaType) {
        Type editModeChoice;
        super.initialize(list, schemaType);
        Type tableList = list.getChild("UNNAMED1").getChild("table");
        if (tableList == null) {
            tableList = list.getSchemaElement().getSchemaType().getType().getDirectChild("UNNAMED1").getDirectChild("table");
        }
        if ((editModeChoice = tableList.getDirectChild("editMode").getChoosenType()) != null) {
            this._editMode = editModeChoice.getName();
        } else {
            this._useDefaultPanelMode = true;
            if (schemaType.getTypeClassification() == 194) {
                this._editMode = "panel";
            }
        }
        String directionValue = TableInfo.getStringProperty(tableList, schemaType, "direction", null);
        if (this._editMode != null && this._editMode.equals("dialog")) {
            String dialogButtonSequence = editModeChoice.getDirectChildValue("dialogButtonSequence");
            String dialogBounds = editModeChoice.getDirectChildValue("dialogBounds");
            this.initDialogBounds(dialogBounds);
            this.initDialogButtonSequence(dialogButtonSequence);
        }
        this._columnHeaderLabellingStrategy = TableInfo.getStringProperty(tableList, schemaType, "columnHeaderLabellingStrategy", null);
        this._showHeader = TableInfo.getBooleanProperty(tableList, schemaType, "showHeader", null);
        this._showBorder = TableInfo.getBooleanProperty(tableList, schemaType, "showBorder", null);
        this._tablePosition = TableInfo.getStringProperty(tableList, schemaType, "tablePosition", null);
        this._allowFlippingOnTheFly = TableInfo.getBooleanProperty(tableList, schemaType, "allowTableFlippingOnTheFly", null);
        this._cellRendererClass = "com.jaxfront.swing.ui.beans.ZebraCellRenderer";
        try {
            this._tableModelClass = TableInfo.getStringProperty(tableList, schemaType, "tableModelClass", null);
            this._cellRendererClass = TableInfo.getStringProperty(tableList, schemaType, "cellRendererClass", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this._lineDirection = 1;
        boolean showSequenceNumbering = true;
        if (directionValue != null && directionValue.equals("AS_COLUMN")) {
            this._lineDirection = 0;
        }
        ListType lineInfos = (ListType)tableList.getDirectChild("lineInfo");
        this.initializeLineInfos(schemaType, lineInfos);
        if (schemaType.isList() && !((ListType)schemaType).getEditingType().isSimple() && lineInfos.size() == 0) {
            this.createDefaultLineInfos((ListType)schemaType);
        }
        if (this.hasFilter()) {
            this.applyFilter();
        }
    }

    public void initializeLineInfos(Type schemaType, List lineInfos) {
        if (lineInfos.size() > 0) {
            this.setIsDefaultRendering(false);
        }
        this.getLineInfos().clear();
        int defaultWidth = this._defaultWidth;
        for (int i = 0; i < lineInfos.size(); ++i) {
            Type lineInfo = (Type)lineInfos.get(i);
            int lineWidth = defaultWidth;
            boolean editorAlwaysVisible = new Boolean(lineInfo.getDirectChildValue("editorAlwaysVisible"));
            lineWidth = StringUtil.getInt(lineInfo.getDirectChildValue("width"), defaultWidth);
            int hAlign = StringUtil.getInt(lineInfo.getDirectChildValue("hAlign"), -1);
            int vAlign = StringUtil.getInt(lineInfo.getDirectChildValue("vAlign"), -1);
            String cssHeaderStyle = lineInfo.getDirectChildValue("cssHeaderStyle");
            String cssStyle = lineInfo.getDirectChildValue("cssStyle");
            SimpleType formulaExpression = (SimpleType)lineInfo.getDirectChild("formulaExpression");
            SimpleType iconExpression = (SimpleType)lineInfo.getDirectChild("iconExpression");
            boolean allowContextNavigation = new Boolean(lineInfo.getDirectChild("keyContext").getDirectChildValue("allowContextNavigation"));
            SimpleType contextFormEx = (SimpleType)lineInfo.getDirectChild("keyContext").getDirectChild("formulaExpression");
            this.addLineInfo(new ColumnInfo(schemaType, i, null, formulaExpression.getValue(), iconExpression.getValue(), lineWidth, allowContextNavigation, editorAlwaysVisible, contextFormEx.getValue(), hAlign, vAlign, cssHeaderStyle, cssStyle));
        }
    }

    public boolean isDialogEditMode() {
        return this._editMode != null && this._editMode.equals("dialog");
    }

    public boolean isDefaultPanelEditMode() {
        return this._useDefaultPanelMode;
    }

    public void release() {
        this.releaseLineInfos();
    }

    public void releaseLineInfos() {
        this.getLineInfos().clear();
    }

    public int size() {
        return this.getLineInfos().size();
    }

    public void clearLineInfos() {
        for (ColumnInfo aColInfo : this.getLineInfos()) {
            aColInfo.reset();
        }
    }

    public void updateLineInfo(Type type, long modus) {
        Iterator<ColumnInfo> lineInfos = this.getLineInfos().iterator();
        while (lineInfos.hasNext()) {
            lineInfos.next().updateLine(type, modus);
        }
    }

    public void updateLineInfos(ListType listType) {
        Iterator<ColumnInfo> iterator = this.getLineInfos().iterator();
        ColumnInfo colInfo = null;
        while (iterator.hasNext()) {
            colInfo = iterator.next();
            colInfo.setFormulaExpressions(null);
            colInfo.setIconExpressions(null);
        }
        int structureSize = listType.size();
        Type listItem = null;
        for (int i = 0; i < structureSize; ++i) {
            listItem = (Type)listType.get(i);
            if (listItem.isSimple()) {
                this.createFormula((SimpleType)listItem);
                continue;
            }
            this.createFormulas((CompositeType)listItem);
        }
    }

    public TableInfo copy(Type type) {
        TableInfo clone = new TableInfo();
        clone._allowAutoColFit = this._allowAutoColFit;
        clone._altColFitMethod = this._altColFitMethod;
        clone._allowFlippingOnTheFly = this._allowFlippingOnTheFly;
        clone._allowReOrdering = this._allowReOrdering;
        clone._allowSorting = this._allowSorting;
        clone._autoCreateMaxOccurListItems = this._autoCreateMaxOccurListItems;
        clone._autoCreateMinOccurListItems = this._autoCreateMinOccurListItems;
        clone._cancelButtonAlignment = this._cancelButtonAlignment;
        clone._cellRendererClass = this._cellRendererClass;
        clone._columnHeaderLabellingStrategy = this._columnHeaderLabellingStrategy;
        clone._showHeader = this._showHeader;
        clone._showBorder = this._showBorder;
        clone._defaultWidth = this._defaultWidth;
        clone._dialogHeight = this._dialogHeight;
        clone._dialogWidth = this._dialogWidth;
        clone._editMode = this._editMode;
        clone._filter = this._filter;
        clone._isDefaultRendering = this._isDefaultRendering;
        clone._isXUIControlled = this._isXUIControlled;
        clone._lineDirection = this._lineDirection;
        clone._okButtonAlignment = this._okButtonAlignment;
        clone._okButtonSequencePosition = this._okButtonSequencePosition;
        clone._selectionMode = this._selectionMode;
        clone._selectionOnly = this._selectionOnly;
        clone._showButtons = this._showButtons;
        clone._showCopyButton = this._showCopyButton;
        clone._showDeleteButton = this._showDeleteButton;
        clone._showEditButton = this._showEditButton;
        clone._showNewButton = this._showNewButton;
        clone._showSequenceNumbering = this._showSequenceNumbering;
        clone._startupSelection = this._startupSelection;
        clone._tableModelClass = this._tableModelClass;
        clone._tablePosition = this._tablePosition;
        clone._tableSize = this._tableSize;
        clone._uniqueListItemIDPath = this._uniqueListItemIDPath;
        clone._useDefaultPanelMode = this._useDefaultPanelMode;
        clone._useDeletionConfirmation = this._useDeletionConfirmation;
        clone._useZebraLook = this._useZebraLook;
        clone._xDialogPos = this._xDialogPos;
        clone._yDialogPos = this._yDialogPos;
        clone._listType = type;
        clone._tableModelClass = this._tableModelClass;
        clone._tablePosition = this._tablePosition;
        clone._useDefaultPanelMode = this._useDefaultPanelMode;
        int iLineInfos = this.getLineInfos().size();
        if (this.getLineInfos().size() > 0) {
            Type edType = ((ListType)type).getEditingType();
            List edTypeChilds = edType.getDirectChildren();
            int edChildCount = edTypeChilds.size();
            for (int i = 0; i < iLineInfos; ++i) {
                ColumnInfo lineInfo = this.getLineInfos().get(i);
                if (i >= edChildCount) continue;
                Type evalHolderType = null;
                if (this.isUsingDefaultRendering()) {
                    evalHolderType = (Type)edTypeChilds.get(i);
                } else {
                    evalHolderType = lineInfo.evalHolder();
                    if (evalHolderType == null) {
                        evalHolderType = type;
                    }
                }
                ColumnInfo lineInfoCopy = lineInfo.copy(evalHolderType);
                clone.addLineInfo(lineInfoCopy);
            }
        }
        return clone;
    }

    public boolean isPanelEditMode() {
        return this._editMode != null && this._editMode.equals("panel");
    }

    public void createDefaultLineInfos(ListType listType) {
        Type editingType = listType.getEditingType();
        this.getLineInfos().clear();
        if (editingType.isSimple()) {
            ColumnInfo lineInfo = new ColumnInfo(editingType, 0, editingType.getStyle().getLabelText());
            lineInfo.setUsingDefaultRendering(true);
            this.addLineInfo(lineInfo);
        } else {
            CompositeType composite = (CompositeType)editingType;
            if (composite.isAbstract() || composite.isChoice()) {
                String formulaExpression = null;
                ColumnInfo lineInfo = new ColumnInfo(composite, 0, composite.getVisualName(), formulaExpression);
                lineInfo.setUsingDefaultRendering(true);
                this.addLineInfo(lineInfo);
            } else {
                Iterator compositeIterator = composite.getComposites().iterator();
                if (listType.getTypeClassification() == 193) {
                    compositeIterator = ((SimpleGroup)listType.getEditingType()).getAllSimpleChildren().iterator();
                }
                int counter = 0;
                while (compositeIterator.hasNext()) {
                    Type type = (Type)compositeIterator.next();
                    if (!type.getStyle().isVisible()) continue;
                    ColumnInfo lineInfo = new ColumnInfo(type, counter, type.getStyle().getLabelText());
                    lineInfo.setUsingDefaultRendering(true);
                    this.addLineInfo(lineInfo);
                    ++counter;
                }
            }
        }
        if (this.size() == 0) {
            this.addLineInfo(new ColumnInfo(editingType, 0, "no name"));
        }
    }

    @Override
    public boolean isShowingButtons() {
        if (this.isSelectionOnly()) {
            return false;
        }
        return super.isShowingButtons();
    }

    private void applyFilter() {
        block5: {
            String filter = this.getFilter();
            FormulaExpression filterExpression = new FormulaExpression(this.getListType(), filter);
            try {
                Object result = filterExpression.evaluateObject();
                if (result instanceof List) {
                    List arrayResult = (List)result;
                    if (arrayResult.size() > 0) {
                        Iterator iterator = arrayResult.iterator();
                        int index = -1;
                        Type type = null;
                        while (iterator.hasNext()) {
                            type = (Type)iterator.next();
                            index = ((ListType)this.getListType()).getList().indexOf(type);
                            if (index == -1) continue;
                            type.putClientProperty("listItem-disabled", "");
                        }
                    }
                    break block5;
                }
                throw new FormulaException(new Exception("Formula does not return a nodeSet (ArrayResult). Use formula: nodes(...)"));
            }
            catch (FormulaException e) {
                LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("Error while executing formula (").append(filter).append("). Reason: ").append(e.getLocalizedMessage()).toString());
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        TableInfo clone = (TableInfo)super.clone();
        if (this._lineInfos != null) {
            List<ColumnInfo> lis = this.getLineInfos();
            Vector<ColumnInfo> clonedLi = new Vector<ColumnInfo>(lis.size());
            for (int i = 0; i < lis.size(); ++i) {
                ColumnInfo aLi = lis.get(i);
                clonedLi.add((ColumnInfo)aLi.clone());
            }
            clone._lineInfos = clonedLi;
        }
        return clone;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append(new StringBuffer().append(" -> TableInfo Listtype:").append(this._listType.getXPathLocation()).toString());
        if (this._lineInfos != null) {
            List<ColumnInfo> lis = this.getLineInfos();
            Vector clonedLi = new Vector(lis.size());
            for (int i = 0; i < lis.size(); ++i) {
                ColumnInfo aLi = lis.get(i);
                toString.append(new StringBuffer().append("\n").append(aLi.toString()).toString());
            }
        }
        return toString.toString();
    }

    protected void update(Type aType) {
        this._listType = aType;
        if (this._lineInfos != null) {
            List<ColumnInfo> lis = this.getLineInfos();
            for (int i = 0; i < lis.size(); ++i) {
                ColumnInfo aLi = lis.get(i);
                aLi.setHolder(aType);
            }
        }
    }
}

