/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NULL;

public class SquareRoot
extends PostfixMathCommand {
    public SquareRoot() {
        this.numberOfParameters = 1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.sqrt(param));
    }

    public Object sqrt(Object param) throws ParseException {
        if (param == NULL._null) {
            param = new Integer(0);
        }
        if (param instanceof Number) {
            double value = ((Number)param).doubleValue();
            if (value < 0.0) {
                return new Complex(value).sqrt();
            }
            return new Double(Math.sqrt(value));
        }
        if (param instanceof Complex) {
            return ((Complex)param).sqrt();
        }
        throw new ParseException("Invalid parameter type: " + param);
    }
}

