/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.rubberband.demo;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.java.swingfx.rubberband.canvas.RubberBandCanvas;
import net.java.swingfx.rubberband.rubberbands.AnimatedRectangularRubberBand;
import net.java.swingfx.rubberband.rubberbands.OvalRubberBand;
import net.java.swingfx.rubberband.rubberbands.RectangularRubberBand;
import net.java.swingfx.rubberband.rubberbands.RubberBand;

public class Main {
    private static final Dimension SIZE = new Dimension(300, 300);

    public static void main(String[] args) {
        MyPanel canvas = new MyPanel();
        RectangularRubberBand rb = new RectangularRubberBand(canvas);
        JFrame f = new JFrame("Rubber Band Demo");
        f.setDefaultCloseOperation(3);
        f.setSize(SIZE);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = scrSize.width / 2 - Main.SIZE.width / 2;
        int y = scrSize.height / 2 - Main.SIZE.height / 2;
        f.setLocation(x, y);
        f.getContentPane().add(canvas.getCanvas());
        f.setVisible(true);
    }

    private static class MyPanel
    extends JPanel
    implements RubberBandCanvas,
    ActionListener {
        private static final long serialVersionUID = 3256445806658466864L;
        private RubberBand rubberband;
        private JRadioButton radioRect = new JRadioButton("Rectangle");
        private JRadioButton radioOval;
        private JRadioButton radioAnimRect;

        public MyPanel() {
            this.radioRect.setSelected(true);
            this.radioRect.addActionListener(this);
            this.radioOval = new JRadioButton("Oval");
            this.radioOval.addActionListener(this);
            this.radioAnimRect = new JRadioButton("Animated Rectangle");
            this.radioAnimRect.addActionListener(this);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.radioRect);
            bg.add(this.radioOval);
            bg.add(this.radioAnimRect);
            this.add(this.radioRect);
            this.add(this.radioOval);
            this.add(this.radioAnimRect);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.rubberband.draw(g);
        }

        @Override
        public void setRubberBand(RubberBand rubberband) {
            this.rubberband = rubberband;
        }

        @Override
        public JComponent getCanvas() {
            return this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.radioRect.isSelected()) {
                this.rubberband = new RectangularRubberBand(this);
            } else if (this.radioOval.isSelected()) {
                this.rubberband = new OvalRubberBand(this);
            } else if (this.radioAnimRect.isSelected()) {
                this.rubberband = new AnimatedRectangularRubberBand(this);
            }
        }
    }
}

