/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import java.util.Hashtable;
import java.util.Map;

public class Attributes {
    private Hashtable<Object, String> ht;

    public Attributes() {
        this.ht = new Hashtable();
    }

    public Attributes(Attributes a) {
        this.ht = new Hashtable<Object, String>(a.ht);
    }

    public void setBoolean(String name, boolean value) {
        if (value) {
            this.ht.put(name, "");
        } else {
            this.ht.remove(name);
        }
    }

    public boolean getBoolean(String name) {
        return this.ht.get(name) != null;
    }

    public void setInt(String name, int value) {
        this.ht.put(name, Integer.toString(value));
    }

    public int getInt(String name) {
        String o = this.ht.get(name);
        if (o == null) {
            return 0;
        }
        try {
            return Integer.parseInt(o);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setString(String name, String value) {
        this.ht.put(name, value);
    }

    public String getString(String name) {
        return this.ht.get(name);
    }

    public void unset(String name) {
        this.ht.remove(name);
    }

    public Map<Object, String> getAll() {
        return new Hashtable<Object, String>(this.ht);
    }
}

