/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Attributes;
import gov.nasa.ltl.graph.Guard;
import gov.nasa.ltl.graph.Node;

public class Edge<PropT> {
    private Node<PropT> source;
    private Node<PropT> next;
    private Guard<PropT> guard;
    private String action;
    private Attributes attributes;

    public Edge(Node<PropT> s, Node<PropT> n, Guard<PropT> g, String a, Attributes as) {
        this.init(s, n, g, a, as);
    }

    public Edge(Node<PropT> s, Node<PropT> n, Guard<PropT> g, String a) {
        this.init(s, n, g, a, null);
    }

    public Edge(Node<PropT> s, Node<PropT> n, Guard<PropT> g) {
        this.init(s, n, g, "-", null);
    }

    public Edge(Node<PropT> s, Node<PropT> n) {
        this.init(s, n, new Guard(), "-", null);
    }

    public Edge(Node<PropT> s, Edge<PropT> e) {
        this.init(s, e.next, e.guard, e.action, new Attributes(e.attributes));
    }

    public Edge(Edge<PropT> e, Node<PropT> n) {
        this.init(e.source, n, e.guard, e.action, new Attributes(e.attributes));
    }

    public Edge(Edge<PropT> e) {
        this.init(e.source, e.next, e.guard, e.action, new Attributes(e.attributes));
    }

    public String getAction() {
        return this.action;
    }

    public synchronized void setAttributes(Attributes a) {
        this.attributes = new Attributes(a);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setBooleanAttribute(String name, boolean value) {
        this.attributes.setBoolean(name, value);
    }

    public boolean getBooleanAttribute(String name) {
        return this.attributes.getBoolean(name);
    }

    public Guard<PropT> getGuard() {
        return this.guard;
    }

    public void setIntAttribute(String name, int value) {
        this.attributes.setInt(name, value);
    }

    public int getIntAttribute(String name) {
        return this.attributes.getInt(name);
    }

    public Node<PropT> getNext() {
        return this.next;
    }

    public Node<PropT> getSource() {
        return this.source;
    }

    public void setStringAttribute(String name, String value) {
        this.attributes.setString(name, value);
    }

    public String getStringAttribute(String name) {
        return this.attributes.getString(name);
    }

    public synchronized void remove() {
        this.source.removeOutgoingEdge(this);
        this.next.removeIncomingEdge(this);
    }

    private void init(Node<PropT> s, Node<PropT> n, Guard<PropT> g, String a, Attributes as) {
        this.source = s;
        this.next = n;
        this.guard = g;
        this.action = a;
        this.attributes = as == null ? new Attributes() : as;
        s.addOutgoingEdge(this);
        n.addIncomingEdge(this);
    }
}

