/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graphio;

import gov.nasa.ltl.graph.Attributes;
import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Literal;
import gov.nasa.ltl.graph.Node;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Reader {
    public static Graph<String> read(BufferedReader in) throws IOException {
        int ns = Reader.readInt(in);
        Node[] nodes = new Node[ns];
        Graph<String> g = new Graph<String>(Reader.readAttributes(in));
        int i = 0;
        while (i < ns) {
            int nt = Reader.readInt(in);
            if (nodes[i] == null) {
                nodes[i] = new Node<String>(g, Reader.readAttributes(in));
            } else {
                nodes[i].setAttributes(Reader.readAttributes(in));
            }
            int j = 0;
            while (j < nt) {
                int nxt = Reader.readInt(in);
                String gu = Reader.readString(in);
                Guard guard = new Guard(gu);
                String ac = Reader.readString(in);
                if (nodes[nxt] == null) {
                    nodes[nxt] = new Node<String>(g);
                }
                new Edge<String>(nodes[i], nodes[nxt], guard, ac, Reader.readAttributes(in));
                ++j;
            }
            ++i;
        }
        g.number();
        return g;
    }

    public static Graph<String> read() throws IOException {
        return Reader.read(new BufferedReader(new InputStreamReader(System.in)));
    }

    public static Graph<String> read(String filename) throws IOException {
        return Reader.read(new BufferedReader(new FileReader(filename)));
    }

    private static Attributes readAttributes(BufferedReader in) throws IOException {
        String line = Reader.readLine(in);
        Attributes attr = new Attributes();
        String[] stringArray = line.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String key;
            String a = stringArray[n2];
            int eq = a.indexOf(61);
            if (eq != -1) {
                key = a.substring(0, eq);
                value = a.substring(eq + 1);
            } else {
                key = a;
                value = "";
            }
            attr.setString(key, value);
            ++n2;
        }
        return attr;
    }

    private static int readInt(BufferedReader in) throws IOException {
        return Integer.parseInt(Reader.readLine(in));
    }

    private static String readLine(BufferedReader in) throws IOException {
        String line;
        do {
            int idx;
            if ((idx = (line = in.readLine()).indexOf(35)) == -1) continue;
            line = line.substring(0, idx);
        } while ((line = line.trim()).length() == 0);
        return line;
    }

    private static String readString(BufferedReader in) throws IOException {
        return Reader.readLine(in);
    }

    private static class Guard
    extends gov.nasa.ltl.graph.Guard<String> {
        private static final long serialVersionUID = -4427343445274801521L;

        public Guard(String formula) {
            String[] stringArray = formula.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (!(token = token.trim()).equals("TRUE")) {
                    if (token.substring(0, 1).equals("!")) {
                        this.add(new Literal<String>(token.substring(1).trim(), true));
                    } else {
                        this.add(new Literal<String>(token.trim(), false));
                    }
                }
                ++n2;
            }
        }
    }
}

