/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graphio;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Guard;
import gov.nasa.ltl.graph.Literal;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graphio.Writer;
import gov.nasa.ltl.trans.State;
import gov.nasa.ltl.trans.Transition;
import java.io.PrintStream;
import java.util.Map;

class SMWriter<PropT>
extends Writer<PropT> {
    protected PrintStream out;

    SMWriter(PrintStream s) {
        this.out = s;
    }

    @Override
    public void write(Graph<PropT> g) {
        boolean first = true;
        Map<Object, String> attr = g.getAttributes().getAll();
        this.out.println(g.getNodeCount());
        for (Object object : attr.keySet()) {
            if (first) {
                first = false;
            } else {
                this.out.print(',');
            }
            this.out.print(object);
            if (attr.get(object) == null || attr.get(object).equals("")) continue;
            this.out.print('=');
            this.out.print(attr.get(object));
        }
        this.out.println();
        if (g.getInit() != null) {
            this.write(g.getInit());
        }
        for (Node node : g.getNodes()) {
            if (node == g.getInit()) continue;
            this.write(node);
        }
    }

    @Override
    public void write(Node<PropT> n) {
        Map<Object, String> attr = n.getAttributes().getAll();
        boolean first = true;
        this.out.print("  " + n.getOutgoingEdgeCount() + "  ");
        for (Object object : attr.keySet()) {
            if (object.equals("_id")) continue;
            if (first) {
                first = false;
            } else {
                this.out.print(',');
            }
            this.out.print(object);
            if (attr.get(object) == null || attr.get(object).equals("")) continue;
            this.out.print('=');
            this.out.print(attr.get(object));
        }
        this.out.println();
        for (Edge edge : n.getOutgoingEdges()) {
            this.write(edge);
        }
    }

    @Override
    public void write(Edge<PropT> e) {
        Map<Object, String> attr = e.getAttributes().getAll();
        boolean first = true;
        this.out.println("    " + e.getNext().getId());
        this.out.print("    ");
        this.write(e.getGuard());
        this.out.println("    " + e.getAction());
        this.out.print("    ");
        for (Object key : attr.keySet()) {
            if (first) {
                first = false;
            } else {
                this.out.print(',');
            }
            this.out.print(key);
            if (attr.get(key) == null || attr.get(key).equals("")) continue;
            this.out.print('=');
            this.out.print(attr.get(key));
        }
        this.out.println();
    }

    @Override
    public void write(State<PropT>[] states) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(State<PropT> s) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(Transition<PropT> t) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(Guard<PropT> g) {
        boolean first = true;
        if (g.isTrue()) {
            this.out.print("TRUE");
            return;
        }
        for (Literal literal : g) {
            if (first) {
                first = false;
            } else {
                this.out.print('&');
            }
            this.write(literal);
        }
    }

    @Override
    public void write(Literal<PropT> l) {
        if (l.isNegated()) {
            this.out.print('!');
        }
        this.out.print(l.getAtom());
    }
}

