/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.tests;

import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.ParseErrorException;
import gov.nasa.ltl.trans.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Rewriter {
    private static int osize = 0;
    private static int rsize = 0;

    public static void main(String[] args) {
        if (args.length != 0) {
            Rewriter.readArgs(args);
        } else {
            Rewriter.readStream(System.in);
        }
    }

    private static void readArgs(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            Rewriter.rewrite(f);
            ++n2;
        }
    }

    private static void readStream(InputStream in) {
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        String line = "";
        while (line != null) {
            if (!line.equals("")) {
                Rewriter.rewrite(line);
            }
            try {
                line = r.readLine();
            }
            catch (IOException e) {
                System.err.println("Input error " + e);
                System.exit(1);
            }
        }
    }

    private static void rewrite(String formula) {
        Formula<String> f;
        try {
            f = Parser.parse(formula);
        }
        catch (ParseErrorException e) {
            System.err.println("Parse error on " + formula + ":" + e);
            return;
        }
        osize += f.size();
        f = new gov.nasa.ltl.trans.Rewriter<String>(f).rewrite();
        System.err.println(String.valueOf((rsize += f.size()) * 100 / osize) + "% (" + osize + " => " + rsize + ")");
    }
}

