/*
 * Decompiled with CFR 0.152.
 */
package apple.dts.samplecode.osxadapter;

import apple.dts.samplecode.osxadapter.OSXAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class MyApp
extends JFrame
implements ActionListener {
    protected JDialog aboutBox;
    protected JDialog prefs;
    protected JLabel imageLabel;
    protected JComboBox colorComboBox;
    protected JMenu fileMenu;
    protected JMenu helpMenu;
    protected JMenuItem openMI;
    protected JMenuItem optionsMI;
    protected JMenuItem quitMI;
    protected JMenuItem docsMI;
    protected JMenuItem supportMI;
    protected JMenuItem aboutMI;
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    protected BufferedImage currentImage;
    Color[] colors = new Color[]{Color.WHITE, Color.BLACK, Color.RED, Color.BLUE, Color.YELLOW, Color.ORANGE};
    String[] colorNames = new String[]{"White", "Black", "Red", "Blue", "Yellow", "Orange"};
    static final int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public MyApp() {
        super("OSXAdapter");
        this.addMenus();
        this.getContentPane().setLayout(new BorderLayout());
        this.imageLabel = new JLabel("Open an image to view it");
        this.getContentPane().add(this.imageLabel);
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setVerticalAlignment(0);
        this.imageLabel.setOpaque(true);
        this.aboutBox = new JDialog((Frame)this, "About OSXAdapter");
        this.aboutBox.getContentPane().setLayout(new BorderLayout());
        this.aboutBox.getContentPane().add(new JLabel("OSXAdapter", 0));
        this.aboutBox.getContentPane().add((Component)new JLabel("\u00a92003-2007 Apple, Inc.", 0), "South");
        this.aboutBox.setSize(160, 120);
        this.aboutBox.setResizable(false);
        this.prefs = new JDialog((Frame)this, "OSXAdapter Preferences");
        this.colorComboBox = new JComboBox<String>(this.colorNames);
        this.colorComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (MyApp.this.currentImage != null) {
                    MyApp.this.imageLabel.setBackground(MyApp.this.colors[MyApp.this.colorComboBox.getSelectedIndex()]);
                }
            }
        });
        JPanel masterPanel = new JPanel();
        masterPanel.setBorder(new TitledBorder("Window background color:"));
        masterPanel.add(this.colorComboBox);
        this.prefs.getContentPane().add(masterPanel);
        this.prefs.setSize(240, 100);
        this.prefs.setResizable(false);
        this.registerForMacOSXEvents();
        this.setSize(320, 240);
    }

    public void registerForMacOSXEvents() {
        if (MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quit", null));
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("about", null));
                OSXAdapter.setPreferencesHandler(this, this.getClass().getDeclaredMethod("preferences", null));
                OSXAdapter.setFileHandler(this, this.getClass().getDeclaredMethod("loadImageFile", String.class));
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public void about() {
        this.aboutBox.setLocation((int)this.getLocation().getX() + 22, (int)this.getLocation().getY() + 22);
        this.aboutBox.setVisible(true);
    }

    public void preferences() {
        this.prefs.setLocation((int)this.getLocation().getX() + 22, (int)this.getLocation().getY() + 22);
        this.prefs.setVisible(true);
    }

    public boolean quit() {
        int option = JOptionPane.showConfirmDialog(this, "Are you sure you want to quit?", "Quit?", 0);
        return option == 0;
    }

    public void addMenus() {
        JMenu fileMenu = new JMenu("File");
        JMenuBar mainMenuBar = new JMenuBar();
        fileMenu = new JMenu("File");
        mainMenuBar.add(fileMenu);
        this.openMI = new JMenuItem("Open...");
        fileMenu.add(this.openMI);
        this.openMI.setAccelerator(KeyStroke.getKeyStroke(79, MENU_MASK));
        this.openMI.addActionListener(this);
        if (!MAC_OS_X) {
            fileMenu.addSeparator();
            this.optionsMI = new JMenuItem("Options");
            fileMenu.add(this.optionsMI);
            this.optionsMI.addActionListener(this);
            fileMenu.addSeparator();
            this.quitMI = new JMenuItem("Quit");
            fileMenu.add(this.quitMI);
            this.quitMI.setAccelerator(KeyStroke.getKeyStroke(81, MENU_MASK));
            this.quitMI.addActionListener(this);
        }
        this.helpMenu = new JMenu("Help");
        mainMenuBar.add(this.helpMenu);
        this.docsMI = new JMenuItem("Online Documentation");
        this.helpMenu.add(this.docsMI);
        this.helpMenu.addSeparator();
        this.supportMI = new JMenuItem("Technical Support");
        this.helpMenu.add(this.supportMI);
        if (!MAC_OS_X) {
            this.helpMenu.addSeparator();
            this.aboutMI = new JMenuItem("About OSXAdapter");
            this.helpMenu.add(this.aboutMI);
            this.aboutMI.addActionListener(this);
        }
        this.setJMenuBar(mainMenuBar);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.quitMI) {
            this.quit();
        } else if (source == this.optionsMI) {
            this.preferences();
        } else if (source == this.aboutMI) {
            this.about();
        } else if (source == this.openMI) {
            FileDialog openDialog = new FileDialog(this);
            openDialog.setMode(0);
            openDialog.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    String[] supportedFiles = ImageIO.getReaderFormatNames();
                    for (int i = 0; i < supportedFiles.length; ++i) {
                        if (!name.endsWith(supportedFiles[i])) continue;
                        return true;
                    }
                    return false;
                }
            });
            openDialog.setVisible(true);
            String filePath = openDialog.getDirectory() + openDialog.getFile();
            if (filePath != null) {
                this.loadImageFile(filePath);
            }
        }
    }

    public void loadImageFile(String path) {
        try {
            this.currentImage = ImageIO.read(new File(path));
            this.imageLabel.setIcon(new ImageIcon(this.currentImage));
            this.imageLabel.setBackground(this.colors[this.colorComboBox.getSelectedIndex()]);
            this.imageLabel.setText("");
        }
        catch (IOException ioe) {
            System.out.println("Could not load image " + path);
        }
        this.repaint();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new MyApp().setVisible(true);
            }
        });
    }
}

