/* GROOVE: GRaphs for Object Oriented VErification
 * Copyright 2003--2011 University of Twente
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific 
 * language governing permissions and limitations under the License.
 *
 * $Id$
 */
package com.alexmerz.graphviz.objects;

import java.util.HashSet;
import java.util.Set;

public class Attribute {
    private static Set<String> keywords = new HashSet<String>();
    static {
        keywords.add("strict");
        keywords.add("graph");
        keywords.add("digraph");
        keywords.add("subgraph");
        keywords.add("node");
        keywords.add("edge");
    }

    private String stringRep;

    public Attribute(String key, String value) {
        if (requireQuote(key)) {
            stringRep = "\"" + key + "\"";
        } else {
            stringRep = key;
        }
        if (!value.equals("")) {
            stringRep += "=";
            if (requireQuote(value)) {
                stringRep += "\"" + value + "\"";
            } else {
                stringRep += value;
            }
        }
    }

    @Override
    public String toString() {
        return stringRep;
    }

    private boolean requireQuote(String ID) {
        if (ID.equals("")) {
            return false;
        }

        for (String keyword : keywords) {
            if (ID.toLowerCase().equals(keyword)) {
                return true;
            }
        }

        // number
        if (ID.matches("-?(\\.[0-9]+|[0-9]+(.[0-9]*)?)")) {
            return false;
        }

        // string
        if (ID.matches("[a-zA-Z\200-\377_][a-zA-Z\200-\377_0-9]*")) {
            return false;
        }

        return true;
    }
}
