/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.PrintStream;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocStyle {
    private static final int PAGE_MARGINS = 36;
    private static final double MM_TO_POINTS_SCALER = 2.834645669291339;
    public static final String XML_NODE_NAME = "docstyle";
    private static final String XML_PAPER_NODE_NAME = "paper";
    private static final String XML_PAPER_ORI_NODE_NAME = "orientation";
    private static final String XML_PAPER_XSIZE_NODE_NAME = "xsize";
    private static final String XML_PAPER_YSIZE_NODE_NAME = "ysize";
    private static final String XML_PAPER_X_NODE_NAME = "x";
    private static final String XML_PAPER_Y_NODE_NAME = "y";
    private static final String XML_PAPER_W_NODE_NAME = "w";
    private static final String XML_PAPER_H_NODE_NAME = "h";
    private static final String XML_PAGE_STYLE_NODE_NAME = "pagestyle";
    private static final String XML_STAMP_STYLE_NODE_NAME = "stampstyle";
    private static final String XML_TEXT_STYLE_NODE_NAME = "textstyle";
    private static final String XML_HORI_ALIGN_NODE_NAME = "horialign";
    private static final String XML_VERT_ALIGN_NODE_NAME = "vertalign";
    private static final String XML_IMAGE_SCALE_NODE_NAME = "imagescale";
    private static final String XML_BORDER_NODE_NAME = "border";
    private static final String XML_BORDER_TYPE_NODE_NAME = "bordertype";
    private static final Dimension A4_page = new Dimension(210, 297);
    private Vector<HorizontalAlign> stampTextHorizontalAligns = new Vector();
    private Vector<VerticalAlign> stampTextVerticalAligns = new Vector();
    private int stampImageScale;
    private BorderStyle pageBorderStyle = BorderStyle.LEGACY;
    private ImageColouring stampImageColouring = ImageColouring.GRAYSCALE;
    private Paper paper = new Paper();
    private PageFormat pageFormat = new PageFormat();

    public DocStyle() {
        this.setDefaultPageFormat();
        this.stampTextHorizontalAligns.add(this.getStampTextHorizontalAlign(0));
        this.stampTextHorizontalAligns.add(this.getStampTextHorizontalAlign(1));
        this.stampTextHorizontalAligns.add(this.getStampTextHorizontalAlign(2));
        this.stampTextVerticalAligns.add(this.getStampTextVerticalAlign(0));
        this.stampTextVerticalAligns.add(this.getStampTextVerticalAlign(1));
        this.stampTextVerticalAligns.add(this.getStampTextVerticalAlign(2));
        this.stampImageScale = 90;
    }

    public DocStyle(DocStyle docStyle) {
        this.setDefaultPageFormat();
        this.stampTextHorizontalAligns.add(docStyle.getStampTextHorizontalAlign(0));
        this.stampTextHorizontalAligns.add(docStyle.getStampTextHorizontalAlign(1));
        this.stampTextHorizontalAligns.add(docStyle.getStampTextHorizontalAlign(2));
        this.stampTextVerticalAligns.add(docStyle.getStampTextVerticalAlign(0));
        this.stampTextVerticalAligns.add(docStyle.getStampTextVerticalAlign(1));
        this.stampTextVerticalAligns.add(docStyle.getStampTextVerticalAlign(2));
        this.stampImageScale = docStyle.getStampImageScaler();
        this.stampImageColouring = docStyle.stampImageColouring;
    }

    public DocStyle(Node node) {
        this.setDefaultPageFormat();
        this.readDocStyleNode(node);
    }

    private void setDefaultPageFormat() {
        double d = 2.834645669291339 * (double)DocStyle.A4_page.width;
        double d2 = 2.834645669291339 * (double)DocStyle.A4_page.height;
        this.paper.setSize(d, d2);
        this.paper.setImageableArea(36.0, 36.0, d - 72.0, d2 - 72.0);
        this.pageFormat.setOrientation(1);
        this.pageFormat.setPaper(this.paper);
    }

    public PageFormat getPageFormat() {
        this.pageFormat.setPaper(this.paper);
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.paper = pageFormat.getPaper();
    }

    public void readDocStyleNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.compareTo(XML_STAMP_STYLE_NODE_NAME) == 0) {
                this.readStampStyleNode(node2);
                continue;
            }
            if (string.compareTo(XML_PAPER_NODE_NAME) == 0) {
                this.readPaperNode(node2);
                continue;
            }
            if (string.compareTo(XML_PAGE_STYLE_NODE_NAME) != 0) continue;
            this.readPageStyleNode(node2);
        }
    }

    private void readPaperNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = 1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.compareTo(XML_PAPER_ORI_NODE_NAME) == 0) {
                n7 = this.readPaperOrientationNode(node2);
                continue;
            }
            if (string.compareTo(XML_PAPER_XSIZE_NODE_NAME) == 0) {
                n = Integer.parseInt(node2.getTextContent().trim());
                continue;
            }
            if (string.compareTo(XML_PAPER_YSIZE_NODE_NAME) == 0) {
                n2 = Integer.parseInt(node2.getTextContent().trim());
                continue;
            }
            if (string.compareTo(XML_PAPER_X_NODE_NAME) == 0) {
                n3 = Integer.parseInt(node2.getTextContent().trim());
                continue;
            }
            if (string.compareTo(XML_PAPER_Y_NODE_NAME) == 0) {
                n4 = Integer.parseInt(node2.getTextContent().trim());
                continue;
            }
            if (string.compareTo(XML_PAPER_W_NODE_NAME) == 0) {
                n5 = Integer.parseInt(node2.getTextContent().trim());
                continue;
            }
            if (string.compareTo(XML_PAPER_H_NODE_NAME) != 0) continue;
            n6 = Integer.parseInt(node2.getTextContent().trim());
        }
        if (n != -1 && n2 != -1 && n3 != -1 && n4 != -1 && n5 != -1 && n6 != -1) {
            this.paper.setSize(n, n2);
            this.paper.setImageableArea(n3, n4, n5, n6);
            this.pageFormat.setOrientation(n7);
            this.pageFormat.setPaper(this.paper);
        }
    }

    private int readPaperOrientationNode(Node node) {
        String string = node.getTextContent().trim();
        int n = string.compareTo("portrait") == 0 ? 1 : (string.compareTo("landscape") == 0 ? 0 : 1);
        return n;
    }

    private void readPageStyleNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().compareTo(XML_BORDER_NODE_NAME) != 0) continue;
            this.setPageBorderStyle(this.readBorderNode(nodeList.item(i)));
        }
    }

    private BorderStyle readBorderNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().compareTo(XML_BORDER_TYPE_NODE_NAME) != 0) continue;
            return this.readBorderTypeNode(nodeList.item(i));
        }
        return BorderStyle.LEGACY;
    }

    private BorderStyle readBorderTypeNode(Node node) {
        String string = node.getTextContent().trim();
        BorderStyle borderStyle = string.compareTo(BorderStyle.NONE.name()) == 0 ? BorderStyle.NONE : (string.compareTo(BorderStyle.SIMPLE.name()) == 0 ? BorderStyle.SIMPLE : BorderStyle.LEGACY);
        return borderStyle;
    }

    private void readStampStyleNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().compareTo(XML_TEXT_STYLE_NODE_NAME) == 0) {
                this.readStampTextStyleNode(nodeList.item(i), n++);
            }
            if (nodeList.item(i).getNodeName().compareTo(XML_IMAGE_SCALE_NODE_NAME) != 0) continue;
            this.readImageScaleNode(nodeList.item(i));
        }
    }

    private void readImageScaleNode(Node node) {
        String string = node.getTextContent();
        this.setStampImageScaler(Integer.parseInt(string.trim()));
    }

    private void readStampTextStyleNode(Node node, int n) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getTextContent();
            if (node2.getNodeName().compareTo(XML_HORI_ALIGN_NODE_NAME) == 0) {
                if (string.compareTo(HorizontalAlign.LEFT.toString()) == 0) {
                    this.setStampTextHorizontalAlign(n, HorizontalAlign.LEFT);
                }
                if (string.compareTo(HorizontalAlign.CENTER.toString()) == 0) {
                    this.setStampTextHorizontalAlign(n, HorizontalAlign.CENTER);
                }
                if (string.compareTo(HorizontalAlign.RIGHT.toString()) == 0) {
                    this.setStampTextHorizontalAlign(n, HorizontalAlign.RIGHT);
                }
            }
            if (node2.getNodeName().compareTo(XML_VERT_ALIGN_NODE_NAME) != 0) continue;
            if (string.compareTo(VerticalAlign.TOP.toString()) == 0) {
                this.setStampTextVerticalAlign(n, VerticalAlign.TOP);
            }
            if (string.compareTo(VerticalAlign.CENTER.toString()) == 0) {
                this.setStampTextVerticalAlign(n, VerticalAlign.CENTER);
            }
            if (string.compareTo(VerticalAlign.BOTTOM.toString()) != 0) continue;
            this.setStampTextVerticalAlign(n, VerticalAlign.BOTTOM);
        }
    }

    private void stampTextsToXml(PrintStream printStream, String string) {
        string = string + "  ";
        for (int i = 0; i < 3; ++i) {
            printStream.println(string + "<" + XML_TEXT_STYLE_NODE_NAME + ">");
            printStream.println(string + "  <" + XML_HORI_ALIGN_NODE_NAME + ">" + (Object)((Object)this.getStampTextHorizontalAlign(i)) + "</" + XML_HORI_ALIGN_NODE_NAME + ">");
            printStream.println(string + "  <" + XML_VERT_ALIGN_NODE_NAME + ">" + (Object)((Object)this.getStampTextVerticalAlign(i)) + "</" + XML_VERT_ALIGN_NODE_NAME + ">");
            printStream.println(string + "</" + XML_TEXT_STYLE_NODE_NAME + ">");
        }
    }

    public void toXml(PrintStream printStream, String string) {
        string = string + "  ";
        printStream.println(string + "<" + XML_NODE_NAME + ">");
        printStream.println(string + "  <" + XML_PAPER_NODE_NAME + ">");
        printStream.println(string + "    <" + XML_PAPER_XSIZE_NODE_NAME + ">" + (int)this.paper.getWidth() + "</" + XML_PAPER_XSIZE_NODE_NAME + ">");
        printStream.println(string + "    <" + XML_PAPER_YSIZE_NODE_NAME + ">" + (int)this.paper.getHeight() + "</" + XML_PAPER_YSIZE_NODE_NAME + ">");
        printStream.println(string + "    <" + XML_PAPER_X_NODE_NAME + ">" + (int)this.paper.getImageableX() + "</" + XML_PAPER_X_NODE_NAME + ">");
        printStream.println(string + "    <" + XML_PAPER_Y_NODE_NAME + ">" + (int)this.paper.getImageableY() + "</" + XML_PAPER_Y_NODE_NAME + ">");
        printStream.println(string + "    <" + XML_PAPER_W_NODE_NAME + ">" + (int)this.paper.getImageableWidth() + "</" + XML_PAPER_W_NODE_NAME + ">");
        printStream.println(string + "    <" + XML_PAPER_H_NODE_NAME + ">" + (int)this.paper.getImageableHeight() + "</" + XML_PAPER_H_NODE_NAME + ">");
        printStream.println(string + "    <" + XML_PAPER_ORI_NODE_NAME + ">" + (this.pageFormat.getOrientation() == 1 ? "portrait" : "landscape") + "</" + XML_PAPER_ORI_NODE_NAME + ">");
        printStream.println(string + "  </" + XML_PAPER_NODE_NAME + ">");
        printStream.println(string + "  <" + XML_PAGE_STYLE_NODE_NAME + ">");
        printStream.println(string + "    <" + XML_BORDER_NODE_NAME + ">");
        printStream.println(string + "      <" + XML_BORDER_TYPE_NODE_NAME + ">" + (Object)((Object)this.getPageBorderStyle()) + "</" + XML_BORDER_TYPE_NODE_NAME + ">");
        printStream.println(string + "    </" + XML_BORDER_NODE_NAME + ">");
        printStream.println(string + "  </" + XML_PAGE_STYLE_NODE_NAME + ">");
        printStream.println(string + "  <" + XML_STAMP_STYLE_NODE_NAME + ">");
        printStream.println(string + "    <" + XML_IMAGE_SCALE_NODE_NAME + ">" + this.getStampImageScaler() + "</" + XML_IMAGE_SCALE_NODE_NAME + ">");
        this.stampTextsToXml(printStream, string + "  ");
        printStream.println(string + "  </" + XML_STAMP_STYLE_NODE_NAME + ">");
        printStream.println(string + "</" + XML_NODE_NAME + ">");
    }

    public HorizontalAlign getStampTextHorizontalAlign(int n) {
        if (n < this.stampTextHorizontalAligns.size()) {
            return this.stampTextHorizontalAligns.elementAt(n);
        }
        return HorizontalAlign.CENTER;
    }

    public VerticalAlign getStampTextVerticalAlign(int n) {
        if (n < this.stampTextVerticalAligns.size()) {
            return this.stampTextVerticalAligns.elementAt(n);
        }
        return VerticalAlign.CENTER;
    }

    public void setStampTextHorizontalAlign(int n, HorizontalAlign horizontalAlign) {
        if (n < this.stampTextHorizontalAligns.size()) {
            this.stampTextHorizontalAligns.set(n, horizontalAlign);
        }
    }

    public void setStampTextVerticalAlign(int n, VerticalAlign verticalAlign) {
        if (n < this.stampTextVerticalAligns.size()) {
            this.stampTextVerticalAligns.set(n, verticalAlign);
        }
    }

    public int getStampImageScaler() {
        return this.stampImageScale;
    }

    public void setStampImageScaler(int n) {
        if (n <= 10 || n > 100) {
            throw new IllegalArgumentException("Invalid scaler");
        }
        this.stampImageScale = n;
    }

    public ImageColouring getStampImageColouring() {
        return this.stampImageColouring;
    }

    public void setStampImageColouring(ImageColouring imageColouring) {
        this.stampImageColouring = imageColouring;
    }

    public BorderStyle getPageBorderStyle() {
        return this.pageBorderStyle;
    }

    public void setPageBorderStyle(BorderStyle borderStyle) {
        this.pageBorderStyle = borderStyle;
    }

    public static enum BorderStyle {
        NONE,
        SIMPLE,
        LEGACY;

    }

    public static enum ImageColouring {
        GRAYSCALE,
        COLOR;

    }

    public static enum VerticalAlign {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum HorizontalAlign {
        LEFT,
        CENTER,
        RIGHT;

    }
}

