/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintStream;
import org.stamppagetor.DocStyle;
import org.stamppagetor.StampPlace;
import org.stamppagetor.StampPrintable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StampLine
extends StampPrintable {
    public static final String XML_NODE_NAME = "line";
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_BOTTOM = 3;
    private static final int DEFAULT_STAMP_SPACING = 20;
    private final int stampSpacing = 20;
    private int align = 3;

    public StampLine() {
    }

    public StampLine(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().compareTo("stamp") != 0) continue;
            this.parts.add(new StampPlace(node2));
        }
    }

    public StampLine(StampLine stampLine) {
        super(stampLine);
        this.align = stampLine.align;
    }

    @Override
    public StampPrintable deepCopy() {
        return new StampLine(this);
    }

    @Override
    public void toXml(PrintStream printStream, String string) {
        string = string + "  ";
        printStream.println(string + "<line>");
        if (this.stampSpacing != 20) {
            printStream.println(string + "  <spacing>" + this.stampSpacing + "</spacing>");
        }
        for (StampPrintable stampPrintable : this.parts) {
            stampPrintable.toXml(printStream, string);
        }
        printStream.println(string + "</line>");
    }

    @Override
    public void print(Graphics graphics, DocStyle docStyle, StampPrintable stampPrintable, Rectangle rectangle) {
        this.printRect(graphics, stampPrintable, rectangle);
        this.printParts(graphics, docStyle, stampPrintable, rectangle);
    }

    @Override
    protected Rectangle[] getPartPlaces(Rectangle rectangle, DocStyle docStyle) {
        int n = this.parts.size();
        Rectangle[] rectangleArray = new Rectangle[n];
        int n2 = this.getHeight(docStyle);
        int n3 = (rectangle.width - this.getWidth(docStyle)) / 2;
        int n4 = 0;
        for (StampPrintable stampPrintable : this.parts) {
            int n5;
            switch (this.align) {
                case 1: {
                    n5 = this.stampSpacing / 2;
                    break;
                }
                case 2: {
                    n5 = (n2 - stampPrintable.getHeight(docStyle)) / 2;
                    break;
                }
                default: {
                    n5 = n2 - this.stampSpacing / 2 - stampPrintable.getHeight(docStyle);
                }
            }
            rectangleArray[n4++] = new Rectangle(n3, n5, stampPrintable.getWidth(docStyle), stampPrintable.getHeight(docStyle));
            n3 += stampPrintable.getWidth(docStyle) + this.stampSpacing;
        }
        return rectangleArray;
    }

    @Override
    protected int getHeight(DocStyle docStyle) {
        int n = 0;
        for (StampPrintable stampPrintable : this.parts) {
            int n2 = stampPrintable.getHeight(docStyle);
            if (n2 <= n) continue;
            n = n2;
        }
        return n + this.stampSpacing;
    }

    @Override
    protected int getWidth(DocStyle docStyle) {
        if (this.parts.size() == 0) {
            return 0;
        }
        int n = 0;
        for (StampPrintable stampPrintable : this.parts) {
            n += stampPrintable.getWidth(docStyle);
        }
        return n + this.stampSpacing * (this.parts.size() - 1);
    }

    public String toString() {
        return "Line";
    }
}

