/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.PrintStream;
import org.stamppagetor.DocStyle;
import org.stamppagetor.StampGroup;
import org.stamppagetor.StampPrintable;
import org.stamppagetor.StampTitle;
import org.stamppagetor.property.PropertyInfo;
import org.stamppagetor.property.PropertyInfoString;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StampPage
extends StampPrintable {
    public static final String XML_NODE_NAME = "page";
    private StampTitle title = new StampTitle("Title of page", 1, 14);
    private final int topSpace = 10;
    private static final PropertyInfo[] properties = new PropertyInfo[]{new PropertyInfoString("Page title", null)};

    public StampPage() {
    }

    public StampPage(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().compareTo("text") == 0) {
                this.title = new StampTitle(node2, 1, 14);
            }
            if (node2.getNodeName().compareTo("group") != 0) continue;
            this.parts.add(new StampGroup(node2));
        }
    }

    public StampPage(StampPage stampPage) {
        super(stampPage);
        this.title = new StampTitle(stampPage.title);
    }

    @Override
    public StampPrintable deepCopy() {
        return new StampPage(this);
    }

    @Override
    public void toXml(PrintStream printStream, String string) {
        string = string + "  ";
        printStream.println(string + "<page>");
        this.title.toXml(printStream, string);
        for (StampPrintable stampPrintable : this.parts) {
            stampPrintable.toXml(printStream, string);
        }
        printStream.println(string + "</page>");
    }

    @Override
    public void print(Graphics graphics, DocStyle docStyle, StampPrintable stampPrintable, Rectangle rectangle) {
        this.printRect(graphics, stampPrintable, rectangle);
        switch (docStyle.getPageBorderStyle()) {
            case NONE: {
                break;
            }
            case SIMPLE: {
                BasicStroke basicStroke = new BasicStroke(0.2f);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(basicStroke);
                graphics2D.drawRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
                break;
            }
            case LEGACY: {
                BasicStroke basicStroke = new BasicStroke(1.0f);
                BasicStroke basicStroke2 = new BasicStroke(0.2f);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(basicStroke);
                graphics2D.drawRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
                graphics2D.setStroke(basicStroke2);
                graphics2D.drawRect(rectangle.x + 2 + 2, rectangle.y + 2 + 2, rectangle.width - 8, rectangle.height - 8);
            }
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + this.topSpace, rectangle.width - 1, this.title.getHeight(docStyle));
        this.title.print(graphics, docStyle, stampPrintable, rectangle2);
        this.printParts(graphics, docStyle, stampPrintable, rectangle);
    }

    @Override
    protected Rectangle[] getPartPlaces(Rectangle rectangle, DocStyle docStyle) {
        Rectangle[] rectangleArray;
        block9: {
            int n = this.parts.size();
            rectangleArray = new Rectangle[n];
            int n2 = this.topSpace + this.title.getHeight(docStyle);
            if (n <= 0) break block9;
            int n3 = rectangle.height - n2;
            StampGroup[][] stampGroupArray = new StampGroup[n][2];
            int[] nArray = new int[n];
            int n4 = 0;
            int n5 = 0;
            for (StampPrintable stampPrintable : this.parts) {
                stampGroupArray[n5][0] = (StampGroup)stampPrintable;
                stampGroupArray[n5][1] = null;
                nArray[n5] = stampPrintable.getHeight(docStyle);
                n4 += nArray[n5];
                ++n5;
            }
            if ((double)n4 > (double)n3 * 0.8) {
                int n6;
                int n7;
                int n8 = 0;
                n4 = 0;
                for (n5 = 0; n5 < n - 1; ++n5) {
                    if (stampGroupArray[n5][0] == null) continue;
                    ++n8;
                    boolean bl = stampGroupArray[n5][0].parts.size() == 1 && ((StampPrintable)stampGroupArray[n5][0].parts.elementAt((int)0)).parts.size() == 1;
                    n7 = stampGroupArray[n5 + 1][0].parts.size() == 1 && ((StampPrintable)stampGroupArray[n5 + 1][0].parts.elementAt((int)0)).parts.size() == 1 ? 1 : 0;
                    n6 = stampGroupArray[n5][0].getWidth(docStyle) + stampGroupArray[n5 + 1][0].getWidth(docStyle);
                    if (bl && n7 != 0 && (double)n6 < (double)rectangle.width * 0.9) {
                        stampGroupArray[n5][1] = stampGroupArray[n5 + 1][0];
                        stampGroupArray[n5 + 1][0] = null;
                        n4 += Math.max(nArray[n5], nArray[n5 + 1]);
                        continue;
                    }
                    n4 += nArray[n5];
                }
                if (stampGroupArray[n5][0] != null) {
                    ++n8;
                    n4 += nArray[n5];
                }
                int n9 = (n3 - n4) / (n8 + 1);
                n7 = 0;
                for (n5 = 0; n5 < n; ++n5) {
                    if (stampGroupArray[n5][0] != null && stampGroupArray[n5][1] == null) {
                        n6 = stampGroupArray[n5][0].getHeight(docStyle);
                        rectangleArray[n7++] = new Rectangle(0, n2 + n9, rectangle.width - 1, n6);
                        n2 += n9 + n6;
                        continue;
                    }
                    if (stampGroupArray[n5][0] == null || stampGroupArray[n5][1] == null) continue;
                    n6 = stampGroupArray[n5][0].getHeight(docStyle);
                    int n10 = stampGroupArray[n5][1].getHeight(docStyle);
                    rectangleArray[n7++] = new Rectangle(0, n2 + n9, (rectangle.width - 1) / 2, n6);
                    rectangleArray[n7++] = new Rectangle((rectangle.width - 1) / 2, n2 + n9, (rectangle.width - 1) / 2, n10);
                    n2 += n9 + Math.max(n6, n10);
                }
            } else {
                int n11 = (n3 - n4) / (n + 1);
                for (n5 = 0; n5 < n; ++n5) {
                    StampPrintable stampPrintable;
                    stampPrintable = this.parts.elementAt(n5);
                    int n12 = stampPrintable.getHeight(docStyle);
                    rectangleArray[n5] = new Rectangle(0, n2 + n11, rectangle.width - 1, n12);
                    n2 += n11 + n12;
                }
            }
        }
        return rectangleArray;
    }

    @Override
    public int getPropertyCount() {
        return properties.length;
    }

    @Override
    public PropertyInfo getPropertyInfo(int n) {
        return properties[n];
    }

    @Override
    public Object getPropertyValue(int n) {
        switch (n) {
            case 0: {
                return this.title.getText();
            }
        }
        return null;
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        switch (n) {
            case 0: {
                this.title.setText((String)object);
                break;
            }
        }
    }

    public String toString() {
        return "Page: " + this.getTitleString();
    }

    public String getTitleString() {
        return this.title.getText();
    }

    public void setTitleString(String string) {
        this.title.setText(string);
    }
}

