/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.image;

class ColorCube {
    private final int bitsPerColor;
    private final int shift;
    private final int reso;
    private final int mask;
    private final int[][][] colorCube;
    private final byte[][][] alphaCube;

    public ColorCube(int n) {
        this.bitsPerColor = n;
        this.shift = 8 - this.bitsPerColor;
        this.reso = 256 >> this.shift;
        this.mask = this.reso - 1;
        this.colorCube = new int[this.reso][this.reso][this.reso];
        this.alphaCube = new byte[this.reso][this.reso][this.reso];
    }

    public void reset() {
        int n = this.reso;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    this.colorCube[i][j][k] = 0;
                    this.alphaCube[i][j][k] = 0;
                }
            }
        }
    }

    public void countColors(int[][] nArray) {
        int n = nArray[0].length;
        int n2 = nArray.length;
        int n3 = this.shift;
        int n4 = this.mask;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = nArray[i][j];
                int n6 = n5 >> 16 + n3 & n4;
                int n7 = n5 >> 8 + n3 & n4;
                int n8 = n5 >> 0 + n3 & n4;
                int[] nArray2 = this.colorCube[n6][n7];
                int n9 = n8;
                nArray2[n9] = nArray2[n9] + 1;
            }
        }
    }

    public int findMaxColor() {
        int n = this.reso;
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    long l2 = this.colorCube[i][j][k];
                    if (l2 <= l) continue;
                    l = l2;
                    n4 = i;
                    n3 = j;
                    n2 = k;
                }
            }
        }
        return (n4 << 16 + this.shift) + (n3 << 8 + this.shift) + (n2 << 0 + this.shift);
    }

    public int getAlphaLevel(int n) {
        int n2 = n >> 16 + this.shift & this.mask;
        int n3 = n >> 8 + this.shift & this.mask;
        int n4 = n >> 0 + this.shift & this.mask;
        return this.alphaCube[n2][n3][n4];
    }

    public void buildAlphaCube(int n) {
        int n2 = n >> 16 + this.shift & this.mask;
        int n3 = n >> 8 + this.shift & this.mask;
        int n4 = n >> 0 + this.shift & this.mask;
        for (int i = -50; i < 50; ++i) {
            int n5 = n2 + n2 * i / 100;
            int n6 = n3 + n3 * i / 100;
            int n7 = n4 + n4 * i / 100;
            if (n5 < 0 || n6 < 0 || n7 < 0 || n5 >= this.reso || n6 >= this.reso || n7 >= this.reso || this.alphaCube[n5][n6][n7] != 0) continue;
            byte[] byArray = this.alphaCube[n5][n6];
            int n8 = n7;
            byArray[n8] = (byte)(byArray[n8] + 1);
        }
        this.addAlphaLevelOfRadius(n2, n3, n4, 3, 1);
        this.addAlphaLevelOfRadius(n2, n3, n4, 2, 1);
        this.addAlphaLevelOfRadius(n2, n3, n4, 1, 1);
        byte[] byArray = this.alphaCube[n2][n3];
        int n9 = n4;
        byArray[n9] = (byte)(byArray[n9] + 1);
    }

    private void addAlphaLevelOfRadius(int n, int n2, int n3, int n4, int n5) {
        int n6 = Math.max(n - n4, 0);
        int n7 = Math.max(n2 - n4, 0);
        int n8 = Math.max(n3 - n4, 0);
        int n9 = Math.min(n + n4, this.reso - 1);
        int n10 = Math.min(n2 + n4, this.reso - 1);
        int n11 = Math.min(n3 + n4, this.reso - 1);
        for (int i = n6; i <= n9; ++i) {
            for (int j = n7; j <= n10; ++j) {
                int n12 = n8;
                while (n12 <= n11) {
                    byte[] byArray = this.alphaCube[i][j];
                    int n13 = n12++;
                    byArray[n13] = (byte)(byArray[n13] + n5);
                }
            }
        }
    }
}

