/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.pdf;

import java.awt.print.PageFormat;
import org.stamppagetor.pdf.PDFObject;
import org.stamppagetor.pdf.PDFObjectContent;
import org.stamppagetor.pdf.PDFObjectPages;
import org.stamppagetor.pdf.PDFObjectResources;

class PDFObjectPage
extends PDFObject {
    private PDFObjectPages parent = null;
    private PDFObjectContent content = null;
    private PDFObjectResources resources = null;
    private final PageFormat format;

    public PDFObjectPage(PageFormat pageFormat) {
        this.format = pageFormat;
    }

    public void setParent(PDFObjectPages pDFObjectPages) {
        this.parent = pDFObjectPages;
    }

    public void setContent(PDFObjectContent pDFObjectContent) {
        this.content = pDFObjectContent;
    }

    public void setResources(PDFObjectResources pDFObjectResources) {
        this.resources = pDFObjectResources;
    }

    @Override
    protected void writeText(StringBuilder stringBuilder) {
        stringBuilder.append("/Type /Page\r");
        stringBuilder.append("/Parent " + this.parent.getIndex() + " 0 R\r");
        stringBuilder.append("/MediaBox [0 0 " + this.format.getWidth() + " " + this.format.getHeight() + "]\r");
        if (this.content != null) {
            stringBuilder.append("/Contents " + this.content.getIndex() + " 0 R\r");
        }
        if (this.resources != null) {
            stringBuilder.append("/Resources " + this.resources.getIndex() + " 0 R\r");
        }
    }
}

