/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.pdf;

import java.util.zip.Deflater;
import org.stamppagetor.pdf.PDFObject;

class PDFObjectXObject
extends PDFObject {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final String streamData;
    private final int w;
    private final int h;
    private final int imageIndex;

    public PDFObjectXObject(int n, int n2, int[] nArray, int n3) {
        this.w = n;
        this.h = n2;
        this.imageIndex = n3;
        this.streamData = this.createStreamData(n, n2, nArray);
    }

    private String createStreamData(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        int n5 = n * n2;
        int n6 = 3 * n5;
        byte[] byArray = new byte[n6 + n2];
        int n7 = 0;
        for (int i = 0; i < n2; ++i) {
            byArray[n7++] = 1;
            for (int j = 0; j < n; ++j) {
                n4 = nArray[j + i * n];
                int n8 = n4 >> 16 & 0xFF;
                int n9 = n4 >> 8 & 0xFF;
                n3 = n4 >> 0 & 0xFF;
                int n10 = j > 0 ? nArray[j + i * n - 1] : 0;
                int n11 = n10 >> 16 & 0xFF;
                int n12 = n10 >> 8 & 0xFF;
                int n13 = n10 >> 0 & 0xFF;
                byArray[n7++] = (byte)(n8 - n11);
                byArray[n7++] = (byte)(n9 - n12);
                byArray[n7++] = (byte)(n3 - n13);
            }
        }
        byte[] byArray2 = new byte[n5 * 6];
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        n4 = deflater.deflate(byArray2);
        StringBuilder stringBuilder = new StringBuilder(2 * n4 + 2);
        char[] cArray = digits;
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuilder.append(cArray[byArray2[n3] >> 4 & 0xF]);
            stringBuilder.append(cArray[byArray2[n3] >> 0 & 0xF]);
        }
        return stringBuilder.toString();
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    @Override
    protected void writeText(StringBuilder stringBuilder) {
        stringBuilder.append("/Type /XObject\r");
        stringBuilder.append("/Subtype /Image\r");
        stringBuilder.append("/Width " + this.w + "\r");
        stringBuilder.append("/Height " + this.h + "\r");
        stringBuilder.append("/ColorSpace /DeviceRGB\r");
        stringBuilder.append("/BitsPerComponent 8\r");
        stringBuilder.append("/Length " + this.streamData.length() + "\r");
        stringBuilder.append("/DecodeParms [null <</Predictor 11 /Colors 3 /BitsPerComponent 8 /Columns " + this.w + " >> ] \r");
        stringBuilder.append("/Filter [/ASCIIHexDecode /FlateDecode]\r");
    }

    @Override
    protected void writeTextStream(StringBuilder stringBuilder) {
        stringBuilder.append("stream\r");
        stringBuilder.append(this.streamData);
        stringBuilder.append("\r");
        stringBuilder.append("endstream\r");
    }
}

