/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.ui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.stamppagetor.StampDocument;
import org.stamppagetor.UiPlatform;
import org.stamppagetor.preferences.LatestFiles;
import org.stamppagetor.ui.RuleStatic;
import org.stamppagetor.ui.UiBundle;
import org.stamppagetor.ui.UiItemMenu;

public class UiBundleSaveAs
extends UiBundle {
    public UiBundleSaveAs() {
        super("SAVEAS", RuleStatic.TRUE);
        this.addUiItem(new UiItemMenu(1400, "Album", "Save As..."));
    }

    @Override
    public void doAction(UiPlatform uiPlatform) {
        UiBundleSaveAs.saveAs(uiPlatform);
    }

    public static boolean saveAs(UiPlatform uiPlatform) {
        int n;
        StampDocument stampDocument = uiPlatform.getDoc();
        String string = stampDocument.getFileName();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(StampDocument.docFileFilter);
        if (string != null) {
            jFileChooser.setSelectedFile(new File(string));
        }
        if ((n = jFileChooser.showSaveDialog(uiPlatform.getMainFrame())) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                String string2 = file.getAbsolutePath();
                if (string2.indexOf(".xml") == -1) {
                    string2 = string2 + ".xml";
                }
                stampDocument.save(string2);
                String string3 = stampDocument.getFileName();
                LatestFiles.getInstance().addFile(string3);
                uiPlatform.getImageCache().reloadImages(new File(string3).getAbsoluteFile().getParentFile());
                return true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Can not save album file: '" + file.getAbsolutePath() + "'!", "Saving Error", 0);
            }
        }
        return false;
    }
}

