/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.ui;

import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.stamppagetor.UiPlatform;
import org.stamppagetor.ui.UiItem;

class UiItemMenu
extends UiItem {
    private final String path;
    private final String text;
    private final KeyStroke keyStroke;
    private ButtonGroup group = null;
    private JMenuItem menuItem = null;

    public UiItemMenu(int n, String string, String string2) {
        this(n, string, string2, null);
    }

    public UiItemMenu(int n, String string, String string2, int n2, int n3) {
        this(n, string, string2, KeyStroke.getKeyStroke(n2, n3));
    }

    public UiItemMenu(int n, String string, String string2, KeyStroke keyStroke) {
        super(n);
        this.path = string;
        this.text = string2;
        this.keyStroke = keyStroke;
    }

    @Override
    public void addUiComponent(UiPlatform uiPlatform) {
        if (this.group == null) {
            this.menuItem = new JMenuItem(this.text);
        } else {
            this.menuItem = new JRadioButtonMenuItem(this.text);
            this.group.add(this.menuItem);
        }
        uiPlatform.addMenuItem(this.menuItem, this.path, this.bundle.getCommand());
        if (this.keyStroke != null) {
            this.addKeyStroke(this.keyStroke);
            this.menuItem.setAccelerator(this.keyStroke);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.menuItem.setEnabled(bl);
    }

    @Override
    public void setVisible(boolean bl) {
        this.menuItem.setVisible(bl);
    }

    @Override
    public void setChecked(boolean bl) {
        this.menuItem.setSelected(bl);
    }

    public void setText(String string) {
        this.menuItem.setText(string);
    }

    public ButtonGroup getGroup() {
        return this.group;
    }

    public void setGroup(ButtonGroup buttonGroup) {
        this.group = buttonGroup;
    }
}

