/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Color;

public class AppearanceOptions
implements PlugIn,
DialogListener {
    private boolean interpolate = Prefs.interpolateScaledImages;
    private boolean open100 = Prefs.open100Percent;
    private boolean black = Prefs.blackCanvas;
    private boolean noBorder = Prefs.noBorder;
    private boolean inverting = Prefs.useInvertingLut;
    private boolean antialiased = Prefs.antialiasedTools;
    private int setMenuSize = Menus.getFontSize();
    private boolean redrawn;
    private boolean repainted;

    public void run(String arg) {
        this.showDialog();
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("Appearance", IJ.getInstance());
        gd.addCheckbox("Interpolate zoomed images", Prefs.interpolateScaledImages);
        gd.addCheckbox("Open images at 100%", Prefs.open100Percent);
        gd.addCheckbox("Black canvas", Prefs.blackCanvas);
        gd.addCheckbox("No image border", Prefs.noBorder);
        gd.addCheckbox("Use inverting lookup table", Prefs.useInvertingLut);
        gd.addCheckbox("Antialiased tool icons", Prefs.antialiasedTools);
        gd.addNumericField("Menu font size:", Menus.getFontSize(), 0, 3, "points");
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#appearance");
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (this.antialiased != Prefs.antialiasedTools) {
                Toolbar.getInstance().repaint();
            }
            Prefs.interpolateScaledImages = this.interpolate;
            Prefs.open100Percent = this.open100;
            Prefs.blackCanvas = this.black;
            Prefs.noBorder = this.noBorder;
            Prefs.useInvertingLut = this.inverting;
            Prefs.antialiasedTools = this.antialiased;
            if (this.redrawn) {
                this.draw();
            }
            if (this.repainted) {
                this.repaintWindow();
            }
            Prefs.open100Percent = this.open100;
            return;
        }
        if (this.setMenuSize != Menus.getFontSize() && !IJ.isMacintosh()) {
            Menus.setFontSize(this.setMenuSize);
            IJ.showMessage("Appearance", "Restart ImageJ to use the new font size");
        }
        if (Prefs.useInvertingLut) {
            IJ.showMessage("Appearance", "The \"Use inverting lookup table\" option is set. Newly opened\n8-bit images will use an inverting LUT (white=0, black=255).");
        }
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (IJ.isMacOSX()) {
            IJ.wait(100);
        }
        boolean interpolate = gd.getNextBoolean();
        Prefs.open100Percent = gd.getNextBoolean();
        boolean blackCanvas = gd.getNextBoolean();
        boolean noBorder = gd.getNextBoolean();
        Prefs.useInvertingLut = gd.getNextBoolean();
        boolean antialiasedTools = gd.getNextBoolean();
        boolean toolbarChange = antialiasedTools != Prefs.antialiasedTools;
        Prefs.antialiasedTools = antialiasedTools;
        if (toolbarChange) {
            Toolbar.getInstance().repaint();
        }
        this.setMenuSize = (int)gd.getNextNumber();
        if (interpolate != Prefs.interpolateScaledImages) {
            Prefs.interpolateScaledImages = interpolate;
            this.draw();
        }
        if (blackCanvas != Prefs.blackCanvas) {
            Prefs.blackCanvas = blackCanvas;
            this.repaintWindow();
        }
        if (noBorder != Prefs.noBorder) {
            Prefs.noBorder = noBorder;
            this.repaintWindow();
        }
        return true;
    }

    void draw() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.draw();
        }
        this.redrawn = true;
    }

    void repaintWindow() {
        ImageWindow win;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (win = imp.getWindow()) != null) {
            if (Prefs.blackCanvas) {
                win.setForeground(Color.white);
                win.setBackground(Color.black);
            } else {
                win.setForeground(Color.black);
                win.setBackground(Color.white);
            }
            imp.repaintWindow();
        }
        this.repainted = true;
    }
}

