/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui.rotate;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class JRotator
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final int IMAGE_WIDTH = 240;
    private static final int IMAGE_HEIGHT = 240;
    private static final double SCALE_CONSTANT = 162.0;
    private static boolean enabled = true;
    private double radAngle;
    private Image mainImage;
    private Image backgroundEnabled;
    private Image backgroundDisabled;
    private String mainImagePath = "/resource/rotate/mainImage.png";
    private Image doubleBufferedImage;
    private Graphics dbg;

    public JRotator() {
        this.initialize();
        this.mainImage = this.scaleImage(this.mainImagePath);
    }

    private void initialize() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setSize(240, 240);
        try {
            this.backgroundEnabled = this.scaleBackground(ImageIO.read(this.getClass().getResource("/resource/rotate/background.png")));
            this.backgroundDisabled = this.scaleBackground(ImageIO.read(this.getClass().getResource("/resource/rotate/backgroundDisabled.png")));
        }
        catch (IOException ex) {
            Logger.getLogger(JRotator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Image scaleImage(String image) {
        BufferedImage scaledImage = null;
        try {
            scaledImage = ImageIO.read(this.getClass().getResource(image));
            double xScale = 0.0;
            double yScale = 0.0;
            try {
                xScale = (double)scaledImage.getWidth() * 162.0 / (double)scaledImage.getHeight();
                yScale = (double)scaledImage.getHeight() * 162.0 / (double)scaledImage.getWidth();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (scaledImage.getWidth() <= scaledImage.getHeight()) {
                return scaledImage.getScaledInstance((int)xScale, -1, 4);
            }
            return scaledImage.getScaledInstance(-1, (int)yScale, 4);
        }
        catch (IOException ex) {
            Logger.getLogger(JRotator.class.getName()).log(Level.SEVERE, null, ex);
            return scaledImage;
        }
    }

    private Image scaleBackground(Image image) {
        return image.getScaledInstance(240, 240, 4);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.doubleBufferedImage = this.createImage(this.getSize().width, this.getSize().height);
        this.dbg = this.doubleBufferedImage.getGraphics();
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2 = (Graphics2D)this.dbg;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isEnabled()) {
            g2.drawImage(this.backgroundEnabled, 0, 0, this);
        } else {
            g2.drawImage(this.backgroundDisabled, 0, 0, this);
        }
        g2.rotate(this.radAngle, w / 2, h / 2);
        g2.drawImage(this.mainImage, 120 - this.mainImage.getWidth(this) / 2, 120 - this.mainImage.getHeight(this) / 2, this);
        g2.rotate(-this.radAngle, w / 2, h / 2);
        g2.dispose();
        g.drawImage(this.doubleBufferedImage, 0, 0, this);
    }

    public void setAngle(int angle) {
        this.radAngle = (double)angle * Math.PI / 180.0;
        this.repaint();
    }

    public int getAngle() {
        return (int)(180.0 * this.radAngle / Math.PI);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.updateAngle(me);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.updateAngle(me);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.updateAngle(me);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void setEnabled(boolean value) {
        enabled = value;
        super.setEnabled(value);
    }

    public void updateAngle(MouseEvent evt) {
        if (!enabled) {
            return;
        }
        double Xd = evt.getX();
        double Yd = evt.getY();
        if (Xd < 120.0 && Yd < 120.0) {
            Yd = 120.0 - Yd;
            Xd = -(120.0 - Xd);
        } else if (Xd >= 120.0 && Yd < 120.0) {
            Yd = 120.0 - Yd;
            Xd -= 120.0;
        } else if (Xd >= 120.0 && Yd >= 120.0) {
            Yd = -(Yd - 120.0);
            Xd -= 120.0;
        } else if (Xd < 120.0 && Yd >= 120.0) {
            Yd = -(Yd - 120.0);
            Xd = -(120.0 - Xd);
        }
        this.radAngle = Math.atan2(Xd, Yd);
        if (57.29577951308232 * this.radAngle < 0.0) {
            this.radAngle += Math.PI * 2;
        }
        this.repaint();
    }
}

