/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui.tabs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bric.gui.rotate.JRotator;
import org.bric.gui.tabs.ImageEditTab;
import org.bric.imageEditParameters.RotateParameters;

public class RotateJPanel
extends JPanel
implements ImageEditTab {
    private int rotationUpLimit = 360;
    private int rotationDownLimit = 0;
    private int randomAngle;
    private int min;
    private int max;
    private Random rand = new Random();
    private JCheckBox RotateEnableCheckBox;
    private JComboBox actionsComboBox;
    private JSlider angleSlider;
    private ButtonGroup buttonGroup2;
    private JRadioButton customRadioButton;
    private JCheckBox differentValueCheckBox;
    private JSpinner fromSpinner;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JRotator jRotator1;
    private JTextField jTextField4;
    private JCheckBox limitCheckBox;
    private JRadioButton predefinedRadioButton;
    private JCheckBox randomCheckBox;
    private JSpinner toSpinner;

    public RotateJPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup2 = new ButtonGroup();
        this.RotateEnableCheckBox = new JCheckBox();
        this.customRadioButton = new JRadioButton();
        this.predefinedRadioButton = new JRadioButton();
        this.jLabel11 = new JLabel();
        this.jTextField4 = new JTextField();
        this.angleSlider = new JSlider();
        this.randomCheckBox = new JCheckBox();
        this.differentValueCheckBox = new JCheckBox();
        this.limitCheckBox = new JCheckBox();
        this.fromSpinner = new JSpinner();
        this.jLabel12 = new JLabel();
        this.toSpinner = new JSpinner();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.actionsComboBox = new JComboBox();
        this.jRotator1 = new JRotator();
        ResourceBundle bundle = ResourceBundle.getBundle("lang/gui/tabs/Bundle");
        this.RotateEnableCheckBox.setText(bundle.getString("RotateJPanel.RotateEnableCheckBox.text"));
        this.RotateEnableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotateJPanel.this.RotateEnableCheckBoxActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.customRadioButton);
        this.customRadioButton.setSelected(true);
        this.customRadioButton.setText(bundle.getString("RotateJPanel.customRadioButton.text"));
        this.customRadioButton.setEnabled(false);
        this.customRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RotateJPanel.this.customRadioButtonItemStateChanged(evt);
            }
        });
        this.buttonGroup2.add(this.predefinedRadioButton);
        this.predefinedRadioButton.setText(bundle.getString("RotateJPanel.predefinedRadioButton.text"));
        this.predefinedRadioButton.setEnabled(false);
        this.predefinedRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RotateJPanel.this.predefinedRadioButtonItemStateChanged(evt);
            }
        });
        this.jLabel11.setText(bundle.getString("RotateJPanel.jLabel11.text"));
        this.jLabel11.setEnabled(false);
        this.jTextField4.setText(bundle.getString("RotateJPanel.jTextField4.text"));
        this.jTextField4.setEnabled(false);
        this.jTextField4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RotateJPanel.this.jTextField4KeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                RotateJPanel.this.jTextField4KeyTyped(evt);
            }
        });
        this.angleSlider.setMajorTickSpacing(45);
        this.angleSlider.setMaximum(360);
        this.angleSlider.setMinorTickSpacing(5);
        this.angleSlider.setPaintLabels(true);
        this.angleSlider.setPaintTicks(true);
        this.angleSlider.setValue(0);
        this.angleSlider.setEnabled(false);
        this.angleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RotateJPanel.this.angleSliderStateChanged(evt);
            }
        });
        this.randomCheckBox.setText(bundle.getString("RotateJPanel.randomCheckBox.text"));
        this.randomCheckBox.setEnabled(false);
        this.randomCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RotateJPanel.this.randomCheckBoxItemStateChanged(evt);
            }
        });
        this.differentValueCheckBox.setText(bundle.getString("RotateJPanel.differentValueCheckBox.text"));
        this.differentValueCheckBox.setEnabled(false);
        this.limitCheckBox.setText(bundle.getString("RotateJPanel.limitCheckBox.text"));
        this.limitCheckBox.setEnabled(false);
        this.limitCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RotateJPanel.this.limitCheckBoxItemStateChanged(evt);
            }
        });
        this.fromSpinner.setModel(new SpinnerNumberModel(0, 0, 360, 1));
        this.fromSpinner.setEnabled(false);
        this.fromSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RotateJPanel.this.fromSpinnerStateChanged(evt);
            }
        });
        this.jLabel12.setText(bundle.getString("RotateJPanel.jLabel12.text"));
        this.jLabel12.setEnabled(false);
        this.toSpinner.setModel(new SpinnerNumberModel(360, 0, 360, 1));
        this.toSpinner.setEnabled(false);
        this.toSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RotateJPanel.this.toSpinnerStateChanged(evt);
            }
        });
        this.jLabel13.setText(bundle.getString("RotateJPanel.jLabel13.text"));
        this.jLabel13.setEnabled(false);
        this.jLabel14.setText(bundle.getString("RotateJPanel.jLabel14.text"));
        this.jLabel14.setEnabled(false);
        this.actionsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"180\u00b0 Upside Down", "90\u00b0 Counter Clockwise", "90\u00b0 Clockwise", "Horizontal Flip", "Horizontal + Vertical Flip", "Vertical Flip"}));
        this.actionsComboBox.setEnabled(false);
        this.jRotator1.setEnabled(false);
        this.jRotator1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RotateJPanel.this.jRotator1MouseClicked(evt);
            }
        });
        this.jRotator1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                RotateJPanel.this.jRotator1MouseDragged(evt);
            }
        });
        GroupLayout jRotator1Layout = new GroupLayout(this.jRotator1);
        this.jRotator1.setLayout(jRotator1Layout);
        jRotator1Layout.setHorizontalGroup(jRotator1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 240, Short.MAX_VALUE));
        jRotator1Layout.setVerticalGroup(jRotator1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 240, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.RotateEnableCheckBox).addGap(18, 18, 18).addComponent(this.customRadioButton).addGap(18, 18, 18).addComponent(this.predefinedRadioButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.randomCheckBox).addComponent(this.limitCheckBox)).addGap(51, 51, 51).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromSpinner, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toSpinner, -2, -1, -2)).addComponent(this.differentValueCheckBox))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel14).addGap(18, 18, 18).addComponent(this.actionsComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRotator1, -2, -1, -2).addComponent(this.jTextField4, -2, 72, -2)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.angleSlider, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RotateEnableCheckBox).addComponent(this.customRadioButton).addComponent(this.predefinedRadioButton)).addGap(2, 2, 2).addComponent(this.jRotator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jTextField4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.angleSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.randomCheckBox).addComponent(this.differentValueCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.limitCheckBox).addComponent(this.jLabel13).addComponent(this.toSpinner, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.fromSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.actionsComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void RotateEnableCheckBoxActionPerformed(ActionEvent evt) {
        this.rotateTabEnable();
    }

    private void customRadioButtonItemStateChanged(ItemEvent evt) {
        this.rotateTabEnable();
    }

    private void predefinedRadioButtonItemStateChanged(ItemEvent evt) {
        this.rotateTabEnable();
    }

    private void jTextField4KeyTyped(KeyEvent evt) {
        this.rotateFieldAction();
    }

    private void jTextField4KeyReleased(KeyEvent evt) {
        this.rotateFieldAction();
    }

    private void angleSliderStateChanged(ChangeEvent evt) {
        this.jRotator1.setAngle(this.angleSlider.getValue());
        if (!this.jTextField4.hasFocus()) {
            this.jTextField4.setText(this.jRotator1.getAngle() + "\u00b0");
        }
    }

    private void randomCheckBoxItemStateChanged(ItemEvent evt) {
        this.rotateTabEnable();
    }

    private void limitCheckBoxItemStateChanged(ItemEvent evt) {
        this.rotateTabEnable();
    }

    private void fromSpinnerStateChanged(ChangeEvent evt) {
        this.setRotationLimit();
    }

    private void toSpinnerStateChanged(ChangeEvent evt) {
        this.setRotationLimit();
    }

    private void jRotator1MouseClicked(MouseEvent evt) {
        this.angleSlider.setValue(this.jRotator1.getAngle());
        this.jTextField4.setText(this.jRotator1.getAngle() + "\u00b0");
    }

    private void jRotator1MouseDragged(MouseEvent evt) {
        this.angleSlider.setValue(this.jRotator1.getAngle());
        this.jTextField4.setText(this.jRotator1.getAngle() + "\u00b0");
    }

    @Override
    public RotateParameters getImageEditParameters() {
        RotateParameters rotateParameters = new RotateParameters();
        rotateParameters.setEnabled(this.RotateEnableCheckBox.isSelected());
        rotateParameters.setCustom(this.customRadioButton.isSelected());
        rotateParameters.setPredefined(this.predefinedRadioButton.isSelected());
        int angle = this.jRotator1.getAngle();
        rotateParameters.setAngle(angle);
        rotateParameters.setRandom(this.randomCheckBox.isSelected());
        rotateParameters.setDifferentValues(this.differentValueCheckBox.isSelected());
        rotateParameters.setLimit(this.limitCheckBox.isSelected());
        rotateParameters.setFrom((Integer)this.fromSpinner.getValue());
        rotateParameters.setTo((Integer)this.toSpinner.getValue());
        rotateParameters.setAction(this.actionsComboBox.getSelectedIndex());
        rotateParameters.setRandomAngle(this.calculateRandomAngle());
        return rotateParameters;
    }

    private int calculateRandomAngle() {
        if (this.limitCheckBox.isSelected()) {
            this.min = Integer.parseInt(this.fromSpinner.getValue().toString());
            this.max = Integer.parseInt(this.toSpinner.getValue().toString());
            if (this.min > this.max) {
                int reminder = this.max;
                this.max = this.min;
                this.min = reminder;
            }
            this.randomAngle = this.rand.nextInt(this.max - this.min + 1) + this.min;
        } else {
            this.randomAngle = this.rand.nextInt(360);
        }
        return this.randomAngle;
    }

    private void rotateTabEnable() {
        boolean enable = this.RotateEnableCheckBox.isSelected();
        boolean predefined = this.predefinedRadioButton.isSelected();
        boolean random = this.randomCheckBox.isSelected();
        boolean limit = this.limitCheckBox.isSelected();
        this.customRadioButton.setEnabled(enable);
        this.predefinedRadioButton.setEnabled(enable);
        this.jRotator1.setEnabled(enable & !random & !predefined);
        this.jLabel11.setEnabled(enable & !random & !predefined);
        this.jTextField4.setEnabled(enable & !random & !predefined);
        this.angleSlider.setEnabled(enable & !random & !predefined);
        this.randomCheckBox.setEnabled(enable & !predefined);
        this.differentValueCheckBox.setEnabled(enable & random & !predefined);
        this.limitCheckBox.setEnabled(enable & random & !predefined);
        this.jLabel12.setEnabled(enable & !predefined & limit & random);
        this.fromSpinner.setEnabled(enable & !predefined & limit & random);
        this.jLabel13.setEnabled(enable & !predefined & limit & random);
        this.toSpinner.setEnabled(enable & !predefined & limit & random);
        this.jLabel14.setEnabled(enable & predefined);
        this.actionsComboBox.setEnabled(enable & predefined);
    }

    private void rotateFieldAction() {
        int symbol = this.jTextField4.getText().contains("\u00b0") ? 1 : 0;
        int fieldNumber = 0;
        try {
            fieldNumber = Integer.parseInt(this.jTextField4.getText(0, this.jTextField4.getText().length() - symbol));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fieldNumber <= 360 && fieldNumber >= 0 && this.jTextField4.getText().length() >= 1) {
            this.jRotator1.setAngle(fieldNumber);
            this.angleSlider.setValue(fieldNumber);
        }
    }

    private void setRotationLimit() {
        this.rotationDownLimit = Integer.parseInt(this.fromSpinner.getValue().toString());
        this.rotationUpLimit = Integer.parseInt(this.toSpinner.getValue().toString());
        if (this.rotationDownLimit > this.rotationUpLimit) {
            int tempValue = this.rotationDownLimit;
            this.rotationDownLimit = this.rotationUpLimit;
            this.rotationUpLimit = tempValue;
        }
    }

    public boolean getRotateEnableCheckBox() {
        return this.RotateEnableCheckBox.isSelected();
    }

    public void setRotateEnableCheckBox(boolean value) {
        this.RotateEnableCheckBox.setSelected(value);
    }

    public int getActionsComboBox() {
        return this.actionsComboBox.getSelectedIndex();
    }

    public void setActionsComboBox(int index) {
        this.actionsComboBox.setSelectedIndex(index);
    }

    public String getAngleSlider() {
        return String.valueOf(this.angleSlider.getValue());
    }

    public void setAngleSlider(int angleSlider) {
        this.angleSlider.getModel().setValue(angleSlider);
    }

    public boolean getCustomRadioButton() {
        return this.customRadioButton.isSelected();
    }

    public void setCustomRadioButton(boolean value) {
        this.customRadioButton.setSelected(value);
    }

    public boolean getDifferentValueCheckBox() {
        return this.differentValueCheckBox.isSelected();
    }

    public void setDifferentValueCheckBox(boolean value) {
        this.differentValueCheckBox.setSelected(value);
    }

    public String getFromSpinner() {
        return this.fromSpinner.getValue().toString();
    }

    public void setFromSpinner(int fromSpinner) {
        this.fromSpinner.getModel().setValue(fromSpinner);
    }

    public boolean getLimitCheckBox() {
        return this.limitCheckBox.isSelected();
    }

    public void setLimitCheckBox(boolean value) {
        this.limitCheckBox.setSelected(value);
    }

    public boolean getPredefinedRadioButton() {
        return this.predefinedRadioButton.isSelected();
    }

    public void setPredefinedRadioButton(boolean value) {
        this.predefinedRadioButton.setSelected(value);
    }

    public boolean getRandomCheckBox() {
        return this.randomCheckBox.isSelected();
    }

    public void setRandomCheckBox(boolean value) {
        this.randomCheckBox.setSelected(value);
    }

    public String getToSpinner() {
        return this.toSpinner.getValue().toString();
    }

    public void setToSpinner(int toSpinner) {
        this.toSpinner.getModel().setValue(toSpinner);
    }
}

