/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui.watermark;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TextEditor
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    public static final int MULTI_LINE = 0;
    public static final int HTML = 1;
    private String text = "";
    private int type = 0;
    private JButton cancelButton;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextPane jTextPane1;
    private JButton okButton;
    private int returnStatus = 0;

    public TextEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditor.this.doClose(0);
            }
        });
    }

    public TextEditor(Frame parent, boolean modal, String text, int type) {
        this(parent, modal);
        this.setText(text, type);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TextEditor.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Text Type:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Simple Multiline", "HTML"}));
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextEditor.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setTabSize(4);
        this.jTextArea1.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                TextEditor.this.jTextArea1CaretUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jLabel2.setText("HTML Preview:");
        this.jTextPane1.setContentType("text/html");
        this.jTextPane1.setEditable(false);
        this.jScrollPane2.setViewportView(this.jTextPane1);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jComboBox1, -2, 157, -2)).addComponent(this.jScrollPane1, -1, 426, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.cancelButton, this.okButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getRootPane().setDefaultButton(this.okButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        this.type = this.jComboBox1.getSelectedIndex();
        if (this.jComboBox1.getSelectedIndex() == 1) {
            this.jTextArea1.setText("<html>\n\t<body>\n\t\tPlace Your Text Here\n\t</body>\n</html>");
        } else {
            this.jTextArea1.setText("");
        }
    }

    private void jTextArea1CaretUpdate(CaretEvent evt) {
        if (this.jComboBox1.getSelectedIndex() == 1) {
            this.jTextPane1.setText(this.jTextArea1.getText());
        }
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextEditor dialog = new TextEditor((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public int getStatus() {
        return this.returnStatus;
    }

    public String getText() {
        if (this.type == 0) {
            return "<html><body>" + this.jTextArea1.getText().replaceAll("\n", "<br />") + "</body></html>";
        }
        return this.jTextArea1.getText();
    }

    public int getTextType() {
        return this.type;
    }

    public final void setText(String text, int type) {
        this.type = type;
        this.text = text;
        this.jComboBox1.setSelectedIndex(type);
        this.jTextArea1.setText(text);
    }
}

