/*
 * Decompiled with CFR 0.152.
 */
package cloudberry.fonts;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import se.datadosen.component.RiverLayout;

public class CFontChooser
extends JDialog
implements ActionListener {
    private JPanel mainPanel = new JPanel(new RiverLayout());
    private Vector<String> availableFonts = new Vector();
    private JComboBox fontBox;
    private Object[] sizes = new Object[]{6, 8, 10, 12, 14, 16, 18, 20, 22, 26, 30, 36, 48, 60, 72, 90, 110, 130, 150, 180};
    private JComboBox sizeBox = new JComboBox<Object>(this.sizes);
    private Object[] styles = new Object[]{"Plain", "Bold", "Italic"};
    private JComboBox styleBox = new JComboBox<Object>(this.styles);
    private Object[] colors = new Object[]{"Black", "Red", "Green", "Blue", "Yellow", "White", "Dark Gray", "Light Gray", "Orange"};
    private JComboBox colorBox = new JComboBox<Object>(this.colors);
    private JTextArea previewArea = new JTextArea("The quick brown fox jumps over the lazy dog");
    private JButton okBTN = new JButton("Ok");
    private JButton cancelBTN = new JButton("Cancel");
    private Font currentFont = null;
    private Color currentColor = Color.BLACK;

    public CFontChooser() {
        this.setTitle("Font Chooser");
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        int i = 1;
        while (i < envfonts.length) {
            this.availableFonts.addElement(envfonts[i]);
            ++i;
        }
        this.fontBox = new JComboBox<String>(this.availableFonts);
        this.previewArea.setLineWrap(true);
        this.previewArea.setWrapStyleWord(true);
        this.previewArea.setEditable(false);
        this.mainPanel.add("center", new JLabel("<html><h1>Choose a font"));
        this.mainPanel.add("p left", new JLabel("Font Name:"));
        this.mainPanel.add("tab hfill", this.fontBox);
        this.mainPanel.add("p left", new JLabel("Font Size:"));
        this.mainPanel.add("tab hfill", this.sizeBox);
        this.mainPanel.add("p left", new JLabel("Font Style:"));
        this.mainPanel.add("tab hfill", this.styleBox);
        this.mainPanel.add("p left", new JLabel("Font Color:"));
        this.mainPanel.add("tab hfill", this.colorBox);
        this.mainPanel.add("p hfill vfill", this.previewArea);
        this.mainPanel.add("p right", this.cancelBTN);
        this.mainPanel.add("right", this.okBTN);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 20, 20));
        this.fontBox.addActionListener(this);
        this.sizeBox.addActionListener(this);
        this.styleBox.addActionListener(this);
        this.colorBox.addActionListener(this);
        this.cancelBTN.addActionListener(this);
        this.okBTN.addActionListener(this);
        this.updatePreview();
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setBounds(300, 100, 400, 400);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
    }

    private Font updateFont() {
        String name = (String)this.fontBox.getSelectedItem();
        int index = this.colorBox.getSelectedIndex();
        if (index == 0) {
            this.currentColor = Color.black;
        }
        if (index == 1) {
            this.currentColor = Color.red;
        }
        if (index == 2) {
            this.currentColor = Color.green;
        }
        if (index == 3) {
            this.currentColor = Color.blue;
        }
        if (index == 4) {
            this.currentColor = Color.yellow;
        }
        if (index == 5) {
            this.currentColor = Color.white;
        }
        if (index == 6) {
            this.currentColor = Color.darkGray;
        }
        if (index == 7) {
            this.currentColor = Color.lightGray;
        }
        if (index == 8) {
            this.currentColor = Color.orange;
        }
        return new Font(name, this.styleBox.getSelectedIndex(), (Integer)this.sizeBox.getSelectedItem());
    }

    private void updatePreview() {
        this.currentFont = this.updateFont();
        this.previewArea.setFont(this.currentFont);
        this.previewArea.setForeground(this.currentColor);
    }

    public Font showDialog(Font current) {
        if (current != null) {
            this.displayFont(current);
        }
        this.setVisible(true);
        return this.currentFont;
    }

    private void displayFont(Font f) {
        System.out.println("a");
        int nameIndex = this.availableFonts.indexOf(f.getName());
        if (nameIndex != -1) {
            this.fontBox.setSelectedIndex(nameIndex);
        }
        int i = 0;
        while (i < this.sizes.length) {
            if (((Integer)this.sizes[i]).intValue() == f.getSize()) {
                this.sizeBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.styleBox.setSelectedIndex(f.getStyle());
    }

    public Color getSelectedColor() {
        return this.currentColor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBTN) {
            this.currentFont = this.updateFont();
            this.dispose();
        } else if (e.getSource() == this.cancelBTN) {
            this.currentFont = null;
            this.dispose();
        } else {
            this.updatePreview();
        }
    }

    public static void main(String[] args) {
    }
}

