/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.awt.Point;
import java.io.Serializable;
import net.grelf.Angle;
import net.grelf.Length;

public class Triangle
implements Cloneable,
Serializable {
    private Point ptA;
    private Point ptB;
    private Point ptC;
    private Angle _A;
    private Angle _B;
    private Angle _C;
    private Length a;
    private Length b;
    private Length c;

    public Triangle(Point point, Point point2, Point point3) {
        this.ptA = point;
        this.ptB = point2;
        this.ptC = point3;
        double d = point2.distance(point3);
        double d2 = point3.distance(point);
        double d3 = point.distance(point2);
        this.a = new Length(d, Length.Units.PIXEL);
        this.b = new Length(d2, Length.Units.PIXEL);
        this.c = new Length(d3, Length.Units.PIXEL);
        double d4 = (d + d2 + d3) * 0.5;
        double d5 = 2.0 * StrictMath.sqrt(d4 * (d4 - d) * (d4 - d2) * (d4 - d3));
        double d6 = d5 / (d2 * d3);
        this._A = Angle.asin(d6);
        double d7 = d5 / (d3 * d);
        this._B = Angle.asin(d7);
        double d8 = d5 / (d * d2);
        this._C = Angle.asin(d8);
    }

    public Point[] getVertices() {
        Point[] pointArray = new Point[]{(Point)this.ptA.clone(), (Point)this.ptB.clone(), (Point)this.ptC.clone()};
        return pointArray;
    }

    public Length perimeter(Length.Units units) {
        double d = this.a.getValue(units) + this.b.getValue(units) + this.c.getValue(units);
        return new Length(d, units);
    }

    public double area(Length.Units units) {
        return 0.5 * this.a.getValue(units) * this.b.getValue(units) * this._C.sin();
    }

    public Triangle clone() {
        return new Triangle(this.ptA, this.ptB, this.ptC);
    }

    public int hashCode() {
        return 13 * this.ptA.hashCode() + 37 * this.ptB.hashCode() + 61 * this.ptC.hashCode();
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        Triangle triangle = (Triangle)object;
        if (!this.ptA.equals(triangle.ptA)) {
            return false;
        }
        if (!this.ptB.equals(triangle.ptB)) {
            return false;
        }
        return this.ptC.equals(triangle.ptC);
    }

    public boolean equalAngles(Triangle triangle, Angle angle) {
        double d = angle.getRadians();
        if (Math.abs(this._A.getRadians() - triangle._A.getRadians()) <= d && Math.abs(this._B.getRadians() - triangle._B.getRadians()) <= d && Math.abs(this._C.getRadians() - triangle._C.getRadians()) <= d) {
            return true;
        }
        if (Math.abs(this._A.getRadians() - triangle._B.getRadians()) <= d && Math.abs(this._B.getRadians() - triangle._C.getRadians()) <= d && Math.abs(this._C.getRadians() - triangle._A.getRadians()) <= d) {
            triangle.cycle(CycleSense.ANTICLOCKWISE);
            return true;
        }
        if (Math.abs(this._A.getRadians() - triangle._C.getRadians()) <= d && Math.abs(this._B.getRadians() - triangle._A.getRadians()) <= d && Math.abs(this._C.getRadians() - triangle._B.getRadians()) <= d) {
            triangle.cycle(CycleSense.CLOCKWISE);
            return true;
        }
        return false;
    }

    public void cycle(CycleSense cycleSense) {
        if (cycleSense == CycleSense.CLOCKWISE) {
            // empty if block
        }
    }

    public double getScaleTo(Triangle triangle) {
        double d = triangle.a.getValue(Length.Units.PIXEL) / this.a.getValue(Length.Units.PIXEL);
        d += triangle.b.getValue(Length.Units.PIXEL) / this.b.getValue(Length.Units.PIXEL);
        return (d += triangle.c.getValue(Length.Units.PIXEL) / this.c.getValue(Length.Units.PIXEL)) / 3.0;
    }

    public double getAngleTo(Triangle triangle) {
        Point[] pointArray = this.getVertices();
        Point[] pointArray2 = triangle.getVertices();
        Angle angle = Angle.atan2(pointArray[1].y - pointArray[0].y, pointArray[1].x - pointArray[0].x);
        Angle angle2 = Angle.atan2(pointArray2[1].y - pointArray2[0].y, pointArray2[1].x - pointArray2[0].x);
        Angle angle3 = Angle.atan2(pointArray[2].y - pointArray[1].y, pointArray[2].x - pointArray[1].x);
        Angle angle4 = Angle.atan2(pointArray2[2].y - pointArray2[1].y, pointArray2[2].x - pointArray2[1].x);
        Angle angle5 = Angle.atan2(pointArray[0].y - pointArray[2].y, pointArray[0].x - pointArray[2].x);
        Angle angle6 = Angle.atan2(pointArray2[0].y - pointArray2[2].y, pointArray2[0].x - pointArray2[2].x);
        double d = angle2.difference(angle).getRadians();
        d += angle4.difference(angle3).getRadians();
        return (d += angle6.difference(angle5).getRadians()) / 3.0;
    }

    private StringBuffer appendPoint(StringBuffer stringBuffer, Point point) {
        stringBuffer.append("(");
        stringBuffer.append(point.x);
        stringBuffer.append(", ");
        stringBuffer.append(point.y);
        stringBuffer.append(")");
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Vertices: ");
        stringBuffer = this.appendPoint(stringBuffer, this.ptA);
        stringBuffer.append(", ");
        stringBuffer = this.appendPoint(stringBuffer, this.ptB);
        stringBuffer.append(", ");
        stringBuffer = this.appendPoint(stringBuffer, this.ptC);
        stringBuffer.append("; Angles (\u00b0): ");
        stringBuffer.append(this._A.toString(Angle.Units.DEGREES));
        stringBuffer.append(", ");
        stringBuffer.append(this._B.toString(Angle.Units.DEGREES));
        stringBuffer.append(", ");
        stringBuffer.append(this._C.toString(Angle.Units.DEGREES));
        stringBuffer.append("; Lengths (px): ");
        stringBuffer.append(this.a.getValue(Length.Units.PIXEL));
        stringBuffer.append(", ");
        stringBuffer.append(this.b.getValue(Length.Units.PIXEL));
        stringBuffer.append(", ");
        stringBuffer.append(this.c.getValue(Length.Units.PIXEL));
        return stringBuffer.toString();
    }

    public static enum CycleSense {
        CLOCKWISE,
        ANTICLOCKWISE;

    }
}

