/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.Serializable;
import java.text.DecimalFormat;
import net.grelf.astro.JulianDate;

public class Epoch
implements Cloneable,
Serializable {
    public static final Epoch J2000 = new Epoch('J', 2000.0f);
    private float year;
    private char type = (char)74;
    private static final DecimalFormat DF2 = new DecimalFormat("0.00");

    public float getYear() {
        return this.year;
    }

    public char getType() {
        return this.type;
    }

    public Epoch(float f) {
        this('J', f);
    }

    public Epoch(char c, float f) {
        this.type = c;
        this.year = f;
    }

    public JulianDate getJulianDate() {
        switch (this.type) {
            case 'B': {
                double d = (double)this.year - 1950.0;
                return new JulianDate(2433282.4235 + d * 365.2421988);
            }
            case 'J': {
                double d = this.year - 2000.0f;
                return new JulianDate(2451545.0 + d * 365.25);
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        Epoch epoch = (Epoch)object;
        if (epoch.year != this.year) {
            return false;
        }
        return epoch.type == this.type;
    }

    public int hashCode() {
        return (int)(this.year * 1234567.0f + (float)this.type);
    }

    public Epoch clone() {
        return new Epoch(this.type, this.year);
    }

    public String toString() {
        return this.type + DF2.format(this.year);
    }
}

