/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grelf.Angle;

public class RA
extends Angle
implements Cloneable,
Serializable {
    private static final DecimalFormat DF2 = new DecimalFormat("00");
    private static final DecimalFormat DF2_2 = new DecimalFormat("00.00");
    private static final double DEG_TO_HOUR = 0.06666666666666667;
    private static final double HOUR_TO_DEG = 15.0;

    public byte getHour() {
        return (byte)Math.floor(this.toHours());
    }

    public byte getMinute() {
        double d = this.toHours() * 60.0;
        int n = (int)Math.floor(d);
        if (n < 0) {
            ++n;
        }
        return (byte)(n % 60);
    }

    public float getSecond() {
        double d = this.toHours();
        double d2 = Math.abs(d * 60.0);
        double d3 = Math.floor(d2);
        double d4 = d2 - d3;
        float f = (float)d4 * 60.0f;
        return f;
    }

    public RA(double d, double d2, double d3, double d4) {
        super(15.0 * (d + d2 / 60.0 + d3 / 3600.0), d4, Angle.Units.DEGREES);
    }

    public RA(double d, double d2, double d3) {
        this(d, d2, d3, 0.0);
    }

    public RA(double d, double d2) {
        super(d, d2, Angle.Units.DEGREES);
    }

    public RA(double d) {
        this(d, 0.0);
    }

    public RA(Angle angle) {
        this(angle.getDegrees(), angle.getStdErrDegrees());
    }

    public static RA parseRA(String string) throws NumberFormatException {
        String string2;
        double d;
        Pattern pattern = Pattern.compile("^\\d+\\.\\d+");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find() && (d = Double.parseDouble(string)) < 24.0) {
            return new RA(d * 15.0);
        }
        Pattern pattern2 = Pattern.compile("^(\\d{1,2}).?(\\d{2}).?(\\d{2}(\\.\\d*)?)s?$");
        Matcher matcher2 = pattern2.matcher(string);
        if (matcher2.find() && null != (string2 = matcher2.group(1))) {
            int n = Integer.parseInt(string2);
            String string3 = matcher2.group(2);
            if (null != string3) {
                int n2 = Integer.parseInt(string3);
                String string4 = matcher2.group(3);
                if (null != string4) {
                    double d2 = Double.parseDouble(string4);
                    return new RA((double)n, (double)n2, d2);
                }
            }
        }
        throw new NumberFormatException(string + " is not a valid RA");
    }

    public double toHours() {
        return 0.06666666666666667 * this.getDegrees();
    }

    public double toDegrees() {
        return this.getDegrees();
    }

    @Override
    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        RA rA = (RA)object;
        return this.valueRadians.equals(rA.valueRadians);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public RA clone() {
        return new RA(this);
    }

    @Override
    public String toString() {
        return DF2.format(this.getHour()) + "h" + DF2.format(this.getMinute()) + "m" + DF2_2.format(this.getSecond()) + "s";
    }
}

