/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextArea;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.grelf.Util;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.Magnitude;
import net.grelf.astro.ProperMotion;
import net.grelf.astro.RA;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.Star;
import net.grelf.astro.StarChartLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimbadGateway
extends StarChartLoader {
    private static SimbadGateway instance = null;
    private static DecimalFormat DF4 = new DecimalFormat("0.0000");
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final XPath XPATH = XPATH_FACTORY.newXPath();
    private static final DocumentBuilderFactory DOC_FACTORY = DocumentBuilderFactory.newInstance();

    public static synchronized SimbadGateway getInstance() {
        if (null == instance) {
            instance = new SimbadGateway();
        }
        return instance;
    }

    private SimbadGateway() {
        this.equinox = new Epoch(2000.0f);
    }

    public Star getStarFromId(String string, String string2, JTextArea jTextArea) {
        try {
            String string3 = URLEncoder.encode(string, "UTF-8");
            URL uRL = null != string2 && string2.length() > 0 ? new URL(string2 + string3) : new URL("http://simbad.u-strasbg.fr/simbad/sim-id?Ident=" + string3 + "&output.format=VOTable");
            StringBuffer stringBuffer = this.doQuery(uRL, jTextArea);
            if (-1 != stringBuffer.indexOf("<VOTABLE") && -1 != stringBuffer.indexOf("<TABLEDATA")) {
                return this.getStarFromVOTable(stringBuffer.toString(), jTextArea);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.showException(malformedURLException, jTextArea);
        }
        catch (Exception exception) {
            this.showException(exception, jTextArea);
        }
        return null;
    }

    private StringBuffer doQuery(URL uRL, JTextArea jTextArea) {
        try {
            String string;
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            while (null != (string = bufferedReader.readLine())) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            bufferedReader.close();
            inputStream.close();
            if (null != jTextArea) {
                jTextArea.setText(stringBuffer.toString());
            }
            return stringBuffer;
        }
        catch (IOException iOException) {
            this.showException(iOException, jTextArea);
            return null;
        }
    }

    public List<Star> searchCone(SkyPoint skyPoint, double d, String string, JTextArea jTextArea) {
        try {
            String string2 = "" + DF4.format(skyPoint.getDec().toDegrees());
            char c = string2.charAt(0);
            if (c != '+' && c != '-') {
                string2 = "+" + string2;
            }
            String string3 = null != string && string.length() > 0 ? string : "http://simbad.u-strasbg.fr/simbad/sim-coo";
            string3 = string3 + "?output.format=VOTable&Coord=" + DF4.format(skyPoint.getRA().toDegrees()) + string2 + "&CooEpoch=" + skyPoint.getEquinox().getYear() + "&Radius=" + d + "&Radius.unit=deg" + "&list.idcat=Tycho,HIP2,GSC";
            Util.logInfo(string3);
            URL uRL = new URL(string3);
            StringBuffer stringBuffer = this.doQuery(uRL, jTextArea);
            if (-1 != stringBuffer.indexOf("<VOTABLE") && -1 != stringBuffer.indexOf("<TABLEDATA")) {
                this.initialiseChartCoordinates(skyPoint, d);
                return this.getStarListFromVOTable(stringBuffer.toString(), jTextArea);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.showException(malformedURLException, jTextArea);
        }
        return null;
    }

    private Star getStarFromVOTable(String string, JTextArea jTextArea) {
        Star star = null;
        try {
            char c;
            DocumentBuilder documentBuilder = DOC_FACTORY.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            String string2 = "/VOTABLE/DEFINITIONS/COOSYS/@epoch";
            String string3 = "/VOTABLE/RESOURCE/TABLE/FIELD";
            String string4 = "/VOTABLE/RESOURCE/TABLE/DATA/TABLEDATA/TR/TD";
            XPathExpression xPathExpression = XPATH.compile(string2);
            Node node = (Node)xPathExpression.evaluate(document, XPathConstants.NODE);
            xPathExpression = XPATH.compile(string3);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            xPathExpression = XPATH.compile(string4);
            NodeList nodeList2 = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (null != jTextArea) {
                jTextArea.append("\n--------------------\n");
            }
            RA rA = null;
            Dec dec = null;
            Epoch epoch = null;
            double d = 0.0;
            double d2 = 0.0;
            String string5 = node.getTextContent();
            if (null != jTextArea) {
                jTextArea.append("Epoch: " + string5 + "\n");
            }
            epoch = Character.isLetter(c = string5.charAt(0)) ? new Epoch(c, Float.parseFloat(string5.substring(1))) : new Epoch('J', Float.parseFloat(string5));
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string6;
                Node node2 = nodeList.item(i);
                if (!(node2 instanceof Element)) continue;
                NamedNodeMap namedNodeMap = ((Element)node2).getAttributes();
                Node node3 = namedNodeMap.getNamedItem("ID");
                Node node4 = namedNodeMap.getNamedItem("unit");
                if (null == node3) continue;
                String string7 = node3.getTextContent();
                if (string7.equals("MAIN_ID")) {
                    if (null == jTextArea) continue;
                    jTextArea.append("Name: " + nodeList2.item(i).getTextContent() + "\n");
                    continue;
                }
                if (string7.equals("OTYPE_S")) {
                    if (null == jTextArea) continue;
                    jTextArea.append("Type: " + nodeList2.item(i).getTextContent() + "\n");
                    continue;
                }
                if (string7.equals("RA_d")) {
                    rA = new RA(Double.parseDouble(nodeList2.item(i).getTextContent()));
                    if (null == jTextArea) continue;
                    jTextArea.append("RA: " + rA.toString() + "\n");
                    continue;
                }
                if (string7.equals("DEC_d")) {
                    dec = new Dec(Double.parseDouble(nodeList2.item(i).getTextContent()));
                    if (null == jTextArea) continue;
                    jTextArea.append("Dec: " + dec.toString() + "\n");
                    continue;
                }
                if (string7.equals("PM_pmra")) {
                    string6 = nodeList2.item(i).getTextContent();
                    if (string6.length() <= 0) continue;
                    if (null != jTextArea) {
                        jTextArea.append("PM in RA: " + string6 + " " + node4.getTextContent() + "\n");
                    }
                    d = Double.parseDouble(string6);
                    continue;
                }
                if (!string7.equals("PM_pmde") || (string6 = nodeList2.item(i).getTextContent()).length() <= 0) continue;
                if (null != jTextArea) {
                    jTextArea.append("PM in Dec: " + string6 + " " + node4.getTextContent() + "\n");
                }
                d2 = Double.parseDouble(string6);
            }
            if (null != rA && null != dec && null != epoch) {
                star = new Star();
                star.setPosition(new SkyPoint(rA, dec, epoch));
                star.setProperMotion(new ProperMotion(d, d2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showException(numberFormatException, jTextArea);
        }
        catch (SAXException sAXException) {
            this.showException(sAXException, jTextArea);
        }
        catch (IOException iOException) {
            this.showException(iOException, jTextArea);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.showException(parserConfigurationException, jTextArea);
        }
        catch (XPathExpressionException xPathExpressionException) {
            this.showException(xPathExpressionException, jTextArea);
        }
        return star;
    }

    private List<Star> getStarListFromVOTable(String string, JTextArea jTextArea) {
        ArrayList<Star> arrayList = new ArrayList<Star>();
        try {
            Object object;
            Object object2;
            Object object3;
            Node node;
            int n;
            char c;
            DocumentBuilder documentBuilder = DOC_FACTORY.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            String string2 = "/VOTABLE/DEFINITIONS/COOSYS/@epoch";
            String string3 = "/VOTABLE/RESOURCE/TABLE/FIELD";
            String string4 = "/VOTABLE/RESOURCE/TABLE/DATA/TABLEDATA/TR";
            XPathExpression xPathExpression = XPATH.compile(string2);
            Node node2 = (Node)xPathExpression.evaluate(document, XPathConstants.NODE);
            if (null != jTextArea) {
                jTextArea.append("\n--------------------\n");
            }
            Epoch epoch = null;
            String string5 = node2.getTextContent();
            if (null != jTextArea) {
                jTextArea.append("Epoch: " + string5 + "\n");
            }
            epoch = Character.isLetter(c = string5.charAt(0)) ? new Epoch(c, Float.parseFloat(string5.substring(1))) : new Epoch('J', Float.parseFloat(string5));
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            xPathExpression = XPATH.compile(string3);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            for (n = 0; n < nodeList.getLength(); ++n) {
                node = nodeList.item(n);
                if (!(node instanceof Element)) continue;
                object3 = ((Element)node).getAttributes();
                object2 = object3.getNamedItem("ID");
                object = object3.getNamedItem("unit");
                if (null == object2) continue;
                String string6 = object2.getTextContent();
                hashMap.put(string6, n);
            }
            xPathExpression = XPATH.compile(string4);
            nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            for (n = 0; n < nodeList.getLength(); ++n) {
                node = nodeList.item(n);
                if (!(node instanceof Element)) continue;
                object3 = (Element)node;
                object2 = object3.getChildNodes();
                object = null;
                double d = 0.0;
                double d2 = 0.0;
                RA rA = new RA(Double.parseDouble(this.getTD("RA_d", hashMap, (NodeList)object2)));
                Dec dec = new Dec(Double.parseDouble(this.getTD("DEC_d", hashMap, (NodeList)object2)));
                if (null == rA || null == dec || null == epoch) continue;
                object = new Star();
                ((Star)object).setPosition(new SkyPoint(rA, dec, epoch));
                String string7 = this.getTD("MAIN_ID", hashMap, (NodeList)object2);
                ((Star)object).setCommonId(string7);
                string7 = this.getTD("OTYPE_S", hashMap, (NodeList)object2);
                if (string7.length() > 0) {
                    ((Star)object).setTypeOfStellarObject(string7);
                }
                if ((string7 = this.getTD("PMRA", hashMap, (NodeList)object2)).length() > 0) {
                    d = Double.parseDouble(string7) / 1000.0;
                }
                if ((string7 = this.getTD("PMDEC", hashMap, (NodeList)object2)).length() > 0) {
                    d2 = Double.parseDouble(string7) / 1000.0;
                }
                ((Star)object).setProperMotion(new ProperMotion(d, d2));
                string7 = this.getTD("FLUX_V", hashMap, (NodeList)object2);
                if (string7.length() > 0) {
                    ((Star)object).addMagnitude(new Magnitude(Float.parseFloat(string7), "V"));
                }
                if ((string7 = this.getTD("FLUX_B", hashMap, (NodeList)object2)).length() > 0) {
                    ((Star)object).addMagnitude(new Magnitude(Float.parseFloat(string7), "B"));
                }
                if ((string7 = this.getTD("FLUX_R", hashMap, (NodeList)object2)).length() > 0) {
                    ((Star)object).addMagnitude(new Magnitude(Float.parseFloat(string7), "R"));
                }
                if (null == ((Star)object).getMagnitude()) continue;
                this.calculateChartCoordinates((Star)object);
                arrayList.add((Star)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showException(numberFormatException, jTextArea);
        }
        catch (SAXException sAXException) {
            this.showException(sAXException, jTextArea);
        }
        catch (IOException iOException) {
            this.showException(iOException, jTextArea);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.showException(parserConfigurationException, jTextArea);
        }
        catch (XPathExpressionException xPathExpressionException) {
            this.showException(xPathExpressionException, jTextArea);
        }
        return arrayList;
    }

    private String getTD(String string, Map<String, Integer> map, NodeList nodeList) {
        Node node;
        Integer n = map.get(string);
        if (null != n && (node = nodeList.item(n)) instanceof Element) {
            Element element = (Element)node;
            return element.getTextContent();
        }
        return "";
    }

    private void showException(Exception exception, JTextArea jTextArea) {
        if (null != jTextArea) {
            jTextArea.append("\nERROR==============================\n" + exception.toString());
        } else {
            Util.logWarning(exception.toString());
        }
    }
}

